/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.pim;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.pim.ContactListImpl;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;
import org.kobjects.pim.PimField;
import org.kobjects.pim.PimItem;
import org.kobjects.pim.PimParser;
import org.kobjects.pim.VCard;

public class PIM {
    public static final int CONTACT_LIST = 1;
    public static final int EVENT_LIST = 2;
    public static final int READ_ONLY = 1;
    public static final int READ_WRITE = 3;
    public static final int TODO_LIST = 3;
    public static final int WRITE_ONLY = 2;
    static PIM pim;
    Hashtable contacts;

    protected PIM() {
        ContactListImpl dummy = new ContactListImpl(null);
        this.contacts = new Hashtable();
        try {
            PimItem item;
            InputStream is = this.getClass().getResourceAsStream("/vcards.txt");
            InputStreamReader fr = new InputStreamReader(is);
            PimParser pp = new PimParser(fr, VCard.class);
            while ((item = pp.readItem()) != null) {
                while (item.getFieldCount("uid") > 1) {
                    item.removeField("uid", item.getFieldCount("uid") - 1);
                }
                PIM.commit(this.contacts, item);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        System.out.println("ME4SE: pim loaded from 'javax/microedition/pim/vcards.txt'");
    }

    static void commit(Hashtable list, PimItem item) {
        String uid = null;
        if (item.getFieldCount("uid") == 0) {
            while (list.get(uid = "" + System.currentTimeMillis()) != null) {
            }
            PimField field = new PimField("uid");
            field.setValue(uid);
            item.addField(field);
        } else {
            uid = (String)item.getField("uid", 0).getValue();
        }
        list.put(uid, item);
    }

    public PIMItem[] fromSerialFormat(InputStream is, String enc) throws PIMException {
        System.out.println("ME4SE: PIM.fromSerialFormat(InputStream is='" + is + "', String enc='" + enc + "') NYI !");
        return null;
    }

    public static PIM getInstance() {
        System.out.println("ME4SE: PIM.getInstance()");
        if (pim == null) {
            pim = new PIM();
        }
        return pim;
    }

    public String[] listPIMLists(int pimListType) {
        System.out.println("ME4SE: PIM.listPIMLists(int pimListType='" + pimListType + "')");
        if (pimListType == 1) {
            return new String[]{"default"};
        }
        return new String[0];
    }

    public PIMList openPIMList(int pimListType, int mode) throws PIMException {
        System.out.println("ME4SE: PIM.openPIMList(int pimListType='" + pimListType + "', int mode='" + mode + "')");
        return this.openPIMList(pimListType, mode, "default");
    }

    public PIMList openPIMList(int pimListType, int mode, String name) throws PIMException {
        System.out.println("ME4SE: PIM.openPIMList(int pimListType='" + pimListType + "', int mode='" + mode + "', String name='" + name + "')");
        if (pimListType != 1) {
            throw new RuntimeException("Currently, only contactList supported");
        }
        return new ContactListImpl(this.contacts);
    }

    public String[] supportedSerialFormats(int pimListType) {
        System.out.println("ME4SE: PIM.supportedSerialFormats(int pimListType='" + pimListType + "') NYI !");
        return null;
    }

    public void toSerialFormat(PIMItem item, OutputStream os, String enc, String dataFormat) throws PIMException {
        System.out.println("ME4SE: PIM.toSerialFormat(PIMItem item='" + item + "', OutputStream os='" + os + "', String enc='" + enc + "', String dataFormat='" + dataFormat + "') NYI !");
        throw new RuntimeException("NYI");
    }
}

