/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.impl.ConnectionImpl;
import org.me4se.psi.java1.gcf.file.AssetConnection;

public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;

    public static Connection open(String name) throws IOException {
        return Connector.open(name, 3, false);
    }

    public static Connection open(String name, int mode) throws IOException {
        return Connector.open(name, mode, false);
    }

    public static Connection open(String url, int mode, boolean timeOuts) throws IOException {
        String PROTOCOL_ASSET = "file:///android_asset/";
        if (url.startsWith("file:///android_asset/")) {
            return new AssetConnection(url.substring("file:///android_asset/".length()));
        }
        int cut = url.indexOf(58);
        if (cut == -1) {
            throw new IOException(": not found!");
        }
        String protocol = url.substring(0, cut).toLowerCase();
        String name = "gcf." + protocol + "." + Character.toUpperCase(protocol.charAt(0)) + protocol.substring(1) + "ConnectionImpl";
        try {
            ConnectionImpl connection = (ConnectionImpl)ApplicationManager.instantiate(name);
            connection.open(url, mode, timeOuts);
            return connection;
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Protocol not found: " + e, e);
        }
    }

    public static InputStream openInputStream(String name) throws IOException {
        return ((InputConnection)Connector.open(name)).openInputStream();
    }

    public static OutputStream openOutputStream(String name) throws IOException {
        return ((OutputConnection)Connector.open(name)).openOutputStream();
    }

    public static DataInputStream openDataInputStream(String name) throws IOException {
        return ((InputConnection)Connector.open(name)).openDataInputStream();
    }

    public static OutputStream openDataOutputStream(String name) throws IOException {
        return ((OutputConnection)Connector.open(name)).openDataOutputStream();
    }
}

