/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.projects;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BooleanSupplier;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.rundeck.client.api.RundeckApi;
import org.rundeck.client.api.model.ProjectExportStatus;
import org.rundeck.client.api.model.ProjectImportStatus;
import org.rundeck.client.tool.CommandOutput;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.ProjectInput;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.ProjectRequiredNameOptions;
import org.rundeck.client.util.Client;
import org.rundeck.client.util.ServiceClient;
import org.rundeck.client.util.Util;
import picocli.CommandLine;

@CommandLine.Command(description={"Project Archives import and export"}, name="archives")
public class Archives
extends BaseCommand {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    String validate(ProjectInput opts) throws InputError {
        if (null != opts.getProject()) {
            ProjectRequiredNameOptions.validateProjectName(opts.getProject(), this.spec);
        }
        return this.getRdTool().projectOrEnv(opts);
    }

    @CommandLine.Command(description={"Import a project archive"}, name="import")
    public int importArchive(@CommandLine.Mixin ArchiveImportOpts opts) throws InputError, IOException {
        File input = opts.getFile();
        if (!input.canRead() || !input.isFile()) {
            throw new InputError(String.format("File is not readable or does not exist: %s", input));
        }
        if ((opts.isIncludeWebhooks() || opts.isWhkRegenAuthTokens()) && this.getRdTool().getClient().getApiVersion() < 34) {
            throw new InputError(String.format("Cannot use --include-webhooks or --regenerate-tokens with API < 34 (currently: %s)", this.getRdTool().getClient().getApiVersion()));
        }
        if (opts.isIncludeNodeSources() && this.getRdTool().getClient().getApiVersion() < 38) {
            throw new InputError(String.format("Cannot use --include-node-sources with API < 38 (currently: %s)", this.getRdTool().getClient().getApiVersion()));
        }
        RequestBody body = RequestBody.create(input, Client.MEDIA_TYPE_ZIP);
        HashMap<String, String> extraCompOpts = new HashMap<String, String>();
        if (opts.components != null && opts.components.size() > 0) {
            for (String string : opts.components) {
                extraCompOpts.put("importComponents." + string, "true");
            }
        }
        if (opts.componentOptions != null && opts.componentOptions.size() > 0) {
            for (Map.Entry entry : opts.componentOptions.entrySet()) {
                extraCompOpts.put("importOpts." + (String)entry.getKey(), (String)entry.getValue());
            }
        }
        String project = this.validate(opts);
        ProjectImportStatus projectImportStatus = (ProjectImportStatus)this.apiCall(api -> api.importProjectArchive(project, opts.isRemove() ? "remove" : "preserve", !opts.isNoExecutions(), opts.isIncludeConfig(), opts.isIncludeAcl(), opts.isIncludeScm(), opts.isIncludeWebhooks(), opts.isWhkRegenAuthTokens(), opts.isIncludeNodeSources(), extraCompOpts, body));
        boolean anyerror = false;
        if (projectImportStatus.getResultSuccess()) {
            this.getRdOutput().info("Jobs imported successfully");
        } else {
            anyerror = true;
            if (null != projectImportStatus.errors && projectImportStatus.errors.size() > 0) {
                this.getRdOutput().error("Some imported Jobs failed:");
                this.getRdOutput().error(projectImportStatus.errors);
            }
        }
        if (null != projectImportStatus.executionErrors && projectImportStatus.executionErrors.size() > 0) {
            anyerror = true;
            this.getRdOutput().error("Some imported executions failed:");
            this.getRdOutput().error(projectImportStatus.executionErrors);
        }
        if (null != projectImportStatus.aclErrors && projectImportStatus.aclErrors.size() > 0) {
            anyerror = true;
            this.getRdOutput().error("Some imported ACLs failed:");
            this.getRdOutput().error(projectImportStatus.aclErrors);
        }
        return (opts.isStrict() ? !anyerror : projectImportStatus.getResultSuccess()) ? 0 : 1;
    }

    @CommandLine.Command(description={"Export a project archive"})
    public int export(@CommandLine.Mixin ArchiveExportOpts opts) throws IOException, InputError {
        HashSet<Flags> includeFlags;
        if (opts.isIncludeFlags() && opts.isExecutionIds()) {
            throw new InputError("Cannot use --execids/-e with --include/-i");
        }
        boolean apiv19 = this.getRdTool().getClient().getApiVersion() >= 19;
        HashSet<Flags> hashSet = includeFlags = opts.isIncludeFlags() ? opts.getIncludeFlags() : new HashSet<Flags>();
        if (!opts.isIncludeFlags()) {
            includeFlags.add(Flags.all);
        }
        String project = this.validate(opts);
        if (!apiv19) {
            if (opts.isIncludeFlags() && includeFlags.size() > 1) {
                throw new InputError("Cannot use --include: " + includeFlags + " with API < 19");
            }
            if (opts.isIncludeFlags() && !includeFlags.contains((Object)Flags.all)) {
                throw new InputError("Cannot use --include: " + includeFlags + " with API < 19");
            }
            this.getRdOutput().info(String.format("Export Archive for project: %s", project));
            if (opts.isExecutionIds()) {
                this.getRdOutput().info(String.format("Contents: only execution IDs: %s", opts.getExecutionIds()));
            } else {
                this.getRdOutput().info("Contents: all");
            }
            this.getRdOutput().info("Begin synchronous request...");
            Archives.receiveArchiveFile(this.getRdOutput(), (ResponseBody)this.apiCall(api -> api.exportProject(project, opts.getExecutionIds())), opts.getFile());
            return 0;
        }
        this.getRdOutput().info(String.format("Export Archive for project: %s", project));
        if (opts.isExecutionIds()) {
            this.getRdOutput().info(String.format("Contents: only execution IDs: %s", opts.getExecutionIds()));
        } else {
            this.getRdOutput().info(String.format("Contents: %s", opts.getIncludeFlags()));
        }
        this.getRdOutput().info("Begin asynchronous request...");
        ProjectExportStatus status = opts.isExecutionIds() ? (ProjectExportStatus)this.apiCall(api -> api.exportProjectAsync(project, opts.getExecutionIds())) : (ProjectExportStatus)this.apiCall(api -> api.exportProjectAsync(project, includeFlags.contains((Object)Flags.all), includeFlags.contains((Object)Flags.jobs), includeFlags.contains((Object)Flags.executions), includeFlags.contains((Object)Flags.configs), includeFlags.contains((Object)Flags.readmes), includeFlags.contains((Object)Flags.acls), includeFlags.contains((Object)Flags.scm)));
        return Archives.loopStatus(this.getRdTool().getClient(), status, project, opts.getFile(), this.getRdOutput(), () -> {
            try {
                Thread.sleep(2000L);
                return true;
            }
            catch (InterruptedException e) {
                return false;
            }
        }) ? 0 : 2;
    }

    public static boolean loopStatus(ServiceClient<RundeckApi> client, ProjectExportStatus status, String project, File outputfile, CommandOutput out, BooleanSupplier waitFunc) throws IOException {
        boolean done = false;
        int perc = status.getPercentage();
        while (!done) {
            ProjectExportStatus status1 = (ProjectExportStatus)client.apiCall((T api) -> api.exportProjectStatus(project, status.getToken()));
            if (status1.getPercentage() > perc) {
                out.output(".");
                perc = status1.getPercentage();
            }
            if ((done = status1.getReady().booleanValue()) || waitFunc.getAsBoolean()) continue;
            break;
        }
        if (done) {
            Archives.receiveArchiveFile(out, (ResponseBody)client.apiCall((T api) -> api.exportProjectDownload(project, status.getToken())), outputfile);
        }
        return done;
    }

    private static void receiveArchiveFile(CommandOutput output, ResponseBody responseBody, File file) throws IOException {
        if (!ServiceClient.hasAnyMediaType(responseBody.contentType(), Client.MEDIA_TYPE_ZIP)) {
            throw new IllegalStateException("Unexpected response format: " + responseBody.contentType());
        }
        InputStream inputStream2 = responseBody.byteStream();
        try (FileOutputStream out = new FileOutputStream(file);){
            long total = Util.copyStream(inputStream2, out);
            output.info(String.format("Wrote %d bytes of %s to file %s%n", total, responseBody.contentType(), file));
        }
    }

    static enum Flags {
        all,
        jobs,
        executions,
        configs,
        readmes,
        acls,
        scm;

    }

    static class ArchiveExportOpts
    extends BaseOptions {
        @CommandLine.Option(names={"--execids", "-e"}, description={"List of execution IDs. Exports only those ids."})
        List<String> executionIds;
        @CommandLine.Option(names={"--include", "-i"}, description={"List of archive contents to include. [all,jobs,executions,configs,readmes,acls,scm]. Default: all. (API v19 required for other options)."})
        Set<Flags> includeFlags;

        ArchiveExportOpts() {
        }

        boolean isExecutionIds() {
            return this.executionIds != null && !this.executionIds.isEmpty();
        }

        boolean isIncludeFlags() {
            return this.includeFlags != null && !this.includeFlags.isEmpty();
        }

        public List<String> getExecutionIds() {
            return this.executionIds;
        }

        public Set<Flags> getIncludeFlags() {
            return this.includeFlags;
        }

        public void setExecutionIds(List<String> executionIds) {
            this.executionIds = executionIds;
        }

        public void setIncludeFlags(Set<Flags> includeFlags) {
            this.includeFlags = includeFlags;
        }
    }

    static class ArchiveImportOpts
    extends BaseOptions {
        @CommandLine.Option(names={"-r"}, description={"Remove Job UUIDs in imported jobs. Default: preserve job UUIDs."})
        boolean remove;
        @CommandLine.Option(names={"-x"}, description={"Do not include executions in import. Default: do include executions in import."})
        boolean noExecutions;
        @CommandLine.Option(names={"-c", "--include-config"}, description={"Include project configuration in import, default: false"})
        boolean includeConfig;
        @CommandLine.Option(names={"-a", "--include-acl"}, description={"Include ACLs in import, default: false"})
        boolean includeAcl;
        @CommandLine.Option(names={"-s", "--include-scm"}, description={"Include SCM configuration in import, default: false (api v28 required)"})
        boolean includeScm;
        @CommandLine.Option(names={"-w", "--include-webhooks"}, description={"Include Webhooks in import, default: false (api v34 required)"})
        boolean includeWebhooks;
        @CommandLine.Option(names={"-t", "--regenerate-tokens"}, description={"regenerate the auth tokens associated with the webhook in import, default: false (api v34 required)"})
        boolean whkRegenAuthTokens;
        @CommandLine.Option(names={"-n", "--include-node-sources"}, description={"Include node resources in import, default: false (api v38 required)"})
        boolean includeNodeSources;
        @CommandLine.Option(names={"--strict"}, description={"Return non-zero exit status if any imported item had an error. Default: only job import errors are treated as failures."})
        boolean strict;
        @CommandLine.Option(names={"--component", "-I"}, arity="0..*", description={"Enable named import components, such as tours-manager (enterprise). See <https://docs.rundeck.com/docs/api/rundeck-api.html#project-archive-import>"})
        Set<String> components;
        @CommandLine.Option(names={"--options", "-O"}, arity="0..*", description={"Set options for enabled components, in the form name.key=value"})
        Map<String, String> componentOptions;

        ArchiveImportOpts() {
        }

        public boolean isRemove() {
            return this.remove;
        }

        public boolean isNoExecutions() {
            return this.noExecutions;
        }

        public boolean isIncludeConfig() {
            return this.includeConfig;
        }

        public boolean isIncludeAcl() {
            return this.includeAcl;
        }

        public boolean isIncludeScm() {
            return this.includeScm;
        }

        public boolean isIncludeWebhooks() {
            return this.includeWebhooks;
        }

        public boolean isWhkRegenAuthTokens() {
            return this.whkRegenAuthTokens;
        }

        public boolean isIncludeNodeSources() {
            return this.includeNodeSources;
        }

        public boolean isStrict() {
            return this.strict;
        }

        public Set<String> getComponents() {
            return this.components;
        }

        public Map<String, String> getComponentOptions() {
            return this.componentOptions;
        }

        public void setRemove(boolean remove) {
            this.remove = remove;
        }

        public void setNoExecutions(boolean noExecutions) {
            this.noExecutions = noExecutions;
        }

        public void setIncludeConfig(boolean includeConfig) {
            this.includeConfig = includeConfig;
        }

        public void setIncludeAcl(boolean includeAcl) {
            this.includeAcl = includeAcl;
        }

        public void setIncludeScm(boolean includeScm) {
            this.includeScm = includeScm;
        }

        public void setIncludeWebhooks(boolean includeWebhooks) {
            this.includeWebhooks = includeWebhooks;
        }

        public void setWhkRegenAuthTokens(boolean whkRegenAuthTokens) {
            this.whkRegenAuthTokens = whkRegenAuthTokens;
        }

        public void setIncludeNodeSources(boolean includeNodeSources) {
            this.includeNodeSources = includeNodeSources;
        }

        public void setStrict(boolean strict) {
            this.strict = strict;
        }

        public void setComponents(Set<String> components) {
            this.components = components;
        }

        public void setComponentOptions(Map<String, String> componentOptions) {
            this.componentOptions = componentOptions;
        }
    }

    static class BaseOptions
    extends ProjectRequiredNameOptions {
        @CommandLine.Option(names={"-f", "--file"}, description={"Output/Import file path"}, required=true)
        private File file;

        BaseOptions() {
        }

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }
}

