/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Paging {
    private int count;
    private int total;
    private int max;
    private int offset;

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String toString() {
        return String.format("Page [%d/%d] results %d - %d (of %d by %d)", this.pagenum(), this.maxPagenum(), this.offset + 1, this.count + this.offset, this.total, this.max);
    }

    public String moreResults(String offsetArg) {
        return this.moreResults(offsetArg, null);
    }

    public String moreResults(String offsetArg, String extra) {
        if (this.hasMoreResults()) {
            int nextOffset = this.getOffset() + this.getMax();
            return String.format("(more results available, append: %s %d%s)", offsetArg, nextOffset, null != extra ? extra : "");
        }
        return "End of results.";
    }

    public int pagenum() {
        if (this.max < 1) {
            return 1;
        }
        int oflow = this.offset % this.max;
        return 1 + (this.offset - oflow) / this.max + (oflow > 0 ? 1 : 0);
    }

    public int maxPagenum() {
        if (this.max < 1) {
            return 1;
        }
        int oflow = this.total % this.max;
        return (this.total - oflow) / this.max + (oflow > 0 ? 1 : 0);
    }

    public int nextPageOffset() {
        if (!this.hasMoreResults()) {
            return -1;
        }
        return this.offset + this.count;
    }

    public boolean hasMoreResults() {
        return this.getTotal() > this.getOffset() + this.getCount();
    }
}

