/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.client.ui.AWT.widget.AdvancedLabel;
import megamek.client.ui.Messages;

public class ConfirmDialog
extends Dialog
implements ActionListener {
    private static final long serialVersionUID = 3187345924955607514L;
    private GridBagLayout gridbag = new GridBagLayout();
    private GridBagConstraints c = new GridBagConstraints();
    private boolean useCheckbox;
    private Checkbox botherCheckbox;
    private Panel panButtons = new Panel();
    private Button butYes = new Button(Messages.getString("Yes"));
    private Button butNo = new Button(Messages.getString("No"));
    private Button defaultButton = this.butYes;
    private boolean confirmation = false;
    private Component firstFocusable;

    public ConfirmDialog(Frame frame, String string, String string2) {
        this(frame, string, string2, false);
    }

    public ConfirmDialog(Frame frame, String string, String string2, char c) {
        this(frame, string, string2, false, c);
    }

    public ConfirmDialog(Frame frame, String string, String string2, boolean bl) {
        this(frame, string, string2, bl, 'y');
    }

    public ConfirmDialog(Frame frame, String string, String string2, boolean bl, char c) {
        super(frame, string, true);
        if ('n' == c) {
            this.defaultButton = this.butNo;
        }
        super.setResizable(false);
        this.useCheckbox = bl;
        this.setLayout(this.gridbag);
        this.addQuestion(string2);
        this.addInputs();
        this.finishSetup(frame);
    }

    private void addQuestion(String string) {
        AdvancedLabel advancedLabel = new AdvancedLabel(string);
        this.c.gridheight = 2;
        this.c.insets = new Insets(5, 5, 5, 5);
        this.gridbag.setConstraints(advancedLabel, this.c);
        this.add(advancedLabel);
    }

    private void addInputs() {
        int n = 2;
        this.c.gridheight = 1;
        if (this.useCheckbox) {
            this.botherCheckbox = new Checkbox(Messages.getString("ConfirmDialog.dontBother"));
            this.c.gridy = n++;
            this.gridbag.setConstraints(this.botherCheckbox, this.c);
            this.add(this.botherCheckbox);
        }
        this.butYes.addActionListener(this);
        this.butNo.addActionListener(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panButtons.setLayout(gridBagLayout);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.ipady = 5;
        gridBagLayout.setConstraints(this.butYes, gridBagConstraints);
        this.panButtons.add(this.butYes);
        gridBagLayout.setConstraints(this.butNo, gridBagConstraints);
        this.panButtons.add(this.butNo);
        this.c.gridy = n;
        this.gridbag.setConstraints(this.panButtons, this.c);
        this.add(this.panButtons);
    }

    private void finishSetup(Frame frame) {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConfirmDialog.this.setVisible(false);
            }
        });
        this.pack();
        Dimension dimension = this.getSize();
        boolean bl = false;
        if (dimension.width < GUIPreferences.getInstance().getMinimumSizeWidth()) {
            dimension.width = GUIPreferences.getInstance().getMinimumSizeWidth();
            bl = true;
        }
        if (dimension.height < GUIPreferences.getInstance().getMinimumSizeHeight()) {
            dimension.height = GUIPreferences.getInstance().getMinimumSizeHeight();
            bl = true;
        }
        if (bl) {
            this.setSize(dimension);
            dimension = this.getSize();
        }
        this.setLocation(frame.getLocation().x + frame.getSize().width / 2 - dimension.width / 2, frame.getLocation().y + frame.getSize().height / 2 - dimension.height / 2);
        this.firstFocusable = this.useCheckbox ? this.botherCheckbox : this.butYes;
        if (!this.firstFocusable.equals(this.defaultButton)) {
            this.firstFocusable.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent focusEvent) {
                    ConfirmDialog.this.defaultButton.requestFocus();
                }

                public void focusLost(FocusEvent focusEvent) {
                    ConfirmDialog.this.firstFocusable.removeFocusListener(this);
                }
            });
        }
    }

    public boolean getAnswer() {
        return this.confirmation;
    }

    public boolean getShowAgain() {
        if (this.botherCheckbox == null) {
            return true;
        }
        return !this.botherCheckbox.getState();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.butYes) {
            this.confirmation = true;
        } else if (actionEvent.getSource() == this.butNo) {
            this.confirmation = false;
        }
        this.setVisible(false);
    }
}

