﻿#include "WizPinyin.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <QDebug>

#include "../share/WizQtHelper.h"
#include "../share/WizMisc.h"
#include "WizMisc.h"


struct WIZCHINESEWORDPINYINDATA
{
	const char* pinyin;
	int yindiao;
    wchar_t chWord;
};

WIZCHINESEWORDPINYINDATA* GetPinYinArray();


class CWizPinYin
{
    std::multimap<wchar_t, WIZCHINESEWORDPINYINDATA> m_data;
	//
	void init()
	{
		if (m_data.empty())
		{
			WIZCHINESEWORDPINYINDATA* p = GetPinYinArray();
			//
			while (1)
			{
				WIZCHINESEWORDPINYINDATA& data = *p;
				//
				if (!data.pinyin)
					break;
				
                m_data.insert(std::make_pair(data.chWord, data));
				//
				//
				p++;
			}
		}
	}
public:
    const char* GetPinYin(wchar_t ch)
	{
		init();
		//
        std::multimap<wchar_t, WIZCHINESEWORDPINYINDATA>::const_iterator it = m_data.find(ch);
		if (it == m_data.end())
			return NULL;
		//
		return it->second.pinyin;
	}
    BOOL GetPinYin(wchar_t ch, bool firstLetterOnly, CWizStdStringArray& arrayText)
	{
		init();
		//
        std::multimap<wchar_t, WIZCHINESEWORDPINYINDATA>::const_iterator itLower = m_data.lower_bound(ch);
        std::multimap<wchar_t, WIZCHINESEWORDPINYINDATA>::const_iterator itUpper = m_data.upper_bound(ch);
		//
		BOOL bFound = FALSE;
        for (std::multimap<wchar_t, WIZCHINESEWORDPINYINDATA>::const_iterator it = itLower;
			it != itUpper;
			it++)
		{
			CString strPinYin = firstLetterOnly ? CString(*(it->second.pinyin)) : CString(it->second.pinyin);
			//
			if (-1  == ::WizFindInArray(arrayText, strPinYin))
			{
				arrayText.push_back(strPinYin);
			}
			bFound = TRUE;
		}
		//
		return bFound;
	}
};

static CWizPinYin g_pinyin;


void MultiplyArray(const CWizStdStringArray& arr1,  const CWizStdStringArray& arr2, const char* lpszSplitter, CWizStdStringArray& arrayRet)
{
	if (arr1.empty())
	{
		arrayRet.assign(arr2.begin(), arr2.end());
	}
	else if (arr2.empty())
	{
		arrayRet.assign(arr1.begin(), arr1.end());
	}
	else
	{
        CString splitter(lpszSplitter);
        //
		for (CWizStdStringArray::const_iterator it1 = arr1.begin();
			it1 != arr1.end();
			it1++)
		{
			for (CWizStdStringArray::const_iterator it2 = arr2.begin();
				it2 != arr2.end();
				it2++)
			{
                CString strRet = *it1 + splitter + *it2;
				arrayRet.push_back(strRet);
			}
		}
	}
}

int WizToolsChinese2PinYinEx(const wchar_t* lpszText, UINT flags, const char* lpszSplitter, QString& pbstrTextResult)
{
	if (!lpszText)
		return E_POINTER;
	//
	if (!*lpszText)
		return S_FALSE;
	//
	bool firstLetterOnly = (WIZ_C2P_FIRST_LETTER_ONLY & flags) ? true : false;
	bool polyphone = (WIZ_C2P_POLYPHONE & flags) ? true : false;
	//
	if (polyphone)
	{
		int polyphoneCount = 0;
		//
		std::vector<CWizStdStringArray > arrayPinYin;
        const wchar_t* p = lpszText;
		while (*p)
		{
            wchar_t ch = *p;
			//
			CWizStdStringArray arrayWordPinYin;
			g_pinyin.GetPinYin(ch, firstLetterOnly, arrayWordPinYin);
			//
			arrayPinYin.push_back(arrayWordPinYin);
			//
			polyphoneCount = std::max<int>(polyphoneCount, int(arrayWordPinYin.size()));
			//
			p++;
		}
		//
		CWizStdStringArray arrayRet;
		//
		for (std::vector<CWizStdStringArray >::const_iterator it = arrayPinYin.begin();
			it != arrayPinYin.end();
			it++)
		{
			const CWizStdStringArray& arr = *it;
			//
			CWizStdStringArray arrayTemp;
			//
			MultiplyArray(arrayRet, arr, lpszSplitter, arrayTemp);
			//
			arrayRet.swap(arrayTemp);
		}
		//
		CString strText;
		::WizStringArrayToText(arrayRet, strText, "\n");
        pbstrTextResult = strText;
        //*pbstrTextResult = strText.AllocSysString();
		//
		return S_OK;
	}
	else
	{
		CWizStdStringArray arr;
		//
        const wchar_t* p = lpszText;
		while (*p)
		{
            wchar_t ch = *p;
			//
			const char* pinyin = g_pinyin.GetPinYin(ch);
			if (pinyin)
			{
				if (firstLetterOnly)
				{
					arr.push_back(CString(*pinyin));
				}
				else
				{
					arr.push_back(CString(pinyin));
				}
			}
			else
			{
				arr.push_back(CString(ch));
			}
			//
			p++;
		}
		//
		CString strText;
		::WizStringArrayToText(arr, strText, CString(lpszSplitter));
        pbstrTextResult = strText;
		//
        //*pbstrTextResult = strText.AllocSysString();
	}
	//
	//
	return S_OK;
}


int WizToolsChinese2PinYin(const wchar_t* lpszText, UINT flags, QString& strTextResult)
{
    return WizToolsChinese2PinYinEx(lpszText, flags, ",", strTextResult);
}

int WizToolsChinese2PinYin(QString text, UINT flags, QString& strTextResult)
{
    int len = text.length() + 1;
    wchar_t* buffer = new wchar_t[len];
    memset(buffer, 0, len * sizeof(wchar_t));
    text.toWCharArray(buffer);
    int ret = WizToolsChinese2PinYin(buffer, flags, strTextResult);
    delete [] buffer;
    return ret;
}
int WizToolsChinese2PinYin(QString text, UINT flags, QString splitter, QString& strTextResult)
{
    int len = text.length() + 1;
    wchar_t* buffer = new wchar_t[len];
    memset(buffer, 0, len * sizeof(wchar_t));
    text.toWCharArray(buffer);
    int ret = WizToolsChinese2PinYinEx(buffer, flags, splitter.toUtf8(), strTextResult);
    delete [] buffer;
    return ret;
}

QString WizToolsChinese2PinYin(QString str)
{
    QString pinyin;
    WizToolsChinese2PinYin(str, 0, "", pinyin);
    return pinyin;
}

bool WizToolsIsChinese(QString str)
{
    if (str.isEmpty())
        return false;
    //
    QString pinyin;
    WizToolsChinese2PinYin(str, WIZ_C2P_FIRST_LETTER_ONLY, "", pinyin);
    if (pinyin.isEmpty())
        return false;
    //
    return pinyin[0] != str[0];
}

int WizToolsSmartCompare(QString text1, QString text2)
{
    static bool isChinese = Utils::WizMisc::isChinese();

    if (text1.isEmpty() && text2.isEmpty()) {
        return 0;
    } else if (text1.isEmpty()) {
        return -1;
    } else if (text2.isEmpty()) {
        return 1;
    }
    //
    //
    if (isChinese) {
        //
        bool chinese1 = WizToolsIsChinese(text1);
        bool chinese2 = WizToolsIsChinese(text2);
        if (chinese1 && chinese2) {
            QString chineseStr1 = WizToolsChinese2PinYin(text1);
            QString chineseStr2 = WizToolsChinese2PinYin(text2);
            return chineseStr1.compare(chineseStr2, Qt::CaseInsensitive);
        } else if (chinese1) {
            return 1;
        } else if (chinese2) {
            return -1;
        } else {
            return text1.compare(text2, Qt::CaseInsensitive);
        }
    } else {
        return text1.compare(text2, Qt::CaseInsensitive);
    }
}



static WIZCHINESEWORDPINYINDATA g_PinYinData [] =
{

{"a", 1, L'啊'},
{"a", 1, L'阿'},
{"a", 1, L'吖'},
{"a", 1, L'腌'},
{"a", 1, L'锕'},
{"a", 2, L'啊'},
{"a", 2, L'嗄'},
{"a", 3, L'啊'},
{"a", 4, L'啊'},
{"a", 5, L'啊'},
{"a", 5, L'呵'},
{"ai", 1, L'埃'},
{"ai", 1, L'挨'},
{"ai", 1, L'哎'},
{"ai", 1, L'唉'},
{"ai", 1, L'哀'},
{"ai", 1, L'嗳'},
{"ai", 1, L'锿'},
{"ai", 2, L'挨'},
{"ai", 2, L'皑'},
{"ai", 2, L'癌'},
{"ai", 2, L'捱'},
{"ai", 3, L'蔼'},
{"ai", 3, L'矮'},
{"ai", 3, L'诶'},
{"ai", 3, L'嗳'},
{"ai", 3, L'霭'},
{"ai", 4, L'唉'},
{"ai", 4, L'艾'},
{"ai", 4, L'碍'},
{"ai", 4, L'爱'},
{"ai", 4, L'隘'},
{"ai", 4, L'嗳'},
{"ai", 4, L'嗌'},
{"ai", 4, L'嫒'},
{"ai", 4, L'瑷'},
{"ai", 4, L'暧'},
{"ai", 4, L'砹'},
{"an", 1, L'鞍'},
{"an", 1, L'氨'},
{"an", 1, L'安'},
{"an", 1, L'厂'},
{"an", 1, L'广'},
{"an", 1, L'谙'},
{"an", 1, L'庵'},
{"an", 1, L'桉'},
{"an", 1, L'鹌'},
{"an", 3, L'俺'},
{"an", 3, L'埯'},
{"an", 3, L'揞'},
{"an", 3, L'铵'},
{"an", 4, L'按'},
{"an", 4, L'暗'},
{"an", 4, L'岸'},
{"an", 4, L'胺'},
{"an", 4, L'案'},
{"an", 4, L'犴'},
{"an", 4, L'黯'},
{"ang", 1, L'肮'},
{"ang", 2, L'昂'},
{"ang", 4, L'盎'},
{"ao", 1, L'凹'},
{"ao", 1, L'熬'},
{"ao", 2, L'敖'},
{"ao", 2, L'熬'},
{"ao", 2, L'翱'},
{"ao", 2, L'嗷'},
{"ao", 2, L'廒'},
{"ao", 2, L'遨'},
{"ao", 2, L'獒'},
{"ao", 2, L'聱'},
{"ao", 2, L'螯'},
{"ao", 2, L'鳌'},
{"ao", 2, L'鏖'},
{"ao", 3, L'袄'},
{"ao", 3, L'拗'},
{"ao", 3, L'媪'},
{"ao", 4, L'傲'},
{"ao", 4, L'奥'},
{"ao", 4, L'懊'},
{"ao", 4, L'澳'},
{"ao", 4, L'坳'},
{"ao", 4, L'拗'},
{"ao", 4, L'岙'},
{"ao", 4, L'骜'},
{"ao", 4, L'鏊'},
{"ba", 1, L'芭'},
{"ba", 1, L'捌'},
{"ba", 1, L'扒'},
{"ba", 1, L'叭'},
{"ba", 1, L'吧'},
{"ba", 1, L'笆'},
{"ba", 1, L'八'},
{"ba", 1, L'疤'},
{"ba", 1, L'巴'},
{"ba", 1, L'岜'},
{"ba", 1, L'粑'},
{"ba", 2, L'拔'},
{"ba", 2, L'跋'},
{"ba", 2, L'茇'},
{"ba", 2, L'菝'},
{"ba", 2, L'魃'},
{"ba", 3, L'靶'},
{"ba", 3, L'把'},
{"ba", 3, L'钯'},
{"ba", 4, L'把'},
{"ba", 4, L'耙'},
{"ba", 4, L'坝'},
{"ba", 4, L'霸'},
{"ba", 4, L'罢'},
{"ba", 4, L'爸'},
{"ba", 4, L'灞'},
{"ba", 4, L'鲅'},
{"ba", 5, L'吧'},
{"ba", 5, L'罢'},
{"bai", 1, L'掰'},
{"bai", 1, L'擘'},
{"bai", 2, L'白'},
{"bai", 3, L'柏'},
{"bai", 3, L'百'},
{"bai", 3, L'摆'},
{"bai", 3, L'佰'},
{"bai", 3, L'伯'},
{"bai", 3, L'捭'},
{"bai", 4, L'败'},
{"bai", 4, L'拜'},
{"bai", 4, L'稗'},
{"bai", 4, L'呗'},
{"ban", 1, L'斑'},
{"ban", 1, L'班'},
{"ban", 1, L'搬'},
{"ban", 1, L'扳'},
{"ban", 1, L'般'},
{"ban", 1, L'颁'},
{"ban", 1, L'瘢'},
{"ban", 1, L'癍'},
{"ban", 3, L'板'},
{"ban", 3, L'版'},
{"ban", 3, L'阪'},
{"ban", 3, L'坂'},
{"ban", 3, L'钣'},
{"ban", 3, L'舨'},
{"ban", 4, L'扮'},
{"ban", 4, L'拌'},
{"ban", 4, L'伴'},
{"ban", 4, L'瓣'},
{"ban", 4, L'半'},
{"ban", 4, L'办'},
{"ban", 4, L'绊'},
{"bang", 1, L'邦'},
{"bang", 1, L'帮'},
{"bang", 1, L'梆'},
{"bang", 1, L'浜'},
{"bang", 3, L'榜'},
{"bang", 3, L'膀'},
{"bang", 3, L'绑'},
{"bang", 4, L'棒'},
{"bang", 4, L'磅'},
{"bang", 4, L'蚌'},
{"bang", 4, L'镑'},
{"bang", 4, L'傍'},
{"bang", 4, L'谤'},
{"bang", 4, L'蒡'},
{"bao", 1, L'苞'},
{"bao", 1, L'胞'},
{"bao", 1, L'包'},
{"bao", 1, L'褒'},
{"bao", 1, L'剥'},
{"bao", 1, L'炮'},
{"bao", 1, L'孢'},
{"bao", 1, L'煲'},
{"bao", 1, L'龅'},
{"bao", 2, L'薄'},
{"bao", 2, L'雹'},
{"bao", 3, L'保'},
{"bao", 3, L'堡'},
{"bao", 3, L'饱'},
{"bao", 3, L'宝'},
{"bao", 3, L'葆'},
{"bao", 3, L'鸨'},
{"bao", 3, L'褓'},
{"bao", 4, L'抱'},
{"bao", 4, L'报'},
{"bao", 4, L'暴'},
{"bao", 4, L'豹'},
{"bao", 4, L'鲍'},
{"bao", 4, L'爆'},
{"bao", 4, L'刨'},
{"bao", 4, L'曝'},
{"bao", 4, L'瀑'},
{"bao", 4, L'趵'},
{"bei", 1, L'杯'},
{"bei", 1, L'碑'},
{"bei", 1, L'悲'},
{"bei", 1, L'卑'},
{"bei", 1, L'背'},
{"bei", 1, L'陂'},
{"bei", 1, L'庳'},
{"bei", 1, L'鹎'},
{"bei", 3, L'北'},
{"bei", 4, L'辈'},
{"bei", 4, L'背'},
{"bei", 4, L'贝'},
{"bei", 4, L'钡'},
{"bei", 4, L'倍'},
{"bei", 4, L'狈'},
{"bei", 4, L'备'},
{"bei", 4, L'惫'},
{"bei", 4, L'焙'},
{"bei", 4, L'被'},
{"bei", 4, L'孛'},
{"bei", 4, L'邶'},
{"bei", 4, L'蓓'},
{"bei", 4, L'悖'},
{"bei", 4, L'碚'},
{"bei", 4, L'褙'},
{"bei", 4, L'鐾'},
{"bei", 4, L'鞴'},
{"bei", 5, L'臂'},
{"bei", 5, L'呗'},
{"ben", 1, L'奔'},
{"ben", 1, L'贲'},
{"ben", 1, L'锛'},
{"ben", 3, L'苯'},
{"ben", 3, L'本'},
{"ben", 3, L'畚'},
{"ben", 4, L'奔'},
{"ben", 4, L'笨'},
{"ben", 4, L'夯'},
{"ben", 4, L'坌'},
{"beng", 1, L'崩'},
{"beng", 1, L'绷'},
{"beng", 1, L'嘣'},
{"beng", 2, L'甭'},
{"beng", 3, L'绷'},
{"beng", 4, L'蚌'},
{"beng", 4, L'泵'},
{"beng", 4, L'蹦'},
{"beng", 4, L'迸'},
{"beng", 4, L'甏'},
{"bi", 1, L'逼'},
{"bi", 2, L'鼻'},
{"bi", 2, L'荸'},
{"bi", 3, L'比'},
{"bi", 3, L'鄙'},
{"bi", 3, L'笔'},
{"bi", 3, L'彼'},
{"bi", 3, L'匕'},
{"bi", 3, L'俾'},
{"bi", 3, L'吡'},
{"bi", 3, L'妣'},
{"bi", 3, L'秕'},
{"bi", 3, L'舭'},
{"bi", 4, L'碧'},
{"bi", 4, L'蓖'},
{"bi", 4, L'蔽'},
{"bi", 4, L'毕'},
{"bi", 4, L'毙'},
{"bi", 4, L'毖'},
{"bi", 4, L'币'},
{"bi", 4, L'庇'},
{"bi", 4, L'痹'},
{"bi", 4, L'闭'},
{"bi", 4, L'敝'},
{"bi", 4, L'弊'},
{"bi", 4, L'必'},
{"bi", 4, L'辟'},
{"bi", 4, L'壁'},
{"bi", 4, L'臂'},
{"bi", 4, L'避'},
{"bi", 4, L'陛'},
{"bi", 4, L'秘'},
{"bi", 4, L'泌'},
{"bi", 4, L'荜'},
{"bi", 4, L'萆'},
{"bi", 4, L'薜'},
{"bi", 4, L'哔'},
{"bi", 4, L'狴'},
{"bi", 4, L'庳'},
{"bi", 4, L'愎'},
{"bi", 4, L'滗'},
{"bi", 4, L'濞'},
{"bi", 4, L'弼'},
{"bi", 4, L'婢'},
{"bi", 4, L'嬖'},
{"bi", 4, L'璧'},
{"bi", 4, L'贲'},
{"bi", 4, L'睥'},
{"bi", 4, L'畀'},
{"bi", 4, L'铋'},
{"bi", 4, L'裨'},
{"bi", 4, L'筚'},
{"bi", 4, L'箅'},
{"bi", 4, L'篦'},
{"bi", 4, L'襞'},
{"bi", 4, L'跸'},
{"bi", 4, L'髀'},
{"bian", 1, L'鞭'},
{"bian", 1, L'边'},
{"bian", 1, L'编'},
{"bian", 1, L'煸'},
{"bian", 1, L'砭'},
{"bian", 1, L'蝙'},
{"bian", 1, L'笾'},
{"bian", 1, L'鳊'},
{"bian", 3, L'贬'},
{"bian", 3, L'扁'},
{"bian", 3, L'匾'},
{"bian", 3, L'碥'},
{"bian", 3, L'窆'},
{"bian", 3, L'褊'},
{"bian", 4, L'便'},
{"bian", 4, L'变'},
{"bian", 4, L'卞'},
{"bian", 4, L'辨'},
{"bian", 4, L'辩'},
{"bian", 4, L'辫'},
{"bian", 4, L'遍'},
{"bian", 4, L'弁'},
{"bian", 4, L'苄'},
{"bian", 4, L'忭'},
{"bian", 4, L'汴'},
{"bian", 4, L'缏'},
{"biao", 1, L'标'},
{"biao", 1, L'彪'},
{"biao", 1, L'膘'},
{"biao", 1, L'骠'},
{"biao", 1, L'杓'},
{"biao", 1, L'飑'},
{"biao", 1, L'飙'},
{"biao", 1, L'飚'},
{"biao", 1, L'镖'},
{"biao", 1, L'镳'},
{"biao", 1, L'瘭'},
{"biao", 1, L'髟'},
{"biao", 3, L'表'},
{"biao", 3, L'婊'},
{"biao", 3, L'裱'},
{"biao", 4, L'鳔'},
{"bie", 1, L'鳖'},
{"bie", 1, L'憋'},
{"bie", 1, L'瘪'},
{"bie", 2, L'别'},
{"bie", 2, L'蹩'},
{"bie", 3, L'瘪'},
{"bie", 4, L'别'},
{"bin", 1, L'彬'},
{"bin", 1, L'斌'},
{"bin", 1, L'濒'},
{"bin", 1, L'滨'},
{"bin", 1, L'宾'},
{"bin", 1, L'傧'},
{"bin", 1, L'豳'},
{"bin", 1, L'缤'},
{"bin", 1, L'玢'},
{"bin", 1, L'槟'},
{"bin", 1, L'镔'},
{"bin", 4, L'摈'},
{"bin", 4, L'殡'},
{"bin", 4, L'膑'},
{"bin", 4, L'髌'},
{"bin", 4, L'鬓'},
{"bing", 1, L'兵'},
{"bing", 1, L'冰'},
{"bing", 1, L'并'},
{"bing", 1, L'槟'},
{"bing", 3, L'柄'},
{"bing", 3, L'丙'},
{"bing", 3, L'秉'},
{"bing", 3, L'饼'},
{"bing", 3, L'炳'},
{"bing", 3, L'屏'},
{"bing", 3, L'禀'},
{"bing", 3, L'邴'},
{"bing", 4, L'柄'},
{"bing", 4, L'病'},
{"bing", 4, L'并'},
{"bing", 4, L'摒'},
{"bo", 1, L'剥'},
{"bo", 1, L'玻'},
{"bo", 1, L'菠'},
{"bo", 1, L'播'},
{"bo", 1, L'拨'},
{"bo", 1, L'钵'},
{"bo", 1, L'波'},
{"bo", 1, L'饽'},
{"bo", 2, L'柏'},
{"bo", 2, L'薄'},
{"bo", 2, L'博'},
{"bo", 2, L'勃'},
{"bo", 2, L'搏'},
{"bo", 2, L'铂'},
{"bo", 2, L'箔'},
{"bo", 2, L'伯'},
{"bo", 2, L'帛'},
{"bo", 2, L'舶'},
{"bo", 2, L'脖'},
{"bo", 2, L'膊'},
{"bo", 2, L'渤'},
{"bo", 2, L'泊'},
{"bo", 2, L'驳'},
{"bo", 2, L'魄'},
{"bo", 2, L'亳'},
{"bo", 2, L'礴'},
{"bo", 2, L'钹'},
{"bo", 2, L'鹁'},
{"bo", 2, L'踣'},
{"bo", 3, L'簸'},
{"bo", 3, L'跛'},
{"bo", 4, L'柏'},
{"bo", 4, L'薄'},
{"bo", 4, L'檗'},
{"bo", 4, L'擘'},
{"bo", 4, L'簸'},
{"bo", 5, L'卜'},
{"bo", 5, L'啵'},
{"bu", 1, L'逋'},
{"bu", 1, L'晡'},
{"bu", 1, L'钸'},
{"bu", 2, L'不'},
{"bu", 2, L'醭'},
{"bu", 3, L'堡'},
{"bu", 3, L'捕'},
{"bu", 3, L'卜'},
{"bu", 3, L'哺'},
{"bu", 3, L'补'},
{"bu", 3, L'卟'},
{"bu", 4, L'埠'},
{"bu", 4, L'不'},
{"bu", 4, L'布'},
{"bu", 4, L'步'},
{"bu", 4, L'簿'},
{"bu", 4, L'部'},
{"bu", 4, L'怖'},
{"bu", 4, L'埔'},
{"bu", 4, L'瓿'},
{"bu", 4, L'钚'},
{"ca", 1, L'擦'},
{"ca", 1, L'拆'},
{"ca", 1, L'嚓'},
{"ca", 3, L'礤'},
{"cai", 1, L'猜'},
{"cai", 2, L'裁'},
{"cai", 2, L'材'},
{"cai", 2, L'才'},
{"cai", 2, L'财'},
{"cai", 3, L'睬'},
{"cai", 3, L'踩'},
{"cai", 3, L'采'},
{"cai", 3, L'彩'},
{"cai", 4, L'采'},
{"cai", 4, L'菜'},
{"cai", 4, L'蔡'},
{"can", 1, L'餐'},
{"can", 1, L'参'},
{"can", 1, L'骖'},
{"can", 2, L'蚕'},
{"can", 2, L'残'},
{"can", 2, L'惭'},
{"can", 3, L'惨'},
{"can", 3, L'黪'},
{"can", 4, L'灿'},
{"can", 4, L'掺'},
{"can", 4, L'孱'},
{"can", 4, L'璨'},
{"can", 4, L'粲'},
{"cang", 1, L'苍'},
{"cang", 1, L'舱'},
{"cang", 1, L'仓'},
{"cang", 1, L'沧'},
{"cang", 1, L'伧'},
{"cang", 2, L'藏'},
{"cao", 1, L'操'},
{"cao", 1, L'糙'},
{"cao", 2, L'槽'},
{"cao", 2, L'曹'},
{"cao", 2, L'嘈'},
{"cao", 2, L'漕'},
{"cao", 2, L'螬'},
{"cao", 2, L'艚'},
{"cao", 3, L'草'},
{"ce", 4, L'厕'},
{"ce", 4, L'策'},
{"ce", 4, L'侧'},
{"ce", 4, L'册'},
{"ce", 4, L'测'},
{"ce", 4, L'恻'},
{"cen", 1, L'参'},
{"cen", 2, L'岑'},
{"cen", 2, L'涔'},
{"ceng", 1, L'噌'},
{"ceng", 2, L'层'},
{"ceng", 2, L'曾'},
{"ceng", 4, L'蹭'},
{"cha", 1, L'插'},
{"cha", 1, L'叉'},
{"cha", 1, L'碴'},
{"cha", 1, L'差'},
{"cha", 1, L'喳'},
{"cha", 1, L'嚓'},
{"cha", 1, L'馇'},
{"cha", 1, L'杈'},
{"cha", 1, L'锸'},
{"cha", 2, L'叉'},
{"cha", 2, L'茬'},
{"cha", 2, L'茶'},
{"cha", 2, L'查'},
{"cha", 2, L'碴'},
{"cha", 2, L'搽'},
{"cha", 2, L'察'},
{"cha", 2, L'猹'},
{"cha", 2, L'楂'},
{"cha", 2, L'槎'},
{"cha", 2, L'檫'},
{"cha", 3, L'叉'},
{"cha", 3, L'镲'},
{"cha", 3, L'衩'},
{"cha", 4, L'岔'},
{"cha", 4, L'差'},
{"cha", 4, L'诧'},
{"cha", 4, L'刹'},
{"cha", 4, L'汊'},
{"cha", 4, L'姹'},
{"cha", 4, L'杈'},
{"cha", 4, L'衩'},
{"chai", 1, L'差'},
{"chai", 1, L'拆'},
{"chai", 1, L'钗'},
{"chai", 2, L'柴'},
{"chai", 2, L'豺'},
{"chai", 2, L'侪'},
{"chai", 4, L'瘥'},
{"chai", 4, L'虿'},
{"chan", 1, L'搀'},
{"chan", 1, L'掺'},
{"chan", 1, L'觇'},
{"chan", 2, L'蝉'},
{"chan", 2, L'馋'},
{"chan", 2, L'谗'},
{"chan", 2, L'缠'},
{"chan", 2, L'单'},
{"chan", 2, L'廛'},
{"chan", 2, L'潺'},
{"chan", 2, L'澶'},
{"chan", 2, L'孱'},
{"chan", 2, L'婵'},
{"chan", 2, L'禅'},
{"chan", 2, L'镡'},
{"chan", 2, L'蟾'},
{"chan", 2, L'躔'},
{"chan", 3, L'铲'},
{"chan", 3, L'产'},
{"chan", 3, L'阐'},
{"chan", 3, L'冁'},
{"chan", 3, L'谄'},
{"chan", 3, L'蒇'},
{"chan", 3, L'骣'},
{"chan", 4, L'颤'},
{"chan", 4, L'忏'},
{"chan", 4, L'羼'},
{"chang", 1, L'昌'},
{"chang", 1, L'猖'},
{"chang", 1, L'伥'},
{"chang", 1, L'菖'},
{"chang", 1, L'阊'},
{"chang", 1, L'娼'},
{"chang", 1, L'鲳'},
{"chang", 2, L'场'},
{"chang", 2, L'尝'},
{"chang", 2, L'常'},
{"chang", 2, L'长'},
{"chang", 2, L'偿'},
{"chang", 2, L'肠'},
{"chang", 2, L'裳'},
{"chang", 2, L'倘'},
{"chang", 2, L'苌'},
{"chang", 2, L'徜'},
{"chang", 2, L'嫦'},
{"chang", 3, L'场'},
{"chang", 3, L'厂'},
{"chang", 3, L'敞'},
{"chang", 3, L'惝'},
{"chang", 3, L'昶'},
{"chang", 3, L'氅'},
{"chang", 4, L'畅'},
{"chang", 4, L'唱'},
{"chang", 4, L'倡'},
{"chang", 4, L'鬯'},
{"chang", 4, L'怅'},
{"chao", 1, L'超'},
{"chao", 1, L'抄'},
{"chao", 1, L'钞'},
{"chao", 1, L'吵'},
{"chao", 1, L'绰'},
{"chao", 1, L'剿'},
{"chao", 1, L'怊'},
{"chao", 1, L'焯'},
{"chao", 2, L'朝'},
{"chao", 2, L'嘲'},
{"chao", 2, L'潮'},
{"chao", 2, L'巢'},
{"chao", 2, L'晁'},
{"chao", 3, L'吵'},
{"chao", 3, L'炒'},
{"chao", 4, L'耖'},
{"che", 1, L'车'},
{"che", 1, L'砗'},
{"che", 3, L'扯'},
{"che", 3, L'尺'},
{"che", 4, L'撤'},
{"che", 4, L'掣'},
{"che", 4, L'彻'},
{"che", 4, L'澈'},
{"che", 4, L'坼'},
{"chen", 1, L'郴'},
{"chen", 1, L'抻'},
{"chen", 1, L'嗔'},
{"chen", 1, L'琛'},
{"chen", 2, L'臣'},
{"chen", 2, L'辰'},
{"chen", 2, L'尘'},
{"chen", 2, L'晨'},
{"chen", 2, L'忱'},
{"chen", 2, L'沉'},
{"chen", 2, L'陈'},
{"chen", 2, L'沈'},
{"chen", 2, L'谌'},
{"chen", 2, L'宸'},
{"chen", 3, L'碜'},
{"chen", 4, L'趁'},
{"chen", 4, L'衬'},
{"chen", 4, L'称'},
{"chen", 4, L'谶'},
{"chen", 4, L'榇'},
{"chen", 4, L'龀'},
{"cheng", 1, L'撑'},
{"cheng", 1, L'称'},
{"cheng", 1, L'柽'},
{"cheng", 1, L'瞠'},
{"cheng", 1, L'铛'},
{"cheng", 1, L'蛏'},
{"cheng", 2, L'城'},
{"cheng", 2, L'橙'},
{"cheng", 2, L'成'},
{"cheng", 2, L'呈'},
{"cheng", 2, L'乘'},
{"cheng", 2, L'程'},
{"cheng", 2, L'惩'},
{"cheng", 2, L'澄'},
{"cheng", 2, L'诚'},
{"cheng", 2, L'承'},
{"cheng", 2, L'盛'},
{"cheng", 2, L'丞'},
{"cheng", 2, L'埕'},
{"cheng", 2, L'枨'},
{"cheng", 2, L'塍'},
{"cheng", 2, L'铖'},
{"cheng", 2, L'裎'},
{"cheng", 2, L'酲'},
{"cheng", 3, L'逞'},
{"cheng", 3, L'骋'},
{"cheng", 4, L'称'},
{"cheng", 4, L'秤'},
{"chi", 1, L'吃'},
{"chi", 1, L'痴'},
{"chi", 1, L'哧'},
{"chi", 1, L'嗤'},
{"chi", 1, L'媸'},
{"chi", 1, L'眵'},
{"chi", 1, L'鸱'},
{"chi", 1, L'蚩'},
{"chi", 1, L'螭'},
{"chi", 1, L'笞'},
{"chi", 1, L'魑'},
{"chi", 2, L'持'},
{"chi", 2, L'匙'},
{"chi", 2, L'池'},
{"chi", 2, L'迟'},
{"chi", 2, L'弛'},
{"chi", 2, L'驰'},
{"chi", 2, L'坻'},
{"chi", 2, L'墀'},
{"chi", 2, L'茌'},
{"chi", 2, L'篪'},
{"chi", 2, L'踟'},
{"chi", 3, L'耻'},
{"chi", 3, L'齿'},
{"chi", 3, L'侈'},
{"chi", 3, L'尺'},
{"chi", 3, L'褫'},
{"chi", 3, L'豉'},
{"chi", 4, L'赤'},
{"chi", 4, L'翅'},
{"chi", 4, L'斥'},
{"chi", 4, L'炽'},
{"chi", 4, L'傺'},
{"chi", 4, L'叱'},
{"chi", 4, L'啻'},
{"chi", 4, L'彳'},
{"chi", 4, L'饬'},
{"chi", 4, L'敕'},
{"chi", 4, L'瘛'},
{"chong", 1, L'充'},
{"chong", 1, L'冲'},
{"chong", 1, L'涌'},
{"chong", 1, L'茺'},
{"chong", 1, L'忡'},
{"chong", 1, L'憧'},
{"chong", 1, L'舂'},
{"chong", 1, L'艟'},
{"chong", 2, L'虫'},
{"chong", 2, L'崇'},
{"chong", 2, L'种'},
{"chong", 2, L'重'},
{"chong", 3, L'宠'},
{"chong", 4, L'冲'},
{"chong", 4, L'铳'},
{"chou", 1, L'抽'},
{"chou", 1, L'瘳'},
{"chou", 2, L'酬'},
{"chou", 2, L'畴'},
{"chou", 2, L'踌'},
{"chou", 2, L'稠'},
{"chou", 2, L'愁'},
{"chou", 2, L'筹'},
{"chou", 2, L'仇'},
{"chou", 2, L'绸'},
{"chou", 2, L'俦'},
{"chou", 2, L'帱'},
{"chou", 2, L'惆'},
{"chou", 2, L'雠'},
{"chou", 3, L'瞅'},
{"chou", 3, L'丑'},
{"chu", 1, L'初'},
{"chu", 1, L'出'},
{"chu", 1, L'樗'},
{"chu", 2, L'橱'},
{"chu", 2, L'厨'},
{"chu", 2, L'躇'},
{"chu", 2, L'锄'},
{"chu", 2, L'雏'},
{"chu", 2, L'滁'},
{"chu", 2, L'除'},
{"chu", 2, L'刍'},
{"chu", 2, L'蜍'},
{"chu", 2, L'蹰'},
{"chu", 3, L'楚'},
{"chu", 3, L'础'},
{"chu", 3, L'储'},
{"chu", 3, L'处'},
{"chu", 3, L'杵'},
{"chu", 3, L'楮'},
{"chu", 3, L'褚'},
{"chu", 4, L'矗'},
{"chu", 4, L'搐'},
{"chu", 4, L'触'},
{"chu", 4, L'处'},
{"chu", 4, L'畜'},
{"chu", 4, L'亍'},
{"chu", 4, L'怵'},
{"chu", 4, L'憷'},
{"chu", 4, L'绌'},
{"chu", 4, L'黜'},
{"chuai", 1, L'揣'},
{"chuai", 1, L'搋'},
{"chuai", 3, L'揣'},
{"chuai", 4, L'揣'},
{"chuai", 4, L'啜'},
{"chuai", 4, L'嘬'},
{"chuai", 4, L'膪'},
{"chuai", 4, L'踹'},
{"chuan", 1, L'川'},
{"chuan", 1, L'穿'},
{"chuan", 1, L'巛'},
{"chuan", 1, L'氚'},
{"chuan", 2, L'椽'},
{"chuan", 2, L'传'},
{"chuan", 2, L'船'},
{"chuan", 2, L'遄'},
{"chuan", 2, L'舡'},
{"chuan", 3, L'喘'},
{"chuan", 3, L'舛'},
{"chuan", 4, L'串'},
{"chuan", 4, L'钏'},
{"chuang", 1, L'疮'},
{"chuang", 1, L'窗'},
{"chuang", 1, L'创'},
{"chuang", 2, L'幢'},
{"chuang", 2, L'床'},
{"chuang", 3, L'闯'},
{"chuang", 4, L'创'},
{"chuang", 4, L'怆'},
{"chui", 1, L'吹'},
{"chui", 1, L'炊'},
{"chui", 2, L'捶'},
{"chui", 2, L'锤'},
{"chui", 2, L'垂'},
{"chui", 2, L'椎'},
{"chui", 2, L'陲'},
{"chui", 2, L'棰'},
{"chui", 2, L'槌'},
{"chun", 1, L'春'},
{"chun", 1, L'椿'},
{"chun", 1, L'蝽'},
{"chun", 2, L'醇'},
{"chun", 2, L'唇'},
{"chun", 2, L'淳'},
{"chun", 2, L'纯'},
{"chun", 2, L'莼'},
{"chun", 2, L'鹑'},
{"chun", 3, L'蠢'},
{"chuo", 1, L'戳'},
{"chuo", 1, L'踔'},
{"chuo", 4, L'绰'},
{"chuo", 4, L'啜'},
{"chuo", 4, L'辍'},
{"chuo", 4, L'龊'},
{"ci", 1, L'差'},
{"ci", 1, L'疵'},
{"ci", 1, L'刺'},
{"ci", 1, L'呲'},
{"ci", 2, L'茨'},
{"ci", 2, L'磁'},
{"ci", 2, L'雌'},
{"ci", 2, L'辞'},
{"ci", 2, L'慈'},
{"ci", 2, L'瓷'},
{"ci", 2, L'词'},
{"ci", 2, L'兹'},
{"ci", 2, L'茈'},
{"ci", 2, L'祠'},
{"ci", 2, L'鹚'},
{"ci", 2, L'糍'},
{"ci", 3, L'此'},
{"ci", 4, L'刺'},
{"ci", 4, L'赐'},
{"ci", 4, L'次'},
{"ci", 4, L'伺'},
{"cong", 1, L'聪'},
{"cong", 1, L'葱'},
{"cong", 1, L'囱'},
{"cong", 1, L'匆'},
{"cong", 1, L'苁'},
{"cong", 1, L'骢'},
{"cong", 1, L'璁'},
{"cong", 1, L'枞'},
{"cong", 2, L'从'},
{"cong", 2, L'丛'},
{"cong", 2, L'淙'},
{"cong", 2, L'琮'},
{"cou", 4, L'凑'},
{"cou", 4, L'楱'},
{"cou", 4, L'辏'},
{"cou", 4, L'腠'},
{"cu", 1, L'粗'},
{"cu", 2, L'徂'},
{"cu", 2, L'殂'},
{"cu", 4, L'醋'},
{"cu", 4, L'簇'},
{"cu", 4, L'促'},
{"cu", 4, L'卒'},
{"cu", 4, L'蔟'},
{"cu", 4, L'猝'},
{"cu", 4, L'酢'},
{"cu", 4, L'蹙'},
{"cu", 4, L'蹴'},
{"cuan", 1, L'蹿'},
{"cuan", 1, L'汆'},
{"cuan", 1, L'撺'},
{"cuan", 1, L'镩'},
{"cuan", 2, L'攒'},
{"cuan", 4, L'篡'},
{"cuan", 4, L'窜'},
{"cuan", 4, L'爨'},
{"cui", 1, L'摧'},
{"cui", 1, L'崔'},
{"cui", 1, L'催'},
{"cui", 1, L'衰'},
{"cui", 1, L'榱'},
{"cui", 3, L'璀'},
{"cui", 4, L'脆'},
{"cui", 4, L'瘁'},
{"cui", 4, L'粹'},
{"cui", 4, L'淬'},
{"cui", 4, L'翠'},
{"cui", 4, L'萃'},
{"cui", 4, L'啐'},
{"cui", 4, L'悴'},
{"cui", 4, L'毳'},
{"cun", 1, L'村'},
{"cun", 1, L'皴'},
{"cun", 2, L'存'},
{"cun", 2, L'蹲'},
{"cun", 3, L'忖'},
{"cun", 4, L'寸'},
{"cuo", 1, L'磋'},
{"cuo", 1, L'撮'},
{"cuo", 1, L'搓'},
{"cuo", 1, L'蹉'},
{"cuo", 2, L'嵯'},
{"cuo", 2, L'矬'},
{"cuo", 2, L'痤'},
{"cuo", 2, L'瘥'},
{"cuo", 2, L'鹾'},
{"cuo", 3, L'脞'},
{"cuo", 4, L'措'},
{"cuo", 4, L'挫'},
{"cuo", 4, L'错'},
{"cuo", 4, L'厝'},
{"cuo", 4, L'锉'},
{"da", 1, L'搭'},
{"da", 1, L'答'},
{"da", 1, L'耷'},
{"da", 1, L'哒'},
{"da", 1, L'嗒'},
{"da", 1, L'褡'},
{"da", 2, L'达'},
{"da", 2, L'答'},
{"da", 2, L'瘩'},
{"da", 2, L'打'},
{"da", 2, L'怛'},
{"da", 2, L'妲'},
{"da", 2, L'沓'},
{"da", 2, L'笪'},
{"da", 2, L'靼'},
{"da", 2, L'鞑'},
{"da", 3, L'打'},
{"da", 4, L'大'},
{"da", 5, L'瘩'},
{"da", 5, L'疸'},
{"dai", 1, L'呆'},
{"dai", 1, L'待'},
{"dai", 1, L'呔'},
{"dai", 3, L'歹'},
{"dai", 3, L'傣'},
{"dai", 3, L'逮'},
{"dai", 4, L'大'},
{"dai", 4, L'戴'},
{"dai", 4, L'带'},
{"dai", 4, L'殆'},
{"dai", 4, L'代'},
{"dai", 4, L'贷'},
{"dai", 4, L'袋'},
{"dai", 4, L'待'},
{"dai", 4, L'逮'},
{"dai", 4, L'怠'},
{"dai", 4, L'埭'},
{"dai", 4, L'甙'},
{"dai", 4, L'岱'},
{"dai", 4, L'迨'},
{"dai", 4, L'骀'},
{"dai", 4, L'绐'},
{"dai", 4, L'玳'},
{"dai", 4, L'黛'},
{"dan", 1, L'耽'},
{"dan", 1, L'担'},
{"dan", 1, L'丹'},
{"dan", 1, L'单'},
{"dan", 1, L'郸'},
{"dan", 1, L'儋'},
{"dan", 1, L'殚'},
{"dan", 1, L'眈'},
{"dan", 1, L'瘅'},
{"dan", 1, L'聃'},
{"dan", 1, L'箪'},
{"dan", 3, L'担'},
{"dan", 3, L'掸'},
{"dan", 3, L'胆'},
{"dan", 3, L'赕'},
{"dan", 3, L'疸'},
{"dan", 4, L'担'},
{"dan", 4, L'旦'},
{"dan", 4, L'氮'},
{"dan", 4, L'但'},
{"dan", 4, L'惮'},
{"dan", 4, L'淡'},
{"dan", 4, L'诞'},
{"dan", 4, L'弹'},
{"dan", 4, L'蛋'},
{"dan", 4, L'石'},
{"dan", 4, L'萏'},
{"dan", 4, L'啖'},
{"dan", 4, L'澹'},
{"dan", 4, L'瘅'},
{"dang", 1, L'当'},
{"dang", 1, L'铛'},
{"dang", 1, L'裆'},
{"dang", 3, L'挡'},
{"dang", 3, L'党'},
{"dang", 3, L'谠'},
{"dang", 4, L'当'},
{"dang", 4, L'挡'},
{"dang", 4, L'荡'},
{"dang", 4, L'档'},
{"dang", 4, L'凼'},
{"dang", 4, L'菪'},
{"dang", 4, L'宕'},
{"dang", 4, L'砀'},
{"dao", 1, L'刀'},
{"dao", 1, L'叨'},
{"dao", 1, L'忉'},
{"dao", 1, L'氘'},
{"dao", 3, L'捣'},
{"dao", 3, L'蹈'},
{"dao", 3, L'倒'},
{"dao", 3, L'岛'},
{"dao", 3, L'祷'},
{"dao", 3, L'导'},
{"dao", 4, L'倒'},
{"dao", 4, L'到'},
{"dao", 4, L'稻'},
{"dao", 4, L'悼'},
{"dao", 4, L'道'},
{"dao", 4, L'盗'},
{"dao", 4, L'帱'},
{"dao", 4, L'焘'},
{"dao", 4, L'纛'},
{"de", 2, L'德'},
{"de", 2, L'得'},
{"de", 2, L'锝'},
{"de", 5, L'得'},
{"de", 5, L'的'},
{"de", 5, L'底'},
{"de", 5, L'地'},
{"dei", 3, L'得'},
{"deng", 1, L'蹬'},
{"deng", 1, L'灯'},
{"deng", 1, L'登'},
{"deng", 1, L'噔'},
{"deng", 1, L'簦'},
{"deng", 3, L'等'},
{"deng", 3, L'戥'},
{"deng", 4, L'澄'},
{"deng", 4, L'蹬'},
{"deng", 4, L'瞪'},
{"deng", 4, L'凳'},
{"deng", 4, L'邓'},
{"deng", 4, L'嶝'},
{"deng", 4, L'磴'},
{"deng", 4, L'镫'},
{"di", 1, L'堤'},
{"di", 1, L'低'},
{"di", 1, L'滴'},
{"di", 1, L'提'},
{"di", 1, L'氐'},
{"di", 1, L'嘀'},
{"di", 1, L'镝'},
{"di", 1, L'羝'},
{"di", 2, L'的'},
{"di", 2, L'迪'},
{"di", 2, L'敌'},
{"di", 2, L'笛'},
{"di", 2, L'狄'},
{"di", 2, L'涤'},
{"di", 2, L'翟'},
{"di", 2, L'嫡'},
{"di", 2, L'籴'},
{"di", 2, L'荻'},
{"di", 2, L'嘀'},
{"di", 2, L'觌'},
{"di", 2, L'镝'},
{"di", 3, L'抵'},
{"di", 3, L'底'},
{"di", 3, L'氐'},
{"di", 3, L'诋'},
{"di", 3, L'邸'},
{"di", 3, L'坻'},
{"di", 3, L'柢'},
{"di", 3, L'砥'},
{"di", 3, L'骶'},
{"di", 4, L'的'},
{"di", 4, L'地'},
{"di", 4, L'蒂'},
{"di", 4, L'第'},
{"di", 4, L'帝'},
{"di", 4, L'弟'},
{"di", 4, L'递'},
{"di", 4, L'缔'},
{"di", 4, L'谛'},
{"di", 4, L'娣'},
{"di", 4, L'棣'},
{"di", 4, L'碲'},
{"di", 4, L'睇'},
{"dia", 3, L'嗲'},
{"dian", 1, L'颠'},
{"dian", 1, L'掂'},
{"dian", 1, L'滇'},
{"dian", 1, L'巅'},
{"dian", 1, L'癫'},
{"dian", 3, L'碘'},
{"dian", 3, L'点'},
{"dian", 3, L'典'},
{"dian", 3, L'踮'},
{"dian", 4, L'靛'},
{"dian", 4, L'垫'},
{"dian", 4, L'电'},
{"dian", 4, L'佃'},
{"dian", 4, L'甸'},
{"dian", 4, L'店'},
{"dian", 4, L'惦'},
{"dian", 4, L'奠'},
{"dian", 4, L'淀'},
{"dian", 4, L'殿'},
{"dian", 4, L'阽'},
{"dian", 4, L'坫'},
{"dian", 4, L'玷'},
{"dian", 4, L'钿'},
{"dian", 4, L'癜'},
{"dian", 4, L'簟'},
{"diao", 1, L'碉'},
{"diao", 1, L'叼'},
{"diao", 1, L'雕'},
{"diao", 1, L'凋'},
{"diao", 1, L'刁'},
{"diao", 1, L'貂'},
{"diao", 1, L'鲷'},
{"diao", 3, L'鸟'},
{"diao", 4, L'掉'},
{"diao", 4, L'吊'},
{"diao", 4, L'钓'},
{"diao", 4, L'调'},
{"diao", 4, L'铞'},
{"diao", 4, L'铫'},
{"die", 1, L'跌'},
{"die", 1, L'爹'},
{"die", 2, L'碟'},
{"die", 2, L'蝶'},
{"die", 2, L'迭'},
{"die", 2, L'谍'},
{"die", 2, L'叠'},
{"die", 2, L'垤'},
{"die", 2, L'堞'},
{"die", 2, L'揲'},
{"die", 2, L'喋'},
{"die", 2, L'牒'},
{"die", 2, L'瓞'},
{"die", 2, L'耋'},
{"die", 2, L'蹀'},
{"die", 2, L'鲽'},
{"ding", 1, L'丁'},
{"ding", 1, L'盯'},
{"ding", 1, L'叮'},
{"ding", 1, L'钉'},
{"ding", 1, L'仃'},
{"ding", 1, L'玎'},
{"ding", 1, L'町'},
{"ding", 1, L'疔'},
{"ding", 1, L'耵'},
{"ding", 1, L'酊'},
{"ding", 3, L'顶'},
{"ding", 3, L'鼎'},
{"ding", 3, L'酊'},
{"ding", 4, L'钉'},
{"ding", 4, L'锭'},
{"ding", 4, L'定'},
{"ding", 4, L'订'},
{"ding", 4, L'啶'},
{"ding", 4, L'腚'},
{"ding", 4, L'碇'},
{"ding", 4, L'铤'},
{"ding", 4, L'铤'},
{"diu", 1, L'丢'},
{"diu", 1, L'铥'},
{"dong", 1, L'东'},
{"dong", 1, L'冬'},
{"dong", 1, L'咚'},
{"dong", 1, L'岽'},
{"dong", 1, L'氡'},
{"dong", 1, L'鸫'},
{"dong", 3, L'董'},
{"dong", 3, L'懂'},
{"dong", 4, L'动'},
{"dong", 4, L'栋'},
{"dong", 4, L'侗'},
{"dong", 4, L'恫'},
{"dong", 4, L'冻'},
{"dong", 4, L'洞'},
{"dong", 4, L'垌'},
{"dong", 4, L'峒'},
{"dong", 4, L'胨'},
{"dong", 4, L'胴'},
{"dong", 4, L'硐'},
{"dou", 1, L'兜'},
{"dou", 1, L'都'},
{"dou", 1, L'蔸'},
{"dou", 1, L'篼'},
{"dou", 3, L'抖'},
{"dou", 3, L'斗'},
{"dou", 3, L'陡'},
{"dou", 3, L'蚪'},
{"dou", 4, L'斗'},
{"dou", 4, L'豆'},
{"dou", 4, L'逗'},
{"dou", 4, L'痘'},
{"dou", 4, L'读'},
{"dou", 4, L'窦'},
{"du", 1, L'都'},
{"du", 1, L'督'},
{"du", 1, L'嘟'},
{"du", 2, L'毒'},
{"du", 2, L'犊'},
{"du", 2, L'独'},
{"du", 2, L'读'},
{"du", 2, L'顿'},
{"du", 2, L'渎'},
{"du", 2, L'椟'},
{"du", 2, L'牍'},
{"du", 2, L'髑'},
{"du", 2, L'黩'},
{"du", 3, L'堵'},
{"du", 3, L'睹'},
{"du", 3, L'赌'},
{"du", 3, L'肚'},
{"du", 3, L'笃'},
{"du", 4, L'杜'},
{"du", 4, L'镀'},
{"du", 4, L'肚'},
{"du", 4, L'度'},
{"du", 4, L'渡'},
{"du", 4, L'妒'},
{"du", 4, L'芏'},
{"du", 4, L'蠹'},
{"duan", 1, L'端'},
{"duan", 3, L'短'},
{"duan", 4, L'锻'},
{"duan", 4, L'段'},
{"duan", 4, L'断'},
{"duan", 4, L'缎'},
{"duan", 4, L'椴'},
{"duan", 4, L'煅'},
{"duan", 4, L'簖'},
{"dui", 1, L'堆'},
{"dui", 4, L'兑'},
{"dui", 4, L'队'},
{"dui", 4, L'对'},
{"dui", 4, L'敦'},
{"dui", 4, L'怼'},
{"dui", 4, L'憝'},
{"dui", 4, L'碓'},
{"dui", 4, L'镦'},
{"dun", 1, L'墩'},
{"dun", 1, L'吨'},
{"dun", 1, L'蹲'},
{"dun", 1, L'敦'},
{"dun", 1, L'礅'},
{"dun", 3, L'盹'},
{"dun", 3, L'趸'},
{"dun", 4, L'顿'},
{"dun", 4, L'囤'},
{"dun", 4, L'钝'},
{"dun", 4, L'盾'},
{"dun", 4, L'遁'},
{"dun", 4, L'沌'},
{"dun", 4, L'炖'},
{"dun", 4, L'砘'},
{"duo", 1, L'掇'},
{"duo", 1, L'哆'},
{"duo", 1, L'多'},
{"duo", 1, L'咄'},
{"duo", 1, L'裰'},
{"duo", 2, L'夺'},
{"duo", 2, L'铎'},
{"duo", 2, L'踱'},
{"duo", 3, L'垛'},
{"duo", 3, L'躲'},
{"duo", 3, L'朵'},
{"duo", 3, L'哚'},
{"duo", 3, L'缍'},
{"duo", 4, L'垛'},
{"duo", 4, L'跺'},
{"duo", 4, L'舵'},
{"duo", 4, L'剁'},
{"duo", 4, L'惰'},
{"duo", 4, L'堕'},
{"duo", 4, L'驮'},
{"duo", 4, L'沲'},
{"duo", 4, L'柁'},
{"e", 1, L'阿'},
{"e", 1, L'屙'},
{"e", 1, L'婀'},
{"e", 2, L'蛾'},
{"e", 2, L'峨'},
{"e", 2, L'鹅'},
{"e", 2, L'俄'},
{"e", 2, L'额'},
{"e", 2, L'讹'},
{"e", 2, L'娥'},
{"e", 2, L'哦'},
{"e", 2, L'莪'},
{"e", 2, L'锇'},
{"e", 3, L'恶'},
{"e", 4, L'恶'},
{"e", 4, L'厄'},
{"e", 4, L'扼'},
{"e", 4, L'遏'},
{"e", 4, L'鄂'},
{"e", 4, L'饿'},
{"e", 4, L'噩'},
{"e", 4, L'谔'},
{"e", 4, L'垩'},
{"e", 4, L'苊'},
{"e", 4, L'萼'},
{"e", 4, L'呃'},
{"e", 4, L'愕'},
{"e", 4, L'阏'},
{"e", 4, L'轭'},
{"e", 4, L'腭'},
{"e", 4, L'锷'},
{"e", 4, L'鹗'},
{"e", 4, L'颚'},
{"e", 4, L'鳄'},
{"ai", 1, L'诶'},
{"ai", 2, L'诶'},
{"ai", 3, L'诶'},
{"ai", 4, L'诶'},
{"ei", 2, L'诶'},
{"ei", 3, L'诶'},
{"ei", 4, L'诶'},
{"en", 1, L'恩'},
{"en", 1, L'蒽'},
{"en", 4, L'摁'},
{"er", 2, L'而'},
{"er", 2, L'儿'},
{"er", 2, L'鸸'},
{"er", 2, L'鲕'},
{"er", 3, L'耳'},
{"er", 3, L'尔'},
{"er", 3, L'饵'},
{"er", 3, L'洱'},
{"er", 3, L'迩'},
{"er", 3, L'珥'},
{"er", 3, L'铒'},
{"er", 4, L'二'},
{"er", 4, L'贰'},
{"er", 4, L'佴'},
{"fa", 1, L'发'},
{"fa", 2, L'罚'},
{"fa", 2, L'筏'},
{"fa", 2, L'伐'},
{"fa", 2, L'乏'},
{"fa", 2, L'阀'},
{"fa", 2, L'垡'},
{"fa", 3, L'法'},
{"fa", 3, L'砝'},
{"fa", 4, L'发'},
{"fa", 4, L'珐'},
{"fan", 1, L'藩'},
{"fan", 1, L'帆'},
{"fan", 1, L'番'},
{"fan", 1, L'翻'},
{"fan", 1, L'蕃'},
{"fan", 1, L'幡'},
{"fan", 2, L'樊'},
{"fan", 2, L'矾'},
{"fan", 2, L'钒'},
{"fan", 2, L'繁'},
{"fan", 2, L'凡'},
{"fan", 2, L'烦'},
{"fan", 2, L'蕃'},
{"fan", 2, L'蘩'},
{"fan", 2, L'燔'},
{"fan", 2, L'蹯'},
{"fan", 3, L'反'},
{"fan", 3, L'返'},
{"fan", 4, L'范'},
{"fan", 4, L'贩'},
{"fan", 4, L'犯'},
{"fan", 4, L'饭'},
{"fan", 4, L'泛'},
{"fan", 4, L'梵'},
{"fan", 4, L'畈'},
{"fang", 1, L'坊'},
{"fang", 1, L'芳'},
{"fang", 1, L'方'},
{"fang", 1, L'邡'},
{"fang", 1, L'枋'},
{"fang", 1, L'钫'},
{"fang", 2, L'坊'},
{"fang", 2, L'肪'},
{"fang", 2, L'房'},
{"fang", 2, L'防'},
{"fang", 2, L'妨'},
{"fang", 2, L'鲂'},
{"fang", 3, L'仿'},
{"fang", 3, L'访'},
{"fang", 3, L'纺'},
{"fang", 3, L'彷'},
{"fang", 3, L'舫'},
{"fang", 4, L'放'},
{"fei", 1, L'菲'},
{"fei", 1, L'非'},
{"fei", 1, L'啡'},
{"fei", 1, L'飞'},
{"fei", 1, L'妃'},
{"fei", 1, L'绯'},
{"fei", 1, L'扉'},
{"fei", 1, L'蜚'},
{"fei", 1, L'霏'},
{"fei", 1, L'鲱'},
{"fei", 2, L'肥'},
{"fei", 2, L'淝'},
{"fei", 2, L'腓'},
{"fei", 3, L'菲'},
{"fei", 3, L'匪'},
{"fei", 3, L'诽'},
{"fei", 3, L'悱'},
{"fei", 3, L'榧'},
{"fei", 3, L'斐'},
{"fei", 3, L'蜚'},
{"fei", 3, L'篚'},
{"fei", 3, L'翡'},
{"fei", 4, L'吠'},
{"fei", 4, L'肺'},
{"fei", 4, L'废'},
{"fei", 4, L'沸'},
{"fei", 4, L'费'},
{"fei", 4, L'芾'},
{"fei", 4, L'狒'},
{"fei", 4, L'怫'},
{"fei", 4, L'镄'},
{"fei", 4, L'痱'},
{"fen", 1, L'芬'},
{"fen", 1, L'酚'},
{"fen", 1, L'吩'},
{"fen", 1, L'氛'},
{"fen", 1, L'分'},
{"fen", 1, L'纷'},
{"fen", 1, L'玢'},
{"fen", 2, L'坟'},
{"fen", 2, L'焚'},
{"fen", 2, L'汾'},
{"fen", 2, L'棼'},
{"fen", 2, L'鼢'},
{"fen", 3, L'粉'},
{"fen", 4, L'分'},
{"fen", 4, L'奋'},
{"fen", 4, L'份'},
{"fen", 4, L'忿'},
{"fen", 4, L'愤'},
{"fen", 4, L'粪'},
{"fen", 4, L'偾'},
{"fen", 4, L'瀵'},
{"fen", 4, L'鲼'},
{"feng", 1, L'丰'},
{"feng", 1, L'封'},
{"feng", 1, L'枫'},
{"feng", 1, L'蜂'},
{"feng", 1, L'峰'},
{"feng", 1, L'锋'},
{"feng", 1, L'风'},
{"feng", 1, L'疯'},
{"feng", 1, L'烽'},
{"feng", 1, L'酆'},
{"feng", 1, L'葑'},
{"feng", 1, L'沣'},
{"feng", 1, L'砜'},
{"feng", 2, L'逢'},
{"feng", 2, L'冯'},
{"feng", 2, L'缝'},
{"feng", 3, L'讽'},
{"feng", 3, L'唪'},
{"feng", 4, L'缝'},
{"feng", 4, L'奉'},
{"feng", 4, L'凤'},
{"feng", 4, L'俸'},
{"feng", 4, L'葑'},
{"fo", 2, L'佛'},
{"fou", 3, L'否'},
{"fou", 3, L'缶'},
{"fu", 1, L'夫'},
{"fu", 1, L'敷'},
{"fu", 1, L'肤'},
{"fu", 1, L'孵'},
{"fu", 1, L'呋'},
{"fu", 1, L'稃'},
{"fu", 1, L'麸'},
{"fu", 1, L'趺'},
{"fu", 1, L'跗'},
{"fu", 2, L'佛'},
{"fu", 2, L'夫'},
{"fu", 2, L'扶'},
{"fu", 2, L'拂'},
{"fu", 2, L'辐'},
{"fu", 2, L'幅'},
{"fu", 2, L'氟'},
{"fu", 2, L'符'},
{"fu", 2, L'伏'},
{"fu", 2, L'俘'},
{"fu", 2, L'服'},
{"fu", 2, L'浮'},
{"fu", 2, L'涪'},
{"fu", 2, L'福'},
{"fu", 2, L'袱'},
{"fu", 2, L'弗'},
{"fu", 2, L'匐'},
{"fu", 2, L'凫'},
{"fu", 2, L'郛'},
{"fu", 2, L'芙'},
{"fu", 2, L'芾'},
{"fu", 2, L'苻'},
{"fu", 2, L'茯'},
{"fu", 2, L'莩'},
{"fu", 2, L'菔'},
{"fu", 2, L'幞'},
{"fu", 2, L'怫'},
{"fu", 2, L'艴'},
{"fu", 2, L'孚'},
{"fu", 2, L'绂'},
{"fu", 2, L'绋'},
{"fu", 2, L'桴'},
{"fu", 2, L'祓'},
{"fu", 2, L'砩'},
{"fu", 2, L'黻'},
{"fu", 2, L'罘'},
{"fu", 2, L'蚨'},
{"fu", 2, L'蜉'},
{"fu", 2, L'蝠'},
{"fu", 3, L'甫'},
{"fu", 3, L'抚'},
{"fu", 3, L'辅'},
{"fu", 3, L'俯'},
{"fu", 3, L'釜'},
{"fu", 3, L'斧'},
{"fu", 3, L'脯'},
{"fu", 3, L'腑'},
{"fu", 3, L'府'},
{"fu", 3, L'腐'},
{"fu", 3, L'父'},
{"fu", 3, L'拊'},
{"fu", 3, L'滏'},
{"fu", 3, L'黼'},
{"fu", 4, L'服'},
{"fu", 4, L'赴'},
{"fu", 4, L'副'},
{"fu", 4, L'覆'},
{"fu", 4, L'赋'},
{"fu", 4, L'复'},
{"fu", 4, L'傅'},
{"fu", 4, L'付'},
{"fu", 4, L'阜'},
{"fu", 4, L'父'},
{"fu", 4, L'腹'},
{"fu", 4, L'负'},
{"fu", 4, L'富'},
{"fu", 4, L'讣'},
{"fu", 4, L'附'},
{"fu", 4, L'妇'},
{"fu", 4, L'缚'},
{"fu", 4, L'咐'},
{"fu", 4, L'驸'},
{"fu", 4, L'赙'},
{"fu", 4, L'馥'},
{"fu", 4, L'蝮'},
{"fu", 4, L'鲋'},
{"fu", 4, L'鳆'},
{"ga", 1, L'嘎'},
{"ga", 1, L'胳'},
{"ga", 1, L'夹'},
{"ga", 1, L'咖'},
{"ga", 1, L'伽'},
{"ga", 1, L'旮'},
{"ga", 2, L'噶'},
{"ga", 2, L'嘎'},
{"ga", 2, L'轧'},
{"ga", 2, L'尜'},
{"ga", 2, L'钆'},
{"ga", 3, L'嘎'},
{"ga", 3, L'尕'},
{"ga", 4, L'尬'},
{"gai", 1, L'该'},
{"gai", 1, L'陔'},
{"gai", 1, L'垓'},
{"gai", 1, L'赅'},
{"gai", 3, L'改'},
{"gai", 4, L'概'},
{"gai", 4, L'钙'},
{"gai", 4, L'盖'},
{"gai", 4, L'溉'},
{"gai", 4, L'芥'},
{"gai", 4, L'丐'},
{"gai", 4, L'戤'},
{"gan", 1, L'干'},
{"gan", 1, L'甘'},
{"gan", 1, L'杆'},
{"gan", 1, L'柑'},
{"gan", 1, L'竿'},
{"gan", 1, L'肝'},
{"gan", 1, L'乾'},
{"gan", 1, L'坩'},
{"gan", 1, L'苷'},
{"gan", 1, L'尴'},
{"gan", 1, L'泔'},
{"gan", 1, L'矸'},
{"gan", 1, L'疳'},
{"gan", 1, L'酐'},
{"gan", 3, L'杆'},
{"gan", 3, L'赶'},
{"gan", 3, L'感'},
{"gan", 3, L'秆'},
{"gan", 3, L'敢'},
{"gan", 3, L'擀'},
{"gan", 3, L'澉'},
{"gan", 3, L'橄'},
{"gan", 4, L'干'},
{"gan", 4, L'赣'},
{"gan", 4, L'淦'},
{"gan", 4, L'绀'},
{"gan", 4, L'旰'},
{"gang", 1, L'冈'},
{"gang", 1, L'刚'},
{"gang", 1, L'钢'},
{"gang", 1, L'缸'},
{"gang", 1, L'肛'},
{"gang", 1, L'纲'},
{"gang", 1, L'岗'},
{"gang", 1, L'杠'},
{"gang", 1, L'扛'},
{"gang", 1, L'罡'},
{"gang", 3, L'岗'},
{"gang", 3, L'港'},
{"gang", 4, L'钢'},
{"gang", 4, L'杠'},
{"gang", 4, L'戆'},
{"gang", 4, L'筻'},
{"gao", 1, L'篙'},
{"gao", 1, L'皋'},
{"gao", 1, L'高'},
{"gao", 1, L'膏'},
{"gao", 1, L'羔'},
{"gao", 1, L'糕'},
{"gao", 1, L'睾'},
{"gao", 1, L'槔'},
{"gao", 3, L'搞'},
{"gao", 3, L'镐'},
{"gao", 3, L'稿'},
{"gao", 3, L'藁'},
{"gao", 3, L'缟'},
{"gao", 3, L'槁'},
{"gao", 3, L'杲'},
{"gao", 4, L'膏'},
{"gao", 4, L'告'},
{"gao", 4, L'诰'},
{"gao", 4, L'郜'},
{"gao", 4, L'锆'},
{"ge", 1, L'哥'},
{"ge", 1, L'歌'},
{"ge", 1, L'搁'},
{"ge", 1, L'戈'},
{"ge", 1, L'鸽'},
{"ge", 1, L'疙'},
{"ge", 1, L'割'},
{"ge", 1, L'格'},
{"ge", 1, L'咯'},
{"ge", 1, L'屹'},
{"ge", 1, L'仡'},
{"ge", 1, L'圪'},
{"ge", 1, L'纥'},
{"ge", 1, L'袼'},
{"ge", 2, L'搁'},
{"ge", 2, L'革'},
{"ge", 2, L'葛'},
{"ge", 2, L'格'},
{"ge", 2, L'蛤'},
{"ge", 2, L'阁'},
{"ge", 2, L'隔'},
{"ge", 2, L'鬲'},
{"ge", 2, L'塥'},
{"ge", 2, L'嗝'},
{"ge", 2, L'搿'},
{"ge", 2, L'膈'},
{"ge", 2, L'镉'},
{"ge", 2, L'颌'},
{"ge", 2, L'骼'},
{"ge", 3, L'盖'},
{"ge", 3, L'葛'},
{"ge", 3, L'个'},
{"ge", 3, L'各'},
{"ge", 3, L'合'},
{"ge", 3, L'哿'},
{"ge", 3, L'舸'},
{"ge", 4, L'铬'},
{"ge", 4, L'个'},
{"ge", 4, L'各'},
{"ge", 4, L'硌'},
{"ge", 4, L'虼'},
{"gei", 3, L'给'},
{"gen", 1, L'根'},
{"gen", 1, L'跟'},
{"gen", 2, L'哏'},
{"gen", 3, L'艮'},
{"gen", 4, L'亘'},
{"gen", 4, L'茛'},
{"gen", 4, L'艮'},
{"geng", 1, L'耕'},
{"geng", 1, L'更'},
{"geng", 1, L'庚'},
{"geng", 1, L'羹'},
{"geng", 1, L'赓'},
{"geng", 3, L'埂'},
{"geng", 3, L'耿'},
{"geng", 3, L'梗'},
{"geng", 3, L'颈'},
{"geng", 3, L'哽'},
{"geng", 3, L'绠'},
{"geng", 3, L'鲠'},
{"geng", 4, L'更'},
{"gong", 1, L'工'},
{"gong", 1, L'攻'},
{"gong", 1, L'功'},
{"gong", 1, L'恭'},
{"gong", 1, L'龚'},
{"gong", 1, L'供'},
{"gong", 1, L'躬'},
{"gong", 1, L'公'},
{"gong", 1, L'宫'},
{"gong", 1, L'弓'},
{"gong", 1, L'红'},
{"gong", 1, L'肱'},
{"gong", 1, L'蚣'},
{"gong", 1, L'觥'},
{"gong", 3, L'巩'},
{"gong", 3, L'汞'},
{"gong", 3, L'拱'},
{"gong", 3, L'珙'},
{"gong", 4, L'供'},
{"gong", 4, L'贡'},
{"gong", 4, L'共'},
{"gou", 1, L'钩'},
{"gou", 1, L'勾'},
{"gou", 1, L'沟'},
{"gou", 1, L'句'},
{"gou", 1, L'佝'},
{"gou", 1, L'缑'},
{"gou", 1, L'枸'},
{"gou", 1, L'篝'},
{"gou", 1, L'鞲'},
{"gou", 3, L'苟'},
{"gou", 3, L'狗'},
{"gou", 3, L'岣'},
{"gou", 3, L'枸'},
{"gou", 3, L'笱'},
{"gou", 4, L'勾'},
{"gou", 4, L'垢'},
{"gou", 4, L'构'},
{"gou", 4, L'购'},
{"gou", 4, L'够'},
{"gou", 4, L'诟'},
{"gou", 4, L'遘'},
{"gou", 4, L'媾'},
{"gou", 4, L'觏'},
{"gou", 4, L'彀'},
{"gu", 1, L'辜'},
{"gu", 1, L'菇'},
{"gu", 1, L'咕'},
{"gu", 1, L'箍'},
{"gu", 1, L'估'},
{"gu", 1, L'沽'},
{"gu", 1, L'孤'},
{"gu", 1, L'姑'},
{"gu", 1, L'骨'},
{"gu", 1, L'菰'},
{"gu", 1, L'呱'},
{"gu", 1, L'轱'},
{"gu", 1, L'毂'},
{"gu", 1, L'鸪'},
{"gu", 1, L'蛄'},
{"gu", 1, L'酤'},
{"gu", 1, L'觚'},
{"gu", 3, L'鼓'},
{"gu", 3, L'古'},
{"gu", 3, L'蛊'},
{"gu", 3, L'骨'},
{"gu", 3, L'谷'},
{"gu", 3, L'股'},
{"gu", 3, L'贾'},
{"gu", 3, L'嘏'},
{"gu", 3, L'诂'},
{"gu", 3, L'汩'},
{"gu", 3, L'牯'},
{"gu", 3, L'臌'},
{"gu", 3, L'毂'},
{"gu", 3, L'瞽'},
{"gu", 3, L'罟'},
{"gu", 3, L'钴'},
{"gu", 3, L'鹄'},
{"gu", 3, L'鹘'},
{"gu", 4, L'估'},
{"gu", 4, L'故'},
{"gu", 4, L'顾'},
{"gu", 4, L'固'},
{"gu", 4, L'雇'},
{"gu", 4, L'崮'},
{"gu", 4, L'梏'},
{"gu", 4, L'牿'},
{"gu", 4, L'锢'},
{"gu", 4, L'痼'},
{"gu", 4, L'鲴'},
{"gua", 1, L'刮'},
{"gua", 1, L'瓜'},
{"gua", 1, L'括'},
{"gua", 1, L'呱'},
{"gua", 1, L'栝'},
{"gua", 1, L'胍'},
{"gua", 1, L'鸹'},
{"gua", 3, L'剐'},
{"gua", 3, L'寡'},
{"gua", 3, L'呱'},
{"gua", 4, L'挂'},
{"gua", 4, L'褂'},
{"gua", 4, L'卦'},
{"gua", 4, L'诖'},
{"guai", 1, L'乖'},
{"guai", 1, L'掴'},
{"guai", 3, L'拐'},
{"guai", 4, L'怪'},
{"guan", 1, L'棺'},
{"guan", 1, L'关'},
{"guan", 1, L'官'},
{"guan", 1, L'冠'},
{"guan", 1, L'观'},
{"guan", 1, L'纶'},
{"guan", 1, L'倌'},
{"guan", 1, L'莞'},
{"guan", 1, L'矜'},
{"guan", 1, L'鳏'},
{"guan", 3, L'管'},
{"guan", 3, L'馆'},
{"guan", 4, L'冠'},
{"guan", 4, L'观'},
{"guan", 4, L'罐'},
{"guan", 4, L'惯'},
{"guan", 4, L'灌'},
{"guan", 4, L'贯'},
{"guan", 4, L'掼'},
{"guan", 4, L'涫'},
{"guan", 4, L'盥'},
{"guan", 4, L'鹳'},
{"guang", 1, L'光'},
{"guang", 1, L'咣'},
{"guang", 1, L'桄'},
{"guang", 1, L'胱'},
{"guang", 3, L'广'},
{"guang", 3, L'犷'},
{"guang", 4, L'逛'},
{"guang", 4, L'桄'},
{"gui", 1, L'瑰'},
{"gui", 1, L'规'},
{"gui", 1, L'圭'},
{"gui", 1, L'硅'},
{"gui", 1, L'归'},
{"gui", 1, L'龟'},
{"gui", 1, L'闺'},
{"gui", 1, L'傀'},
{"gui", 1, L'妫'},
{"gui", 1, L'皈'},
{"gui", 1, L'鲑'},
{"gui", 3, L'轨'},
{"gui", 3, L'鬼'},
{"gui", 3, L'诡'},
{"gui", 3, L'癸'},
{"gui", 3, L'匦'},
{"gui", 3, L'庋'},
{"gui", 3, L'宄'},
{"gui", 3, L'晷'},
{"gui", 3, L'簋'},
{"gui", 4, L'桂'},
{"gui", 4, L'柜'},
{"gui", 4, L'跪'},
{"gui", 4, L'贵'},
{"gui", 4, L'刽'},
{"gui", 4, L'炔'},
{"gui", 4, L'刿'},
{"gui", 4, L'桧'},
{"gui", 4, L'炅'},
{"gui", 4, L'鳜'},
{"gun", 3, L'辊'},
{"gun", 3, L'滚'},
{"gun", 3, L'衮'},
{"gun", 3, L'绲'},
{"gun", 3, L'磙'},
{"gun", 3, L'鲧'},
{"gun", 4, L'棍'},
{"guo", 1, L'锅'},
{"guo", 1, L'郭'},
{"guo", 1, L'过'},
{"guo", 1, L'涡'},
{"guo", 1, L'埚'},
{"guo", 1, L'呙'},
{"guo", 1, L'崞'},
{"guo", 1, L'聒'},
{"guo", 1, L'蝈'},
{"guo", 2, L'国'},
{"guo", 2, L'馘'},
{"guo", 2, L'掴'},
{"guo", 2, L'帼'},
{"guo", 2, L'虢'},
{"guo", 3, L'果'},
{"guo", 3, L'裹'},
{"guo", 3, L'猓'},
{"guo", 3, L'椁'},
{"guo", 3, L'蜾'},
{"guo", 4, L'过'},
{"ha", 1, L'哈'},
{"ha", 1, L'铪'},
{"ha", 2, L'蛤'},
{"ha", 2, L'虾'},
{"ha", 3, L'哈'},
{"ha", 4, L'哈'},
{"hai", 1, L'咳'},
{"hai", 1, L'嗨'},
{"hai", 2, L'骸'},
{"hai", 2, L'孩'},
{"hai", 2, L'还'},
{"hai", 3, L'海'},
{"hai", 3, L'胲'},
{"hai", 3, L'醢'},
{"hai", 4, L'氦'},
{"hai", 4, L'亥'},
{"hai", 4, L'害'},
{"hai", 4, L'骇'},
{"han", 1, L'酣'},
{"han", 1, L'憨'},
{"han", 1, L'犴'},
{"han", 1, L'顸'},
{"han", 1, L'蚶'},
{"han", 1, L'鼾'},
{"han", 2, L'邯'},
{"han", 2, L'韩'},
{"han", 2, L'含'},
{"han", 2, L'涵'},
{"han", 2, L'寒'},
{"han", 2, L'函'},
{"han", 2, L'汗'},
{"han", 2, L'邗'},
{"han", 2, L'晗'},
{"han", 2, L'焓'},
{"han", 3, L'喊'},
{"han", 3, L'罕'},
{"han", 3, L'阚'},
{"han", 4, L'翰'},
{"han", 4, L'撼'},
{"han", 4, L'捍'},
{"han", 4, L'旱'},
{"han", 4, L'憾'},
{"han", 4, L'悍'},
{"han", 4, L'焊'},
{"han", 4, L'汗'},
{"han", 4, L'汉'},
{"han", 4, L'菡'},
{"han", 4, L'撖'},
{"han", 4, L'瀚'},
{"han", 4, L'颔'},
{"hang", 1, L'夯'},
{"hang", 2, L'杭'},
{"hang", 2, L'航'},
{"hang", 2, L'吭'},
{"hang", 2, L'行'},
{"hang", 2, L'绗'},
{"hang", 2, L'颃'},
{"hang", 4, L'巷'},
{"hang", 4, L'沆'},
{"hao", 1, L'蒿'},
{"hao", 1, L'薅'},
{"hao", 1, L'嚆'},
{"hao", 2, L'壕'},
{"hao", 2, L'嚎'},
{"hao", 2, L'豪'},
{"hao", 2, L'毫'},
{"hao", 2, L'号'},
{"hao", 2, L'貉'},
{"hao", 2, L'嗥'},
{"hao", 2, L'濠'},
{"hao", 2, L'蚝'},
{"hao", 3, L'郝'},
{"hao", 3, L'好'},
{"hao", 4, L'镐'},
{"hao", 4, L'好'},
{"hao", 4, L'耗'},
{"hao", 4, L'号'},
{"hao", 4, L'浩'},
{"hao", 4, L'灏'},
{"hao", 4, L'昊'},
{"hao", 4, L'皓'},
{"hao", 4, L'颢'},
{"he", 1, L'呵'},
{"he", 1, L'喝'},
{"he", 1, L'诃'},
{"he", 1, L'嗬'},
{"he", 2, L'荷'},
{"he", 2, L'菏'},
{"he", 2, L'核'},
{"he", 2, L'禾'},
{"he", 2, L'和'},
{"he", 2, L'何'},
{"he", 2, L'合'},
{"he", 2, L'盒'},
{"he", 2, L'貉'},
{"he", 2, L'阂'},
{"he", 2, L'河'},
{"he", 2, L'涸'},
{"he", 2, L'劾'},
{"he", 2, L'阖'},
{"he", 2, L'纥'},
{"he", 2, L'曷'},
{"he", 2, L'盍'},
{"he", 2, L'颌'},
{"he", 2, L'蚵'},
{"he", 2, L'翮'},
{"he", 4, L'喝'},
{"he", 4, L'荷'},
{"he", 4, L'和'},
{"he", 4, L'赫'},
{"he", 4, L'褐'},
{"he", 4, L'鹤'},
{"he", 4, L'贺'},
{"he", 4, L'吓'},
{"he", 4, L'壑'},
{"hei", 1, L'嘿'},
{"hei", 1, L'黑'},
{"hei", 1, L'嗨'},
{"hen", 2, L'痕'},
{"hen", 3, L'很'},
{"hen", 3, L'狠'},
{"hen", 4, L'恨'},
{"heng", 1, L'哼'},
{"heng", 1, L'亨'},
{"heng", 2, L'横'},
{"heng", 2, L'衡'},
{"heng", 2, L'恒'},
{"heng", 2, L'蘅'},
{"heng", 2, L'珩'},
{"heng", 2, L'桁'},
{"heng", 4, L'横'},
{"hng", 5, L'哼'},
{"hong", 1, L'轰'},
{"hong", 1, L'哄'},
{"hong", 1, L'烘'},
{"hong", 1, L'訇'},
{"hong", 1, L'薨'},
{"hong", 2, L'虹'},
{"hong", 2, L'鸿'},
{"hong", 2, L'洪'},
{"hong", 2, L'宏'},
{"hong", 2, L'弘'},
{"hong", 2, L'红'},
{"hong", 2, L'黉'},
{"hong", 2, L'荭'},
{"hong", 2, L'蕻'},
{"hong", 2, L'闳'},
{"hong", 2, L'泓'},
{"hong", 3, L'哄'},
{"hong", 4, L'哄'},
{"hong", 4, L'讧'},
{"hong", 4, L'蕻'},
{"hou", 2, L'喉'},
{"hou", 2, L'侯'},
{"hou", 2, L'猴'},
{"hou", 2, L'瘊'},
{"hou", 2, L'篌'},
{"hou", 2, L'糇'},
{"hou", 2, L'骺'},
{"hou", 3, L'吼'},
{"hou", 4, L'侯'},
{"hou", 4, L'厚'},
{"hou", 4, L'候'},
{"hou", 4, L'后'},
{"hou", 4, L'堠'},
{"hou", 4, L'後'},
{"hou", 4, L'逅'},
{"hou", 4, L'鲎'},
{"hu", 1, L'呼'},
{"hu", 1, L'乎'},
{"hu", 1, L'忽'},
{"hu", 1, L'糊'},
{"hu", 1, L'戏'},
{"hu", 1, L'唿'},
{"hu", 1, L'惚'},
{"hu", 1, L'滹'},
{"hu", 1, L'轷'},
{"hu", 1, L'烀'},
{"hu", 2, L'鼓'},
{"hu", 2, L'核'},
{"hu", 2, L'和'},
{"hu", 2, L'瑚'},
{"hu", 2, L'壶'},
{"hu", 2, L'葫'},
{"hu", 2, L'胡'},
{"hu", 2, L'蝴'},
{"hu", 2, L'狐'},
{"hu", 2, L'糊'},
{"hu", 2, L'湖'},
{"hu", 2, L'弧'},
{"hu", 2, L'囫'},
{"hu", 2, L'猢'},
{"hu", 2, L'槲'},
{"hu", 2, L'觳'},
{"hu", 2, L'煳'},
{"hu", 2, L'鹕'},
{"hu", 2, L'醐'},
{"hu", 2, L'斛'},
{"hu", 2, L'鹘'},
{"hu", 3, L'虎'},
{"hu", 3, L'唬'},
{"hu", 3, L'浒'},
{"hu", 3, L'琥'},
{"hu", 4, L'糊'},
{"hu", 4, L'护'},
{"hu", 4, L'互'},
{"hu", 4, L'沪'},
{"hu", 4, L'户'},
{"hu", 4, L'冱'},
{"hu", 4, L'岵'},
{"hu", 4, L'怙'},
{"hu", 4, L'戽'},
{"hu", 4, L'扈'},
{"hu", 4, L'祜'},
{"hu", 4, L'瓠'},
{"hu", 4, L'鹱'},
{"hu", 4, L'笏'},
{"hua", 1, L'花'},
{"hua", 1, L'哗'},
{"hua", 1, L'华'},
{"hua", 1, L'化'},
{"hua", 1, L'砉'},
{"hua", 2, L'哗'},
{"hua", 2, L'华'},
{"hua", 2, L'猾'},
{"hua", 2, L'滑'},
{"hua", 2, L'划'},
{"hua", 2, L'骅'},
{"hua", 2, L'铧'},
{"hua", 4, L'华'},
{"hua", 4, L'画'},
{"hua", 4, L'划'},
{"hua", 4, L'化'},
{"hua", 4, L'话'},
{"hua", 4, L'桦'},
{"huai", 2, L'槐'},
{"huai", 2, L'徊'},
{"huai", 2, L'怀'},
{"huai", 2, L'淮'},
{"huai", 2, L'踝'},
{"huai", 4, L'坏'},
{"huai", 5, L'划'},
{"huan", 1, L'欢'},
{"huan", 1, L'獾'},
{"huan", 2, L'环'},
{"huan", 2, L'桓'},
{"huan", 2, L'还'},
{"huan", 2, L'郇'},
{"huan", 2, L'萑'},
{"huan", 2, L'圜'},
{"huan", 2, L'洹'},
{"huan", 2, L'寰'},
{"huan", 2, L'缳'},
{"huan", 2, L'锾'},
{"huan", 2, L'鬟'},
{"huan", 3, L'缓'},
{"huan", 4, L'换'},
{"huan", 4, L'患'},
{"huan", 4, L'唤'},
{"huan", 4, L'痪'},
{"huan", 4, L'豢'},
{"huan", 4, L'焕'},
{"huan", 4, L'涣'},
{"huan", 4, L'宦'},
{"huan", 4, L'幻'},
{"huan", 4, L'奂'},
{"huan", 4, L'擐'},
{"huan", 4, L'浣'},
{"huan", 4, L'漶'},
{"huan", 4, L'逭'},
{"huan", 4, L'鲩'},
{"huang", 1, L'荒'},
{"huang", 1, L'慌'},
{"huang", 1, L'肓'},
{"huang", 2, L'黄'},
{"huang", 2, L'磺'},
{"huang", 2, L'蝗'},
{"huang", 2, L'簧'},
{"huang", 2, L'皇'},
{"huang", 2, L'凰'},
{"huang", 2, L'惶'},
{"huang", 2, L'煌'},
{"huang", 2, L'隍'},
{"huang", 2, L'徨'},
{"huang", 2, L'湟'},
{"huang", 2, L'潢'},
{"huang", 2, L'遑'},
{"huang", 2, L'璜'},
{"huang", 2, L'癀'},
{"huang", 2, L'蟥'},
{"huang", 2, L'篁'},
{"huang", 2, L'鳇'},
{"huang", 3, L'晃'},
{"huang", 3, L'幌'},
{"huang", 3, L'恍'},
{"huang", 3, L'谎'},
{"huang", 4, L'晃'},
{"hui", 1, L'灰'},
{"hui", 1, L'挥'},
{"hui", 1, L'辉'},
{"hui", 1, L'徽'},
{"hui", 1, L'恢'},
{"hui", 1, L'诙'},
{"hui", 1, L'咴'},
{"hui", 1, L'隳'},
{"hui", 1, L'珲'},
{"hui", 1, L'晖'},
{"hui", 1, L'虺'},
{"hui", 1, L'麾'},
{"hui", 2, L'蛔'},
{"hui", 2, L'回'},
{"hui", 2, L'茴'},
{"hui", 2, L'洄'},
{"hui", 3, L'毁'},
{"hui", 3, L'悔'},
{"hui", 3, L'虺'},
{"hui", 4, L'慧'},
{"hui", 4, L'卉'},
{"hui", 4, L'惠'},
{"hui", 4, L'晦'},
{"hui", 4, L'贿'},
{"hui", 4, L'秽'},
{"hui", 4, L'会'},
{"hui", 4, L'烩'},
{"hui", 4, L'汇'},
{"hui", 4, L'讳'},
{"hui", 4, L'诲'},
{"hui", 4, L'绘'},
{"hui", 4, L'溃'},
{"hui", 4, L'荟'},
{"hui", 4, L'蕙'},
{"hui", 4, L'哕'},
{"hui", 4, L'喙'},
{"hui", 4, L'浍'},
{"hui", 4, L'彗'},
{"hui", 4, L'缋'},
{"hui", 4, L'桧'},
{"hui", 4, L'恚'},
{"hui", 4, L'蟪'},
{"hun", 1, L'荤'},
{"hun", 1, L'昏'},
{"hun", 1, L'婚'},
{"hun", 1, L'阍'},
{"hun", 2, L'魂'},
{"hun", 2, L'浑'},
{"hun", 2, L'混'},
{"hun", 2, L'馄'},
{"hun", 2, L'珲'},
{"hun", 4, L'混'},
{"hun", 4, L'诨'},
{"hun", 4, L'溷'},
{"huo", 1, L'豁'},
{"huo", 1, L'劐'},
{"huo", 1, L'攉'},
{"huo", 1, L'锪'},
{"huo", 1, L'耠'},
{"huo", 2, L'和'},
{"huo", 2, L'活'},
{"huo", 3, L'伙'},
{"huo", 3, L'火'},
{"huo", 3, L'夥'},
{"huo", 3, L'钬'},
{"huo", 4, L'和'},
{"huo", 4, L'豁'},
{"huo", 4, L'获'},
{"huo", 4, L'或'},
{"huo", 4, L'惑'},
{"huo", 4, L'霍'},
{"huo", 4, L'货'},
{"huo", 4, L'祸'},
{"huo", 4, L'藿'},
{"huo", 4, L'嚯'},
{"huo", 4, L'镬'},
{"huo", 4, L'蠖'},
{"ji", 1, L'击'},
{"ji", 1, L'圾'},
{"ji", 1, L'基'},
{"ji", 1, L'机'},
{"ji", 1, L'畸'},
{"ji", 1, L'稽'},
{"ji", 1, L'积'},
{"ji", 1, L'箕'},
{"ji", 1, L'肌'},
{"ji", 1, L'饥'},
{"ji", 1, L'激'},
{"ji", 1, L'讥'},
{"ji", 1, L'鸡'},
{"ji", 1, L'姬'},
{"ji", 1, L'缉'},
{"ji", 1, L'几'},
{"ji", 1, L'期'},
{"ji", 1, L'其'},
{"ji", 1, L'奇'},
{"ji", 1, L'丌'},
{"ji", 1, L'乩'},
{"ji", 1, L'剞'},
{"ji", 1, L'墼'},
{"ji", 1, L'芨'},
{"ji", 1, L'叽'},
{"ji", 1, L'咭'},
{"ji", 1, L'唧'},
{"ji", 1, L'屐'},
{"ji", 1, L'畿'},
{"ji", 1, L'玑'},
{"ji", 1, L'赍'},
{"ji", 1, L'犄'},
{"ji", 1, L'齑'},
{"ji", 1, L'矶'},
{"ji", 1, L'羁'},
{"ji", 1, L'嵇'},
{"ji", 1, L'笄'},
{"ji", 1, L'跻'},
{"ji", 2, L'革'},
{"ji", 2, L'吉'},
{"ji", 2, L'极'},
{"ji", 2, L'棘'},
{"ji", 2, L'辑'},
{"ji", 2, L'籍'},
{"ji", 2, L'集'},
{"ji", 2, L'及'},
{"ji", 2, L'急'},
{"ji", 2, L'疾'},
{"ji", 2, L'汲'},
{"ji", 2, L'即'},
{"ji", 2, L'嫉'},
{"ji", 2, L'级'},
{"ji", 2, L'藉'},
{"ji", 2, L'亟'},
{"ji", 2, L'佶'},
{"ji", 2, L'诘'},
{"ji", 2, L'蒺'},
{"ji", 2, L'蕺'},
{"ji", 2, L'岌'},
{"ji", 2, L'嵴'},
{"ji", 2, L'楫'},
{"ji", 2, L'殛'},
{"ji", 2, L'戢'},
{"ji", 2, L'瘠'},
{"ji", 2, L'笈'},
{"ji", 3, L'给'},
{"ji", 3, L'挤'},
{"ji", 3, L'几'},
{"ji", 3, L'脊'},
{"ji", 3, L'己'},
{"ji", 3, L'济'},
{"ji", 3, L'纪'},
{"ji", 3, L'掎'},
{"ji", 3, L'戟'},
{"ji", 3, L'虮'},
{"ji", 3, L'麂'},
{"ji", 4, L'迹'},
{"ji", 4, L'绩'},
{"ji", 4, L'蓟'},
{"ji", 4, L'技'},
{"ji", 4, L'冀'},
{"ji", 4, L'季'},
{"ji", 4, L'伎'},
{"ji", 4, L'祭'},
{"ji", 4, L'剂'},
{"ji", 4, L'悸'},
{"ji", 4, L'济'},
{"ji", 4, L'寄'},
{"ji", 4, L'寂'},
{"ji", 4, L'计'},
{"ji", 4, L'记'},
{"ji", 4, L'既'},
{"ji", 4, L'忌'},
{"ji", 4, L'际'},
{"ji", 4, L'妓'},
{"ji", 4, L'继'},
{"ji", 4, L'纪'},
{"ji", 4, L'齐'},
{"ji", 4, L'系'},
{"ji", 4, L'偈'},
{"ji", 4, L'芰'},
{"ji", 4, L'荠'},
{"ji", 4, L'哜'},
{"ji", 4, L'洎'},
{"ji", 4, L'骥'},
{"ji", 4, L'觊'},
{"ji", 4, L'稷'},
{"ji", 4, L'暨'},
{"ji", 4, L'跽'},
{"ji", 4, L'霁'},
{"ji", 4, L'鲚'},
{"ji", 4, L'鲫'},
{"ji", 4, L'髻'},
{"jia", 1, L'嘉'},
{"jia", 1, L'枷'},
{"jia", 1, L'夹'},
{"jia", 1, L'佳'},
{"jia", 1, L'家'},
{"jia", 1, L'加'},
{"jia", 1, L'茄'},
{"jia", 1, L'挟'},
{"jia", 1, L'葭'},
{"jia", 1, L'浃'},
{"jia", 1, L'迦'},
{"jia", 1, L'珈'},
{"jia", 1, L'镓'},
{"jia", 1, L'痂'},
{"jia", 1, L'笳'},
{"jia", 1, L'袈'},
{"jia", 1, L'跏'},
{"jia", 2, L'夹'},
{"jia", 2, L'荚'},
{"jia", 2, L'颊'},
{"jia", 2, L'郏'},
{"jia", 2, L'戛'},
{"jia", 2, L'恝'},
{"jia", 2, L'铗'},
{"jia", 2, L'袷'},
{"jia", 2, L'蛱'},
{"jia", 3, L'贾'},
{"jia", 3, L'甲'},
{"jia", 3, L'钾'},
{"jia", 3, L'假'},
{"jia", 3, L'嘏'},
{"jia", 3, L'岬'},
{"jia", 3, L'胛'},
{"jia", 3, L'瘕'},
{"jia", 4, L'假'},
{"jia", 4, L'稼'},
{"jia", 4, L'价'},
{"jia", 4, L'架'},
{"jia", 4, L'驾'},
{"jia", 4, L'嫁'},
{"jian", 1, L'歼'},
{"jian", 1, L'监'},
{"jian", 1, L'坚'},
{"jian", 1, L'尖'},
{"jian", 1, L'笺'},
{"jian", 1, L'间'},
{"jian", 1, L'煎'},
{"jian", 1, L'兼'},
{"jian", 1, L'肩'},
{"jian", 1, L'艰'},
{"jian", 1, L'奸'},
{"jian", 1, L'缄'},
{"jian", 1, L'渐'},
{"jian", 1, L'溅'},
{"jian", 1, L'浅'},
{"jian", 1, L'菅'},
{"jian", 1, L'蒹'},
{"jian", 1, L'搛'},
{"jian", 1, L'湔'},
{"jian", 1, L'缣'},
{"jian", 1, L'戋'},
{"jian", 1, L'犍'},
{"jian", 1, L'鹣'},
{"jian", 1, L'鲣'},
{"jian", 1, L'鞯'},
{"jian", 2, L'监'},
{"jian", 3, L'茧'},
{"jian", 3, L'检'},
{"jian", 3, L'柬'},
{"jian", 3, L'碱'},
{"jian", 3, L'硷'},
{"jian", 3, L'拣'},
{"jian", 3, L'捡'},
{"jian", 3, L'简'},
{"jian", 3, L'俭'},
{"jian", 3, L'剪'},
{"jian", 3, L'减'},
{"jian", 3, L'谫'},
{"jian", 3, L'囝'},
{"jian", 3, L'蹇'},
{"jian", 3, L'謇'},
{"jian", 3, L'枧'},
{"jian", 3, L'戬'},
{"jian", 3, L'睑'},
{"jian", 3, L'锏'},
{"jian", 3, L'裥'},
{"jian", 3, L'笕'},
{"jian", 3, L'翦'},
{"jian", 3, L'趼'},
{"jian", 4, L'间'},
{"jian", 4, L'荐'},
{"jian", 4, L'槛'},
{"jian", 4, L'鉴'},
{"jian", 4, L'践'},
{"jian", 4, L'贱'},
{"jian", 4, L'见'},
{"jian", 4, L'键'},
{"jian", 4, L'箭'},
{"jian", 4, L'件'},
{"jian", 4, L'健'},
{"jian", 4, L'舰'},
{"jian", 4, L'剑'},
{"jian", 4, L'饯'},
{"jian", 4, L'渐'},
{"jian", 4, L'溅'},
{"jian", 4, L'涧'},
{"jian", 4, L'建'},
{"jian", 4, L'僭'},
{"jian", 4, L'谏'},
{"jian", 4, L'楗'},
{"jian", 4, L'牮'},
{"jian", 4, L'毽'},
{"jian", 4, L'腱'},
{"jian", 4, L'锏'},
{"jian", 4, L'踺'},
{"jiang", 1, L'僵'},
{"jiang", 1, L'姜'},
{"jiang", 1, L'将'},
{"jiang", 1, L'浆'},
{"jiang", 1, L'江'},
{"jiang", 1, L'疆'},
{"jiang", 1, L'茳'},
{"jiang", 1, L'缰'},
{"jiang", 1, L'礓'},
{"jiang", 1, L'豇'},
{"jiang", 3, L'蒋'},
{"jiang", 3, L'桨'},
{"jiang", 3, L'奖'},
{"jiang", 3, L'讲'},
{"jiang", 3, L'耩'},
{"jiang", 4, L'虹'},
{"jiang", 4, L'将'},
{"jiang", 4, L'浆'},
{"jiang", 4, L'匠'},
{"jiang", 4, L'酱'},
{"jiang", 4, L'降'},
{"jiang", 4, L'强'},
{"jiang", 4, L'洚'},
{"jiang", 4, L'绛'},
{"jiang", 4, L'犟'},
{"jiang", 4, L'糨'},
{"jiao", 1, L'蕉'},
{"jiao", 1, L'椒'},
{"jiao", 1, L'礁'},
{"jiao", 1, L'焦'},
{"jiao", 1, L'胶'},
{"jiao", 1, L'交'},
{"jiao", 1, L'郊'},
{"jiao", 1, L'浇'},
{"jiao", 1, L'骄'},
{"jiao", 1, L'娇'},
{"jiao", 1, L'教'},
{"jiao", 1, L'僬'},
{"jiao", 1, L'艽'},
{"jiao", 1, L'茭'},
{"jiao", 1, L'姣'},
{"jiao", 1, L'鹪'},
{"jiao", 1, L'蛟'},
{"jiao", 1, L'跤'},
{"jiao", 1, L'鲛'},
{"jiao", 2, L'嚼'},
{"jiao", 3, L'搅'},
{"jiao", 3, L'铰'},
{"jiao", 3, L'矫'},
{"jiao", 3, L'侥'},
{"jiao", 3, L'脚'},
{"jiao", 3, L'狡'},
{"jiao", 3, L'角'},
{"jiao", 3, L'饺'},
{"jiao", 3, L'缴'},
{"jiao", 3, L'绞'},
{"jiao", 3, L'剿'},
{"jiao", 3, L'佼'},
{"jiao", 3, L'挢'},
{"jiao", 3, L'徼'},
{"jiao", 3, L'湫'},
{"jiao", 3, L'敫'},
{"jiao", 3, L'皎'},
{"jiao", 4, L'嚼'},
{"jiao", 4, L'教'},
{"jiao", 4, L'酵'},
{"jiao", 4, L'轿'},
{"jiao", 4, L'较'},
{"jiao", 4, L'叫'},
{"jiao", 4, L'窖'},
{"jiao", 4, L'觉'},
{"jiao", 4, L'校'},
{"jiao", 4, L'噍'},
{"jiao", 4, L'峤'},
{"jiao", 4, L'徼'},
{"jiao", 4, L'爝'},
{"jiao", 4, L'醮'},
{"jie", 1, L'揭'},
{"jie", 1, L'接'},
{"jie", 1, L'皆'},
{"jie", 1, L'秸'},
{"jie", 1, L'街'},
{"jie", 1, L'阶'},
{"jie", 1, L'节'},
{"jie", 1, L'结'},
{"jie", 1, L'楷'},
{"jie", 1, L'喈'},
{"jie", 1, L'嗟'},
{"jie", 1, L'疖'},
{"jie", 2, L'截'},
{"jie", 2, L'劫'},
{"jie", 2, L'节'},
{"jie", 2, L'桔'},
{"jie", 2, L'杰'},
{"jie", 2, L'捷'},
{"jie", 2, L'睫'},
{"jie", 2, L'竭'},
{"jie", 2, L'洁'},
{"jie", 2, L'结'},
{"jie", 2, L'偈'},
{"jie", 2, L'讦'},
{"jie", 2, L'诘'},
{"jie", 2, L'拮'},
{"jie", 2, L'婕'},
{"jie", 2, L'孑'},
{"jie", 2, L'桀'},
{"jie", 2, L'碣'},
{"jie", 2, L'颉'},
{"jie", 2, L'羯'},
{"jie", 2, L'鲒'},
{"jie", 3, L'解'},
{"jie", 3, L'姐'},
{"jie", 4, L'价'},
{"jie", 4, L'解'},
{"jie", 4, L'戒'},
{"jie", 4, L'藉'},
{"jie", 4, L'芥'},
{"jie", 4, L'界'},
{"jie", 4, L'借'},
{"jie", 4, L'介'},
{"jie", 4, L'疥'},
{"jie", 4, L'诫'},
{"jie", 4, L'届'},
{"jie", 4, L'蚧'},
{"jie", 4, L'骱'},
{"jie", 5, L'家'},
{"jie", 5, L'价'},
{"jin", 1, L'巾'},
{"jin", 1, L'筋'},
{"jin", 1, L'斤'},
{"jin", 1, L'金'},
{"jin", 1, L'今'},
{"jin", 1, L'津'},
{"jin", 1, L'襟'},
{"jin", 1, L'禁'},
{"jin", 1, L'衿'},
{"jin", 1, L'矜'},
{"jin", 3, L'紧'},
{"jin", 3, L'锦'},
{"jin", 3, L'仅'},
{"jin", 3, L'谨'},
{"jin", 3, L'尽'},
{"jin", 3, L'卺'},
{"jin", 3, L'堇'},
{"jin", 3, L'馑'},
{"jin", 3, L'廑'},
{"jin", 3, L'瑾'},
{"jin", 3, L'槿'},
{"jin", 4, L'仅'},
{"jin", 4, L'进'},
{"jin", 4, L'靳'},
{"jin", 4, L'晋'},
{"jin", 4, L'禁'},
{"jin", 4, L'近'},
{"jin", 4, L'烬'},
{"jin", 4, L'浸'},
{"jin", 4, L'尽'},
{"jin", 4, L'劲'},
{"jin", 4, L'荩'},
{"jin", 4, L'噤'},
{"jin", 4, L'妗'},
{"jin", 4, L'缙'},
{"jin", 4, L'赆'},
{"jin", 4, L'觐'},
{"jing", 1, L'荆'},
{"jing", 1, L'兢'},
{"jing", 1, L'茎'},
{"jing", 1, L'睛'},
{"jing", 1, L'晶'},
{"jing", 1, L'鲸'},
{"jing", 1, L'京'},
{"jing", 1, L'惊'},
{"jing", 1, L'精'},
{"jing", 1, L'粳'},
{"jing", 1, L'经'},
{"jing", 1, L'菁'},
{"jing", 1, L'泾'},
{"jing", 1, L'腈'},
{"jing", 1, L'旌'},
{"jing", 3, L'井'},
{"jing", 3, L'警'},
{"jing", 3, L'景'},
{"jing", 3, L'颈'},
{"jing", 3, L'刭'},
{"jing", 3, L'儆'},
{"jing", 3, L'阱'},
{"jing", 3, L'憬'},
{"jing", 3, L'肼'},
{"jing", 4, L'劲'},
{"jing", 4, L'静'},
{"jing", 4, L'境'},
{"jing", 4, L'敬'},
{"jing", 4, L'镜'},
{"jing", 4, L'径'},
{"jing", 4, L'痉'},
{"jing", 4, L'靖'},
{"jing", 4, L'竟'},
{"jing", 4, L'竞'},
{"jing", 4, L'净'},
{"jing", 4, L'獍'},
{"jing", 4, L'迳'},
{"jing", 4, L'弪'},
{"jing", 4, L'婧'},
{"jing", 4, L'胫'},
{"jing", 4, L'靓'},
{"jiong", 1, L'扃'},
{"jiong", 3, L'炯'},
{"jiong", 3, L'窘'},
{"jiong", 3, L'迥'},
{"jiong", 3, L'炅'},
{"jiu", 1, L'揪'},
{"jiu", 1, L'究'},
{"jiu", 1, L'纠'},
{"jiu", 1, L'啾'},
{"jiu", 1, L'阄'},
{"jiu", 1, L'鸠'},
{"jiu", 1, L'赳'},
{"jiu", 1, L'鬏'},
{"jiu", 3, L'玖'},
{"jiu", 3, L'韭'},
{"jiu", 3, L'久'},
{"jiu", 3, L'灸'},
{"jiu", 3, L'九'},
{"jiu", 3, L'酒'},
{"jiu", 4, L'厩'},
{"jiu", 4, L'救'},
{"jiu", 4, L'旧'},
{"jiu", 4, L'臼'},
{"jiu", 4, L'舅'},
{"jiu", 4, L'咎'},
{"jiu", 4, L'就'},
{"jiu", 4, L'疚'},
{"jiu", 4, L'僦'},
{"jiu", 4, L'柩'},
{"jiu", 4, L'桕'},
{"jiu", 4, L'鹫'},
{"ju", 1, L'车'},
{"ju", 1, L'鞠'},
{"ju", 1, L'拘'},
{"ju", 1, L'狙'},
{"ju", 1, L'疽'},
{"ju", 1, L'居'},
{"ju", 1, L'驹'},
{"ju", 1, L'据'},
{"ju", 1, L'锯'},
{"ju", 1, L'俱'},
{"ju", 1, L'且'},
{"ju", 1, L'苴'},
{"ju", 1, L'掬'},
{"ju", 1, L'琚'},
{"ju", 1, L'椐'},
{"ju", 1, L'锔'},
{"ju", 1, L'裾'},
{"ju", 1, L'趄'},
{"ju", 1, L'雎'},
{"ju", 1, L'鞫'},
{"ju", 2, L'桔'},
{"ju", 2, L'菊'},
{"ju", 2, L'局'},
{"ju", 2, L'橘'},
{"ju", 2, L'锔'},
{"ju", 3, L'柜'},
{"ju", 3, L'咀'},
{"ju", 3, L'矩'},
{"ju", 3, L'举'},
{"ju", 3, L'沮'},
{"ju", 3, L'莒'},
{"ju", 3, L'枸'},
{"ju", 3, L'榘'},
{"ju", 3, L'榉'},
{"ju", 3, L'踽'},
{"ju", 3, L'龃'},
{"ju", 4, L'沮'},
{"ju", 4, L'聚'},
{"ju", 4, L'拒'},
{"ju", 4, L'据'},
{"ju", 4, L'巨'},
{"ju", 4, L'具'},
{"ju", 4, L'距'},
{"ju", 4, L'踞'},
{"ju", 4, L'锯'},
{"ju", 4, L'俱'},
{"ju", 4, L'句'},
{"ju", 4, L'惧'},
{"ju", 4, L'炬'},
{"ju", 4, L'剧'},
{"ju", 4, L'倨'},
{"ju", 4, L'讵'},
{"ju", 4, L'苣'},
{"ju", 4, L'遽'},
{"ju", 4, L'屦'},
{"ju", 4, L'犋'},
{"ju", 4, L'飓'},
{"ju", 4, L'钜'},
{"ju", 4, L'窭'},
{"ju", 4, L'醵'},
{"ju", 4, L'瞿'},
{"juan", 1, L'捐'},
{"juan", 1, L'鹃'},
{"juan", 1, L'娟'},
{"juan", 1, L'圈'},
{"juan", 1, L'涓'},
{"juan", 1, L'蠲'},
{"juan", 1, L'镌'},
{"juan", 3, L'卷'},
{"juan", 3, L'锩'},
{"juan", 4, L'倦'},
{"juan", 4, L'眷'},
{"juan", 4, L'卷'},
{"juan", 4, L'绢'},
{"juan", 4, L'圈'},
{"juan", 4, L'鄄'},
{"juan", 4, L'狷'},
{"juan", 4, L'桊'},
{"juan", 4, L'隽'},
{"jue", 1, L'撅'},
{"jue", 1, L'嗟'},
{"jue", 1, L'噘'},
{"jue", 2, L'嚼'},
{"jue", 2, L'脚'},
{"jue", 2, L'角'},
{"jue", 2, L'攫'},
{"jue", 2, L'抉'},
{"jue", 2, L'掘'},
{"jue", 2, L'倔'},
{"jue", 2, L'爵'},
{"jue", 2, L'觉'},
{"jue", 2, L'决'},
{"jue", 2, L'诀'},
{"jue", 2, L'绝'},
{"jue", 2, L'厥'},
{"jue", 2, L'劂'},
{"jue", 2, L'谲'},
{"jue", 2, L'矍'},
{"jue", 2, L'蕨'},
{"jue", 2, L'噱'},
{"jue", 2, L'崛'},
{"jue", 2, L'獗'},
{"jue", 2, L'孓'},
{"jue", 2, L'珏'},
{"jue", 2, L'桷'},
{"jue", 2, L'橛'},
{"jue", 2, L'爝'},
{"jue", 2, L'镢'},
{"jue", 2, L'蹶'},
{"jue", 2, L'觖'},
{"jue", 3, L'蹶'},
{"jue", 4, L'倔'},
{"Jun", 1, L'龟'},
{"Jun", 1, L'均'},
{"Jun", 1, L'菌'},
{"Jun", 1, L'钧'},
{"Jun", 1, L'军'},
{"Jun", 1, L'君'},
{"Jun", 1, L'皲'},
{"Jun", 1, L'筠'},
{"Jun", 1, L'麇'},
{"Jun", 4, L'菌'},
{"Jun", 4, L'峻'},
{"Jun", 4, L'俊'},
{"Jun", 4, L'竣'},
{"Jun", 4, L'浚'},
{"Jun", 4, L'郡'},
{"Jun", 4, L'骏'},
{"Jun", 4, L'捃'},
{"Jun", 4, L'隽'},
{"ka", 1, L'喀'},
{"ka", 1, L'咖'},
{"ka", 1, L'咔'},
{"ka", 3, L'卡'},
{"ka", 3, L'咯'},
{"ka", 3, L'佧'},
{"ka", 3, L'咔'},
{"ka", 3, L'胩'},
{"kai", 1, L'开'},
{"kai", 1, L'揩'},
{"kai", 1, L'锎'},
{"kai", 3, L'楷'},
{"kai", 3, L'凯'},
{"kai", 3, L'慨'},
{"kai", 3, L'剀'},
{"kai", 3, L'垲'},
{"kai", 3, L'蒈'},
{"kai", 3, L'恺'},
{"kai", 3, L'铠'},
{"kai", 3, L'锴'},
{"kai", 4, L'忾'},
{"kan", 1, L'刊'},
{"kan", 1, L'堪'},
{"kan", 1, L'勘'},
{"kan", 1, L'看'},
{"kan", 1, L'戡'},
{"kan", 1, L'龛'},
{"kan", 3, L'槛'},
{"kan", 3, L'坎'},
{"kan", 3, L'砍'},
{"kan", 3, L'侃'},
{"kan", 3, L'莰'},
{"kan", 4, L'看'},
{"kan", 4, L'嵌'},
{"kan", 4, L'阚'},
{"kan", 4, L'瞰'},
{"kang", 1, L'康'},
{"kang", 1, L'慷'},
{"kang", 1, L'糠'},
{"kang", 1, L'闶'},
{"kang", 2, L'扛'},
{"kang", 4, L'抗'},
{"kang", 4, L'亢'},
{"kang", 4, L'炕'},
{"kang", 4, L'伉'},
{"kang", 4, L'钪'},
{"kao", 1, L'尻'},
{"kao", 3, L'考'},
{"kao", 3, L'拷'},
{"kao", 3, L'烤'},
{"kao", 3, L'栲'},
{"kao", 4, L'靠'},
{"kao", 4, L'犒'},
{"kao", 4, L'铐'},
{"ke", 1, L'坷'},
{"ke", 1, L'苛'},
{"ke", 1, L'柯'},
{"ke", 1, L'棵'},
{"ke", 1, L'磕'},
{"ke", 1, L'颗'},
{"ke", 1, L'科'},
{"ke", 1, L'嗑'},
{"ke", 1, L'珂'},
{"ke", 1, L'轲'},
{"ke", 1, L'瞌'},
{"ke", 1, L'钶'},
{"ke", 1, L'稞'},
{"ke", 1, L'疴'},
{"ke", 1, L'窠'},
{"ke", 1, L'颏'},
{"ke", 1, L'蝌'},
{"ke", 1, L'髁'},
{"ke", 2, L'壳'},
{"ke", 2, L'咳'},
{"ke", 3, L'坷'},
{"ke", 3, L'可'},
{"ke", 3, L'渴'},
{"ke", 3, L'岢'},
{"ke", 4, L'可'},
{"ke", 4, L'克'},
{"ke", 4, L'刻'},
{"ke", 4, L'客'},
{"ke", 4, L'课'},
{"ke", 4, L'嗑'},
{"ke", 4, L'恪'},
{"ke", 4, L'溘'},
{"ke", 4, L'骒'},
{"ke", 4, L'缂'},
{"ke", 4, L'氪'},
{"ke", 4, L'锞'},
{"ken", 3, L'肯'},
{"ken", 3, L'啃'},
{"ken", 3, L'垦'},
{"ken", 3, L'恳'},
{"ken", 3, L'龈'},
{"ken", 4, L'裉'},
{"keng", 1, L'坑'},
{"keng", 1, L'吭'},
{"keng", 1, L'铿'},
{"kong", 1, L'空'},
{"kong", 1, L'倥'},
{"kong", 1, L'崆'},
{"kong", 1, L'箜'},
{"kong", 3, L'恐'},
{"kong", 3, L'孔'},
{"kong", 4, L'空'},
{"kong", 4, L'控'},
{"kou", 1, L'抠'},
{"kou", 1, L'芤'},
{"kou", 1, L'眍'},
{"kou", 3, L'口'},
{"kou", 4, L'扣'},
{"kou", 4, L'寇'},
{"kou", 4, L'蔻'},
{"kou", 4, L'叩'},
{"kou", 4, L'筘'},
{"ku", 1, L'枯'},
{"ku", 1, L'哭'},
{"ku", 1, L'窟'},
{"ku", 1, L'刳'},
{"ku", 1, L'堀'},
{"ku", 1, L'骷'},
{"ku", 3, L'苦'},
{"ku", 4, L'酷'},
{"ku", 4, L'库'},
{"ku", 4, L'裤'},
{"ku", 4, L'喾'},
{"ku", 4, L'绔'},
{"kua", 1, L'夸'},
{"kua", 3, L'垮'},
{"kua", 3, L'侉'},
{"kua", 4, L'挎'},
{"kua", 4, L'跨'},
{"kua", 4, L'胯'},
{"kuai", 3, L'蒯'},
{"kuai", 4, L'会'},
{"kuai", 4, L'块'},
{"kuai", 4, L'筷'},
{"kuai", 4, L'侩'},
{"kuai", 4, L'快'},
{"kuai", 4, L'郐'},
{"kuai", 4, L'哙'},
{"kuai", 4, L'狯'},
{"kuai", 4, L'浍'},
{"kuai", 4, L'脍'},
{"kuan", 1, L'宽'},
{"kuan", 1, L'髋'},
{"kuan", 3, L'款'},
{"kuang", 1, L'匡'},
{"kuang", 1, L'筐'},
{"kuang", 1, L'诓'},
{"kuang", 1, L'哐'},
{"kuang", 2, L'狂'},
{"kuang", 2, L'诳'},
{"kuang", 3, L'夼'},
{"kuang", 4, L'框'},
{"kuang", 4, L'矿'},
{"kuang", 4, L'眶'},
{"kuang", 4, L'旷'},
{"kuang", 4, L'况'},
{"kuang", 4, L'邝'},
{"kuang", 4, L'圹'},
{"kuang", 4, L'纩'},
{"kuang", 4, L'贶'},
{"kui", 1, L'亏'},
{"kui", 1, L'盔'},
{"kui", 1, L'岿'},
{"kui", 1, L'窥'},
{"kui", 1, L'悝'},
{"kui", 2, L'葵'},
{"kui", 2, L'奎'},
{"kui", 2, L'魁'},
{"kui", 2, L'馗'},
{"kui", 2, L'夔'},
{"kui", 2, L'隗'},
{"kui", 2, L'揆'},
{"kui", 2, L'喹'},
{"kui", 2, L'逵'},
{"kui", 2, L'暌'},
{"kui", 2, L'睽'},
{"kui", 2, L'蝰'},
{"kui", 3, L'傀'},
{"kui", 3, L'跬'},
{"kui", 4, L'馈'},
{"kui", 4, L'愧'},
{"kui", 4, L'溃'},
{"kui", 4, L'匮'},
{"kui", 4, L'蒉'},
{"kui", 4, L'喟'},
{"kui", 4, L'愦'},
{"kui", 4, L'聩'},
{"kui", 4, L'篑'},
{"kun", 1, L'坤'},
{"kun", 1, L'昆'},
{"kun", 1, L'琨'},
{"kun", 1, L'锟'},
{"kun", 1, L'醌'},
{"kun", 1, L'鲲'},
{"kun", 1, L'髡'},
{"kun", 3, L'捆'},
{"kun", 3, L'悃'},
{"kun", 3, L'阃'},
{"kun", 4, L'困'},
{"kuo", 4, L'括'},
{"kuo", 4, L'扩'},
{"kuo", 4, L'廓'},
{"kuo", 4, L'阔'},
{"kuo", 4, L'适'},
{"kuo", 4, L'蛞'},
{"la", 1, L'垃'},
{"la", 1, L'拉'},
{"la", 1, L'喇'},
{"la", 1, L'喇'},
{"la", 1, L'啦'},
{"la", 1, L'邋'},
{"la", 2, L'拉'},
{"la", 2, L'旯'},
{"la", 2, L'砬'},
{"la", 3, L'喇'},
{"la", 4, L'蜡'},
{"la", 4, L'腊'},
{"la", 4, L'辣'},
{"la", 4, L'落'},
{"la", 4, L'剌'},
{"la", 4, L'瘌'},
{"la", 5, L'啦'},
{"lai", 2, L'莱'},
{"lai", 2, L'来'},
{"lai", 2, L'崃'},
{"lai", 2, L'徕'},
{"lai", 2, L'涞'},
{"lai", 2, L'铼'},
{"lai", 4, L'赖'},
{"lai", 4, L'濑'},
{"lai", 4, L'赉'},
{"lai", 4, L'睐'},
{"lai", 4, L'癞'},
{"lai", 4, L'籁'},
{"lan", 2, L'蓝'},
{"lan", 2, L'婪'},
{"lan", 2, L'栏'},
{"lan", 2, L'拦'},
{"lan", 2, L'篮'},
{"lan", 2, L'阑'},
{"lan", 2, L'兰'},
{"lan", 2, L'澜'},
{"lan", 2, L'谰'},
{"lan", 2, L'岚'},
{"lan", 2, L'斓'},
{"lan", 2, L'镧'},
{"lan", 2, L'褴'},
{"lan", 3, L'揽'},
{"lan", 3, L'览'},
{"lan", 3, L'懒'},
{"lan", 3, L'缆'},
{"lan", 3, L'漤'},
{"lan", 3, L'榄'},
{"lan", 3, L'罱'},
{"lan", 4, L'烂'},
{"lan", 4, L'滥'},
{"lang", 1, L'啷'},
{"lang", 2, L'琅'},
{"lang", 2, L'榔'},
{"lang", 2, L'狼'},
{"lang", 2, L'廊'},
{"lang", 2, L'郎'},
{"lang", 2, L'阆'},
{"lang", 2, L'锒'},
{"lang", 2, L'稂'},
{"lang", 2, L'螂'},
{"lang", 3, L'朗'},
{"lang", 4, L'浪'},
{"lang", 4, L'莨'},
{"lang", 4, L'蒗'},
{"lang", 4, L'阆'},
{"lao", 1, L'捞'},
{"lao", 2, L'劳'},
{"lao", 2, L'牢'},
{"lao", 2, L'唠'},
{"lao", 2, L'崂'},
{"lao", 2, L'铹'},
{"lao", 2, L'痨'},
{"lao", 2, L'醪'},
{"lao", 3, L'老'},
{"lao", 3, L'佬'},
{"lao", 3, L'姥'},
{"lao", 3, L'潦'},
{"lao", 3, L'栳'},
{"lao", 3, L'铑'},
{"lao", 4, L'酪'},
{"lao", 4, L'烙'},
{"lao", 4, L'涝'},
{"lao", 4, L'落'},
{"lao", 4, L'络'},
{"lao", 4, L'唠'},
{"lao", 4, L'耢'},
{"le", 1, L'肋'},
{"le", 4, L'勒'},
{"le", 4, L'乐'},
{"le", 4, L'仂'},
{"le", 4, L'叻'},
{"le", 4, L'泐'},
{"le", 4, L'鳓'},
{"le", 5, L'了'},
{"lei", 1, L'勒'},
{"lei", 2, L'雷'},
{"lei", 2, L'镭'},
{"lei", 2, L'累'},
{"lei", 2, L'擂'},
{"lei", 2, L'羸'},
{"lei", 2, L'嫘'},
{"lei", 2, L'缧'},
{"lei", 2, L'檑'},
{"lei", 3, L'蕾'},
{"lei", 3, L'磊'},
{"lei", 3, L'累'},
{"lei", 3, L'儡'},
{"lei", 3, L'垒'},
{"lei", 3, L'诔'},
{"lei", 3, L'耒'},
{"lei", 4, L'累'},
{"lei", 4, L'擂'},
{"lei", 4, L'肋'},
{"lei", 4, L'类'},
{"lei", 4, L'泪'},
{"lei", 4, L'酹'},
{"lei", 5, L'嘞'},
{"leng", 1, L'棱'},
{"leng", 2, L'棱'},
{"leng", 2, L'楞'},
{"leng", 2, L'塄'},
{"leng", 3, L'冷'},
{"leng", 4, L'愣'},
{"li", 1, L'哩'},
{"li", 2, L'厘'},
{"li", 2, L'梨'},
{"li", 2, L'犁'},
{"li", 2, L'黎'},
{"li", 2, L'篱'},
{"li", 2, L'狸'},
{"li", 2, L'离'},
{"li", 2, L'漓'},
{"li", 2, L'丽'},
{"li", 2, L'璃'},
{"li", 2, L'蓠'},
{"li", 2, L'藜'},
{"li", 2, L'喱'},
{"li", 2, L'嫠'},
{"li", 2, L'骊'},
{"li", 2, L'缡'},
{"li", 2, L'罹'},
{"li", 2, L'鹂'},
{"li", 2, L'蜊'},
{"li", 2, L'蠡'},
{"li", 2, L'鲡'},
{"li", 2, L'黧'},
{"li", 3, L'理'},
{"li", 3, L'李'},
{"li", 3, L'里'},
{"li", 3, L'鲤'},
{"li", 3, L'礼'},
{"li", 3, L'哩'},
{"li", 3, L'俚'},
{"li", 3, L'澧'},
{"li", 3, L'逦'},
{"li", 3, L'娌'},
{"li", 3, L'锂'},
{"li", 3, L'蠡'},
{"li", 3, L'醴'},
{"li", 3, L'鳢'},
{"li", 4, L'莉'},
{"li", 4, L'荔'},
{"li", 4, L'吏'},
{"li", 4, L'栗'},
{"li", 4, L'丽'},
{"li", 4, L'厉'},
{"li", 4, L'励'},
{"li", 4, L'砾'},
{"li", 4, L'历'},
{"li", 4, L'利'},
{"li", 4, L'傈'},
{"li", 4, L'例'},
{"li", 4, L'俐'},
{"li", 4, L'痢'},
{"li", 4, L'立'},
{"li", 4, L'粒'},
{"li", 4, L'沥'},
{"li", 4, L'隶'},
{"li", 4, L'力'},
{"li", 4, L'鬲'},
{"li", 4, L'俪'},
{"li", 4, L'郦'},
{"li", 4, L'坜'},
{"li", 4, L'苈'},
{"li", 4, L'莅'},
{"li", 4, L'呖'},
{"li", 4, L'唳'},
{"li", 4, L'猁'},
{"li", 4, L'溧'},
{"li", 4, L'枥'},
{"li", 4, L'栎'},
{"li", 4, L'轹'},
{"li", 4, L'戾'},
{"li", 4, L'砺'},
{"li", 4, L'詈'},
{"li", 4, L'疠'},
{"li", 4, L'疬'},
{"li", 4, L'蛎'},
{"li", 4, L'笠'},
{"li", 4, L'篥'},
{"li", 4, L'粝'},
{"li", 4, L'跞'},
{"li", 4, L'雳'},
{"li", 5, L'哩'},
{"lia", 3, L'俩'},
{"lian", 2, L'联'},
{"lian", 2, L'莲'},
{"lian", 2, L'连'},
{"lian", 2, L'镰'},
{"lian", 2, L'廉'},
{"lian", 2, L'怜'},
{"lian", 2, L'涟'},
{"lian", 2, L'帘'},
{"lian", 2, L'奁'},
{"lian", 2, L'濂'},
{"lian", 2, L'臁'},
{"lian", 2, L'裢'},
{"lian", 2, L'蠊'},
{"lian", 2, L'鲢'},
{"lian", 3, L'敛'},
{"lian", 3, L'脸'},
{"lian", 3, L'蔹'},
{"lian", 3, L'琏'},
{"lian", 3, L'裣'},
{"lian", 4, L'链'},
{"lian", 4, L'恋'},
{"lian", 4, L'炼'},
{"lian", 4, L'练'},
{"lian", 4, L'潋'},
{"lian", 4, L'楝'},
{"lian", 4, L'殓'},
{"liang", 2, L'粮'},
{"liang", 2, L'凉'},
{"liang", 2, L'梁'},
{"liang", 2, L'粱'},
{"liang", 2, L'良'},
{"liang", 2, L'量'},
{"liang", 2, L'墚'},
{"liang", 2, L'椋'},
{"liang", 2, L'踉'},
{"liang", 3, L'俩'},
{"liang", 3, L'两'},
{"liang", 3, L'魉'},
{"liang", 4, L'凉'},
{"liang", 4, L'辆'},
{"liang", 4, L'量'},
{"liang", 4, L'晾'},
{"liang", 4, L'亮'},
{"liang", 4, L'谅'},
{"liang", 4, L'踉'},
{"liang", 4, L'靓'},
{"liao", 1, L'撩'},
{"liao", 2, L'撩'},
{"liao", 2, L'聊'},
{"liao", 2, L'僚'},
{"liao", 2, L'疗'},
{"liao", 2, L'燎'},
{"liao", 2, L'寥'},
{"liao", 2, L'辽'},
{"liao", 2, L'潦'},
{"liao", 2, L'嘹'},
{"liao", 2, L'獠'},
{"liao", 2, L'寮'},
{"liao", 2, L'缭'},
{"liao", 2, L'鹩'},
{"liao", 3, L'燎'},
{"liao", 3, L'了'},
{"liao", 3, L'蓼'},
{"liao", 3, L'钌'},
{"liao", 4, L'撂'},
{"liao", 4, L'镣'},
{"liao", 4, L'廖'},
{"liao", 4, L'料'},
{"liao", 4, L'尥'},
{"liao", 4, L'钌'},
{"lie", 1, L'咧'},
{"lie", 3, L'裂'},
{"lie", 3, L'咧'},
{"lie", 4, L'列'},
{"lie", 4, L'裂'},
{"lie", 4, L'烈'},
{"lie", 4, L'劣'},
{"lie", 4, L'猎'},
{"lie", 4, L'冽'},
{"lie", 4, L'埒'},
{"lie", 4, L'捩'},
{"lie", 4, L'洌'},
{"lie", 4, L'趔'},
{"lie", 4, L'躐'},
{"lie", 4, L'鬣'},
{"lie", 5, L'咧'},
{"lin", 1, L'拎'},
{"lin", 2, L'琳'},
{"lin", 2, L'林'},
{"lin", 2, L'磷'},
{"lin", 2, L'霖'},
{"lin", 2, L'临'},
{"lin", 2, L'邻'},
{"lin", 2, L'鳞'},
{"lin", 2, L'淋'},
{"lin", 2, L'啉'},
{"lin", 2, L'嶙'},
{"lin", 2, L'遴'},
{"lin", 2, L'辚'},
{"lin", 2, L'瞵'},
{"lin", 2, L'粼'},
{"lin", 2, L'麟'},
{"lin", 3, L'凛'},
{"lin", 3, L'廪'},
{"lin", 3, L'懔'},
{"lin", 3, L'檩'},
{"lin", 4, L'淋'},
{"lin", 4, L'赁'},
{"lin", 4, L'吝'},
{"lin", 4, L'蔺'},
{"lin", 4, L'膦'},
{"lin", 4, L'躏'},
{"ling", 2, L'棱'},
{"ling", 2, L'玲'},
{"ling", 2, L'菱'},
{"ling", 2, L'零'},
{"ling", 2, L'龄'},
{"ling", 2, L'铃'},
{"ling", 2, L'伶'},
{"ling", 2, L'羚'},
{"ling", 2, L'凌'},
{"ling", 2, L'灵'},
{"ling", 2, L'陵'},
{"ling", 2, L'令'},
{"ling", 2, L'酃'},
{"ling", 2, L'苓'},
{"ling", 2, L'囹'},
{"ling", 2, L'泠'},
{"ling", 2, L'绫'},
{"ling", 2, L'柃'},
{"ling", 2, L'棂'},
{"ling", 2, L'瓴'},
{"ling", 2, L'聆'},
{"ling", 2, L'蛉'},
{"ling", 2, L'翎'},
{"ling", 2, L'鲮'},
{"ling", 3, L'岭'},
{"ling", 3, L'领'},
{"ling", 3, L'令'},
{"ling", 4, L'另'},
{"ling", 4, L'令'},
{"ling", 4, L'呤'},
{"liu", 1, L'溜'},
{"liu", 1, L'熘'},
{"liu", 2, L'琉'},
{"liu", 2, L'榴'},
{"liu", 2, L'硫'},
{"liu", 2, L'馏'},
{"liu", 2, L'留'},
{"liu", 2, L'刘'},
{"liu", 2, L'瘤'},
{"liu", 2, L'流'},
{"liu", 2, L'浏'},
{"liu", 2, L'遛'},
{"liu", 2, L'骝'},
{"liu", 2, L'旒'},
{"liu", 2, L'镏'},
{"liu", 2, L'鎏'},
{"liu", 3, L'柳'},
{"liu", 3, L'绺'},
{"liu", 3, L'锍'},
{"liu", 4, L'溜'},
{"liu", 4, L'馏'},
{"liu", 4, L'六'},
{"liu", 4, L'碌'},
{"liu", 4, L'陆'},
{"liu", 4, L'遛'},
{"liu", 4, L'镏'},
{"liu", 4, L'鹨'},
{"lo", 5, L'咯'},
{"long", 1, L'隆'},
{"long", 2, L'龙'},
{"long", 2, L'聋'},
{"long", 2, L'咙'},
{"long", 2, L'笼'},
{"long", 2, L'窿'},
{"long", 2, L'隆'},
{"long", 2, L'茏'},
{"long", 2, L'泷'},
{"long", 2, L'珑'},
{"long", 2, L'栊'},
{"long", 2, L'胧'},
{"long", 2, L'砻'},
{"long", 2, L'癃'},
{"long", 3, L'笼'},
{"long", 3, L'垄'},
{"long", 3, L'拢'},
{"long", 3, L'陇'},
{"long", 3, L'垅'},
{"long", 4, L'弄'},
{"lou", 1, L'搂'},
{"lou", 2, L'楼'},
{"lou", 2, L'娄'},
{"lou", 2, L'偻'},
{"lou", 2, L'蒌'},
{"lou", 2, L'喽'},
{"lou", 2, L'耧'},
{"lou", 2, L'蝼'},
{"lou", 2, L'髅'},
{"lou", 3, L'搂'},
{"lou", 3, L'篓'},
{"lou", 3, L'嵝'},
{"lou", 4, L'漏'},
{"lou", 4, L'陋'},
{"lou", 4, L'露'},
{"lou", 4, L'镂'},
{"lou", 4, L'瘘'},
{"lou", 5, L'喽'},
{"lu", 1, L'撸'},
{"lu", 1, L'噜'},
{"lu", 2, L'芦'},
{"lu", 2, L'卢'},
{"lu", 2, L'颅'},
{"lu", 2, L'庐'},
{"lu", 2, L'炉'},
{"lu", 2, L'垆'},
{"lu", 2, L'泸'},
{"lu", 2, L'栌'},
{"lu", 2, L'轳'},
{"lu", 2, L'胪'},
{"lu", 2, L'鸬'},
{"lu", 2, L'舻'},
{"lu", 2, L'鲈'},
{"lu", 3, L'掳'},
{"lu", 3, L'卤'},
{"lu", 3, L'虏'},
{"lu", 3, L'鲁'},
{"lu", 3, L'橹'},
{"lu", 3, L'镥'},
{"lu", 4, L'六'},
{"lu", 4, L'麓'},
{"lu", 4, L'碌'},
{"lu", 4, L'露'},
{"lu", 4, L'路'},
{"lu", 4, L'赂'},
{"lu", 4, L'鹿'},
{"lu", 4, L'潞'},
{"lu", 4, L'禄'},
{"lu", 4, L'录'},
{"lu", 4, L'陆'},
{"lu", 4, L'戮'},
{"lu", 4, L'绿'},
{"lu", 4, L'渌'},
{"lu", 4, L'漉'},
{"lu", 4, L'逯'},
{"lu", 4, L'璐'},
{"lu", 4, L'辂'},
{"lu", 4, L'辘'},
{"lu", 4, L'鹭'},
{"lu", 4, L'簏'},
{"lu", 5, L'氇'},
{"lu:", 2, L'驴'},
{"lu:", 2, L'闾'},
{"lu:", 2, L'榈'},
{"lu:", 3, L'吕'},
{"lu:", 3, L'铝'},
{"lu:", 3, L'侣'},
{"lu:", 3, L'旅'},
{"lu:", 3, L'履'},
{"lu:", 3, L'屡'},
{"lu:", 3, L'缕'},
{"lu:", 3, L'偻'},
{"lu:", 3, L'捋'},
{"lu:", 3, L'膂'},
{"lu:", 3, L'稆'},
{"lu:", 3, L'褛'},
{"lu:", 4, L'虑'},
{"lu:", 4, L'氯'},
{"lu:", 4, L'律'},
{"lu:", 4, L'率'},
{"lu:", 4, L'滤'},
{"lu:", 4, L'绿'},
{"luan", 2, L'峦'},
{"luan", 2, L'挛'},
{"luan", 2, L'孪'},
{"luan", 2, L'滦'},
{"luan", 2, L'脔'},
{"luan", 2, L'娈'},
{"luan", 2, L'栾'},
{"luan", 2, L'鸾'},
{"luan", 2, L'銮'},
{"luan", 3, L'卵'},
{"luan", 4, L'乱'},
{"lue:", 3, L'掠'},
{"lue:", 4, L'掠'},
{"lue:", 4, L'略'},
{"lue:", 4, L'锊'},
{"lun", 1, L'抡'},
{"lun", 2, L'抡'},
{"lun", 2, L'轮'},
{"lun", 2, L'伦'},
{"lun", 2, L'仑'},
{"lun", 2, L'沦'},
{"lun", 2, L'纶'},
{"lun", 2, L'论'},
{"lun", 2, L'囵'},
{"lun", 4, L'论'},
{"luo", 1, L'捋'},
{"luo", 2, L'萝'},
{"luo", 2, L'螺'},
{"luo", 2, L'罗'},
{"luo", 2, L'逻'},
{"luo", 2, L'锣'},
{"luo", 2, L'箩'},
{"luo", 2, L'骡'},
{"luo", 2, L'猡'},
{"luo", 2, L'椤'},
{"luo", 2, L'脶'},
{"luo", 2, L'镙'},
{"luo", 3, L'裸'},
{"luo", 3, L'倮'},
{"luo", 3, L'蠃'},
{"luo", 3, L'瘰'},
{"luo", 4, L'烙'},
{"luo", 4, L'落'},
{"luo", 4, L'洛'},
{"luo", 4, L'骆'},
{"luo", 4, L'络'},
{"luo", 4, L'荦'},
{"luo", 4, L'摞'},
{"luo", 4, L'泺'},
{"luo", 4, L'漯'},
{"luo", 4, L'珞'},
{"luo", 4, L'硌'},
{"luo", 4, L'跞'},
{"luo", 4, L'雒'},
{"m", 2, L'呒'},
{"ma", 1, L'妈'},
{"ma", 1, L'麻'},
{"ma", 1, L'蚂'},
{"ma", 1, L'摩'},
{"ma", 1, L'抹'},
{"ma", 2, L'麻'},
{"ma", 2, L'吗'},
{"ma", 2, L'蟆'},
{"ma", 3, L'玛'},
{"ma", 3, L'码'},
{"ma", 3, L'蚂'},
{"ma", 3, L'马'},
{"ma", 3, L'吗'},
{"ma", 3, L'犸'},
{"ma", 4, L'蚂'},
{"ma", 4, L'骂'},
{"ma", 4, L'唛'},
{"ma", 4, L'杩'},
{"ma", 5, L'嘛'},
{"ma", 5, L'吗'},
{"ma", 5, L'么'},
{"mai", 2, L'埋'},
{"mai", 2, L'霾'},
{"mai", 3, L'买'},
{"mai", 3, L'荬'},
{"mai", 4, L'麦'},
{"mai", 4, L'卖'},
{"mai", 4, L'迈'},
{"mai", 4, L'脉'},
{"mai", 4, L'劢'},
{"man", 1, L'颟'},
{"man", 2, L'埋'},
{"man", 2, L'瞒'},
{"man", 2, L'馒'},
{"man", 2, L'蛮'},
{"man", 2, L'蔓'},
{"man", 2, L'谩'},
{"man", 2, L'鳗'},
{"man", 2, L'鞔'},
{"man", 3, L'满'},
{"man", 3, L'螨'},
{"man", 4, L'蔓'},
{"man", 4, L'曼'},
{"man", 4, L'慢'},
{"man", 4, L'漫'},
{"man", 4, L'谩'},
{"man", 4, L'墁'},
{"man", 4, L'幔'},
{"man", 4, L'缦'},
{"man", 4, L'熳'},
{"man", 4, L'镘'},
{"mang", 2, L'芒'},
{"mang", 2, L'茫'},
{"mang", 2, L'盲'},
{"mang", 2, L'氓'},
{"mang", 2, L'忙'},
{"mang", 2, L'邙'},
{"mang", 2, L'硭'},
{"mang", 3, L'莽'},
{"mang", 3, L'漭'},
{"mang", 3, L'蟒'},
{"mao", 1, L'猫'},
{"mao", 2, L'猫'},
{"mao", 2, L'茅'},
{"mao", 2, L'锚'},
{"mao", 2, L'毛'},
{"mao", 2, L'矛'},
{"mao", 2, L'茆'},
{"mao", 2, L'牦'},
{"mao", 2, L'旄'},
{"mao", 2, L'蝥'},
{"mao", 2, L'蟊'},
{"mao", 2, L'髦'},
{"mao", 3, L'铆'},
{"mao", 3, L'卯'},
{"mao", 3, L'峁'},
{"mao", 3, L'泖'},
{"mao", 3, L'昴'},
{"mao", 4, L'茂'},
{"mao", 4, L'冒'},
{"mao", 4, L'帽'},
{"mao", 4, L'貌'},
{"mao", 4, L'贸'},
{"mao", 4, L'袤'},
{"mao", 4, L'瑁'},
{"mao", 4, L'耄'},
{"mao", 4, L'懋'},
{"mao", 4, L'瞀'},
{"me", 5, L'么'},
{"me", 5, L'麽'},
{"mei", 2, L'玫'},
{"mei", 2, L'枚'},
{"mei", 2, L'梅'},
{"mei", 2, L'酶'},
{"mei", 2, L'霉'},
{"mei", 2, L'煤'},
{"mei", 2, L'没'},
{"mei", 2, L'眉'},
{"mei", 2, L'媒'},
{"mei", 2, L'糜'},
{"mei", 2, L'莓'},
{"mei", 2, L'嵋'},
{"mei", 2, L'猸'},
{"mei", 2, L'湄'},
{"mei", 2, L'楣'},
{"mei", 2, L'镅'},
{"mei", 2, L'鹛'},
{"mei", 3, L'镁'},
{"mei", 3, L'每'},
{"mei", 3, L'美'},
{"mei", 3, L'浼'},
{"mei", 4, L'昧'},
{"mei", 4, L'寐'},
{"mei", 4, L'妹'},
{"mei", 4, L'媚'},
{"mei", 4, L'谜'},
{"mei", 4, L'袂'},
{"mei", 4, L'魅'},
{"men", 1, L'闷'},
{"men", 2, L'门'},
{"men", 2, L'扪'},
{"men", 2, L'钔'},
{"men", 4, L'闷'},
{"men", 4, L'焖'},
{"men", 4, L'懑'},
{"men", 5, L'们'},
{"meng", 1, L'蒙'},
{"meng", 2, L'氓'},
{"meng", 2, L'萌'},
{"meng", 2, L'蒙'},
{"meng", 2, L'檬'},
{"meng", 2, L'盟'},
{"meng", 2, L'甍'},
{"meng", 2, L'瞢'},
{"meng", 2, L'朦'},
{"meng", 2, L'礞'},
{"meng", 2, L'虻'},
{"meng", 2, L'艨'},
{"meng", 3, L'蒙'},
{"meng", 3, L'锰'},
{"meng", 3, L'猛'},
{"meng", 3, L'勐'},
{"meng", 3, L'懵'},
{"meng", 3, L'蜢'},
{"meng", 3, L'蠓'},
{"meng", 3, L'艋'},
{"meng", 4, L'梦'},
{"meng", 4, L'孟'},
{"mi", 1, L'眯'},
{"mi", 1, L'咪'},
{"mi", 2, L'眯'},
{"mi", 2, L'醚'},
{"mi", 2, L'靡'},
{"mi", 2, L'糜'},
{"mi", 2, L'迷'},
{"mi", 2, L'谜'},
{"mi", 2, L'弥'},
{"mi", 2, L'蘼'},
{"mi", 2, L'猕'},
{"mi", 2, L'祢'},
{"mi", 2, L'縻'},
{"mi", 2, L'麋'},
{"mi", 3, L'靡'},
{"mi", 3, L'米'},
{"mi", 3, L'芈'},
{"mi", 3, L'弭'},
{"mi", 3, L'脒'},
{"mi", 3, L'敉'},
{"mi", 4, L'秘'},
{"mi", 4, L'觅'},
{"mi", 4, L'泌'},
{"mi", 4, L'蜜'},
{"mi", 4, L'密'},
{"mi", 4, L'幂'},
{"mi", 4, L'谧'},
{"mi", 4, L'嘧'},
{"mi", 4, L'汨'},
{"mi", 4, L'宓'},
{"mi", 4, L'糸'},
{"mian", 2, L'棉'},
{"mian", 2, L'眠'},
{"mian", 2, L'绵'},
{"mian", 3, L'冕'},
{"mian", 3, L'免'},
{"mian", 3, L'勉'},
{"mian", 3, L'娩'},
{"mian", 3, L'缅'},
{"mian", 3, L'沔'},
{"mian", 3, L'渑'},
{"mian", 3, L'湎'},
{"mian", 3, L'腼'},
{"mian", 3, L'眄'},
{"mian", 3, L'黾'},
{"mian", 4, L'面'},
{"mian", 4, L'眄'},
{"miao", 1, L'喵'},
{"miao", 2, L'苗'},
{"miao", 2, L'描'},
{"miao", 2, L'瞄'},
{"miao", 2, L'鹋'},
{"miao", 3, L'藐'},
{"miao", 3, L'秒'},
{"miao", 3, L'渺'},
{"miao", 3, L'邈'},
{"miao", 3, L'缈'},
{"miao", 3, L'杪'},
{"miao", 3, L'淼'},
{"miao", 3, L'眇'},
{"miao", 4, L'庙'},
{"miao", 4, L'妙'},
{"miao", 4, L'缪'},
{"mie", 1, L'乜'},
{"mie", 1, L'咩'},
{"mie", 4, L'蔑'},
{"mie", 4, L'灭'},
{"mie", 4, L'蠛'},
{"mie", 4, L'篾'},
{"min", 2, L'民'},
{"min", 2, L'苠'},
{"min", 2, L'岷'},
{"min", 2, L'缗'},
{"min", 2, L'玟'},
{"min", 2, L'珉'},
{"min", 3, L'抿'},
{"min", 3, L'皿'},
{"min", 3, L'敏'},
{"min", 3, L'悯'},
{"min", 3, L'闽'},
{"min", 3, L'闵'},
{"min", 3, L'泯'},
{"min", 3, L'愍'},
{"min", 3, L'黾'},
{"min", 3, L'鳘'},
{"ming", 2, L'明'},
{"ming", 2, L'螟'},
{"ming", 2, L'鸣'},
{"ming", 2, L'铭'},
{"ming", 2, L'名'},
{"ming", 2, L'冥'},
{"ming", 2, L'茗'},
{"ming", 2, L'溟'},
{"ming", 2, L'暝'},
{"ming", 2, L'瞑'},
{"ming", 3, L'酩'},
{"ming", 4, L'命'},
{"miu", 4, L'谬'},
{"miu", 4, L'缪'},
{"mo", 1, L'摸'},
{"mo", 2, L'摹'},
{"mo", 2, L'蘑'},
{"mo", 2, L'模'},
{"mo", 2, L'膜'},
{"mo", 2, L'磨'},
{"mo", 2, L'摩'},
{"mo", 2, L'魔'},
{"mo", 2, L'无'},
{"mo", 2, L'谟'},
{"mo", 2, L'馍'},
{"mo", 2, L'嫫'},
{"mo", 2, L'嬷'},
{"mo", 2, L'麽'},
{"mo", 3, L'抹'},
{"mo", 4, L'嘿'},
{"mo", 4, L'脉'},
{"mo", 4, L'冒'},
{"mo", 4, L'没'},
{"mo", 4, L'磨'},
{"mo", 4, L'抹'},
{"mo", 4, L'末'},
{"mo", 4, L'莫'},
{"mo", 4, L'墨'},
{"mo", 4, L'默'},
{"mo", 4, L'沫'},
{"mo", 4, L'漠'},
{"mo", 4, L'寞'},
{"mo", 4, L'陌'},
{"mo", 4, L'万'},
{"mo", 4, L'茉'},
{"mo", 4, L'蓦'},
{"mo", 4, L'殁'},
{"mo", 4, L'镆'},
{"mo", 4, L'秣'},
{"mo", 4, L'瘼'},
{"mo", 4, L'耱'},
{"mo", 4, L'貊'},
{"mo", 4, L'貘'},
{"mou", 1, L'哞'},
{"mou", 2, L'谋'},
{"mou", 2, L'牟'},
{"mou", 2, L'侔'},
{"mou", 2, L'缪'},
{"mou", 2, L'眸'},
{"mou", 2, L'蛑'},
{"mou", 2, L'鍪'},
{"mou", 3, L'某'},
{"mu", 2, L'模'},
{"mu", 2, L'毪'},
{"mu", 3, L'姥'},
{"mu", 3, L'拇'},
{"mu", 3, L'牡'},
{"mu", 3, L'亩'},
{"mu", 3, L'姆'},
{"mu", 3, L'母'},
{"mu", 3, L'坶'},
{"mu", 4, L'牟'},
{"mu", 4, L'墓'},
{"mu", 4, L'暮'},
{"mu", 4, L'幕'},
{"mu", 4, L'募'},
{"mu", 4, L'慕'},
{"mu", 4, L'木'},
{"mu", 4, L'目'},
{"mu", 4, L'睦'},
{"mu", 4, L'牧'},
{"mu", 4, L'穆'},
{"mu", 4, L'仫'},
{"mu", 4, L'苜'},
{"mu", 4, L'沐'},
{"mu", 4, L'钼'},
{"n", 2, L'嗯'},
{"n", 3, L'嗯'},
{"n", 4, L'嗯'},
{"na", 1, L'那'},
{"na", 1, L'南'},
{"na", 2, L'拿'},
{"na", 2, L'镎'},
{"na", 3, L'哪'},
{"na", 4, L'呐'},
{"na", 4, L'钠'},
{"na", 4, L'那'},
{"na", 4, L'娜'},
{"na", 4, L'纳'},
{"na", 4, L'捺'},
{"na", 4, L'肭'},
{"na", 4, L'衲'},
{"na", 5, L'哪'},
{"nai", 3, L'氖'},
{"nai", 3, L'乃'},
{"nai", 3, L'奶'},
{"nai", 3, L'艿'},
{"nai", 4, L'耐'},
{"nai", 4, L'奈'},
{"nai", 4, L'鼐'},
{"nai", 4, L'佴'},
{"nai", 4, L'萘'},
{"nai", 4, L'柰'},
{"nan", 1, L'囝'},
{"nan", 1, L'囡'},
{"nan", 2, L'南'},
{"nan", 2, L'男'},
{"nan", 2, L'难'},
{"nan", 2, L'喃'},
{"nan", 2, L'楠'},
{"nan", 3, L'腩'},
{"nan", 3, L'蝻'},
{"nan", 3, L'赧'},
{"nan", 4, L'难'},
{"nang", 1, L'囊'},
{"nang", 1, L'囔'},
{"nang", 2, L'囊'},
{"nang", 2, L'馕'},
{"nang", 3, L'攮'},
{"nang", 3, L'馕'},
{"nang", 3, L'曩'},
{"nao", 1, L'孬'},
{"nao", 2, L'挠'},
{"nao", 2, L'呶'},
{"nao", 2, L'猱'},
{"nao", 2, L'硇'},
{"nao", 2, L'铙'},
{"nao", 2, L'蛲'},
{"nao", 3, L'脑'},
{"nao", 3, L'恼'},
{"nao", 3, L'垴'},
{"nao", 3, L'瑙'},
{"nao", 4, L'闹'},
{"nao", 4, L'淖'},
{"ne", 2, L'哪'},
{"ne", 4, L'讷'},
{"ne", 5, L'呢'},
{"nei", 3, L'哪'},
{"nei", 3, L'馁'},
{"nei", 4, L'那'},
{"nei", 4, L'内'},
{"nen", 4, L'嫩'},
{"nen", 4, L'恁'},
{"neng", 2, L'能'},
{"ng", 2, L'唔'},
{"ng", 2, L'嗯'},
{"ng", 3, L'嗯'},
{"ng", 4, L'嗯'},
{"ni", 1, L'妮'},
{"ni", 2, L'呢'},
{"ni", 2, L'霓'},
{"ni", 2, L'倪'},
{"ni", 2, L'泥'},
{"ni", 2, L'尼'},
{"ni", 2, L'坭'},
{"ni", 2, L'猊'},
{"ni", 2, L'怩'},
{"ni", 2, L'铌'},
{"ni", 2, L'鲵'},
{"ni", 3, L'拟'},
{"ni", 3, L'你'},
{"ni", 3, L'旎'},
{"ni", 4, L'泥'},
{"ni", 4, L'匿'},
{"ni", 4, L'腻'},
{"ni", 4, L'逆'},
{"ni", 4, L'溺'},
{"ni", 4, L'伲'},
{"ni", 4, L'昵'},
{"ni", 4, L'睨'},
{"nian", 1, L'蔫'},
{"nian", 1, L'拈'},
{"nian", 2, L'年'},
{"nian", 2, L'粘'},
{"nian", 2, L'黏'},
{"nian", 2, L'鲇'},
{"nian", 2, L'鲶'},
{"nian", 3, L'碾'},
{"nian", 3, L'撵'},
{"nian", 3, L'捻'},
{"nian", 3, L'辇'},
{"nian", 4, L'念'},
{"nian", 4, L'廿'},
{"nian", 4, L'埝'},
{"niang", 2, L'娘'},
{"niang", 4, L'酿'},
{"niao", 3, L'鸟'},
{"niao", 3, L'茑'},
{"niao", 3, L'嬲'},
{"niao", 3, L'袅'},
{"niao", 4, L'溺'},
{"niao", 4, L'尿'},
{"niao", 4, L'脲'},
{"nie", 1, L'捏'},
{"nie", 4, L'聂'},
{"nie", 4, L'孽'},
{"nie", 4, L'啮'},
{"nie", 4, L'镊'},
{"nie", 4, L'镍'},
{"nie", 4, L'涅'},
{"nie", 4, L'乜'},
{"nie", 4, L'陧'},
{"nie", 4, L'蘖'},
{"nie", 4, L'嗫'},
{"nie", 4, L'颞'},
{"nie", 4, L'臬'},
{"nie", 4, L'蹑'},
{"nin", 2, L'您'},
{"ning", 2, L'柠'},
{"ning", 2, L'狞'},
{"ning", 2, L'凝'},
{"ning", 2, L'宁'},
{"ning", 2, L'拧'},
{"ning", 2, L'咛'},
{"ning", 2, L'甯'},
{"ning", 2, L'聍'},
{"ning", 3, L'拧'},
{"ning", 4, L'宁'},
{"ning", 4, L'拧'},
{"ning", 4, L'泞'},
{"ning", 4, L'佞'},
{"niu", 1, L'妞'},
{"niu", 2, L'牛'},
{"niu", 3, L'扭'},
{"niu", 3, L'钮'},
{"niu", 3, L'纽'},
{"niu", 3, L'狃'},
{"niu", 3, L'忸'},
{"niu", 4, L'拗'},
{"nong", 2, L'脓'},
{"nong", 2, L'浓'},
{"nong", 2, L'农'},
{"nong", 2, L'侬'},
{"nong", 2, L'哝'},
{"nong", 4, L'弄'},
{"nou", 4, L'耨'},
{"nu", 2, L'奴'},
{"nu", 2, L'孥'},
{"nu", 2, L'驽'},
{"nu", 3, L'努'},
{"nu", 3, L'弩'},
{"nu", 3, L'胬'},
{"nu", 4, L'怒'},
{"nu:", 3, L'女'},
{"nu:", 3, L'钕'},
{"nu:", 4, L'恧'},
{"nu:", 4, L'衄'},
{"nuan", 3, L'暖'},
{"nue:", 4, L'虐'},
{"nue:", 4, L'疟'},
{"nuo", 2, L'娜'},
{"nuo", 2, L'挪'},
{"nuo", 2, L'傩'},
{"nuo", 4, L'懦'},
{"nuo", 4, L'糯'},
{"nuo", 4, L'诺'},
{"nuo", 4, L'搦'},
{"nuo", 4, L'喏'},
{"nuo", 4, L'锘'},
{"o", 1, L'喔'},
{"o", 1, L'噢'},
{"o", 2, L'哦'},
{"o", 4, L'哦'},
{"ou", 1, L'欧'},
{"ou", 1, L'鸥'},
{"ou", 1, L'殴'},
{"ou", 1, L'沤'},
{"ou", 1, L'区'},
{"ou", 1, L'讴'},
{"ou", 1, L'瓯'},
{"ou", 3, L'藕'},
{"ou", 3, L'呕'},
{"ou", 3, L'偶'},
{"ou", 3, L'耦'},
{"ou", 4, L'沤'},
{"ou", 4, L'怄'},
{"pa", 1, L'啪'},
{"pa", 1, L'趴'},
{"pa", 1, L'派'},
{"pa", 1, L'葩'},
{"pa", 2, L'扒'},
{"pa", 2, L'耙'},
{"pa", 2, L'爬'},
{"pa", 2, L'琶'},
{"pa", 2, L'杷'},
{"pa", 2, L'钯'},
{"pa", 2, L'筢'},
{"pa", 4, L'帕'},
{"pa", 4, L'怕'},
{"pai", 1, L'拍'},
{"pai", 2, L'排'},
{"pai", 2, L'牌'},
{"pai", 2, L'徘'},
{"pai", 2, L'俳'},
{"pai", 3, L'排'},
{"pai", 3, L'迫'},
{"pai", 4, L'湃'},
{"pai", 4, L'派'},
{"pai", 4, L'蒎'},
{"pai", 4, L'哌'},
{"pan", 1, L'番'},
{"pan", 1, L'攀'},
{"pan", 1, L'潘'},
{"pan", 2, L'盘'},
{"pan", 2, L'磐'},
{"pan", 2, L'胖'},
{"pan", 2, L'爿'},
{"pan", 2, L'蟠'},
{"pan", 2, L'蹒'},
{"pan", 4, L'盼'},
{"pan", 4, L'畔'},
{"pan", 4, L'判'},
{"pan", 4, L'叛'},
{"pan", 4, L'拚'},
{"pan", 4, L'泮'},
{"pan", 4, L'袢'},
{"pan", 4, L'襻'},
{"pang", 1, L'膀'},
{"pang", 1, L'乓'},
{"pang", 1, L'滂'},
{"pang", 2, L'膀'},
{"pang", 2, L'磅'},
{"pang", 2, L'庞'},
{"pang", 2, L'旁'},
{"pang", 2, L'彷'},
{"pang", 2, L'逄'},
{"pang", 2, L'螃'},
{"pang", 3, L'耪'},
{"pang", 4, L'胖'},
{"pao", 1, L'抛'},
{"pao", 1, L'泡'},
{"pao", 1, L'脬'},
{"pao", 2, L'咆'},
{"pao", 2, L'刨'},
{"pao", 2, L'炮'},
{"pao", 2, L'袍'},
{"pao", 2, L'跑'},
{"pao", 2, L'匏'},
{"pao", 2, L'狍'},
{"pao", 2, L'庖'},
{"pao", 3, L'跑'},
{"pao", 4, L'炮'},
{"pao", 4, L'泡'},
{"pao", 4, L'疱'},
{"pei", 1, L'呸'},
{"pei", 1, L'胚'},
{"pei", 1, L'醅'},
{"pei", 2, L'培'},
{"pei", 2, L'裴'},
{"pei", 2, L'赔'},
{"pei", 2, L'陪'},
{"pei", 2, L'锫'},
{"pei", 4, L'配'},
{"pei", 4, L'佩'},
{"pei", 4, L'沛'},
{"pei", 4, L'辔'},
{"pei", 4, L'帔'},
{"pei", 4, L'旆'},
{"pei", 4, L'霈'},
{"pen", 1, L'喷'},
{"pen", 2, L'盆'},
{"pen", 2, L'湓'},
{"pen", 4, L'喷'},
{"peng", 1, L'砰'},
{"peng", 1, L'抨'},
{"peng", 1, L'烹'},
{"peng", 1, L'澎'},
{"peng", 1, L'嘭'},
{"peng", 1, L'怦'},
{"peng", 2, L'澎'},
{"peng", 2, L'彭'},
{"peng", 2, L'蓬'},
{"peng", 2, L'棚'},
{"peng", 2, L'硼'},
{"peng", 2, L'篷'},
{"peng", 2, L'膨'},
{"peng", 2, L'朋'},
{"peng", 2, L'鹏'},
{"peng", 2, L'堋'},
{"peng", 2, L'蟛'},
{"peng", 3, L'捧'},
{"peng", 4, L'碰'},
{"pi", 1, L'坏'},
{"pi", 1, L'坯'},
{"pi", 1, L'砒'},
{"pi", 1, L'霹'},
{"pi", 1, L'批'},
{"pi", 1, L'披'},
{"pi", 1, L'劈'},
{"pi", 1, L'丕'},
{"pi", 1, L'邳'},
{"pi", 1, L'噼'},
{"pi", 1, L'纰'},
{"pi", 1, L'铍'},
{"pi", 2, L'琵'},
{"pi", 2, L'毗'},
{"pi", 2, L'啤'},
{"pi", 2, L'脾'},
{"pi", 2, L'疲'},
{"pi", 2, L'皮'},
{"pi", 2, L'陂'},
{"pi", 2, L'陴'},
{"pi", 2, L'郫'},
{"pi", 2, L'埤'},
{"pi", 2, L'鼙'},
{"pi", 2, L'芘'},
{"pi", 2, L'枇'},
{"pi", 2, L'罴'},
{"pi", 2, L'裨'},
{"pi", 2, L'蚍'},
{"pi", 2, L'蜱'},
{"pi", 2, L'貔'},
{"pi", 3, L'否'},
{"pi", 3, L'劈'},
{"pi", 3, L'匹'},
{"pi", 3, L'痞'},
{"pi", 3, L'仳'},
{"pi", 3, L'圮'},
{"pi", 3, L'擗'},
{"pi", 3, L'吡'},
{"pi", 3, L'庀'},
{"pi", 3, L'癖'},
{"pi", 3, L'疋'},
{"pi", 4, L'辟'},
{"pi", 4, L'僻'},
{"pi", 4, L'屁'},
{"pi", 4, L'譬'},
{"pi", 4, L'埤'},
{"pi", 4, L'淠'},
{"pi", 4, L'媲'},
{"pi", 4, L'甓'},
{"pi", 4, L'睥'},
{"pian", 1, L'扁'},
{"pian", 1, L'篇'},
{"pian", 1, L'偏'},
{"pian", 1, L'片'},
{"pian", 1, L'犏'},
{"pian", 1, L'翩'},
{"pian", 2, L'便'},
{"pian", 2, L'骈'},
{"pian", 2, L'缏'},
{"pian", 2, L'胼'},
{"pian", 2, L'蹁'},
{"pian", 3, L'谝'},
{"pian", 4, L'片'},
{"pian", 4, L'骗'},
{"piao", 1, L'飘'},
{"piao", 1, L'漂'},
{"piao", 1, L'剽'},
{"piao", 1, L'缥'},
{"piao", 1, L'螵'},
{"piao", 2, L'瓢'},
{"piao", 2, L'朴'},
{"piao", 2, L'嫖'},
{"piao", 3, L'漂'},
{"piao", 3, L'莩'},
{"piao", 3, L'缥'},
{"piao", 3, L'殍'},
{"piao", 3, L'瞟'},
{"piao", 4, L'漂'},
{"piao", 4, L'票'},
{"piao", 4, L'嘌'},
{"piao", 4, L'骠'},
{"pie", 1, L'撇'},
{"pie", 1, L'瞥'},
{"pie", 1, L'氕'},
{"pie", 3, L'撇'},
{"pie", 3, L'苤'},
{"pin", 1, L'拼'},
{"pin", 1, L'拚'},
{"pin", 1, L'姘'},
{"pin", 2, L'频'},
{"pin", 2, L'贫'},
{"pin", 2, L'嫔'},
{"pin", 2, L'颦'},
{"pin", 3, L'品'},
{"pin", 3, L'榀'},
{"pin", 4, L'聘'},
{"pin", 4, L'牝'},
{"ping", 1, L'乒'},
{"ping", 1, L'俜'},
{"ping", 1, L'娉'},
{"ping", 2, L'坪'},
{"ping", 2, L'苹'},
{"ping", 2, L'萍'},
{"ping", 2, L'平'},
{"ping", 2, L'凭'},
{"ping", 2, L'瓶'},
{"ping", 2, L'评'},
{"ping", 2, L'屏'},
{"ping", 2, L'枰'},
{"ping", 2, L'鲆'},
{"po", 1, L'泊'},
{"po", 1, L'坡'},
{"po", 1, L'泼'},
{"po", 1, L'颇'},
{"po", 1, L'朴'},
{"po", 1, L'陂'},
{"po", 1, L'泺'},
{"po", 1, L'攴'},
{"po", 1, L'钋'},
{"po", 2, L'繁'},
{"po", 2, L'婆'},
{"po", 2, L'鄱'},
{"po", 2, L'皤'},
{"po", 3, L'叵'},
{"po", 3, L'钷'},
{"po", 3, L'笸'},
{"po", 4, L'破'},
{"po", 4, L'魄'},
{"po", 4, L'迫'},
{"po", 4, L'粕'},
{"po", 4, L'朴'},
{"po", 4, L'珀'},
{"pou", 1, L'剖'},
{"pou", 2, L'裒'},
{"pou", 2, L'掊'},
{"pou", 3, L'掊'},
{"pu", 1, L'扑'},
{"pu", 1, L'铺'},
{"pu", 1, L'仆'},
{"pu", 1, L'噗'},
{"pu", 2, L'脯'},
{"pu", 2, L'仆'},
{"pu", 2, L'莆'},
{"pu", 2, L'葡'},
{"pu", 2, L'菩'},
{"pu", 2, L'蒲'},
{"pu", 2, L'匍'},
{"pu", 2, L'濮'},
{"pu", 2, L'璞'},
{"pu", 2, L'镤'},
{"pu", 3, L'埔'},
{"pu", 3, L'朴'},
{"pu", 3, L'圃'},
{"pu", 3, L'普'},
{"pu", 3, L'浦'},
{"pu", 3, L'谱'},
{"pu", 3, L'溥'},
{"pu", 3, L'氆'},
{"pu", 3, L'镨'},
{"pu", 3, L'蹼'},
{"pu", 4, L'堡'},
{"pu", 4, L'暴'},
{"pu", 4, L'铺'},
{"pu", 4, L'曝'},
{"pu", 4, L'瀑'},
{"qi", 1, L'缉'},
{"qi", 1, L'期'},
{"qi", 1, L'欺'},
{"qi", 1, L'栖'},
{"qi", 1, L'戚'},
{"qi", 1, L'妻'},
{"qi", 1, L'七'},
{"qi", 1, L'凄'},
{"qi", 1, L'漆'},
{"qi", 1, L'柒'},
{"qi", 1, L'沏'},
{"qi", 1, L'萋'},
{"qi", 1, L'嘁'},
{"qi", 1, L'桤'},
{"qi", 1, L'欹'},
{"qi", 1, L'蹊'},
{"qi", 2, L'其'},
{"qi", 2, L'棋'},
{"qi", 2, L'奇'},
{"qi", 2, L'歧'},
{"qi", 2, L'畦'},
{"qi", 2, L'崎'},
{"qi", 2, L'脐'},
{"qi", 2, L'齐'},
{"qi", 2, L'旗'},
{"qi", 2, L'祈'},
{"qi", 2, L'祁'},
{"qi", 2, L'骑'},
{"qi", 2, L'亓'},
{"qi", 2, L'俟'},
{"qi", 2, L'圻'},
{"qi", 2, L'芪'},
{"qi", 2, L'萁'},
{"qi", 2, L'蕲'},
{"qi", 2, L'岐'},
{"qi", 2, L'淇'},
{"qi", 2, L'骐'},
{"qi", 2, L'琪'},
{"qi", 2, L'琦'},
{"qi", 2, L'耆'},
{"qi", 2, L'祺'},
{"qi", 2, L'颀'},
{"qi", 2, L'蛴'},
{"qi", 2, L'蜞'},
{"qi", 2, L'綦'},
{"qi", 2, L'鳍'},
{"qi", 2, L'麒'},
{"qi", 3, L'稽'},
{"qi", 3, L'起'},
{"qi", 3, L'岂'},
{"qi", 3, L'乞'},
{"qi", 3, L'企'},
{"qi", 3, L'启'},
{"qi", 3, L'芑'},
{"qi", 3, L'屺'},
{"qi", 3, L'绮'},
{"qi", 3, L'杞'},
{"qi", 3, L'綮'},
{"qi", 4, L'妻'},
{"qi", 4, L'契'},
{"qi", 4, L'砌'},
{"qi", 4, L'器'},
{"qi", 4, L'气'},
{"qi", 4, L'迄'},
{"qi", 4, L'弃'},
{"qi", 4, L'汽'},
{"qi", 4, L'泣'},
{"qi", 4, L'讫'},
{"qi", 4, L'亟'},
{"qi", 4, L'葺'},
{"qi", 4, L'汔'},
{"qi", 4, L'槭'},
{"qi", 4, L'憩'},
{"qi", 4, L'碛'},
{"qi", 5, L'荠'},
{"qia", 1, L'掐'},
{"qia", 1, L'葜'},
{"qia", 1, L'袷'},
{"qia", 3, L'卡'},
{"qia", 4, L'恰'},
{"qia", 4, L'洽'},
{"qia", 4, L'髂'},
{"qian", 1, L'牵'},
{"qian", 1, L'扦'},
{"qian", 1, L'钎'},
{"qian", 1, L'铅'},
{"qian", 1, L'千'},
{"qian", 1, L'迁'},
{"qian", 1, L'签'},
{"qian", 1, L'仟'},
{"qian", 1, L'谦'},
{"qian", 1, L'佥'},
{"qian", 1, L'阡'},
{"qian", 1, L'芊'},
{"qian", 1, L'岍'},
{"qian", 1, L'悭'},
{"qian", 1, L'骞'},
{"qian", 1, L'搴'},
{"qian", 1, L'褰'},
{"qian", 1, L'愆'},
{"qian", 2, L'乾'},
{"qian", 2, L'黔'},
{"qian", 2, L'钱'},
{"qian", 2, L'钳'},
{"qian", 2, L'前'},
{"qian", 2, L'潜'},
{"qian", 2, L'荨'},
{"qian", 2, L'掮'},
{"qian", 2, L'犍'},
{"qian", 2, L'钤'},
{"qian", 2, L'虔'},
{"qian", 2, L'箝'},
{"qian", 3, L'遣'},
{"qian", 3, L'浅'},
{"qian", 3, L'谴'},
{"qian", 3, L'缱'},
{"qian", 3, L'肷'},
{"qian", 4, L'堑'},
{"qian", 4, L'嵌'},
{"qian", 4, L'欠'},
{"qian", 4, L'歉'},
{"qian", 4, L'纤'},
{"qian", 4, L'倩'},
{"qian", 4, L'芡'},
{"qian", 4, L'茜'},
{"qian", 4, L'慊'},
{"qian", 4, L'椠'},
{"qiang", 1, L'枪'},
{"qiang", 1, L'呛'},
{"qiang", 1, L'腔'},
{"qiang", 1, L'羌'},
{"qiang", 1, L'抢'},
{"qiang", 1, L'戕'},
{"qiang", 1, L'戗'},
{"qiang", 1, L'锖'},
{"qiang", 1, L'锵'},
{"qiang", 1, L'镪'},
{"qiang", 1, L'蜣'},
{"qiang", 1, L'跄'},
{"qiang", 2, L'墙'},
{"qiang", 2, L'蔷'},
{"qiang", 2, L'强'},
{"qiang", 2, L'嫱'},
{"qiang", 2, L'樯'},
{"qiang", 3, L'抢'},
{"qiang", 3, L'镪'},
{"qiang", 3, L'襁'},
{"qiang", 3, L'羟'},
{"qiang", 4, L'呛'},
{"qiang", 4, L'戗'},
{"qiang", 4, L'炝'},
{"qiang", 4, L'跄'},
{"qiao", 1, L'橇'},
{"qiao", 1, L'锹'},
{"qiao", 1, L'敲'},
{"qiao", 1, L'悄'},
{"qiao", 1, L'雀'},
{"qiao", 1, L'劁'},
{"qiao", 1, L'缲'},
{"qiao", 1, L'硗'},
{"qiao", 1, L'跷'},
{"qiao", 2, L'桥'},
{"qiao", 2, L'瞧'},
{"qiao", 2, L'乔'},
{"qiao", 2, L'侨'},
{"qiao", 2, L'翘'},
{"qiao", 2, L'谯'},
{"qiao", 2, L'荞'},
{"qiao", 2, L'峤'},
{"qiao", 2, L'憔'},
{"qiao", 2, L'樵'},
{"qiao", 2, L'鞒'},
{"qiao", 3, L'悄'},
{"qiao", 3, L'巧'},
{"qiao", 3, L'雀'},
{"qiao", 3, L'愀'},
{"qiao", 4, L'壳'},
{"qiao", 4, L'鞘'},
{"qiao", 4, L'撬'},
{"qiao", 4, L'翘'},
{"qiao", 4, L'峭'},
{"qiao", 4, L'俏'},
{"qiao", 4, L'窍'},
{"qiao", 4, L'诮'},
{"qie", 1, L'切'},
{"qie", 2, L'茄'},
{"qie", 3, L'且'},
{"qie", 4, L'切'},
{"qie", 4, L'怯'},
{"qie", 4, L'窃'},
{"qie", 4, L'郄'},
{"qie", 4, L'惬'},
{"qie", 4, L'慊'},
{"qie", 4, L'妾'},
{"qie", 4, L'挈'},
{"qie", 4, L'锲'},
{"qie", 4, L'箧'},
{"qie", 4, L'趄'},
{"qin", 1, L'钦'},
{"qin", 1, L'侵'},
{"qin", 1, L'亲'},
{"qin", 1, L'衾'},
{"qin", 2, L'秦'},
{"qin", 2, L'琴'},
{"qin", 2, L'勤'},
{"qin", 2, L'芹'},
{"qin", 2, L'擒'},
{"qin", 2, L'禽'},
{"qin", 2, L'芩'},
{"qin", 2, L'嗪'},
{"qin", 2, L'噙'},
{"qin", 2, L'廑'},
{"qin", 2, L'溱'},
{"qin", 2, L'檎'},
{"qin", 2, L'矜'},
{"qin", 2, L'覃'},
{"qin", 2, L'螓'},
{"qin", 3, L'寝'},
{"qin", 3, L'锓'},
{"qin", 4, L'沁'},
{"qin", 4, L'揿'},
{"qin", 4, L'吣'},
{"qing", 1, L'青'},
{"qing", 1, L'轻'},
{"qing", 1, L'氢'},
{"qing", 1, L'倾'},
{"qing", 1, L'卿'},
{"qing", 1, L'清'},
{"qing", 1, L'圊'},
{"qing", 1, L'蜻'},
{"qing", 1, L'鲭'},
{"qing", 2, L'擎'},
{"qing", 2, L'晴'},
{"qing", 2, L'氰'},
{"qing", 2, L'情'},
{"qing", 2, L'檠'},
{"qing", 2, L'黥'},
{"qing", 3, L'顷'},
{"qing", 3, L'请'},
{"qing", 3, L'苘'},
{"qing", 3, L'綮'},
{"qing", 3, L'謦'},
{"qing", 4, L'亲'},
{"qing", 4, L'庆'},
{"qing", 4, L'磬'},
{"qing", 4, L'罄'},
{"qing", 4, L'箐'},
{"qiong", 2, L'琼'},
{"qiong", 2, L'穷'},
{"qiong", 2, L'邛'},
{"qiong", 2, L'茕'},
{"qiong", 2, L'穹'},
{"qiong", 2, L'蛩'},
{"qiong", 2, L'筇'},
{"qiong", 2, L'跫'},
{"qiong", 2, L'銎'},
{"qiu", 1, L'龟'},
{"qiu", 1, L'秋'},
{"qiu", 1, L'丘'},
{"qiu", 1, L'邱'},
{"qiu", 1, L'湫'},
{"qiu", 1, L'楸'},
{"qiu", 1, L'蚯'},
{"qiu", 1, L'鳅'},
{"qiu", 2, L'仇'},
{"qiu", 2, L'球'},
{"qiu", 2, L'求'},
{"qiu", 2, L'囚'},
{"qiu", 2, L'酋'},
{"qiu", 2, L'泅'},
{"qiu", 2, L'俅'},
{"qiu", 2, L'巯'},
{"qiu", 2, L'犰'},
{"qiu", 2, L'逑'},
{"qiu", 2, L'遒'},
{"qiu", 2, L'赇'},
{"qiu", 2, L'虬'},
{"qiu", 2, L'蝤'},
{"qiu", 2, L'裘'},
{"qiu", 2, L'鼽'},
{"qiu", 3, L'糗'},
{"qu", 1, L'趋'},
{"qu", 1, L'区'},
{"qu", 1, L'蛆'},
{"qu", 1, L'曲'},
{"qu", 1, L'躯'},
{"qu", 1, L'屈'},
{"qu", 1, L'驱'},
{"qu", 1, L'诎'},
{"qu", 1, L'岖'},
{"qu", 1, L'觑'},
{"qu", 1, L'祛'},
{"qu", 1, L'蛐'},
{"qu", 1, L'麴'},
{"qu", 1, L'黢'},
{"qu", 2, L'渠'},
{"qu", 2, L'劬'},
{"qu", 2, L'蕖'},
{"qu", 2, L'蘧'},
{"qu", 2, L'衢'},
{"qu", 2, L'璩'},
{"qu", 2, L'氍'},
{"qu", 2, L'朐'},
{"qu", 2, L'磲'},
{"qu", 2, L'鸲'},
{"qu", 2, L'癯'},
{"qu", 2, L'蠼'},
{"qu", 2, L'瞿'},
{"qu", 3, L'曲'},
{"qu", 3, L'取'},
{"qu", 3, L'娶'},
{"qu", 3, L'龋'},
{"qu", 3, L'苣'},
{"qu", 4, L'趣'},
{"qu", 4, L'去'},
{"qu", 4, L'阒'},
{"qu", 4, L'觑'},
{"qu", 5, L'戌'},
{"quan", 1, L'圈'},
{"quan", 1, L'悛'},
{"quan", 2, L'颧'},
{"quan", 2, L'权'},
{"quan", 2, L'醛'},
{"quan", 2, L'泉'},
{"quan", 2, L'全'},
{"quan", 2, L'痊'},
{"quan", 2, L'拳'},
{"quan", 2, L'诠'},
{"quan", 2, L'荃'},
{"quan", 2, L'辁'},
{"quan", 2, L'铨'},
{"quan", 2, L'蜷'},
{"quan", 2, L'筌'},
{"quan", 2, L'鬈'},
{"quan", 3, L'犬'},
{"quan", 3, L'绻'},
{"quan", 3, L'畎'},
{"quan", 4, L'券'},
{"quan", 4, L'劝'},
{"que", 1, L'缺'},
{"que", 1, L'炔'},
{"que", 1, L'阙'},
{"que", 2, L'瘸'},
{"que", 4, L'却'},
{"que", 4, L'鹊'},
{"que", 4, L'榷'},
{"que", 4, L'确'},
{"que", 4, L'雀'},
{"que", 4, L'阕'},
{"que", 4, L'阙'},
{"que", 4, L'悫'},
{"qun", 1, L'逡'},
{"qun", 2, L'裙'},
{"qun", 2, L'群'},
{"qun", 2, L'麇'},
{"ran", 2, L'然'},
{"ran", 2, L'燃'},
{"ran", 2, L'蚺'},
{"ran", 2, L'髯'},
{"ran", 3, L'冉'},
{"ran", 3, L'染'},
{"ran", 3, L'苒'},
{"rang", 1, L'嚷'},
{"rang", 2, L'瓤'},
{"rang", 2, L'禳'},
{"rang", 2, L'穰'},
{"rang", 3, L'壤'},
{"rang", 3, L'攘'},
{"rang", 3, L'嚷'},
{"rang", 4, L'让'},
{"rao", 2, L'饶'},
{"rao", 2, L'荛'},
{"rao", 2, L'娆'},
{"rao", 2, L'桡'},
{"rao", 3, L'扰'},
{"rao", 3, L'娆'},
{"rao", 5, L'绕'},
{"re", 3, L'惹'},
{"re", 3, L'若'},
{"re", 3, L'喏'},
{"re", 4, L'热'},
{"ren", 2, L'壬'},
{"ren", 2, L'仁'},
{"ren", 2, L'人'},
{"ren", 2, L'任'},
{"ren", 3, L'忍'},
{"ren", 3, L'荏'},
{"ren", 3, L'稔'},
{"ren", 4, L'韧'},
{"ren", 4, L'任'},
{"ren", 4, L'认'},
{"ren", 4, L'刃'},
{"ren", 4, L'妊'},
{"ren", 4, L'纫'},
{"ren", 4, L'仞'},
{"ren", 4, L'葚'},
{"ren", 4, L'饪'},
{"ren", 4, L'轫'},
{"ren", 4, L'衽'},
{"reng", 1, L'扔'},
{"reng", 2, L'仍'},
{"ri", 4, L'日'},
{"rong", 2, L'戎'},
{"rong", 2, L'茸'},
{"rong", 2, L'蓉'},
{"rong", 2, L'荣'},
{"rong", 2, L'融'},
{"rong", 2, L'熔'},
{"rong", 2, L'溶'},
{"rong", 2, L'容'},
{"rong", 2, L'绒'},
{"rong", 2, L'嵘'},
{"rong", 2, L'狨'},
{"rong", 2, L'榕'},
{"rong", 2, L'肜'},
{"rong", 2, L'蝾'},
{"rong", 3, L'冗'},
{"rou", 2, L'揉'},
{"rou", 2, L'柔'},
{"rou", 2, L'糅'},
{"rou", 2, L'蹂'},
{"rou", 2, L'鞣'},
{"rou", 4, L'肉'},
{"ru", 2, L'茹'},
{"ru", 2, L'蠕'},
{"ru", 2, L'儒'},
{"ru", 2, L'孺'},
{"ru", 2, L'如'},
{"ru", 2, L'薷'},
{"ru", 2, L'嚅'},
{"ru", 2, L'濡'},
{"ru", 2, L'铷'},
{"ru", 2, L'襦'},
{"ru", 2, L'颥'},
{"ru", 3, L'辱'},
{"ru", 3, L'乳'},
{"ru", 3, L'汝'},
{"ru", 4, L'入'},
{"ru", 4, L'褥'},
{"ru", 4, L'蓐'},
{"ru", 4, L'洳'},
{"ru", 4, L'溽'},
{"ru", 4, L'缛'},
{"ruan", 3, L'软'},
{"ruan", 3, L'阮'},
{"ruan", 3, L'朊'},
{"rui", 2, L'蕤'},
{"rui", 3, L'蕊'},
{"rui", 4, L'瑞'},
{"rui", 4, L'锐'},
{"rui", 4, L'芮'},
{"rui", 4, L'枘'},
{"rui", 4, L'睿'},
{"rui", 4, L'蚋'},
{"run", 4, L'闰'},
{"run", 4, L'润'},
{"ruo", 4, L'若'},
{"ruo", 4, L'弱'},
{"ruo", 4, L'偌'},
{"ruo", 4, L'箬'},
{"sa", 1, L'撒'},
{"sa", 1, L'思'},
{"sa", 1, L'仨'},
{"sa", 1, L'挲'},
{"sa", 3, L'撒'},
{"sa", 3, L'洒'},
{"sa", 4, L'萨'},
{"sa", 4, L'卅'},
{"sa", 4, L'脎'},
{"sa", 4, L'飒'},
{"sai", 1, L'腮'},
{"sai", 1, L'鳃'},
{"sai", 1, L'塞'},
{"sai", 1, L'思'},
{"sai", 1, L'噻'},
{"sai", 4, L'塞'},
{"sai", 4, L'赛'},
{"san", 1, L'三'},
{"san", 1, L'叁'},
{"san", 1, L'毵'},
{"san", 3, L'伞'},
{"san", 3, L'散'},
{"san", 3, L'馓'},
{"san", 3, L'糁'},
{"san", 4, L'散'},
{"sang", 1, L'桑'},
{"sang", 1, L'丧'},
{"sang", 3, L'嗓'},
{"sang", 3, L'搡'},
{"sang", 3, L'磉'},
{"sang", 3, L'颡'},
{"sang", 4, L'丧'},
{"sao", 1, L'搔'},
{"sao", 1, L'骚'},
{"sao", 1, L'缫'},
{"sao", 1, L'缲'},
{"sao", 1, L'臊'},
{"sao", 1, L'鳋'},
{"sao", 3, L'扫'},
{"sao", 3, L'嫂'},
{"sao", 4, L'扫'},
{"sao", 4, L'梢'},
{"sao", 4, L'埽'},
{"sao", 4, L'臊'},
{"sao", 4, L'瘙'},
{"se", 4, L'塞'},
{"se", 4, L'瑟'},
{"se", 4, L'色'},
{"se", 4, L'涩'},
{"se", 4, L'啬'},
{"se", 4, L'铯'},
{"se", 4, L'穑'},
{"sen", 1, L'森'},
{"seng", 1, L'僧'},
{"sha", 1, L'莎'},
{"sha", 1, L'砂'},
{"sha", 1, L'杀'},
{"sha", 1, L'刹'},
{"sha", 1, L'沙'},
{"sha", 1, L'纱'},
{"sha", 1, L'煞'},
{"sha", 1, L'杉'},
{"sha", 1, L'挲'},
{"sha", 1, L'铩'},
{"sha", 1, L'痧'},
{"sha", 1, L'裟'},
{"sha", 1, L'鲨'},
{"sha", 2, L'啥'},
{"sha", 3, L'傻'},
{"sha", 4, L'沙'},
{"sha", 4, L'煞'},
{"sha", 4, L'厦'},
{"sha", 4, L'唼'},
{"sha", 4, L'嗄'},
{"sha", 4, L'歃'},
{"sha", 4, L'霎'},
{"shai", 1, L'筛'},
{"shai", 1, L'酾'},
{"shai", 3, L'色'},
{"shai", 4, L'晒'},
{"shan", 1, L'珊'},
{"shan", 1, L'苫'},
{"shan", 1, L'杉'},
{"shan", 1, L'山'},
{"shan", 1, L'删'},
{"shan", 1, L'煽'},
{"shan", 1, L'衫'},
{"shan", 1, L'扇'},
{"shan", 1, L'栅'},
{"shan", 1, L'埏'},
{"shan", 1, L'芟'},
{"shan", 1, L'潸'},
{"shan", 1, L'姗'},
{"shan", 1, L'膻'},
{"shan", 1, L'钐'},
{"shan", 1, L'舢'},
{"shan", 1, L'跚'},
{"shan", 3, L'掺'},
{"shan", 3, L'闪'},
{"shan", 3, L'陕'},
{"shan", 4, L'单'},
{"shan", 4, L'掸'},
{"shan", 4, L'苫'},
{"shan", 4, L'擅'},
{"shan", 4, L'赡'},
{"shan", 4, L'膳'},
{"shan", 4, L'善'},
{"shan", 4, L'汕'},
{"shan", 4, L'扇'},
{"shan", 4, L'缮'},
{"shan", 4, L'剡'},
{"shan", 4, L'讪'},
{"shan", 4, L'鄯'},
{"shan", 4, L'嬗'},
{"shan", 4, L'骟'},
{"shan", 4, L'禅'},
{"shan", 4, L'钐'},
{"shan", 4, L'疝'},
{"shan", 4, L'蟮'},
{"shan", 4, L'鳝'},
{"shang", 1, L'墒'},
{"shang", 1, L'伤'},
{"shang", 1, L'商'},
{"shang", 1, L'汤'},
{"shang", 1, L'殇'},
{"shang", 1, L'熵'},
{"shang", 1, L'觞'},
{"shang", 3, L'赏'},
{"shang", 3, L'晌'},
{"shang", 3, L'上'},
{"shang", 3, L'垧'},
{"shang", 4, L'上'},
{"shang", 4, L'尚'},
{"shang", 4, L'绱'},
{"shang", 5, L'裳'},
{"shao", 1, L'鞘'},
{"shao", 1, L'梢'},
{"shao", 1, L'捎'},
{"shao", 1, L'稍'},
{"shao", 1, L'烧'},
{"shao", 1, L'蛸'},
{"shao", 1, L'筲'},
{"shao", 1, L'艄'},
{"shao", 2, L'芍'},
{"shao", 2, L'勺'},
{"shao", 2, L'韶'},
{"shao", 2, L'苕'},
{"shao", 2, L'杓'},
{"shao", 3, L'少'},
{"shao", 4, L'稍'},
{"shao", 4, L'少'},
{"shao", 4, L'哨'},
{"shao", 4, L'邵'},
{"shao", 4, L'绍'},
{"shao", 4, L'召'},
{"shao", 4, L'劭'},
{"shao", 4, L'潲'},
{"she", 1, L'奢'},
{"she", 1, L'赊'},
{"she", 1, L'猞'},
{"she", 1, L'畲'},
{"she", 2, L'蛇'},
{"she", 2, L'舌'},
{"she", 2, L'折'},
{"she", 2, L'佘'},
{"she", 2, L'揲'},
{"she", 3, L'舍'},
{"she", 4, L'舍'},
{"she", 4, L'赦'},
{"she", 4, L'摄'},
{"she", 4, L'射'},
{"she", 4, L'慑'},
{"she", 4, L'涉'},
{"she", 4, L'社'},
{"she", 4, L'设'},
{"she", 4, L'厍'},
{"she", 4, L'滠'},
{"she", 4, L'歙'},
{"she", 4, L'麝'},
{"shei", 2, L'谁'},
{"shen", 1, L'参'},
{"shen", 1, L'砷'},
{"shen", 1, L'申'},
{"shen", 1, L'呻'},
{"shen", 1, L'伸'},
{"shen", 1, L'身'},
{"shen", 1, L'深'},
{"shen", 1, L'娠'},
{"shen", 1, L'绅'},
{"shen", 1, L'诜'},
{"shen", 1, L'莘'},
{"shen", 1, L'糁'},
{"shen", 2, L'神'},
{"shen", 2, L'甚'},
{"shen", 2, L'什'},
{"shen", 3, L'沈'},
{"shen", 3, L'审'},
{"shen", 3, L'婶'},
{"shen", 3, L'谂'},
{"shen", 3, L'哂'},
{"shen", 3, L'渖'},
{"shen", 3, L'矧'},
{"shen", 4, L'甚'},
{"shen", 4, L'肾'},
{"shen", 4, L'慎'},
{"shen", 4, L'渗'},
{"shen", 4, L'葚'},
{"shen", 4, L'椹'},
{"shen", 4, L'胂'},
{"shen", 4, L'蜃'},
{"sheng", 1, L'声'},
{"sheng", 1, L'生'},
{"sheng", 1, L'甥'},
{"sheng", 1, L'牲'},
{"sheng", 1, L'升'},
{"sheng", 1, L'胜'},
{"sheng", 1, L'笙'},
{"sheng", 2, L'绳'},
{"sheng", 2, L'渑'},
{"sheng", 3, L'省'},
{"sheng", 3, L'眚'},
{"sheng", 4, L'乘'},
{"sheng", 4, L'盛'},
{"sheng", 4, L'剩'},
{"sheng", 4, L'胜'},
{"sheng", 4, L'圣'},
{"sheng", 4, L'嵊'},
{"sheng", 4, L'晟'},
{"shi", 1, L'师'},
{"shi", 1, L'失'},
{"shi", 1, L'狮'},
{"shi", 1, L'施'},
{"shi", 1, L'湿'},
{"shi", 1, L'诗'},
{"shi", 1, L'尸'},
{"shi", 1, L'虱'},
{"shi", 1, L'嘘'},
{"shi", 1, L'蓍'},
{"shi", 1, L'酾'},
{"shi", 1, L'鲺'},
{"shi", 2, L'十'},
{"shi", 2, L'石'},
{"shi", 2, L'拾'},
{"shi", 2, L'时'},
{"shi", 2, L'什'},
{"shi", 2, L'食'},
{"shi", 2, L'蚀'},
{"shi", 2, L'实'},
{"shi", 2, L'识'},
{"shi", 2, L'埘'},
{"shi", 2, L'莳'},
{"shi", 2, L'炻'},
{"shi", 2, L'鲥'},
{"shi", 3, L'史'},
{"shi", 3, L'矢'},
{"shi", 3, L'使'},
{"shi", 3, L'屎'},
{"shi", 3, L'驶'},
{"shi", 3, L'始'},
{"shi", 3, L'豕'},
{"shi", 4, L'式'},
{"shi", 4, L'示'},
{"shi", 4, L'士'},
{"shi", 4, L'世'},
{"shi", 4, L'柿'},
{"shi", 4, L'事'},
{"shi", 4, L'拭'},
{"shi", 4, L'誓'},
{"shi", 4, L'逝'},
{"shi", 4, L'势'},
{"shi", 4, L'是'},
{"shi", 4, L'嗜'},
{"shi", 4, L'噬'},
{"shi", 4, L'适'},
{"shi", 4, L'仕'},
{"shi", 4, L'侍'},
{"shi", 4, L'释'},
{"shi", 4, L'饰'},
{"shi", 4, L'氏'},
{"shi", 4, L'市'},
{"shi", 4, L'恃'},
{"shi", 4, L'室'},
{"shi", 4, L'视'},
{"shi", 4, L'试'},
{"shi", 4, L'似'},
{"shi", 4, L'峙'},
{"shi", 4, L'谥'},
{"shi", 4, L'莳'},
{"shi", 4, L'弑'},
{"shi", 4, L'轼'},
{"shi", 4, L'贳'},
{"shi", 4, L'铈'},
{"shi", 4, L'螫'},
{"shi", 4, L'舐'},
{"shi", 4, L'筮'},
{"shi", 5, L'匙'},
{"shi", 5, L'殖'},
{"shou", 1, L'收'},
{"shou", 2, L'熟'},
{"shou", 3, L'手'},
{"shou", 3, L'首'},
{"shou", 3, L'守'},
{"shou", 3, L'艏'},
{"shou", 4, L'寿'},
{"shou", 4, L'授'},
{"shou", 4, L'售'},
{"shou", 4, L'受'},
{"shou", 4, L'瘦'},
{"shou", 4, L'兽'},
{"shou", 4, L'狩'},
{"shou", 4, L'绶'},
{"shu", 1, L'蔬'},
{"shu", 1, L'枢'},
{"shu", 1, L'梳'},
{"shu", 1, L'殊'},
{"shu", 1, L'抒'},
{"shu", 1, L'输'},
{"shu", 1, L'叔'},
{"shu", 1, L'舒'},
{"shu", 1, L'淑'},
{"shu", 1, L'疏'},
{"shu", 1, L'书'},
{"shu", 1, L'倏'},
{"shu", 1, L'菽'},
{"shu", 1, L'摅'},
{"shu", 1, L'姝'},
{"shu", 1, L'纾'},
{"shu", 1, L'毹'},
{"shu", 1, L'殳'},
{"shu", 2, L'赎'},
{"shu", 2, L'孰'},
{"shu", 2, L'熟'},
{"shu", 2, L'塾'},
{"shu", 2, L'秫'},
{"shu", 3, L'薯'},
{"shu", 3, L'暑'},
{"shu", 3, L'曙'},
{"shu", 3, L'署'},
{"shu", 3, L'蜀'},
{"shu", 3, L'黍'},
{"shu", 3, L'鼠'},
{"shu", 3, L'属'},
{"shu", 3, L'数'},
{"shu", 4, L'术'},
{"shu", 4, L'述'},
{"shu", 4, L'树'},
{"shu", 4, L'束'},
{"shu", 4, L'戍'},
{"shu", 4, L'竖'},
{"shu", 4, L'墅'},
{"shu", 4, L'庶'},
{"shu", 4, L'数'},
{"shu", 4, L'漱'},
{"shu", 4, L'恕'},
{"shu", 4, L'俞'},
{"shu", 4, L'沭'},
{"shu", 4, L'澍'},
{"shu", 4, L'腧'},
{"shua", 1, L'刷'},
{"shua", 1, L'唰'},
{"shua", 3, L'耍'},
{"shua", 4, L'刷'},
{"shuai", 1, L'摔'},
{"shuai", 3, L'甩'},
{"shuai", 4, L'率'},
{"shuai", 4, L'帅'},
{"shuai", 4, L'蟀'},
{"shuan", 1, L'栓'},
{"shuan", 1, L'拴'},
{"shuan", 1, L'闩'},
{"shuan", 4, L'涮'},
{"shuang", 1, L'霜'},
{"shuang", 1, L'双'},
{"shuang", 1, L'泷'},
{"shuang", 1, L'孀'},
{"shuang", 3, L'爽'},
{"shui", 2, L'谁'},
{"shui", 3, L'水'},
{"shui", 4, L'睡'},
{"shui", 4, L'税'},
{"shui", 4, L'说'},
{"shun", 3, L'吮'},
{"shun", 4, L'瞬'},
{"shun", 4, L'顺'},
{"shun", 4, L'舜'},
{"shuo", 1, L'说'},
{"shuo", 4, L'数'},
{"shuo", 4, L'硕'},
{"shuo", 4, L'朔'},
{"shuo", 4, L'烁'},
{"shuo", 4, L'蒴'},
{"shuo", 4, L'搠'},
{"shuo", 4, L'妁'},
{"shuo", 4, L'槊'},
{"shuo", 4, L'铄'},
{"si", 1, L'斯'},
{"si", 1, L'撕'},
{"si", 1, L'嘶'},
{"si", 1, L'私'},
{"si", 1, L'司'},
{"si", 1, L'丝'},
{"si", 1, L'厮'},
{"si", 1, L'厶'},
{"si", 1, L'咝'},
{"si", 1, L'澌'},
{"si", 1, L'缌'},
{"si", 1, L'锶'},
{"si", 1, L'鸶'},
{"si", 1, L'蛳'},
{"si", 3, L'死'},
{"si", 4, L'食'},
{"si", 4, L'肆'},
{"si", 4, L'寺'},
{"si", 4, L'嗣'},
{"si", 4, L'四'},
{"si", 4, L'伺'},
{"si", 4, L'似'},
{"si", 4, L'饲'},
{"si", 4, L'巳'},
{"si", 4, L'俟'},
{"si", 4, L'兕'},
{"si", 4, L'汜'},
{"si", 4, L'泗'},
{"si", 4, L'姒'},
{"si", 4, L'驷'},
{"si", 4, L'祀'},
{"si", 4, L'耜'},
{"si", 4, L'笥'},
{"song", 1, L'松'},
{"song", 1, L'凇'},
{"song", 1, L'菘'},
{"song", 1, L'崧'},
{"song", 1, L'嵩'},
{"song", 1, L'忪'},
{"song", 1, L'淞'},
{"song", 3, L'耸'},
{"song", 3, L'怂'},
{"song", 3, L'悚'},
{"song", 3, L'竦'},
{"song", 4, L'颂'},
{"song", 4, L'送'},
{"song", 4, L'宋'},
{"song", 4, L'讼'},
{"song", 4, L'诵'},
{"sou", 1, L'搜'},
{"sou", 1, L'艘'},
{"sou", 1, L'嗖'},
{"sou", 1, L'馊'},
{"sou", 1, L'溲'},
{"sou", 1, L'飕'},
{"sou", 1, L'锼'},
{"sou", 1, L'螋'},
{"sou", 3, L'擞'},
{"sou", 3, L'叟'},
{"sou", 3, L'薮'},
{"sou", 3, L'嗾'},
{"sou", 3, L'瞍'},
{"sou", 4, L'擞'},
{"sou", 4, L'嗽'},
{"su", 1, L'苏'},
{"su", 1, L'酥'},
{"su", 1, L'稣'},
{"su", 2, L'俗'},
{"su", 4, L'素'},
{"su", 4, L'速'},
{"su", 4, L'粟'},
{"su", 4, L'僳'},
{"su", 4, L'塑'},
{"su", 4, L'溯'},
{"su", 4, L'宿'},
{"su", 4, L'诉'},
{"su", 4, L'肃'},
{"su", 4, L'缩'},
{"su", 4, L'夙'},
{"su", 4, L'谡'},
{"su", 4, L'蔌'},
{"su", 4, L'嗉'},
{"su", 4, L'愫'},
{"su", 4, L'涑'},
{"su", 4, L'簌'},
{"su", 4, L'觫'},
{"suan", 1, L'酸'},
{"suan", 1, L'狻'},
{"suan", 4, L'蒜'},
{"suan", 4, L'算'},
{"sui", 1, L'尿'},
{"sui", 1, L'虽'},
{"sui", 1, L'荽'},
{"sui", 1, L'濉'},
{"sui", 1, L'眭'},
{"sui", 1, L'睢'},
{"sui", 2, L'隋'},
{"sui", 2, L'随'},
{"sui", 2, L'绥'},
{"sui", 2, L'遂'},
{"sui", 3, L'髓'},
{"sui", 4, L'碎'},
{"sui", 4, L'岁'},
{"sui", 4, L'穗'},
{"sui", 4, L'遂'},
{"sui", 4, L'隧'},
{"sui", 4, L'祟'},
{"sui", 4, L'谇'},
{"sui", 4, L'邃'},
{"sui", 4, L'燧'},
{"sun", 1, L'孙'},
{"sun", 1, L'荪'},
{"sun", 1, L'狲'},
{"sun", 1, L'飧'},
{"sun", 3, L'损'},
{"sun", 3, L'笋'},
{"sun", 3, L'榫'},
{"sun", 3, L'隼'},
{"suo", 1, L'莎'},
{"suo", 1, L'蓑'},
{"suo", 1, L'梭'},
{"suo", 1, L'唆'},
{"suo", 1, L'缩'},
{"suo", 1, L'嗦'},
{"suo", 1, L'嗍'},
{"suo", 1, L'娑'},
{"suo", 1, L'桫'},
{"suo", 1, L'挲'},
{"suo", 1, L'睃'},
{"suo", 1, L'羧'},
{"suo", 3, L'琐'},
{"suo", 3, L'索'},
{"suo", 3, L'锁'},
{"suo", 3, L'所'},
{"suo", 3, L'唢'},
{"ta", 1, L'塌'},
{"ta", 1, L'他'},
{"ta", 1, L'它'},
{"ta", 1, L'她'},
{"ta", 1, L'踏'},
{"ta", 1, L'溻'},
{"ta", 1, L'遢'},
{"ta", 1, L'铊'},
{"ta", 1, L'趿'},
{"ta", 3, L'塔'},
{"ta", 3, L'獭'},
{"ta", 3, L'鳎'},
{"ta", 4, L'挞'},
{"ta", 4, L'蹋'},
{"ta", 4, L'踏'},
{"ta", 4, L'拓'},
{"ta", 4, L'嗒'},
{"ta", 4, L'闼'},
{"ta", 4, L'漯'},
{"ta", 4, L'榻'},
{"ta", 4, L'沓'},
{"tai", 1, L'胎'},
{"tai", 1, L'苔'},
{"tai", 1, L'台'},
{"tai", 2, L'苔'},
{"tai", 2, L'抬'},
{"tai", 2, L'台'},
{"tai", 2, L'邰'},
{"tai", 2, L'薹'},
{"tai", 2, L'骀'},
{"tai", 2, L'炱'},
{"tai", 2, L'跆'},
{"tai", 2, L'鲐'},
{"tai", 4, L'泰'},
{"tai", 4, L'酞'},
{"tai", 4, L'太'},
{"tai", 4, L'态'},
{"tai", 4, L'汰'},
{"tai", 4, L'肽'},
{"tai", 4, L'钛'},
{"tan", 1, L'坍'},
{"tan", 1, L'摊'},
{"tan", 1, L'贪'},
{"tan", 1, L'瘫'},
{"tan", 1, L'滩'},
{"tan", 2, L'弹'},
{"tan", 2, L'坛'},
{"tan", 2, L'檀'},
{"tan", 2, L'痰'},
{"tan", 2, L'潭'},
{"tan", 2, L'谭'},
{"tan", 2, L'谈'},
{"tan", 2, L'郯'},
{"tan", 2, L'澹'},
{"tan", 2, L'昙'},
{"tan", 2, L'锬'},
{"tan", 2, L'镡'},
{"tan", 2, L'覃'},
{"tan", 3, L'坦'},
{"tan", 3, L'毯'},
{"tan", 3, L'袒'},
{"tan", 3, L'忐'},
{"tan", 3, L'钽'},
{"tan", 4, L'碳'},
{"tan", 4, L'探'},
{"tan", 4, L'叹'},
{"tan", 4, L'炭'},
{"tang", 1, L'汤'},
{"tang", 1, L'趟'},
{"tang", 1, L'铴'},
{"tang", 1, L'镗'},
{"tang", 1, L'耥'},
{"tang", 1, L'羰'},
{"tang", 2, L'塘'},
{"tang", 2, L'搪'},
{"tang", 2, L'堂'},
{"tang", 2, L'棠'},
{"tang", 2, L'膛'},
{"tang", 2, L'唐'},
{"tang", 2, L'糖'},
{"tang", 2, L'饧'},
{"tang", 2, L'溏'},
{"tang", 2, L'瑭'},
{"tang", 2, L'樘'},
{"tang", 2, L'镗'},
{"tang", 2, L'螗'},
{"tang", 2, L'螳'},
{"tang", 2, L'醣'},
{"tang", 3, L'敞'},
{"tang", 3, L'躺'},
{"tang", 3, L'淌'},
{"tang", 3, L'伥'},
{"tang", 3, L'傥'},
{"tang", 3, L'帑'},
{"tang", 3, L'耥'},
{"tang", 4, L'趟'},
{"tang", 4, L'烫'},
{"tao", 1, L'掏'},
{"tao", 1, L'涛'},
{"tao", 1, L'滔'},
{"tao", 1, L'绦'},
{"tao", 1, L'叨'},
{"tao", 1, L'韬'},
{"tao", 1, L'焘'},
{"tao", 1, L'饕'},
{"tao", 2, L'萄'},
{"tao", 2, L'桃'},
{"tao", 2, L'逃'},
{"tao", 2, L'淘'},
{"tao", 2, L'陶'},
{"tao", 2, L'鼗'},
{"tao", 2, L'啕'},
{"tao", 2, L'洮'},
{"tao", 3, L'讨'},
{"tao", 4, L'套'},
{"te", 4, L'特'},
{"te", 4, L'忒'},
{"te", 4, L'忑'},
{"te", 4, L'慝'},
{"te", 4, L'铽'},
{"teng", 2, L'藤'},
{"teng", 2, L'腾'},
{"teng", 2, L'疼'},
{"teng", 2, L'誊'},
{"teng", 2, L'滕'},
{"ti", 1, L'梯'},
{"ti", 1, L'剔'},
{"ti", 1, L'踢'},
{"ti", 1, L'锑'},
{"ti", 1, L'体'},
{"ti", 2, L'提'},
{"ti", 2, L'题'},
{"ti", 2, L'蹄'},
{"ti", 2, L'啼'},
{"ti", 2, L'荑'},
{"ti", 2, L'绨'},
{"ti", 2, L'缇'},
{"ti", 2, L'鹈'},
{"ti", 2, L'醍'},
{"ti", 3, L'体'},
{"ti", 4, L'替'},
{"ti", 4, L'嚏'},
{"ti", 4, L'惕'},
{"ti", 4, L'涕'},
{"ti", 4, L'剃'},
{"ti", 4, L'屉'},
{"ti", 4, L'倜'},
{"ti", 4, L'悌'},
{"ti", 4, L'逖'},
{"ti", 4, L'绨'},
{"ti", 4, L'裼'},
{"tian", 1, L'天'},
{"tian", 1, L'添'},
{"tian", 2, L'佃'},
{"tian", 2, L'填'},
{"tian", 2, L'田'},
{"tian", 2, L'甜'},
{"tian", 2, L'恬'},
{"tian", 2, L'阗'},
{"tian", 2, L'畋'},
{"tian", 2, L'钿'},
{"tian", 3, L'舔'},
{"tian", 3, L'腆'},
{"tian", 3, L'忝'},
{"tian", 3, L'殄'},
{"tian", 4, L'掭'},
{"tiao", 1, L'挑'},
{"tiao", 1, L'佻'},
{"tiao", 1, L'祧'},
{"tiao", 2, L'调'},
{"tiao", 2, L'条'},
{"tiao", 2, L'迢'},
{"tiao", 2, L'苕'},
{"tiao", 2, L'蜩'},
{"tiao", 2, L'笤'},
{"tiao", 2, L'龆'},
{"tiao", 2, L'鲦'},
{"tiao", 2, L'髫'},
{"tiao", 3, L'挑'},
{"tiao", 3, L'窕'},
{"tiao", 4, L'眺'},
{"tiao", 4, L'跳'},
{"tiao", 4, L'粜'},
{"tie", 1, L'贴'},
{"tie", 1, L'帖'},
{"tie", 1, L'萜'},
{"tie", 3, L'铁'},
{"tie", 3, L'帖'},
{"tie", 4, L'帖'},
{"tie", 4, L'餮'},
{"ting", 1, L'厅'},
{"ting", 1, L'听'},
{"ting", 1, L'烃'},
{"ting", 1, L'汀'},
{"ting", 2, L'廷'},
{"ting", 2, L'停'},
{"ting", 2, L'亭'},
{"ting", 2, L'庭'},
{"ting", 2, L'莛'},
{"ting", 2, L'葶'},
{"ting", 2, L'婷'},
{"ting", 2, L'蜓'},
{"ting", 2, L'霆'},
{"ting", 3, L'挺'},
{"ting", 3, L'艇'},
{"ting", 3, L'梃'},
{"ting", 3, L'町'},
{"ting", 3, L'铤'},
{"ting", 4, L'梃'},
{"tong", 1, L'通'},
{"tong", 1, L'嗵'},
{"tong", 2, L'侗'},
{"tong", 2, L'桐'},
{"tong", 2, L'酮'},
{"tong", 2, L'瞳'},
{"tong", 2, L'同'},
{"tong", 2, L'铜'},
{"tong", 2, L'彤'},
{"tong", 2, L'童'},
{"tong", 2, L'佟'},
{"tong", 2, L'僮'},
{"tong", 2, L'仝'},
{"tong", 2, L'垌'},
{"tong", 2, L'茼'},
{"tong", 2, L'峒'},
{"tong", 2, L'潼'},
{"tong", 2, L'砼'},
{"tong", 3, L'侗'},
{"tong", 3, L'桶'},
{"tong", 3, L'捅'},
{"tong", 3, L'筒'},
{"tong", 3, L'统'},
{"tong", 4, L'通'},
{"tong", 4, L'同'},
{"tong", 4, L'痛'},
{"tong", 4, L'恸'},
{"tou", 1, L'偷'},
{"tou", 2, L'投'},
{"tou", 2, L'头'},
{"tou", 2, L'骰'},
{"tou", 3, L'钭'},
{"tou", 4, L'透'},
{"tu", 1, L'凸'},
{"tu", 1, L'秃'},
{"tu", 1, L'突'},
{"tu", 2, L'图'},
{"tu", 2, L'徒'},
{"tu", 2, L'途'},
{"tu", 2, L'涂'},
{"tu", 2, L'屠'},
{"tu", 2, L'荼'},
{"tu", 2, L'菟'},
{"tu", 2, L'酴'},
{"tu", 3, L'土'},
{"tu", 3, L'吐'},
{"tu", 3, L'钍'},
{"tu", 4, L'吐'},
{"tu", 4, L'兔'},
{"tu", 4, L'堍'},
{"tu", 4, L'菟'},
{"tuan", 1, L'湍'},
{"tuan", 2, L'团'},
{"tuan", 2, L'抟'},
{"tuan", 3, L'疃'},
{"tuan", 4, L'彖'},
{"tui", 1, L'推'},
{"tui", 1, L'忒'},
{"tui", 2, L'颓'},
{"tui", 3, L'腿'},
{"tui", 4, L'蜕'},
{"tui", 4, L'褪'},
{"tui", 4, L'退'},
{"tui", 4, L'煺'},
{"tun", 1, L'吞'},
{"tun", 1, L'暾'},
{"tun", 2, L'囤'},
{"tun", 2, L'屯'},
{"tun", 2, L'臀'},
{"tun", 2, L'饨'},
{"tun", 2, L'豚'},
{"tun", 3, L'氽'},
{"tun", 4, L'褪'},
{"tuo", 1, L'拖'},
{"tuo", 1, L'托'},
{"tuo", 1, L'脱'},
{"tuo", 1, L'乇'},
{"tuo", 2, L'鸵'},
{"tuo", 2, L'陀'},
{"tuo", 2, L'驮'},
{"tuo", 2, L'驼'},
{"tuo", 2, L'佗'},
{"tuo", 2, L'坨'},
{"tuo", 2, L'沱'},
{"tuo", 2, L'柁'},
{"tuo", 2, L'橐'},
{"tuo", 2, L'砣'},
{"tuo", 2, L'铊'},
{"tuo", 2, L'酡'},
{"tuo", 2, L'跎'},
{"tuo", 2, L'鼍'},
{"tuo", 3, L'椭'},
{"tuo", 3, L'妥'},
{"tuo", 3, L'庹'},
{"tuo", 4, L'魄'},
{"tuo", 4, L'拓'},
{"tuo", 4, L'唾'},
{"tuo", 4, L'柝'},
{"tuo", 4, L'箨'},
{"wa", 1, L'挖'},
{"wa", 1, L'哇'},
{"wa", 1, L'蛙'},
{"wa", 1, L'洼'},
{"wa", 1, L'娲'},
{"wa", 2, L'娃'},
{"wa", 3, L'瓦'},
{"wa", 3, L'佤'},
{"wa", 4, L'瓦'},
{"wa", 4, L'袜'},
{"wa", 4, L'腽'},
{"wa", 5, L'哇'},
{"wai", 1, L'歪'},
{"wai", 3, L'崴'},
{"wai", 4, L'外'},
{"wan", 1, L'豌'},
{"wan", 1, L'弯'},
{"wan", 1, L'湾'},
{"wan", 1, L'剜'},
{"wan", 1, L'蜿'},
{"wan", 2, L'玩'},
{"wan", 2, L'顽'},
{"wan", 2, L'丸'},
{"wan", 2, L'烷'},
{"wan", 2, L'完'},
{"wan", 2, L'芄'},
{"wan", 2, L'纨'},
{"wan", 3, L'碗'},
{"wan", 3, L'挽'},
{"wan", 3, L'晚'},
{"wan", 3, L'皖'},
{"wan", 3, L'惋'},
{"wan", 3, L'宛'},
{"wan", 3, L'婉'},
{"wan", 3, L'莞'},
{"wan", 3, L'菀'},
{"wan", 3, L'绾'},
{"wan", 3, L'琬'},
{"wan", 3, L'脘'},
{"wan", 3, L'畹'},
{"wan", 4, L'蔓'},
{"wan", 4, L'万'},
{"wan", 4, L'腕'},
{"wang", 1, L'汪'},
{"wang", 1, L'尢'},
{"wang", 2, L'王'},
{"wang", 2, L'亡'},
{"wang", 3, L'枉'},
{"wang", 3, L'网'},
{"wang", 3, L'往'},
{"wang", 3, L'罔'},
{"wang", 3, L'惘'},
{"wang", 3, L'辋'},
{"wang", 3, L'魍'},
{"wang", 4, L'王'},
{"wang", 4, L'旺'},
{"wang", 4, L'望'},
{"wang", 4, L'忘'},
{"wang", 4, L'妄'},
{"wei", 1, L'威'},
{"wei", 1, L'巍'},
{"wei", 1, L'微'},
{"wei", 1, L'危'},
{"wei", 1, L'委'},
{"wei", 1, L'偎'},
{"wei", 1, L'隈'},
{"wei", 1, L'葳'},
{"wei", 1, L'薇'},
{"wei", 1, L'崴'},
{"wei", 1, L'逶'},
{"wei", 1, L'煨'},
{"wei", 2, L'韦'},
{"wei", 2, L'违'},
{"wei", 2, L'桅'},
{"wei", 2, L'围'},
{"wei", 2, L'唯'},
{"wei", 2, L'惟'},
{"wei", 2, L'为'},
{"wei", 2, L'潍'},
{"wei", 2, L'维'},
{"wei", 2, L'圩'},
{"wei", 2, L'帏'},
{"wei", 2, L'帷'},
{"wei", 2, L'嵬'},
{"wei", 2, L'闱'},
{"wei", 2, L'沩'},
{"wei", 2, L'涠'},
{"wei", 3, L'苇'},
{"wei", 3, L'萎'},
{"wei", 3, L'委'},
{"wei", 3, L'伟'},
{"wei", 3, L'伪'},
{"wei", 3, L'尾'},
{"wei", 3, L'纬'},
{"wei", 3, L'诿'},
{"wei", 3, L'隗'},
{"wei", 3, L'猥'},
{"wei", 3, L'洧'},
{"wei", 3, L'娓'},
{"wei", 3, L'玮'},
{"wei", 3, L'韪'},
{"wei", 3, L'炜'},
{"wei", 3, L'痿'},
{"wei", 3, L'艉'},
{"wei", 3, L'鲔'},
{"wei", 4, L'为'},
{"wei", 4, L'未'},
{"wei", 4, L'蔚'},
{"wei", 4, L'味'},
{"wei", 4, L'畏'},
{"wei", 4, L'胃'},
{"wei", 4, L'喂'},
{"wei", 4, L'魏'},
{"wei", 4, L'位'},
{"wei", 4, L'渭'},
{"wei", 4, L'谓'},
{"wei", 4, L'尉'},
{"wei", 4, L'慰'},
{"wei", 4, L'卫'},
{"wei", 4, L'遗'},
{"wei", 4, L'猬'},
{"wei", 4, L'軎'},
{"wen", 1, L'瘟'},
{"wen", 1, L'温'},
{"wen", 2, L'蚊'},
{"wen", 2, L'文'},
{"wen", 2, L'闻'},
{"wen", 2, L'纹'},
{"wen", 2, L'阌'},
{"wen", 2, L'雯'},
{"wen", 3, L'吻'},
{"wen", 3, L'稳'},
{"wen", 3, L'紊'},
{"wen", 3, L'刎'},
{"wen", 4, L'纹'},
{"wen", 4, L'问'},
{"wen", 4, L'汶'},
{"wen", 4, L'璺'},
{"weng", 1, L'嗡'},
{"weng", 1, L'翁'},
{"weng", 3, L'蓊'},
{"weng", 4, L'瓮'},
{"weng", 4, L'蕹'},
{"wo", 1, L'挝'},
{"wo", 1, L'蜗'},
{"wo", 1, L'涡'},
{"wo", 1, L'窝'},
{"wo", 1, L'倭'},
{"wo", 1, L'莴'},
{"wo", 1, L'喔'},
{"wo", 3, L'我'},
{"wo", 4, L'斡'},
{"wo", 4, L'卧'},
{"wo", 4, L'握'},
{"wo", 4, L'沃'},
{"wo", 4, L'幄'},
{"wo", 4, L'渥'},
{"wo", 4, L'肟'},
{"wo", 4, L'硪'},
{"wo", 4, L'龌'},
{"wu", 1, L'恶'},
{"wu", 1, L'巫'},
{"wu", 1, L'呜'},
{"wu", 1, L'钨'},
{"wu", 1, L'乌'},
{"wu", 1, L'污'},
{"wu", 1, L'诬'},
{"wu", 1, L'屋'},
{"wu", 1, L'兀'},
{"wu", 1, L'邬'},
{"wu", 1, L'圬'},
{"wu", 1, L'於'},
{"wu", 2, L'亡'},
{"wu", 2, L'无'},
{"wu", 2, L'芜'},
{"wu", 2, L'梧'},
{"wu", 2, L'吾'},
{"wu", 2, L'吴'},
{"wu", 2, L'毋'},
{"wu", 2, L'捂'},
{"wu", 2, L'唔'},
{"wu", 2, L'浯'},
{"wu", 2, L'蜈'},
{"wu", 2, L'鼯'},
{"wu", 3, L'武'},
{"wu", 3, L'五'},
{"wu", 3, L'捂'},
{"wu", 3, L'午'},
{"wu", 3, L'舞'},
{"wu", 3, L'伍'},
{"wu", 3, L'侮'},
{"wu", 3, L'仵'},
{"wu", 3, L'庑'},
{"wu", 3, L'怃'},
{"wu", 3, L'忤'},
{"wu", 3, L'迕'},
{"wu", 3, L'妩'},
{"wu", 3, L'牾'},
{"wu", 3, L'鹉'},
{"wu", 4, L'恶'},
{"wu", 4, L'坞'},
{"wu", 4, L'戊'},
{"wu", 4, L'雾'},
{"wu", 4, L'晤'},
{"wu", 4, L'物'},
{"wu", 4, L'勿'},
{"wu", 4, L'务'},
{"wu", 4, L'悟'},
{"wu", 4, L'误'},
{"wu", 4, L'兀'},
{"wu", 4, L'阢'},
{"wu", 4, L'芴'},
{"wu", 4, L'寤'},
{"wu", 4, L'婺'},
{"wu", 4, L'骛'},
{"wu", 4, L'杌'},
{"wu", 4, L'焐'},
{"wu", 4, L'鹜'},
{"wu", 4, L'痦'},
{"wu", 4, L'鋈'},
{"xi", 1, L'腊'},
{"xi", 1, L'栖'},
{"xi", 1, L'漆'},
{"xi", 1, L'昔'},
{"xi", 1, L'熙'},
{"xi", 1, L'析'},
{"xi", 1, L'西'},
{"xi", 1, L'硒'},
{"xi", 1, L'矽'},
{"xi", 1, L'晰'},
{"xi", 1, L'嘻'},
{"xi", 1, L'吸'},
{"xi", 1, L'锡'},
{"xi", 1, L'牺'},
{"xi", 1, L'稀'},
{"xi", 1, L'息'},
{"xi", 1, L'希'},
{"xi", 1, L'悉'},
{"xi", 1, L'膝'},
{"xi", 1, L'夕'},
{"xi", 1, L'惜'},
{"xi", 1, L'熄'},
{"xi", 1, L'烯'},
{"xi", 1, L'溪'},
{"xi", 1, L'汐'},
{"xi", 1, L'犀'},
{"xi", 1, L'僖'},
{"xi", 1, L'兮'},
{"xi", 1, L'郗'},
{"xi", 1, L'茜'},
{"xi", 1, L'菥'},
{"xi", 1, L'奚'},
{"xi", 1, L'唏'},
{"xi", 1, L'浠'},
{"xi", 1, L'淅'},
{"xi", 1, L'嬉'},
{"xi", 1, L'樨'},
{"xi", 1, L'曦'},
{"xi", 1, L'欷'},
{"xi", 1, L'歙'},
{"xi", 1, L'熹'},
{"xi", 1, L'皙'},
{"xi", 1, L'穸'},
{"xi", 1, L'裼'},
{"xi", 1, L'蜥'},
{"xi", 1, L'螅'},
{"xi", 1, L'蟋'},
{"xi", 1, L'舾'},
{"xi", 1, L'羲'},
{"xi", 1, L'粞'},
{"xi", 1, L'翕'},
{"xi", 1, L'醯'},
{"xi", 1, L'蹊'},
{"xi", 1, L'鼷'},
{"xi", 2, L'檄'},
{"xi", 2, L'袭'},
{"xi", 2, L'席'},
{"xi", 2, L'习'},
{"xi", 2, L'媳'},
{"xi", 2, L'隰'},
{"xi", 2, L'觋'},
{"xi", 3, L'喜'},
{"xi", 3, L'铣'},
{"xi", 3, L'洗'},
{"xi", 3, L'葸'},
{"xi", 3, L'蓰'},
{"xi", 3, L'徙'},
{"xi", 3, L'屣'},
{"xi", 3, L'玺'},
{"xi", 3, L'禧'},
{"xi", 4, L'系'},
{"xi", 4, L'隙'},
{"xi", 4, L'戏'},
{"xi", 4, L'细'},
{"xi", 4, L'饩'},
{"xi", 4, L'阋'},
{"xi", 4, L'禊'},
{"xi", 4, L'舄'},
{"xia", 1, L'瞎'},
{"xia", 1, L'虾'},
{"xia", 1, L'呷'},
{"xia", 2, L'匣'},
{"xia", 2, L'霞'},
{"xia", 2, L'辖'},
{"xia", 2, L'暇'},
{"xia", 2, L'峡'},
{"xia", 2, L'侠'},
{"xia", 2, L'狭'},
{"xia", 2, L'狎'},
{"xia", 2, L'遐'},
{"xia", 2, L'瑕'},
{"xia", 2, L'柙'},
{"xia", 2, L'硖'},
{"xia", 2, L'黠'},
{"xia", 4, L'唬'},
{"xia", 4, L'下'},
{"xia", 4, L'厦'},
{"xia", 4, L'夏'},
{"xia", 4, L'吓'},
{"xia", 4, L'罅'},
{"xian", 1, L'掀'},
{"xian", 1, L'锨'},
{"xian", 1, L'先'},
{"xian", 1, L'仙'},
{"xian", 1, L'鲜'},
{"xian", 1, L'纤'},
{"xian", 1, L'莶'},
{"xian", 1, L'暹'},
{"xian", 1, L'氙'},
{"xian", 1, L'祆'},
{"xian", 1, L'籼'},
{"xian", 1, L'酰'},
{"xian", 1, L'跹'},
{"xian", 2, L'咸'},
{"xian", 2, L'贤'},
{"xian", 2, L'衔'},
{"xian", 2, L'舷'},
{"xian", 2, L'闲'},
{"xian", 2, L'涎'},
{"xian", 2, L'弦'},
{"xian", 2, L'嫌'},
{"xian", 2, L'娴'},
{"xian", 2, L'鹇'},
{"xian", 2, L'痫'},
{"xian", 3, L'铣'},
{"xian", 3, L'洗'},
{"xian", 3, L'鲜'},
{"xian", 3, L'显'},
{"xian", 3, L'险'},
{"xian", 3, L'冼'},
{"xian", 3, L'藓'},
{"xian", 3, L'猃'},
{"xian", 3, L'燹'},
{"xian", 3, L'蚬'},
{"xian", 3, L'筅'},
{"xian", 3, L'跣'},
{"xian", 4, L'见'},
{"xian", 4, L'现'},
{"xian", 4, L'献'},
{"xian", 4, L'县'},
{"xian", 4, L'腺'},
{"xian", 4, L'馅'},
{"xian", 4, L'羡'},
{"xian", 4, L'宪'},
{"xian", 4, L'陷'},
{"xian", 4, L'限'},
{"xian", 4, L'线'},
{"xian", 4, L'苋'},
{"xian", 4, L'岘'},
{"xian", 4, L'霰'},
{"xiang", 1, L'相'},
{"xiang", 1, L'厢'},
{"xiang", 1, L'镶'},
{"xiang", 1, L'香'},
{"xiang", 1, L'箱'},
{"xiang", 1, L'襄'},
{"xiang", 1, L'湘'},
{"xiang", 1, L'乡'},
{"xiang", 1, L'芗'},
{"xiang", 1, L'葙'},
{"xiang", 1, L'骧'},
{"xiang", 1, L'缃'},
{"xiang", 2, L'降'},
{"xiang", 2, L'翔'},
{"xiang", 2, L'祥'},
{"xiang", 2, L'详'},
{"xiang", 2, L'庠'},
{"xiang", 3, L'想'},
{"xiang", 3, L'响'},
{"xiang", 3, L'享'},
{"xiang", 3, L'饷'},
{"xiang", 3, L'鲞'},
{"xiang", 3, L'飨'},
{"xiang", 4, L'相'},
{"xiang", 4, L'项'},
{"xiang", 4, L'巷'},
{"xiang", 4, L'橡'},
{"xiang", 4, L'像'},
{"xiang", 4, L'向'},
{"xiang", 4, L'象'},
{"xiang", 4, L'蟓'},
{"xiao", 1, L'萧'},
{"xiao", 1, L'硝'},
{"xiao", 1, L'霄'},
{"xiao", 1, L'削'},
{"xiao", 1, L'嚣'},
{"xiao", 1, L'销'},
{"xiao", 1, L'消'},
{"xiao", 1, L'宵'},
{"xiao", 1, L'肖'},
{"xiao", 1, L'哓'},
{"xiao", 1, L'潇'},
{"xiao", 1, L'逍'},
{"xiao", 1, L'骁'},
{"xiao", 1, L'绡'},
{"xiao", 1, L'枭'},
{"xiao", 1, L'枵'},
{"xiao", 1, L'蛸'},
{"xiao", 1, L'箫'},
{"xiao", 1, L'魈'},
{"xiao", 2, L'淆'},
{"xiao", 2, L'崤'},
{"xiao", 3, L'晓'},
{"xiao", 3, L'小'},
{"xiao", 3, L'筱'},
{"xiao", 4, L'哮'},
{"xiao", 4, L'孝'},
{"xiao", 4, L'校'},
{"xiao", 4, L'肖'},
{"xiao", 4, L'啸'},
{"xiao", 4, L'笑'},
{"xiao", 4, L'效'},
{"xie", 1, L'楔'},
{"xie", 1, L'些'},
{"xie", 1, L'歇'},
{"xie", 1, L'蝎'},
{"xie", 2, L'鞋'},
{"xie", 2, L'协'},
{"xie", 2, L'挟'},
{"xie", 2, L'携'},
{"xie", 2, L'邪'},
{"xie", 2, L'斜'},
{"xie", 2, L'胁'},
{"xie", 2, L'谐'},
{"xie", 2, L'叶'},
{"xie", 2, L'偕'},
{"xie", 2, L'勰'},
{"xie", 2, L'撷'},
{"xie", 2, L'缬'},
{"xie", 2, L'颉'},
{"xie", 3, L'写'},
{"xie", 3, L'血'},
{"xie", 4, L'解'},
{"xie", 4, L'泣'},
{"xie", 4, L'械'},
{"xie", 4, L'卸'},
{"xie", 4, L'蟹'},
{"xie", 4, L'懈'},
{"xie", 4, L'泄'},
{"xie", 4, L'泻'},
{"xie", 4, L'谢'},
{"xie", 4, L'屑'},
{"xie", 4, L'亵'},
{"xie", 4, L'燮'},
{"xie", 4, L'薤'},
{"xie", 4, L'獬'},
{"xie", 4, L'廨'},
{"xie", 4, L'渫'},
{"xie", 4, L'瀣'},
{"xie", 4, L'邂'},
{"xie", 4, L'绁'},
{"xie", 4, L'榭'},
{"xie", 4, L'榍'},
{"xie", 4, L'躞'},
{"xin", 1, L'薪'},
{"xin", 1, L'芯'},
{"xin", 1, L'锌'},
{"xin", 1, L'欣'},
{"xin", 1, L'辛'},
{"xin", 1, L'新'},
{"xin", 1, L'忻'},
{"xin", 1, L'心'},
{"xin", 1, L'馨'},
{"xin", 1, L'莘'},
{"xin", 1, L'昕'},
{"xin", 1, L'歆'},
{"xin", 1, L'鑫'},
{"xin", 2, L'镡'},
{"xin", 4, L'芯'},
{"xin", 4, L'信'},
{"xin", 4, L'衅'},
{"xin", 4, L'囟'},
{"xing", 1, L'星'},
{"xing", 1, L'腥'},
{"xing", 1, L'猩'},
{"xing", 1, L'惺'},
{"xing", 1, L'兴'},
{"xing", 2, L'刑'},
{"xing", 2, L'型'},
{"xing", 2, L'形'},
{"xing", 2, L'邢'},
{"xing", 2, L'行'},
{"xing", 2, L'陉'},
{"xing", 2, L'荥'},
{"xing", 2, L'饧'},
{"xing", 2, L'硎'},
{"xing", 3, L'省'},
{"xing", 3, L'醒'},
{"xing", 3, L'擤'},
{"xing", 4, L'兴'},
{"xing", 4, L'幸'},
{"xing", 4, L'杏'},
{"xing", 4, L'性'},
{"xing", 4, L'姓'},
{"xing", 4, L'荇'},
{"xing", 4, L'悻'},
{"xiong", 1, L'兄'},
{"xiong", 1, L'凶'},
{"xiong", 1, L'胸'},
{"xiong", 1, L'匈'},
{"xiong", 1, L'汹'},
{"xiong", 1, L'芎'},
{"xiong", 2, L'雄'},
{"xiong", 2, L'熊'},
{"xiu", 1, L'休'},
{"xiu", 1, L'修'},
{"xiu", 1, L'羞'},
{"xiu", 1, L'咻'},
{"xiu", 1, L'馐'},
{"xiu", 1, L'庥'},
{"xiu", 1, L'鸺'},
{"xiu", 1, L'貅'},
{"xiu", 1, L'髹'},
{"xiu", 3, L'宿'},
{"xiu", 3, L'朽'},
{"xiu", 4, L'臭'},
{"xiu", 4, L'宿'},
{"xiu", 4, L'嗅'},
{"xiu", 4, L'锈'},
{"xiu", 4, L'秀'},
{"xiu", 4, L'袖'},
{"xiu", 4, L'绣'},
{"xiu", 4, L'岫'},
{"xiu", 4, L'溴'},
{"xu", 1, L'墟'},
{"xu", 1, L'戌'},
{"xu", 1, L'需'},
{"xu", 1, L'虚'},
{"xu", 1, L'嘘'},
{"xu", 1, L'须'},
{"xu", 1, L'吁'},
{"xu", 1, L'圩'},
{"xu", 1, L'顼'},
{"xu", 1, L'盱'},
{"xu", 1, L'胥'},
{"xu", 2, L'徐'},
{"xu", 3, L'许'},
{"xu", 3, L'诩'},
{"xu", 3, L'浒'},
{"xu", 3, L'栩'},
{"xu", 3, L'糈'},
{"xu", 3, L'醑'},
{"xu", 4, L'蓄'},
{"xu", 4, L'酗'},
{"xu", 4, L'叙'},
{"xu", 4, L'旭'},
{"xu", 4, L'序'},
{"xu", 4, L'畜'},
{"xu", 4, L'恤'},
{"xu", 4, L'絮'},
{"xu", 4, L'婿'},
{"xu", 4, L'绪'},
{"xu", 4, L'续'},
{"xu", 4, L'勖'},
{"xu", 4, L'洫'},
{"xu", 4, L'溆'},
{"xu", 4, L'煦'},
{"xu", 5, L'蓿'},
{"xuan", 1, L'轩'},
{"xuan", 1, L'喧'},
{"xuan", 1, L'宣'},
{"xuan", 1, L'儇'},
{"xuan", 1, L'谖'},
{"xuan", 1, L'萱'},
{"xuan", 1, L'揎'},
{"xuan", 1, L'暄'},
{"xuan", 1, L'煊'},
{"xuan", 2, L'悬'},
{"xuan", 2, L'旋'},
{"xuan", 2, L'玄'},
{"xuan", 2, L'漩'},
{"xuan", 2, L'璇'},
{"xuan", 2, L'痃'},
{"xuan", 3, L'选'},
{"xuan", 3, L'癣'},
{"xuan", 4, L'券'},
{"xuan", 4, L'旋'},
{"xuan", 4, L'眩'},
{"xuan", 4, L'绚'},
{"xuan", 4, L'泫'},
{"xuan", 4, L'渲'},
{"xuan", 4, L'楦'},
{"xuan", 4, L'炫'},
{"xuan", 4, L'碹'},
{"xuan", 4, L'铉'},
{"xuan", 4, L'镟'},
{"xue", 1, L'削'},
{"xue", 1, L'靴'},
{"xue", 1, L'薛'},
{"xue", 2, L'学'},
{"xue", 2, L'穴'},
{"xue", 2, L'噱'},
{"xue", 2, L'泶'},
{"xue", 2, L'踅'},
{"xue", 3, L'雪'},
{"xue", 3, L'鳕'},
{"xue", 4, L'血'},
{"xue", 4, L'谑'},
{"xun", 1, L'勋'},
{"xun", 1, L'熏'},
{"xun", 1, L'埙'},
{"xun", 1, L'薰'},
{"xun", 1, L'獯'},
{"xun", 1, L'曛'},
{"xun", 1, L'窨'},
{"xun", 1, L'醺'},
{"xun", 2, L'循'},
{"xun", 2, L'旬'},
{"xun", 2, L'询'},
{"xun", 2, L'寻'},
{"xun", 2, L'巡'},
{"xun", 2, L'郇'},
{"xun", 2, L'荀'},
{"xun", 2, L'荨'},
{"xun", 2, L'峋'},
{"xun", 2, L'恂'},
{"xun", 2, L'洵'},
{"xun", 2, L'浔'},
{"xun", 2, L'鲟'},
{"xun", 4, L'浚'},
{"xun", 4, L'熏'},
{"xun", 4, L'驯'},
{"xun", 4, L'殉'},
{"xun", 4, L'汛'},
{"xun", 4, L'训'},
{"xun", 4, L'讯'},
{"xun", 4, L'逊'},
{"xun", 4, L'迅'},
{"xun", 4, L'巽'},
{"xun", 4, L'蕈'},
{"xun", 4, L'徇'},
{"ya", 1, L'压'},
{"ya", 1, L'押'},
{"ya", 1, L'鸦'},
{"ya", 1, L'鸭'},
{"ya", 1, L'呀'},
{"ya", 1, L'丫'},
{"ya", 1, L'雅'},
{"ya", 1, L'哑'},
{"ya", 1, L'垭'},
{"ya", 1, L'桠'},
{"ya", 2, L'芽'},
{"ya", 2, L'牙'},
{"ya", 2, L'蚜'},
{"ya", 2, L'崖'},
{"ya", 2, L'衙'},
{"ya", 2, L'涯'},
{"ya", 2, L'伢'},
{"ya", 2, L'岈'},
{"ya", 2, L'琊'},
{"ya", 2, L'睚'},
{"ya", 3, L'雅'},
{"ya", 3, L'哑'},
{"ya", 3, L'痖'},
{"ya", 3, L'疋'},
{"ya", 4, L'亚'},
{"ya", 4, L'讶'},
{"ya", 4, L'轧'},
{"ya", 4, L'垭'},
{"ya", 4, L'揠'},
{"ya", 4, L'迓'},
{"ya", 4, L'娅'},
{"ya", 4, L'氩'},
{"ya", 4, L'砑'},
{"ya", 5, L'呀'},
{"yan", 1, L'焉'},
{"yan", 1, L'咽'},
{"yan", 1, L'阉'},
{"yan", 1, L'烟'},
{"yan", 1, L'淹'},
{"yan", 1, L'燕'},
{"yan", 1, L'殷'},
{"yan", 1, L'鄢'},
{"yan", 1, L'菸'},
{"yan", 1, L'崦'},
{"yan", 1, L'恹'},
{"yan", 1, L'阏'},
{"yan", 1, L'湮'},
{"yan", 1, L'嫣'},
{"yan", 1, L'胭'},
{"yan", 1, L'腌'},
{"yan", 2, L'铅'},
{"yan", 2, L'盐'},
{"yan", 2, L'严'},
{"yan", 2, L'研'},
{"yan", 2, L'蜒'},
{"yan", 2, L'岩'},
{"yan", 2, L'延'},
{"yan", 2, L'言'},
{"yan", 2, L'颜'},
{"yan", 2, L'阎'},
{"yan", 2, L'炎'},
{"yan", 2, L'沿'},
{"yan", 2, L'阽'},
{"yan", 2, L'芫'},
{"yan", 2, L'闫'},
{"yan", 2, L'妍'},
{"yan", 2, L'檐'},
{"yan", 2, L'筵'},
{"yan", 3, L'奄'},
{"yan", 3, L'掩'},
{"yan", 3, L'眼'},
{"yan", 3, L'衍'},
{"yan", 3, L'演'},
{"yan", 3, L'厣'},
{"yan", 3, L'剡'},
{"yan", 3, L'俨'},
{"yan", 3, L'偃'},
{"yan", 3, L'兖'},
{"yan", 3, L'郾'},
{"yan", 3, L'琰'},
{"yan", 3, L'罨'},
{"yan", 3, L'魇'},
{"yan", 3, L'鼹'},
{"yan", 4, L'咽'},
{"yan", 4, L'艳'},
{"yan", 4, L'堰'},
{"yan", 4, L'燕'},
{"yan", 4, L'厌'},
{"yan", 4, L'砚'},
{"yan", 4, L'雁'},
{"yan", 4, L'唁'},
{"yan", 4, L'彦'},
{"yan", 4, L'焰'},
{"yan", 4, L'宴'},
{"yan", 4, L'谚'},
{"yan", 4, L'验'},
{"yan", 4, L'赝'},
{"yan", 4, L'谳'},
{"yan", 4, L'滟'},
{"yan", 4, L'晏'},
{"yan", 4, L'焱'},
{"yan", 4, L'酽'},
{"yan", 4, L'餍'},
{"yang", 1, L'殃'},
{"yang", 1, L'央'},
{"yang", 1, L'鸯'},
{"yang", 1, L'秧'},
{"yang", 1, L'泱'},
{"yang", 1, L'鞅'},
{"yang", 2, L'杨'},
{"yang", 2, L'扬'},
{"yang", 2, L'佯'},
{"yang", 2, L'疡'},
{"yang", 2, L'羊'},
{"yang", 2, L'洋'},
{"yang", 2, L'阳'},
{"yang", 2, L'徉'},
{"yang", 2, L'炀'},
{"yang", 2, L'烊'},
{"yang", 2, L'蛘'},
{"yang", 3, L'氧'},
{"yang", 3, L'仰'},
{"yang", 3, L'痒'},
{"yang", 3, L'养'},
{"yang", 4, L'样'},
{"yang", 4, L'漾'},
{"yang", 4, L'怏'},
{"yang", 4, L'烊'},
{"yang", 4, L'恙'},
{"yang", 4, L'鞅'},
{"yao", 1, L'么'},
{"yao", 1, L'邀'},
{"yao", 1, L'腰'},
{"yao", 1, L'妖'},
{"yao", 1, L'要'},
{"yao", 1, L'约'},
{"yao", 1, L'夭'},
{"yao", 1, L'吆'},
{"yao", 1, L'幺'},
{"yao", 2, L'侥'},
{"yao", 2, L'陶'},
{"yao", 2, L'瑶'},
{"yao", 2, L'摇'},
{"yao", 2, L'尧'},
{"yao", 2, L'遥'},
{"yao", 2, L'窑'},
{"yao", 2, L'谣'},
{"yao", 2, L'姚'},
{"yao", 2, L'爻'},
{"yao", 2, L'徭'},
{"yao", 2, L'珧'},
{"yao", 2, L'轺'},
{"yao", 2, L'肴'},
{"yao", 2, L'铫'},
{"yao", 2, L'繇'},
{"yao", 2, L'鳐'},
{"yao", 3, L'咬'},
{"yao", 3, L'舀'},
{"yao", 3, L'崾'},
{"yao", 3, L'杳'},
{"yao", 3, L'窈'},
{"yao", 4, L'疟'},
{"yao", 4, L'药'},
{"yao", 4, L'要'},
{"yao", 4, L'耀'},
{"yao", 4, L'钥'},
{"yao", 4, L'曜'},
{"yao", 4, L'鹞'},
{"ye", 1, L'椰'},
{"ye", 1, L'噎'},
{"ye", 1, L'耶'},
{"ye", 1, L'掖'},
{"ye", 2, L'邪'},
{"ye", 2, L'耶'},
{"ye", 2, L'爷'},
{"ye", 2, L'揶'},
{"ye", 2, L'铘'},
{"ye", 3, L'野'},
{"ye", 3, L'冶'},
{"ye", 3, L'也'},
{"ye", 4, L'咽'},
{"ye", 4, L'页'},
{"ye", 4, L'掖'},
{"ye", 4, L'业'},
{"ye", 4, L'叶'},
{"ye", 4, L'曳'},
{"ye", 4, L'腋'},
{"ye", 4, L'夜'},
{"ye", 4, L'液'},
{"ye", 4, L'拽'},
{"ye", 4, L'靥'},
{"ye", 4, L'谒'},
{"ye", 4, L'邺'},
{"ye", 4, L'晔'},
{"ye", 4, L'烨'},
{"yi", 1, L'一'},
{"yi", 1, L'壹'},
{"yi", 1, L'医'},
{"yi", 1, L'揖'},
{"yi", 1, L'铱'},
{"yi", 1, L'依'},
{"yi", 1, L'伊'},
{"yi", 1, L'衣'},
{"yi", 1, L'椅'},
{"yi", 1, L'咿'},
{"yi", 1, L'噫'},
{"yi", 1, L'猗'},
{"yi", 1, L'漪'},
{"yi", 1, L'欹'},
{"yi", 1, L'黟'},
{"yi", 2, L'蛇'},
{"yi", 2, L'颐'},
{"yi", 2, L'夷'},
{"yi", 2, L'遗'},
{"yi", 2, L'移'},
{"yi", 2, L'仪'},
{"yi", 2, L'胰'},
{"yi", 2, L'疑'},
{"yi", 2, L'沂'},
{"yi", 2, L'宜'},
{"yi", 2, L'姨'},
{"yi", 2, L'彝'},
{"yi", 2, L'诒'},
{"yi", 2, L'圯'},
{"yi", 2, L'荑'},
{"yi", 2, L'咦'},
{"yi", 2, L'嶷'},
{"yi", 2, L'饴'},
{"yi", 2, L'怡'},
{"yi", 2, L'迤'},
{"yi", 2, L'贻'},
{"yi", 2, L'眙'},
{"yi", 2, L'痍'},
{"yi", 3, L'尾'},
{"yi", 3, L'椅'},
{"yi", 3, L'蚁'},
{"yi", 3, L'倚'},
{"yi", 3, L'已'},
{"yi", 3, L'乙'},
{"yi", 3, L'矣'},
{"yi", 3, L'以'},
{"yi", 3, L'苡'},
{"yi", 3, L'迤'},
{"yi", 3, L'旖'},
{"yi", 3, L'钇'},
{"yi", 3, L'舣'},
{"yi", 3, L'酏'},
{"yi", 4, L'艾'},
{"yi", 4, L'衣'},
{"yi", 4, L'艺'},
{"yi", 4, L'抑'},
{"yi", 4, L'易'},
{"yi", 4, L'邑'},
{"yi", 4, L'屹'},
{"yi", 4, L'亿'},
{"yi", 4, L'役'},
{"yi", 4, L'臆'},
{"yi", 4, L'逸'},
{"yi", 4, L'肄'},
{"yi", 4, L'疫'},
{"yi", 4, L'亦'},
{"yi", 4, L'裔'},
{"yi", 4, L'意'},
{"yi", 4, L'毅'},
{"yi", 4, L'忆'},
{"yi", 4, L'义'},
{"yi", 4, L'益'},
{"yi", 4, L'溢'},
{"yi", 4, L'诣'},
{"yi", 4, L'议'},
{"yi", 4, L'谊'},
{"yi", 4, L'译'},
{"yi", 4, L'异'},
{"yi", 4, L'翼'},
{"yi", 4, L'翌'},
{"yi", 4, L'绎'},
{"yi", 4, L'刈'},
{"yi", 4, L'劓'},
{"yi", 4, L'佚'},
{"yi", 4, L'佾'},
{"yi", 4, L'埸'},
{"yi", 4, L'懿'},
{"yi", 4, L'薏'},
{"yi", 4, L'弈'},
{"yi", 4, L'奕'},
{"yi", 4, L'挹'},
{"yi", 4, L'弋'},
{"yi", 4, L'呓'},
{"yi", 4, L'嗌'},
{"yi", 4, L'峄'},
{"yi", 4, L'怿'},
{"yi", 4, L'悒'},
{"yi", 4, L'驿'},
{"yi", 4, L'缢'},
{"yi", 4, L'殪'},
{"yi", 4, L'轶'},
{"yi", 4, L'熠'},
{"yi", 4, L'镒'},
{"yi", 4, L'镱'},
{"yi", 4, L'瘗'},
{"yi", 4, L'癔'},
{"yi", 4, L'翊'},
{"yi", 4, L'蜴'},
{"yi", 4, L'羿'},
{"yi", 4, L'翳'},
{"yin", 1, L'茵'},
{"yin", 1, L'荫'},
{"yin", 1, L'因'},
{"yin", 1, L'殷'},
{"yin", 1, L'音'},
{"yin", 1, L'阴'},
{"yin", 1, L'姻'},
{"yin", 1, L'堙'},
{"yin", 1, L'喑'},
{"yin", 1, L'洇'},
{"yin", 1, L'湮'},
{"yin", 1, L'氤'},
{"yin", 1, L'铟'},
{"yin", 2, L'吟'},
{"yin", 2, L'银'},
{"yin", 2, L'淫'},
{"yin", 2, L'寅'},
{"yin", 2, L'鄞'},
{"yin", 2, L'垠'},
{"yin", 2, L'狺'},
{"yin", 2, L'夤'},
{"yin", 2, L'霪'},
{"yin", 2, L'龈'},
{"yin", 3, L'饮'},
{"yin", 3, L'尹'},
{"yin", 3, L'引'},
{"yin", 3, L'隐'},
{"yin", 3, L'吲'},
{"yin", 3, L'瘾'},
{"yin", 3, L'蚓'},
{"yin", 4, L'荫'},
{"yin", 4, L'饮'},
{"yin", 4, L'印'},
{"yin", 4, L'胤'},
{"yin", 4, L'茚'},
{"yin", 4, L'窨'},
{"ying", 1, L'英'},
{"ying", 1, L'樱'},
{"ying", 1, L'婴'},
{"ying", 1, L'鹰'},
{"ying", 1, L'应'},
{"ying", 1, L'缨'},
{"ying", 1, L'莺'},
{"ying", 1, L'撄'},
{"ying", 1, L'嘤'},
{"ying", 1, L'膺'},
{"ying", 1, L'瑛'},
{"ying", 1, L'璎'},
{"ying", 1, L'鹦'},
{"ying", 1, L'罂'},
{"ying", 2, L'莹'},
{"ying", 2, L'萤'},
{"ying", 2, L'营'},
{"ying", 2, L'荧'},
{"ying", 2, L'蝇'},
{"ying", 2, L'迎'},
{"ying", 2, L'赢'},
{"ying", 2, L'盈'},
{"ying", 2, L'嬴'},
{"ying", 2, L'茔'},
{"ying", 2, L'荥'},
{"ying", 2, L'萦'},
{"ying", 2, L'蓥'},
{"ying", 2, L'滢'},
{"ying", 2, L'潆'},
{"ying", 2, L'瀛'},
{"ying", 2, L'楹'},
{"ying", 3, L'影'},
{"ying", 3, L'颖'},
{"ying", 3, L'郢'},
{"ying", 3, L'瘿'},
{"ying", 3, L'颍'},
{"ying", 4, L'应'},
{"ying", 4, L'硬'},
{"ying", 4, L'映'},
{"ying", 4, L'媵'},
{"yo", 1, L'哟'},
{"yo", 1, L'育'},
{"yo", 1, L'唷'},
{"yo", 5, L'哟'},
{"yong", 1, L'拥'},
{"yong", 1, L'佣'},
{"yong", 1, L'臃'},
{"yong", 1, L'痈'},
{"yong", 1, L'庸'},
{"yong", 1, L'雍'},
{"yong", 1, L'壅'},
{"yong", 1, L'墉'},
{"yong", 1, L'慵'},
{"yong", 1, L'邕'},
{"yong", 1, L'镛'},
{"yong", 1, L'鳙'},
{"yong", 1, L'饔'},
{"yong", 2, L'喁'},
{"yong", 3, L'踊'},
{"yong", 3, L'蛹'},
{"yong", 3, L'咏'},
{"yong", 3, L'泳'},
{"yong", 3, L'涌'},
{"yong", 3, L'永'},
{"yong", 3, L'恿'},
{"yong", 3, L'勇'},
{"yong", 3, L'俑'},
{"yong", 3, L'甬'},
{"yong", 4, L'佣'},
{"yong", 4, L'用'},
{"you", 1, L'幽'},
{"you", 1, L'优'},
{"you", 1, L'悠'},
{"you", 1, L'忧'},
{"you", 1, L'攸'},
{"you", 1, L'呦'},
{"you", 2, L'尤'},
{"you", 2, L'由'},
{"you", 2, L'邮'},
{"you", 2, L'铀'},
{"you", 2, L'犹'},
{"you", 2, L'油'},
{"you", 2, L'游'},
{"you", 2, L'莜'},
{"you", 2, L'莸'},
{"you", 2, L'柚'},
{"you", 2, L'猷'},
{"you", 2, L'疣'},
{"you", 2, L'蚰'},
{"you", 2, L'蝣'},
{"you", 2, L'蝤'},
{"you", 2, L'繇'},
{"you", 2, L'鱿'},
{"you", 3, L'酉'},
{"you", 3, L'有'},
{"you", 3, L'友'},
{"you", 3, L'卣'},
{"you", 3, L'莠'},
{"you", 3, L'牖'},
{"you", 3, L'铕'},
{"you", 3, L'黝'},
{"you", 4, L'有'},
{"you", 4, L'右'},
{"you", 4, L'佑'},
{"you", 4, L'釉'},
{"you", 4, L'诱'},
{"you", 4, L'又'},
{"you", 4, L'幼'},
{"you", 4, L'侑'},
{"you", 4, L'囿'},
{"you", 4, L'宥'},
{"you", 4, L'柚'},
{"you", 4, L'蚴'},
{"you", 4, L'鼬'},
{"yu", 1, L'迂'},
{"yu", 1, L'淤'},
{"yu", 1, L'纡'},
{"yu", 1, L'於'},
{"yu", 1, L'瘀'},
{"yu", 2, L'于'},
{"yu", 2, L'盂'},
{"yu", 2, L'榆'},
{"yu", 2, L'虞'},
{"yu", 2, L'愚'},
{"yu", 2, L'舆'},
{"yu", 2, L'余'},
{"yu", 2, L'俞'},
{"yu", 2, L'逾'},
{"yu", 2, L'鱼'},
{"yu", 2, L'愉'},
{"yu", 2, L'渝'},
{"yu", 2, L'渔'},
{"yu", 2, L'隅'},
{"yu", 2, L'予'},
{"yu", 2, L'娱'},
{"yu", 2, L'与'},
{"yu", 2, L'禺'},
{"yu", 2, L'谀'},
{"yu", 2, L'萸'},
{"yu", 2, L'揄'},
{"yu", 2, L'嵛'},
{"yu", 2, L'狳'},
{"yu", 2, L'馀'},
{"yu", 2, L'妤'},
{"yu", 2, L'瑜'},
{"yu", 2, L'觎'},
{"yu", 2, L'腴'},
{"yu", 2, L'欤'},
{"yu", 2, L'於'},
{"yu", 2, L'窬'},
{"yu", 2, L'蝓'},
{"yu", 2, L'竽'},
{"yu", 2, L'臾'},
{"yu", 2, L'舁'},
{"yu", 2, L'雩'},
{"yu", 3, L'予'},
{"yu", 3, L'雨'},
{"yu", 3, L'与'},
{"yu", 3, L'屿'},
{"yu", 3, L'禹'},
{"yu", 3, L'宇'},
{"yu", 3, L'语'},
{"yu", 3, L'羽'},
{"yu", 3, L'伛'},
{"yu", 3, L'俣'},
{"yu", 3, L'圄'},
{"yu", 3, L'圉'},
{"yu", 3, L'庾'},
{"yu", 3, L'瘐'},
{"yu", 3, L'窳'},
{"yu", 3, L'龉'},
{"yu", 4, L'谷'},
{"yu", 4, L'蔚'},
{"yu", 4, L'尉'},
{"yu", 4, L'雨'},
{"yu", 4, L'与'},
{"yu", 4, L'语'},
{"yu", 4, L'玉'},
{"yu", 4, L'域'},
{"yu", 4, L'芋'},
{"yu", 4, L'郁'},
{"yu", 4, L'吁'},
{"yu", 4, L'遇'},
{"yu", 4, L'喻'},
{"yu", 4, L'峪'},
{"yu", 4, L'御'},
{"yu", 4, L'愈'},
{"yu", 4, L'欲'},
{"yu", 4, L'狱'},
{"yu", 4, L'育'},
{"yu", 4, L'誉'},
{"yu", 4, L'浴'},
{"yu", 4, L'寓'},
{"yu", 4, L'裕'},
{"yu", 4, L'预'},
{"yu", 4, L'豫'},
{"yu", 4, L'驭'},
{"yu", 4, L'粥'},
{"yu", 4, L'毓'},
{"yu", 4, L'谕'},
{"yu", 4, L'蓣'},
{"yu", 4, L'饫'},
{"yu", 4, L'阈'},
{"yu", 4, L'鬻'},
{"yu", 4, L'妪'},
{"yu", 4, L'昱'},
{"yu", 4, L'煜'},
{"yu", 4, L'熨'},
{"yu", 4, L'燠'},
{"yu", 4, L'聿'},
{"yu", 4, L'钰'},
{"yu", 4, L'鹆'},
{"yu", 4, L'鹬'},
{"yu", 4, L'蜮'},
{"yuan", 1, L'鸳'},
{"yuan", 1, L'渊'},
{"yuan", 1, L'冤'},
{"yuan", 1, L'眢'},
{"yuan", 1, L'鸢'},
{"yuan", 1, L'箢'},
{"yuan", 2, L'元'},
{"yuan", 2, L'垣'},
{"yuan", 2, L'袁'},
{"yuan", 2, L'原'},
{"yuan", 2, L'援'},
{"yuan", 2, L'辕'},
{"yuan", 2, L'园'},
{"yuan", 2, L'员'},
{"yuan", 2, L'圆'},
{"yuan", 2, L'猿'},
{"yuan", 2, L'源'},
{"yuan", 2, L'缘'},
{"yuan", 2, L'塬'},
{"yuan", 2, L'芫'},
{"yuan", 2, L'圜'},
{"yuan", 2, L'沅'},
{"yuan", 2, L'媛'},
{"yuan", 2, L'橼'},
{"yuan", 2, L'爰'},
{"yuan", 2, L'螈'},
{"yuan", 2, L'鼋'},
{"yuan", 3, L'远'},
{"yuan", 4, L'苑'},
{"yuan", 4, L'愿'},
{"yuan", 4, L'怨'},
{"yuan", 4, L'院'},
{"yuan", 4, L'垸'},
{"yuan", 4, L'掾'},
{"yuan", 4, L'媛'},
{"yuan", 4, L'瑗'},
{"yue", 1, L'曰'},
{"yue", 1, L'约'},
{"yue", 3, L'哕'},
{"yue", 4, L'乐'},
{"yue", 4, L'说'},
{"yue", 4, L'越'},
{"yue", 4, L'跃'},
{"yue", 4, L'钥'},
{"yue", 4, L'岳'},
{"yue", 4, L'粤'},
{"yue", 4, L'月'},
{"yue", 4, L'悦'},
{"yue", 4, L'阅'},
{"yue", 4, L'龠'},
{"yue", 4, L'瀹'},
{"yue", 4, L'栎'},
{"yue", 4, L'樾'},
{"yue", 4, L'刖'},
{"yue", 4, L'钺'},
{"yun", 1, L'晕'},
{"yun", 1, L'氲'},
{"yun", 2, L'员'},
{"yun", 2, L'耘'},
{"yun", 2, L'云'},
{"yun", 2, L'郧'},
{"yun", 2, L'匀'},
{"yun", 2, L'芸'},
{"yun", 2, L'纭'},
{"yun", 2, L'昀'},
{"yun", 2, L'筠'},
{"yun", 3, L'陨'},
{"yun", 3, L'允'},
{"yun", 3, L'狁'},
{"yun", 3, L'殒'},
{"yun", 4, L'员'},
{"yun", 4, L'运'},
{"yun", 4, L'蕴'},
{"yun", 4, L'酝'},
{"yun", 4, L'晕'},
{"yun", 4, L'韵'},
{"yun", 4, L'孕'},
{"yun", 4, L'郓'},
{"yun", 4, L'恽'},
{"yun", 4, L'愠'},
{"yun", 4, L'韫'},
{"yun", 4, L'熨'},
{"za", 1, L'匝'},
{"za", 1, L'扎'},
{"za", 1, L'拶'},
{"za", 1, L'咂'},
{"za", 2, L'砸'},
{"za", 2, L'杂'},
{"za", 2, L'咱'},
{"za", 3, L'咋'},
{"zai", 1, L'栽'},
{"zai", 1, L'哉'},
{"zai", 1, L'灾'},
{"zai", 1, L'甾'},
{"zai", 3, L'宰'},
{"zai", 3, L'载'},
{"zai", 3, L'仔'},
{"zai", 3, L'崽'},
{"zai", 4, L'载'},
{"zai", 4, L'再'},
{"zai", 4, L'在'},
{"zan", 1, L'簪'},
{"zan", 1, L'糌'},
{"zan", 2, L'咱'},
{"zan", 3, L'攒'},
{"zan", 3, L'拶'},
{"zan", 3, L'昝'},
{"zan", 3, L'趱'},
{"zan", 4, L'暂'},
{"zan", 4, L'赞'},
{"zan", 4, L'瓒'},
{"zan", 4, L'錾'},
{"zan", 5, L'咱'},
{"zang", 1, L'赃'},
{"zang", 1, L'脏'},
{"zang", 1, L'臧'},
{"zang", 3, L'驵'},
{"zang", 4, L'藏'},
{"zang", 4, L'脏'},
{"zang", 4, L'葬'},
{"zang", 4, L'奘'},
{"zao", 1, L'遭'},
{"zao", 1, L'糟'},
{"zao", 2, L'凿'},
{"zao", 3, L'藻'},
{"zao", 3, L'枣'},
{"zao", 3, L'早'},
{"zao", 3, L'澡'},
{"zao", 3, L'蚤'},
{"zao", 4, L'躁'},
{"zao", 4, L'噪'},
{"zao", 4, L'造'},
{"zao", 4, L'皂'},
{"zao", 4, L'灶'},
{"zao", 4, L'燥'},
{"zao", 4, L'唣'},
{"ze", 2, L'责'},
{"ze", 2, L'择'},
{"ze", 2, L'则'},
{"ze", 2, L'泽'},
{"ze", 2, L'赜'},
{"ze", 2, L'啧'},
{"ze", 2, L'帻'},
{"ze", 2, L'迮'},
{"ze", 2, L'笮'},
{"ze", 2, L'箦'},
{"ze", 2, L'舴'},
{"ze", 4, L'侧'},
{"ze", 4, L'仄'},
{"ze", 4, L'昃'},
{"zei", 2, L'贼'},
{"zen", 3, L'怎'},
{"zen", 4, L'谮'},
{"zeng", 1, L'增'},
{"zeng", 1, L'憎'},
{"zeng", 1, L'曾'},
{"zeng", 1, L'缯'},
{"zeng", 1, L'罾'},
{"zeng", 4, L'赠'},
{"zeng", 4, L'综'},
{"zeng", 4, L'缯'},
{"zeng", 4, L'甑'},
{"zeng", 4, L'锃'},
{"zha", 1, L'茬'},
{"zha", 1, L'查'},
{"zha", 1, L'扎'},
{"zha", 1, L'喳'},
{"zha", 1, L'渣'},
{"zha", 1, L'咋'},
{"zha", 1, L'揸'},
{"zha", 1, L'吒'},
{"zha", 1, L'哳'},
{"zha", 1, L'齄'},
{"zha", 2, L'扎'},
{"zha", 2, L'札'},
{"zha", 2, L'轧'},
{"zha", 2, L'铡'},
{"zha", 2, L'闸'},
{"zha", 2, L'炸'},
{"zha", 3, L'眨'},
{"zha", 3, L'砟'},
{"zha", 4, L'蜡'},
{"zha", 4, L'栅'},
{"zha", 4, L'榨'},
{"zha", 4, L'咋'},
{"zha", 4, L'乍'},
{"zha", 4, L'炸'},
{"zha", 4, L'诈'},
{"zha", 4, L'柞'},
{"zha", 4, L'吒'},
{"zha", 4, L'咤'},
{"zha", 4, L'痄'},
{"zha", 4, L'蚱'},
{"zhai", 1, L'侧'},
{"zhai", 1, L'摘'},
{"zhai", 1, L'斋'},
{"zhai", 2, L'翟'},
{"zhai", 2, L'择'},
{"zhai", 2, L'宅'},
{"zhai", 3, L'窄'},
{"zhai", 4, L'债'},
{"zhai", 4, L'寨'},
{"zhai", 4, L'砦'},
{"zhai", 4, L'瘵'},
{"zhan", 1, L'瞻'},
{"zhan", 1, L'毡'},
{"zhan", 1, L'詹'},
{"zhan", 1, L'粘'},
{"zhan", 1, L'沾'},
{"zhan", 1, L'占'},
{"zhan", 1, L'谵'},
{"zhan", 1, L'旃'},
{"zhan", 3, L'盏'},
{"zhan", 3, L'斩'},
{"zhan", 3, L'辗'},
{"zhan", 3, L'崭'},
{"zhan", 3, L'展'},
{"zhan", 3, L'搌'},
{"zhan", 4, L'颤'},
{"zhan", 4, L'蘸'},
{"zhan", 4, L'栈'},
{"zhan", 4, L'占'},
{"zhan", 4, L'战'},
{"zhan", 4, L'站'},
{"zhan", 4, L'湛'},
{"zhan", 4, L'绽'},
{"zhang", 1, L'樟'},
{"zhang", 1, L'章'},
{"zhang", 1, L'彰'},
{"zhang", 1, L'漳'},
{"zhang", 1, L'张'},
{"zhang", 1, L'鄣'},
{"zhang", 1, L'獐'},
{"zhang", 1, L'嫜'},
{"zhang", 1, L'璋'},
{"zhang", 1, L'蟑'},
{"zhang", 3, L'长'},
{"zhang", 3, L'掌'},
{"zhang", 3, L'涨'},
{"zhang", 3, L'仉'},
{"zhang", 4, L'涨'},
{"zhang", 4, L'杖'},
{"zhang", 4, L'丈'},
{"zhang", 4, L'帐'},
{"zhang", 4, L'账'},
{"zhang", 4, L'仗'},
{"zhang", 4, L'胀'},
{"zhang", 4, L'瘴'},
{"zhang", 4, L'障'},
{"zhang", 4, L'幛'},
{"zhang", 4, L'嶂'},
{"zhao", 1, L'朝'},
{"zhao", 1, L'嘲'},
{"zhao", 1, L'招'},
{"zhao", 1, L'昭'},
{"zhao", 1, L'着'},
{"zhao", 1, L'啁'},
{"zhao", 1, L'钊'},
{"zhao", 2, L'着'},
{"zhao", 3, L'找'},
{"zhao", 3, L'沼'},
{"zhao", 3, L'爪'},
{"zhao", 4, L'赵'},
{"zhao", 4, L'照'},
{"zhao", 4, L'罩'},
{"zhao", 4, L'兆'},
{"zhao", 4, L'肇'},
{"zhao", 4, L'召'},
{"zhao", 4, L'诏'},
{"zhao", 4, L'棹'},
{"zhao", 4, L'笊'},
{"zhe", 1, L'遮'},
{"zhe", 1, L'折'},
{"zhe", 1, L'蜇'},
{"zhe", 1, L'螫'},
{"zhe", 2, L'折'},
{"zhe", 2, L'哲'},
{"zhe", 2, L'蛰'},
{"zhe", 2, L'辙'},
{"zhe", 2, L'谪'},
{"zhe", 2, L'摺'},
{"zhe", 2, L'辄'},
{"zhe", 2, L'磔'},
{"zhe", 2, L'蜇'},
{"zhe", 3, L'者'},
{"zhe", 3, L'锗'},
{"zhe", 3, L'褶'},
{"zhe", 3, L'赭'},
{"zhe", 4, L'蔗'},
{"zhe", 4, L'这'},
{"zhe", 4, L'浙'},
{"zhe", 4, L'柘'},
{"zhe", 4, L'鹧'},
{"zhe", 5, L'着'},
{"zhei", 4, L'这'},
{"zhen", 1, L'珍'},
{"zhen", 1, L'斟'},
{"zhen", 1, L'真'},
{"zhen", 1, L'甄'},
{"zhen", 1, L'砧'},
{"zhen", 1, L'臻'},
{"zhen", 1, L'贞'},
{"zhen", 1, L'针'},
{"zhen", 1, L'侦'},
{"zhen", 1, L'帧'},
{"zhen", 1, L'蓁'},
{"zhen", 1, L'浈'},
{"zhen", 1, L'溱'},
{"zhen", 1, L'桢'},
{"zhen", 1, L'榛'},
{"zhen", 1, L'胗'},
{"zhen", 1, L'祯'},
{"zhen", 1, L'箴'},
{"zhen", 3, L'枕'},
{"zhen", 3, L'疹'},
{"zhen", 3, L'诊'},
{"zhen", 3, L'缜'},
{"zhen", 3, L'轸'},
{"zhen", 3, L'畛'},
{"zhen", 3, L'稹'},
{"zhen", 4, L'震'},
{"zhen", 4, L'振'},
{"zhen", 4, L'镇'},
{"zhen", 4, L'阵'},
{"zhen", 4, L'圳'},
{"zhen", 4, L'椹'},
{"zhen", 4, L'赈'},
{"zhen", 4, L'朕'},
{"zhen", 4, L'鸩'},
{"zheng", 1, L'丁'},
{"zheng", 1, L'蒸'},
{"zheng", 1, L'挣'},
{"zheng", 1, L'睁'},
{"zheng", 1, L'征'},
{"zheng", 1, L'狰'},
{"zheng", 1, L'争'},
{"zheng", 1, L'怔'},
{"zheng", 1, L'正'},
{"zheng", 1, L'症'},
{"zheng", 1, L'峥'},
{"zheng", 1, L'徵'},
{"zheng", 1, L'钲'},
{"zheng", 1, L'铮'},
{"zheng", 1, L'筝'},
{"zheng", 3, L'整'},
{"zheng", 3, L'拯'},
{"zheng", 4, L'挣'},
{"zheng", 4, L'正'},
{"zheng", 4, L'政'},
{"zheng", 4, L'症'},
{"zheng", 4, L'郑'},
{"zheng", 4, L'证'},
{"zheng", 4, L'诤'},
{"zheng", 4, L'钲'},
{"zhi", 1, L'氏'},
{"zhi", 1, L'芝'},
{"zhi", 1, L'枝'},
{"zhi", 1, L'支'},
{"zhi", 1, L'吱'},
{"zhi", 1, L'蜘'},
{"zhi", 1, L'知'},
{"zhi", 1, L'肢'},
{"zhi", 1, L'脂'},
{"zhi", 1, L'汁'},
{"zhi", 1, L'之'},
{"zhi", 1, L'织'},
{"zhi", 1, L'只'},
{"zhi", 1, L'卮'},
{"zhi", 1, L'栀'},
{"zhi", 1, L'胝'},
{"zhi", 1, L'祗'},
{"zhi", 2, L'职'},
{"zhi", 2, L'直'},
{"zhi", 2, L'植'},
{"zhi", 2, L'殖'},
{"zhi", 2, L'执'},
{"zhi", 2, L'值'},
{"zhi", 2, L'侄'},
{"zhi", 2, L'埴'},
{"zhi", 2, L'摭'},
{"zhi", 2, L'絷'},
{"zhi", 2, L'跖'},
{"zhi", 2, L'踯'},
{"zhi", 3, L'址'},
{"zhi", 3, L'指'},
{"zhi", 3, L'止'},
{"zhi", 3, L'趾'},
{"zhi", 3, L'只'},
{"zhi", 3, L'旨'},
{"zhi", 3, L'纸'},
{"zhi", 3, L'芷'},
{"zhi", 3, L'徵'},
{"zhi", 3, L'咫'},
{"zhi", 3, L'枳'},
{"zhi", 3, L'轵'},
{"zhi", 3, L'祉'},
{"zhi", 3, L'黹'},
{"zhi", 3, L'酯'},
{"zhi", 4, L'识'},
{"zhi", 4, L'志'},
{"zhi", 4, L'挚'},
{"zhi", 4, L'掷'},
{"zhi", 4, L'至'},
{"zhi", 4, L'致'},
{"zhi", 4, L'置'},
{"zhi", 4, L'帜'},
{"zhi", 4, L'峙'},
{"zhi", 4, L'制'},
{"zhi", 4, L'智'},
{"zhi", 4, L'秩'},
{"zhi", 4, L'稚'},
{"zhi", 4, L'质'},
{"zhi", 4, L'炙'},
{"zhi", 4, L'痔'},
{"zhi", 4, L'滞'},
{"zhi", 4, L'治'},
{"zhi", 4, L'窒'},
{"zhi", 4, L'陟'},
{"zhi", 4, L'郅'},
{"zhi", 4, L'帙'},
{"zhi", 4, L'忮'},
{"zhi", 4, L'彘'},
{"zhi", 4, L'骘'},
{"zhi", 4, L'栉'},
{"zhi", 4, L'桎'},
{"zhi", 4, L'轾'},
{"zhi", 4, L'贽'},
{"zhi", 4, L'膣'},
{"zhi", 4, L'雉'},
{"zhi", 4, L'鸷'},
{"zhi", 4, L'痣'},
{"zhi", 4, L'蛭'},
{"zhi", 4, L'踬'},
{"zhi", 4, L'豸'},
{"zhi", 4, L'觯'},
{"zhong", 1, L'中'},
{"zhong", 1, L'盅'},
{"zhong", 1, L'忠'},
{"zhong", 1, L'钟'},
{"zhong", 1, L'衷'},
{"zhong", 1, L'终'},
{"zhong", 1, L'忪'},
{"zhong", 1, L'锺'},
{"zhong", 1, L'螽'},
{"zhong", 1, L'舯'},
{"zhong", 3, L'种'},
{"zhong", 3, L'肿'},
{"zhong", 3, L'冢'},
{"zhong", 3, L'踵'},
{"zhong", 4, L'中'},
{"zhong", 4, L'种'},
{"zhong", 4, L'重'},
{"zhong", 4, L'仲'},
{"zhong", 4, L'众'},
{"zhou", 1, L'舟'},
{"zhou", 1, L'周'},
{"zhou", 1, L'州'},
{"zhou", 1, L'洲'},
{"zhou", 1, L'诌'},
{"zhou", 1, L'粥'},
{"zhou", 1, L'啁'},
{"zhou", 2, L'轴'},
{"zhou", 2, L'妯'},
{"zhou", 2, L'碡'},
{"zhou", 3, L'肘'},
{"zhou", 3, L'帚'},
{"zhou", 4, L'轴'},
{"zhou", 4, L'咒'},
{"zhou", 4, L'皱'},
{"zhou", 4, L'宙'},
{"zhou", 4, L'昼'},
{"zhou", 4, L'骤'},
{"zhou", 4, L'荮'},
{"zhou", 4, L'纣'},
{"zhou", 4, L'绉'},
{"zhou", 4, L'胄'},
{"zhou", 4, L'籀'},
{"zhou", 4, L'酎'},
{"zhu", 1, L'珠'},
{"zhu", 1, L'株'},
{"zhu", 1, L'蛛'},
{"zhu", 1, L'朱'},
{"zhu", 1, L'猪'},
{"zhu", 1, L'诸'},
{"zhu", 1, L'诛'},
{"zhu", 1, L'侏'},
{"zhu", 1, L'邾'},
{"zhu", 1, L'茱'},
{"zhu", 1, L'洙'},
{"zhu", 1, L'潴'},
{"zhu", 1, L'槠'},
{"zhu", 1, L'橥'},
{"zhu", 1, L'铢'},
{"zhu", 2, L'术'},
{"zhu", 2, L'逐'},
{"zhu", 2, L'竹'},
{"zhu", 2, L'烛'},
{"zhu", 2, L'筑'},
{"zhu", 2, L'瘃'},
{"zhu", 2, L'竺'},
{"zhu", 2, L'舳'},
{"zhu", 2, L'躅'},
{"zhu", 3, L'属'},
{"zhu", 3, L'煮'},
{"zhu", 3, L'拄'},
{"zhu", 3, L'瞩'},
{"zhu", 3, L'嘱'},
{"zhu", 3, L'主'},
{"zhu", 3, L'渚'},
{"zhu", 3, L'麈'},
{"zhu", 4, L'著'},
{"zhu", 4, L'柱'},
{"zhu", 4, L'助'},
{"zhu", 4, L'蛀'},
{"zhu", 4, L'贮'},
{"zhu", 4, L'铸'},
{"zhu", 4, L'住'},
{"zhu", 4, L'注'},
{"zhu", 4, L'祝'},
{"zhu", 4, L'驻'},
{"zhu", 4, L'伫'},
{"zhu", 4, L'苎'},
{"zhu", 4, L'杼'},
{"zhu", 4, L'炷'},
{"zhu", 4, L'疰'},
{"zhu", 4, L'箸'},
{"zhu", 4, L'翥'},
{"zhua", 1, L'抓'},
{"zhua", 1, L'莴'},
{"zhua", 3, L'爪'},
{"zhuai", 1, L'拽'},
{"zhuai", 3, L'转'},
{"zhuai", 4, L'拽'},
{"zhuan", 1, L'专'},
{"zhuan", 1, L'砖'},
{"zhuan", 1, L'颛'},
{"zhuan", 3, L'转'},
{"zhuan", 4, L'传'},
{"zhuan", 4, L'转'},
{"zhuan", 4, L'撰'},
{"zhuan", 4, L'赚'},
{"zhuan", 4, L'篆'},
{"zhuan", 4, L'啭'},
{"zhuan", 4, L'馔'},
{"zhuang", 1, L'桩'},
{"zhuang", 1, L'庄'},
{"zhuang", 1, L'装'},
{"zhuang", 1, L'妆'},
{"zhuang", 3, L'奘'},
{"zhuang", 4, L'幢'},
{"zhuang", 4, L'撞'},
{"zhuang", 4, L'壮'},
{"zhuang", 4, L'状'},
{"zhuang", 4, L'僮'},
{"zhuang", 4, L'戆'},
{"zhui", 1, L'椎'},
{"zhui", 1, L'锥'},
{"zhui", 1, L'追'},
{"zhui", 1, L'骓'},
{"zhui", 1, L'隹'},
{"zhui", 4, L'赘'},
{"zhui", 4, L'坠'},
{"zhui", 4, L'缀'},
{"zhui", 4, L'惴'},
{"zhui", 4, L'缒'},
{"zhun", 1, L'屯'},
{"zhun", 1, L'谆'},
{"zhun", 1, L'肫'},
{"zhun", 1, L'窀'},
{"zhun", 3, L'准'},
{"zhuo", 1, L'捉'},
{"zhuo", 1, L'拙'},
{"zhuo", 1, L'桌'},
{"zhuo", 1, L'倬'},
{"zhuo", 1, L'涿'},
{"zhuo", 1, L'棹'},
{"zhuo", 1, L'焯'},
{"zhuo", 2, L'缴'},
{"zhuo", 2, L'著'},
{"zhuo", 2, L'卓'},
{"zhuo", 2, L'琢'},
{"zhuo", 2, L'茁'},
{"zhuo", 2, L'酌'},
{"zhuo", 2, L'啄'},
{"zhuo", 2, L'着'},
{"zhuo", 2, L'灼'},
{"zhuo", 2, L'浊'},
{"zhuo", 2, L'诼'},
{"zhuo", 2, L'擢'},
{"zhuo", 2, L'浞'},
{"zhuo", 2, L'濯'},
{"zhuo", 2, L'禚'},
{"zhuo", 2, L'斫'},
{"zhuo", 2, L'镯'},
{"zi", 1, L'吱'},
{"zi", 1, L'兹'},
{"zi", 1, L'咨'},
{"zi", 1, L'资'},
{"zi", 1, L'姿'},
{"zi", 1, L'滋'},
{"zi", 1, L'淄'},
{"zi", 1, L'孜'},
{"zi", 1, L'仔'},
{"zi", 1, L'谘'},
{"zi", 1, L'嵫'},
{"zi", 1, L'孳'},
{"zi", 1, L'缁'},
{"zi", 1, L'辎'},
{"zi", 1, L'赀'},
{"zi", 1, L'锱'},
{"zi", 1, L'粢'},
{"zi", 1, L'趑'},
{"zi", 1, L'觜'},
{"zi", 1, L'訾'},
{"zi", 1, L'龇'},
{"zi", 1, L'鲻'},
{"zi", 1, L'髭'},
{"zi", 3, L'紫'},
{"zi", 3, L'仔'},
{"zi", 3, L'籽'},
{"zi", 3, L'滓'},
{"zi", 3, L'子'},
{"zi", 3, L'茈'},
{"zi", 3, L'姊'},
{"zi", 3, L'梓'},
{"zi", 3, L'秭'},
{"zi", 3, L'耔'},
{"zi", 3, L'笫'},
{"zi", 3, L'訾'},
{"zi", 4, L'自'},
{"zi", 4, L'渍'},
{"zi", 4, L'字'},
{"zi", 4, L'恣'},
{"zi", 4, L'眦'},
{"zong", 1, L'鬃'},
{"zong", 1, L'棕'},
{"zong", 1, L'踪'},
{"zong", 1, L'宗'},
{"zong", 1, L'综'},
{"zong", 1, L'枞'},
{"zong", 1, L'腙'},
{"zong", 3, L'总'},
{"zong", 3, L'偬'},
{"zong", 4, L'纵'},
{"zong", 4, L'粽'},
{"zou", 1, L'邹'},
{"zou", 1, L'诹'},
{"zou", 1, L'陬'},
{"zou", 1, L'鄹'},
{"zou", 1, L'驺'},
{"zou", 1, L'鲰'},
{"zou", 3, L'走'},
{"zou", 4, L'奏'},
{"zou", 4, L'揍'},
{"zu", 1, L'租'},
{"zu", 1, L'菹'},
{"zu", 2, L'足'},
{"zu", 2, L'卒'},
{"zu", 2, L'族'},
{"zu", 2, L'镞'},
{"zu", 3, L'祖'},
{"zu", 3, L'诅'},
{"zu", 3, L'阻'},
{"zu", 3, L'组'},
{"zu", 3, L'俎'},
{"zuan", 1, L'钻'},
{"zuan", 1, L'躜'},
{"zuan", 3, L'纂'},
{"zuan", 3, L'缵'},
{"zuan", 4, L'赚'},
{"zuan", 4, L'钻'},
{"zuan", 4, L'攥'},
{"zui", 3, L'咀'},
{"zui", 3, L'嘴'},
{"zui", 3, L'觜'},
{"zui", 4, L'醉'},
{"zui", 4, L'最'},
{"zui", 4, L'罪'},
{"zui", 4, L'蕞'},
{"zun", 1, L'尊'},
{"zun", 1, L'遵'},
{"zun", 1, L'樽'},
{"zun", 1, L'鳟'},
{"zun", 3, L'撙'},
{"zuo", 1, L'作'},
{"zuo", 1, L'嘬'},
{"zuo", 2, L'昨'},
{"zuo", 2, L'笮'},
{"zuo", 3, L'撮'},
{"zuo", 3, L'左'},
{"zuo", 3, L'佐'},
{"zuo", 4, L'柞'},
{"zuo", 4, L'做'},
{"zuo", 4, L'作'},
{"zuo", 4, L'坐'},
{"zuo", 4, L'座'},
{"zuo", 4, L'阼'},
{"zuo", 4, L'唑'},
{"zuo", 4, L'怍'},
{"zuo", 4, L'胙'},
{"zuo", 4, L'祚'},
{"zuo", 4, L'酢'},
{NULL, 1, L'啊'}
};



WIZCHINESEWORDPINYINDATA* GetPinYinArray()
{
	return ::g_PinYinData;
}

