# -*- coding: utf-8 -*-

# Simpilfied Chinese to Traditional Chinese
S_2_T = {
    "㑇" : ("㑳", ),  # 3447 => 3473
    "㖞" : ("喎", ),  # 359E => 558E
    "㘎" : ("㘚", ),  # 360E => 361A
    "㤘" : ("㥮", ),  # 3918 => 396E
    "㧏" : ("掆", ),  # 39CF => 6386
    "㧐" : ("㩳", ),  # 39D0 => 3A73
    "㧟" : ("擓", ),  # 39DF => 64D3
    "㭎" : ("棡", ),  # 3B4E => 68E1
    "㳠" : ("澾", ),  # 3CE0 => 6FBE
    "䁖" : ("瞜", ),  # 4056 => 779C
    "䅟" : ("穇", ),  # 415F => 7A47
    "䌷" : ("紬", ),  # 4337 => 7D2C
    "䎬" : ("䎱", ),  # 43AC => 43B1
    "䏝" : ("膞", ),  # 43DD => 819E
    "䓖" : ("藭", ),  # 44D6 => 85ED
    "䙌" : ("䙡", ),  # 464C => 4661
    "䜣" : ("訢", ),  # 4723 => 8A22
    "䜩" : ("讌", ),  # 4729 => 8B8C
    "䞍" : ("䝼", ),  # 478D => 477C
    "䥺" : ("釾", ),  # 497A => 91FE
    "䥽" : ("鏺", ),  # 497D => 93FA
    "䦂" : ("䥇", ),  # 4982 => 4947
    "䦃" : ("鐯", ),  # 4983 => 942F
    "䦅" : ("鐥", ),  # 4985 => 9425
    "䦆" : ("钁", ),  # 4986 => 9481
    "䦶" : ("䦛", ),  # 49B6 => 499B
    "䦷" : ("䦟", ),  # 49B7 => 499F
    "䲟" : ("鮣", ),  # 4C9F => 9BA3
    "䲠" : ("鰆", ),  # 4CA0 => 9C06
    "䲡" : ("鰌", ),  # 4CA1 => 9C0C
    "䲢" : ("鰧", ),  # 4CA2 => 9C27
    "䲣" : ("䱷", ),  # 4CA3 => 4C77
    "䴓" : ("鳾", ),  # 4D13 => 9CFE
    "䴔" : ("鵁", ),  # 4D14 => 9D41
    "䴕" : ("鴷", ),  # 4D15 => 9D37
    "䴖" : ("鶄", ),  # 4D16 => 9D84
    "䴗" : ("鶪", ),  # 4D17 => 9DAA
    "䴘" : ("鷉", ),  # 4D18 => 9DC9
    "䴙" : ("鸊", ),  # 4D19 => 9E0A
    "䶮" : ("龑", ),  # 4DAE => 9F91
    "万" : ("萬", ),  # 4E07 => 842C
    "与" : ("與", ),  # 4E0E => 8207
    "丑" : ("醜", ),  # 4E11 => 919C
    "专" : ("專", ),  # 4E13 => 5C08
    "业" : ("業", ),  # 4E1A => 696D
    "丛" : ("叢", ),  # 4E1B => 53E2
    "东" : ("東", ),  # 4E1C => 6771
    "丝" : ("絲", ),  # 4E1D => 7D72
    "丢" : ("丟", ),  # 4E22 => 4E1F
    "两" : ("兩", ),  # 4E24 => 5169
    "严" : ("嚴", ),  # 4E25 => 56B4
    "丧" : ("喪", ),  # 4E27 => 55AA
    "个" : ("個", ),  # 4E2A => 500B
    "丬" : ("爿", ),  # 4E2C => 723F
    "丰" : ("豐", ),  # 4E30 => 8C50
    "临" : ("臨", ),  # 4E34 => 81E8
    "为" : ("為", ),  # 4E3A => 70BA
    "丽" : ("麗", ),  # 4E3D => 9E97
    "举" : ("舉", ),  # 4E3E => 8209
    "么" : ("麼", "麽"),  # 4E48 => 9EBC 9EBD
    "义" : ("義", ),  # 4E49 => 7FA9
    "乌" : ("烏", ),  # 4E4C => 70CF
    "乐" : ("樂", ),  # 4E50 => 6A02
    "乔" : ("喬", ),  # 4E54 => 55AC
    "习" : ("習", ),  # 4E60 => 7FD2
    "乡" : ("鄉", ),  # 4E61 => 9109
    "书" : ("書", ),  # 4E66 => 66F8
    "买" : ("買", ),  # 4E70 => 8CB7
    "乱" : ("亂", ),  # 4E71 => 4E82
    "了" : ("瞭", ),  # 4E86 => 77AD
    "争" : ("爭", ),  # 4E89 => 722D
    "亏" : ("虧", ),  # 4E8F => 8667
    "云" : ("雲", ),  # 4E91 => 96F2
    "亘" : ("亙", ),  # 4E98 => 4E99
    "亚" : ("亞", ),  # 4E9A => 4E9E
    "产" : ("產", "産"),  # 4EA7 => 7522 7523
    "亩" : ("畝", ),  # 4EA9 => 755D
    "亲" : ("親", ),  # 4EB2 => 89AA
    "亵" : ("褻", ),  # 4EB5 => 893B
    "亿" : ("億", ),  # 4EBF => 5104
    "仅" : ("僅", ),  # 4EC5 => 50C5
    "仆" : ("僕", ),  # 4EC6 => 50D5
    "从" : ("從", ),  # 4ECE => 5F9E
    "仑" : ("侖", ),  # 4ED1 => 4F96
    "仓" : ("倉", ),  # 4ED3 => 5009
    "仪" : ("儀", ),  # 4EEA => 5100
    "们" : ("們", ),  # 4EEC => 5011
    "价" : ("價", ),  # 4EF7 => 50F9
    "众" : ("眾", "衆"),  # 4F17 => 773E 8846
    "优" : ("優", ),  # 4F18 => 512A
    "伙" : ("夥", ),  # 4F19 => 5925
    "会" : ("會", ),  # 4F1A => 6703
    "伛" : ("傴", ),  # 4F1B => 50B4
    "伞" : ("傘", ),  # 4F1E => 5098
    "伟" : ("偉", ),  # 4F1F => 5049
    "传" : ("傳", ),  # 4F20 => 50B3
    "伤" : ("傷", ),  # 4F24 => 50B7
    "伥" : ("倀", ),  # 4F25 => 5000
    "伦" : ("倫", ),  # 4F26 => 502B
    "伧" : ("傖", ),  # 4F27 => 5096
    "伪" : ("偽", "僞"),  # 4F2A => 507D 50DE
    "伫" : ("佇", ),  # 4F2B => 4F47
    "体" : ("體", ),  # 4F53 => 9AD4
    "余" : ("餘", ),  # 4F59 => 9918
    "佣" : ("傭", ),  # 4F63 => 50AD
    "佥" : ("僉", ),  # 4F65 => 50C9
    "侠" : ("俠", ),  # 4FA0 => 4FE0
    "侣" : ("侶", ),  # 4FA3 => 4FB6
    "侥" : ("僥", ),  # 4FA5 => 50E5
    "侦" : ("偵", ),  # 4FA6 => 5075
    "侧" : ("側", ),  # 4FA7 => 5074
    "侨" : ("僑", ),  # 4FA8 => 50D1
    "侩" : ("儈", ),  # 4FA9 => 5108
    "侪" : ("儕", ),  # 4FAA => 5115
    "侬" : ("儂", ),  # 4FAC => 5102
    "俣" : ("俁", ),  # 4FE3 => 4FC1
    "俦" : ("儔", ),  # 4FE6 => 5114
    "俨" : ("儼", ),  # 4FE8 => 513C
    "俩" : ("倆", ),  # 4FE9 => 5006
    "俪" : ("儷", ),  # 4FEA => 5137
    "俭" : ("儉", ),  # 4FED => 5109
    "借" : ("藉", ),  # 501F => 85C9
    "债" : ("債", ),  # 503A => 50B5
    "倾" : ("傾", ),  # 503E => 50BE
    "偬" : ("傯", ),  # 506C => 50AF
    "偻" : ("僂", ),  # 507B => 50C2
    "偾" : ("僨", ),  # 507E => 50E8
    "偿" : ("償", ),  # 507F => 511F
    "傥" : ("儻", ),  # 50A5 => 513B
    "傧" : ("儐", ),  # 50A7 => 5110
    "储" : ("儲", ),  # 50A8 => 5132
    "傩" : ("儺", ),  # 50A9 => 513A
    "儿" : ("兒", ),  # 513F => 5152
    "克" : ("剋", ),  # 514B => 524B
    "兑" : ("兌", ),  # 5151 => 514C
    "兖" : ("兗", ),  # 5156 => 5157
    "党" : ("黨", ),  # 515A => 9EE8
    "兰" : ("蘭", ),  # 5170 => 862D
    "关" : ("關", ),  # 5173 => 95DC
    "兴" : ("興", ),  # 5174 => 8208
    "兹" : ("茲", ),  # 5179 => 8332
    "养" : ("養", ),  # 517B => 990A
    "兽" : ("獸", ),  # 517D => 7378
    "冁" : ("囅", ),  # 5181 => 56C5
    "内" : ("內", ),  # 5185 => 5167
    "冈" : ("岡", ),  # 5188 => 5CA1
    "册" : ("冊", ),  # 518C => 518A
    "写" : ("寫", ),  # 5199 => 5BEB
    "军" : ("軍", ),  # 519B => 8ECD
    "农" : ("農", ),  # 519C => 8FB2
    "冢" : ("塚", ),  # 51A2 => 585A
    "冬" : ("鼕", ),  # 51AC => 9F15
    "冯" : ("馮", ),  # 51AF => 99AE
    "冲" : ("沖", "衝"),  # 51B2 => 6C96 885D
    "决" : ("決", ),  # 51B3 => 6C7A
    "况" : ("況", ),  # 51B5 => 6CC1
    "冻" : ("凍", ),  # 51BB => 51CD
    "净" : ("淨", ),  # 51C0 => 6DE8
    "凄" : ("淒", ),  # 51C4 => 6DD2
    "准" : ("凖", ),  # 51C6 => 51D6
    "凉" : ("涼", ),  # 51C9 => 6DBC
    "凌" : ("淩", ),  # 51CC => 6DE9
    "减" : ("減", ),  # 51CF => 6E1B
    "凑" : ("湊", ),  # 51D1 => 6E4A
    "凛" : ("凜", ),  # 51DB => 51DC
    "几" : ("幾", ),  # 51E0 => 5E7E
    "凤" : ("鳳", ),  # 51E4 => 9CF3
    "凫" : ("鳧", "鳬"),  # 51EB => 9CE7 9CEC
    "凭" : ("憑", ),  # 51ED => 6191
    "凯" : ("凱", ),  # 51EF => 51F1
    "出" : ("齣", ),  # 51FA => 9F63
    "击" : ("撃", "擊"),  # 51FB => 6483 64CA
    "凼" : ("氹", ),  # 51FC => 6C39
    "凿" : ("鑿", ),  # 51FF => 947F
    "刍" : ("芻", ),  # 520D => 82BB
    "划" : ("劃", ),  # 5212 => 5283
    "刘" : ("劉", ),  # 5218 => 5289
    "则" : ("則", ),  # 5219 => 5247
    "刚" : ("剛", ),  # 521A => 525B
    "创" : ("創", ),  # 521B => 5275
    "删" : ("刪", ),  # 5220 => 522A
    "别" : ("別", "彆"),  # 522B => 5225 5F46
    "刬" : ("剗", ),  # 522C => 5257
    "刭" : ("剄", ),  # 522D => 5244
    "刮" : ("颳", ),  # 522E => 98B3
    "制" : ("製", ),  # 5236 => 88FD
    "刽" : ("劊", ),  # 523D => 528A
    "刿" : ("劌", ),  # 523F => 528C
    "剀" : ("剴", ),  # 5240 => 5274
    "剂" : ("劑", ),  # 5242 => 5291
    "剐" : ("剮", ),  # 5250 => 526E
    "剑" : ("劍", ),  # 5251 => 528D
    "剥" : ("剝", ),  # 5265 => 525D
    "剧" : ("劇", ),  # 5267 => 5287
    "劝" : ("勸", ),  # 529D => 52F8
    "办" : ("辦", ),  # 529E => 8FA6
    "务" : ("務", ),  # 52A1 => 52D9
    "劢" : ("勱", ),  # 52A2 => 52F1
    "动" : ("動", ),  # 52A8 => 52D5
    "励" : ("勵", ),  # 52B1 => 52F5
    "劲" : ("勁", ),  # 52B2 => 52C1
    "劳" : ("勞", ),  # 52B3 => 52DE
    "势" : ("勢", ),  # 52BF => 52E2
    "勋" : ("勛", "勳"),  # 52CB => 52DB 52F3
    "勐" : ("猛", ),  # 52D0 => 731B
    "勚" : ("勩", ),  # 52DA => 52E9
    "匀" : ("勻", ),  # 5300 => 52FB
    "匦" : ("匭", ),  # 5326 => 532D
    "匮" : ("匱", ),  # 532E => 5331
    "区" : ("區", ),  # 533A => 5340
    "医" : ("醫", ),  # 533B => 91AB
    "千" : ("韆", ),  # 5343 => 97C6
    "华" : ("華", ),  # 534E => 83EF
    "协" : ("協", ),  # 534F => 5354
    "单" : ("單", ),  # 5355 => 55AE
    "卖" : ("賣", ),  # 5356 => 8CE3
    "卜" : ("蔔", ),  # 535C => 8514
    "卢" : ("盧", ),  # 5362 => 76E7
    "卤" : ("滷", "鹵"),  # 5364 => 6EF7 9E75
    "卧" : ("臥", ),  # 5367 => 81E5
    "卫" : ("衛", ),  # 536B => 885B
    "却" : ("卻", ),  # 5374 => 537B
    "卷" : ("捲", ),  # 5377 => 6372
    "卺" : ("巹", ),  # 537A => 5DF9
    "厂" : ("廠", ),  # 5382 => 5EE0
    "厅" : ("廳", ),  # 5385 => 5EF3
    "历" : ("曆", "歷"),  # 5386 => 66C6 6B77
    "厉" : ("厲", ),  # 5389 => 53B2
    "压" : ("壓", ),  # 538B => 58D3
    "厌" : ("厭", ),  # 538C => 53AD
    "厍" : ("厙", ),  # 538D => 5399
    "厕" : ("厠", "廁"),  # 5395 => 53A0 5EC1
    "厢" : ("廂", ),  # 53A2 => 5EC2
    "厣" : ("厴", ),  # 53A3 => 53B4
    "厦" : ("廈", ),  # 53A6 => 5EC8
    "厨" : ("廚", ),  # 53A8 => 5EDA
    "厩" : ("廄", ),  # 53A9 => 5EC4
    "厮" : ("廝", ),  # 53AE => 5EDD
    "县" : ("縣", ),  # 53BF => 7E23
    "叁" : ("參", ),  # 53C1 => 53C3
    "参" : ("參", ),  # 53C2 => 53C3
    "叆" : ("靉", ),  # 53C6 => 9749
    "叇" : ("靆", ),  # 53C7 => 9746
    "双" : ("雙", ),  # 53CC => 96D9
    "发" : ("發", "髮"),  # 53D1 => 767C 9AEE
    "变" : ("變", ),  # 53D8 => 8B8A
    "叙" : ("敘", ),  # 53D9 => 6558
    "叠" : ("疊", ),  # 53E0 => 758A
    "只" : ("戠", "祗", "衹", "隻"),  # 53EA => 6220 7957 8879 96BB
    "台" : ("檯", "臺", "颱"),  # 53F0 => 6AAF 81FA 98B1
    "叶" : ("葉", ),  # 53F6 => 8449
    "号" : ("號", ),  # 53F7 => 865F
    "叹" : ("嘆", "歎"),  # 53F9 => 5606 6B4E
    "叽" : ("嘰", ),  # 53FD => 5630
    "吁" : ("籲", ),  # 5401 => 7C72
    "合" : ("閤", ),  # 5408 => 95A4
    "后" : ("後", ),  # 540E => 5F8C
    "向" : ("嚮", ),  # 5411 => 56AE
    "吓" : ("嚇", ),  # 5413 => 5687
    "吕" : ("呂", ),  # 5415 => 5442
    "吗" : ("嗎", ),  # 5417 => 55CE
    "吣" : ("唚", ),  # 5423 => 551A
    "吨" : ("噸", ),  # 5428 => 5678
    "听" : ("聽", ),  # 542C => 807D
    "启" : ("啓", "啟"),  # 542F => 5553 555F
    "吴" : ("吳", ),  # 5434 => 5433
    "呒" : ("嘸", ),  # 5452 => 5638
    "呓" : ("囈", ),  # 5453 => 56C8
    "呕" : ("嘔", ),  # 5455 => 5614
    "呖" : ("嚦", ),  # 5456 => 56A6
    "呗" : ("唄", ),  # 5457 => 5504
    "员" : ("員", ),  # 5458 => 54E1
    "呙" : ("咼", ),  # 5459 => 54BC
    "呛" : ("嗆", ),  # 545B => 55C6
    "呜" : ("嗚", ),  # 545C => 55DA
    "咏" : ("詠", ),  # 548F => 8A60
    "咔" : ("哢", ),  # 5494 => 54E2
    "咙" : ("嚨", ),  # 5499 => 56A8
    "咛" : ("嚀", ),  # 549B => 5680
    "咝" : ("噝", ),  # 549D => 565D
    "咤" : ("吒", ),  # 54A4 => 5412
    "咴" : ("噅", ),  # 54B4 => 5645
    "咸" : ("鹹", ),  # 54B8 => 9E79
    "哌" : ("呱", ),  # 54CC => 5471
    "响" : ("響", ),  # 54CD => 97FF
    "哑" : ("啞", ),  # 54D1 => 555E
    "哒" : ("噠", ),  # 54D2 => 5660
    "哓" : ("嘵", ),  # 54D3 => 5635
    "哔" : ("嗶", ),  # 54D4 => 55F6
    "哕" : ("噦", ),  # 54D5 => 5666
    "哗" : ("嘩", ),  # 54D7 => 5629
    "哙" : ("噲", ),  # 54D9 => 5672
    "哜" : ("嚌", ),  # 54DC => 568C
    "哝" : ("噥", ),  # 54DD => 5665
    "哟" : ("喲", ),  # 54DF => 55B2
    "唛" : ("嘜", ),  # 551B => 561C
    "唝" : ("嗊", ),  # 551D => 55CA
    "唠" : ("嘮", ),  # 5520 => 562E
    "唡" : ("啢", ),  # 5521 => 5562
    "唢" : ("嗩", ),  # 5522 => 55E9
    "唣" : ("唕", ),  # 5523 => 5515
    "唤" : ("喚", ),  # 5524 => 559A
    "唿" : ("呼", ),  # 553F => 547C
    "啧" : ("嘖", ),  # 5567 => 5616
    "啬" : ("嗇", ),  # 556C => 55C7
    "啭" : ("囀", ),  # 556D => 56C0
    "啮" : ("嚙", "齧"),  # 556E => 5699 9F67
    "啰" : ("囉", ),  # 5570 => 56C9
    "啸" : ("嘯", ),  # 5578 => 562F
    "喷" : ("噴", ),  # 55B7 => 5674
    "喽" : ("嘍", ),  # 55BD => 560D
    "喾" : ("嚳", ),  # 55BE => 56B3
    "嗫" : ("囁", ),  # 55EB => 56C1
    "嗬" : ("呵", ),  # 55EC => 5475
    "嗳" : ("噯", ),  # 55F3 => 566F
    "嘘" : ("噓", ),  # 5618 => 5653
    "嘤" : ("嚶", ),  # 5624 => 56B6
    "嘱" : ("囑", ),  # 5631 => 56D1
    "噜" : ("嚕", ),  # 565C => 5695
    "噼" : ("劈", ),  # 567C => 5288
    "嚣" : ("囂", ),  # 56A3 => 56C2
    "嚯" : ("謔", ),  # 56AF => 8B14
    "回" : ("迴", ),  # 56DE => 8FF4
    "团" : ("團", "糰"),  # 56E2 => 5718 7CF0
    "园" : ("園", ),  # 56ED => 5712
    "困" : ("睏", ),  # 56F0 => 774F
    "囱" : ("囪", ),  # 56F1 => 56EA
    "围" : ("圍", ),  # 56F4 => 570D
    "囵" : ("圇", ),  # 56F5 => 5707
    "国" : ("國", ),  # 56FD => 570B
    "图" : ("圖", ),  # 56FE => 5716
    "圆" : ("圓", ),  # 5706 => 5713
    "圣" : ("聖", ),  # 5723 => 8056
    "圹" : ("壙", ),  # 5739 => 58D9
    "场" : ("場", ),  # 573A => 5834
    "坂" : ("阪", ),  # 5742 => 962A
    "坏" : ("壞", ),  # 574F => 58DE
    "块" : ("塊", ),  # 5757 => 584A
    "坚" : ("堅", ),  # 575A => 5805
    "坛" : ("壇", "罎"),  # 575B => 58C7 7F4E
    "坜" : ("壢", ),  # 575C => 58E2
    "坝" : ("壩", ),  # 575D => 58E9
    "坞" : ("塢", ),  # 575E => 5862
    "坟" : ("墳", ),  # 575F => 58B3
    "坠" : ("墜", ),  # 5760 => 589C
    "垄" : ("壟", ),  # 5784 => 58DF
    "垅" : ("壟", ),  # 5785 => 58DF
    "垆" : ("壚", ),  # 5786 => 58DA
    "垒" : ("壘", ),  # 5792 => 58D8
    "垦" : ("墾", ),  # 57A6 => 58BE
    "垧" : ("坰", ),  # 57A7 => 5770
    "垩" : ("堊", ),  # 57A9 => 580A
    "垫" : ("墊", ),  # 57AB => 588A
    "垭" : ("埡", ),  # 57AD => 57E1
    "垲" : ("塏", ),  # 57B2 => 584F
    "垴" : ("堖", ),  # 57B4 => 5816
    "埘" : ("塒", ),  # 57D8 => 5852
    "埙" : ("塤", ),  # 57D9 => 5864
    "埚" : ("堝", ),  # 57DA => 581D
    "埝" : ("墊", ),  # 57DD => 588A
    "埯" : ("垵", ),  # 57EF => 57B5
    "堑" : ("塹", ),  # 5811 => 5879
    "堕" : ("墮", ),  # 5815 => 58AE
    "塬" : ("原", ),  # 586C => 539F
    "墙" : ("墻", "牆"),  # 5899 => 58BB 7246
    "壮" : ("壯", ),  # 58EE => 58EF
    "声" : ("聲", ),  # 58F0 => 8072
    "壳" : ("殻", "殼"),  # 58F3 => 6BBB 6BBC
    "壶" : ("壺", ),  # 58F6 => 58FA
    "处" : ("處", ),  # 5904 => 8655
    "备" : ("備", ),  # 5907 => 5099
    "复" : ("復", "複"),  # 590D => 5FA9 8907
    "够" : ("夠", ),  # 591F => 5920
    "头" : ("頭", ),  # 5934 => 982D
    "夸" : ("誇", ),  # 5938 => 8A87
    "夹" : ("夾", ),  # 5939 => 593E
    "夺" : ("奪", ),  # 593A => 596A
    "奁" : ("奩", ),  # 5941 => 5969
    "奂" : ("奐", ),  # 5942 => 5950
    "奋" : ("奮", ),  # 594B => 596E
    "奖" : ("奬", "獎"),  # 5956 => 596C 734E
    "奥" : ("奧", ),  # 5965 => 5967
    "妆" : ("妝", ),  # 5986 => 599D
    "妇" : ("婦", ),  # 5987 => 5A66
    "妈" : ("媽", ),  # 5988 => 5ABD
    "妩" : ("嫵", ),  # 59A9 => 5AF5
    "妪" : ("嫗", ),  # 59AA => 5AD7
    "妫" : ("媯", ),  # 59AB => 5AAF
    "姗" : ("姍", ),  # 59D7 => 59CD
    "姜" : ("薑", ),  # 59DC => 8591
    "娄" : ("婁", ),  # 5A04 => 5A41
    "娅" : ("婭", ),  # 5A05 => 5A6D
    "娆" : ("嬈", ),  # 5A06 => 5B08
    "娇" : ("嬌", ),  # 5A07 => 5B0C
    "娈" : ("孌", ),  # 5A08 => 5B4C
    "娱" : ("娛", ),  # 5A31 => 5A1B
    "娲" : ("媧", ),  # 5A32 => 5AA7
    "娴" : ("嫻", ),  # 5A34 => 5AFB
    "婳" : ("嫿", ),  # 5A73 => 5AFF
    "婴" : ("嬰", ),  # 5A74 => 5B30
    "婵" : ("嬋", ),  # 5A75 => 5B0B
    "婶" : ("嬸", ),  # 5A76 => 5B38
    "媪" : ("媼", ),  # 5AAA => 5ABC
    "嫒" : ("嬡", ),  # 5AD2 => 5B21
    "嫔" : ("嬪", ),  # 5AD4 => 5B2A
    "嫱" : ("嬙", ),  # 5AF1 => 5B19
    "嬷" : ("嬤", ),  # 5B37 => 5B24
    "孙" : ("孫", ),  # 5B59 => 5B6B
    "学" : ("學", ),  # 5B66 => 5B78
    "孪" : ("孿", ),  # 5B6A => 5B7F
    "宁" : ("寜", "甯"),  # 5B81 => 5BDC 752F
    "宝" : ("寶", ),  # 5B9D => 5BF6
    "实" : ("實", ),  # 5B9E => 5BE6
    "宠" : ("寵", ),  # 5BA0 => 5BF5
    "审" : ("審", ),  # 5BA1 => 5BE9
    "宪" : ("憲", ),  # 5BAA => 61B2
    "宫" : ("宮", ),  # 5BAB => 5BAE
    "家" : ("傢", ),  # 5BB6 => 50A2
    "宽" : ("寬", ),  # 5BBD => 5BEC
    "宾" : ("賓", ),  # 5BBE => 8CD3
    "寝" : ("寢", ),  # 5BDD => 5BE2
    "对" : ("對", ),  # 5BF9 => 5C0D
    "寻" : ("尋", ),  # 5BFB => 5C0B
    "导" : ("導", ),  # 5BFC => 5C0E
    "寿" : ("壽", "夀"),  # 5BFF => 58FD 5900
    "将" : ("將", ),  # 5C06 => 5C07
    "尔" : ("爾", ),  # 5C14 => 723E
    "尘" : ("塵", ),  # 5C18 => 5875
    "尝" : ("嘗", ),  # 5C1D => 5617
    "尧" : ("堯", ),  # 5C27 => 582F
    "尴" : ("尷", ),  # 5C34 => 5C37
    "尸" : ("屍", ),  # 5C38 => 5C4D
    "尽" : ("儘", "盡"),  # 5C3D => 5118 76E1
    "层" : ("層", ),  # 5C42 => 5C64
    "屉" : ("屜", ),  # 5C49 => 5C5C
    "届" : ("屆", ),  # 5C4A => 5C46
    "属" : ("屬", ),  # 5C5E => 5C6C
    "屡" : ("屢", ),  # 5C61 => 5C62
    "屦" : ("屨", ),  # 5C66 => 5C68
    "屿" : ("嶼", ),  # 5C7F => 5DBC
    "岁" : ("嵗", "歲"),  # 5C81 => 5D57 6B72
    "岂" : ("豈", ),  # 5C82 => 8C48
    "岖" : ("嶇", ),  # 5C96 => 5D87
    "岗" : ("崗", ),  # 5C97 => 5D17
    "岘" : ("峴", ),  # 5C98 => 5CF4
    "岙" : ("嶴", ),  # 5C99 => 5DB4
    "岚" : ("嵐", ),  # 5C9A => 5D50
    "岛" : ("島", ),  # 5C9B => 5CF6
    "岭" : ("嶺", ),  # 5CAD => 5DBA
    "岳" : ("嶽", ),  # 5CB3 => 5DBD
    "岽" : ("崠", "崬"),  # 5CBD => 5D20 5D2C
    "岿" : ("巋", ),  # 5CBF => 5DCB
    "峃" : ("嶨", ),  # 5CC3 => 5DA8
    "峄" : ("嶧", ),  # 5CC4 => 5DA7
    "峡" : ("峽", ),  # 5CE1 => 5CFD
    "峣" : ("嶢", ),  # 5CE3 => 5DA2
    "峤" : ("嶠", ),  # 5CE4 => 5DA0
    "峥" : ("崢", ),  # 5CE5 => 5D22
    "峦" : ("巒", ),  # 5CE6 => 5DD2
    "崂" : ("嶗", ),  # 5D02 => 5D97
    "崃" : ("崍", ),  # 5D03 => 5D0D
    "崭" : ("嶄", ),  # 5D2D => 5D84
    "嵘" : ("嶸", ),  # 5D58 => 5DB8
    "嵚" : ("嶔", ),  # 5D5A => 5D94
    "嵛" : ("崳", ),  # 5D5B => 5D33
    "嵝" : ("嶁", ),  # 5D5D => 5D81
    "嵴" : ("脊", ),  # 5D74 => 810A
    "巅" : ("巔", ),  # 5DC5 => 5DD4
    "巩" : ("鞏", ),  # 5DE9 => 978F
    "巯" : ("巰", ),  # 5DEF => 5DF0
    "币" : ("幣", ),  # 5E01 => 5E63
    "帅" : ("帥", ),  # 5E05 => 5E25
    "师" : ("師", ),  # 5E08 => 5E2B
    "帏" : ("幃", ),  # 5E0F => 5E43
    "帐" : ("帳", ),  # 5E10 => 5E33
    "帘" : ("簾", ),  # 5E18 => 7C3E
    "帜" : ("幟", ),  # 5E1C => 5E5F
    "带" : ("帶", ),  # 5E26 => 5E36
    "帧" : ("幀", ),  # 5E27 => 5E40
    "帮" : ("幫", ),  # 5E2E => 5E6B
    "帱" : ("幬", ),  # 5E31 => 5E6C
    "帻" : ("幘", ),  # 5E3B => 5E58
    "帼" : ("幗", ),  # 5E3C => 5E57
    "幂" : ("冪", ),  # 5E42 => 51AA
    "幞" : ("襆", ),  # 5E5E => 8946
    "干" : ("乾", "幹"),  # 5E72 => 4E7E 5E79
    "并" : ("並", ),  # 5E76 => 4E26
    "幺" : ("么", ),  # 5E7A => 4E48
    "广" : ("廣", ),  # 5E7F => 5EE3
    "庄" : ("莊", ),  # 5E84 => 838A
    "庆" : ("慶", ),  # 5E86 => 6176
    "庐" : ("廬", ),  # 5E90 => 5EEC
    "庑" : ("廡", ),  # 5E91 => 5EE1
    "库" : ("庫", ),  # 5E93 => 5EAB
    "应" : ("應", ),  # 5E94 => 61C9
    "庙" : ("廟", ),  # 5E99 => 5EDF
    "庞" : ("龐", ),  # 5E9E => 9F90
    "废" : ("廢", ),  # 5E9F => 5EE2
    "庼" : ("廎", ),  # 5EBC => 5ECE
    "廪" : ("廩", ),  # 5EEA => 5EE9
    "开" : ("開", ),  # 5F00 => 958B
    "异" : ("異", ),  # 5F02 => 7570
    "弃" : ("棄", ),  # 5F03 => 68C4
    "张" : ("張", ),  # 5F20 => 5F35
    "弥" : ("彌", "瀰"),  # 5F25 => 5F4C 7030
    "弪" : ("弳", ),  # 5F2A => 5F33
    "弯" : ("彎", ),  # 5F2F => 5F4E
    "弹" : ("彈", ),  # 5F39 => 5F48
    "强" : ("強", ),  # 5F3A => 5F37
    "归" : ("歸", ),  # 5F52 => 6B78
    "当" : ("噹", "當"),  # 5F53 => 5679 7576
    "录" : ("錄", "録"),  # 5F55 => 9304 9332
    "彦" : ("彥", ),  # 5F66 => 5F65
    "彻" : ("徹", ),  # 5F7B => 5FB9
    "征" : ("徵", ),  # 5F81 => 5FB5
    "径" : ("徑", ),  # 5F84 => 5F91
    "徕" : ("徠", ),  # 5F95 => 5FA0
    "御" : ("禦", ),  # 5FA1 => 79A6
    "忆" : ("憶", ),  # 5FC6 => 61B6
    "忏" : ("懺", ),  # 5FCF => 61FA
    "忧" : ("憂", ),  # 5FE7 => 6182
    "忾" : ("愾", ),  # 5FFE => 613E
    "怀" : ("懷", ),  # 6000 => 61F7
    "态" : ("態", ),  # 6001 => 614B
    "怂" : ("慫", ),  # 6002 => 616B
    "怃" : ("憮", ),  # 6003 => 61AE
    "怄" : ("慪", ),  # 6004 => 616A
    "怅" : ("悵", ),  # 6005 => 60B5
    "怆" : ("愴", ),  # 6006 => 6134
    "怜" : ("憐", ),  # 601C => 6190
    "总" : ("總", ),  # 603B => 7E3D
    "怼" : ("懟", ),  # 603C => 61DF
    "怿" : ("懌", ),  # 603F => 61CC
    "恋" : ("戀", ),  # 604B => 6200
    "恳" : ("懇", ),  # 6073 => 61C7
    "恶" : ("噁", "惡"),  # 6076 => 5641 60E1
    "恸" : ("慟", ),  # 6078 => 615F
    "恹" : ("懨", ),  # 6079 => 61E8
    "恺" : ("愷", ),  # 607A => 6137
    "恻" : ("惻", ),  # 607B => 60FB
    "恼" : ("惱", ),  # 607C => 60F1
    "恽" : ("惲", ),  # 607D => 60F2
    "悦" : ("悅", ),  # 60A6 => 6085
    "悫" : ("愨", "慤"),  # 60AB => 6128 6164
    "悬" : ("懸", ),  # 60AC => 61F8
    "悭" : ("慳", ),  # 60AD => 6173
    "悯" : ("憫", ),  # 60AF => 61AB
    "惊" : ("驚", ),  # 60CA => 9A5A
    "惧" : ("懼", ),  # 60E7 => 61FC
    "惨" : ("慘", ),  # 60E8 => 6158
    "惩" : ("懲", ),  # 60E9 => 61F2
    "惫" : ("憊", ),  # 60EB => 618A
    "惬" : ("愜", ),  # 60EC => 611C
    "惭" : ("慚", ),  # 60ED => 615A
    "惮" : ("憚", ),  # 60EE => 619A
    "惯" : ("慣", ),  # 60EF => 6163
    "愍" : ("湣", ),  # 610D => 6E63
    "愠" : ("慍", ),  # 6120 => 614D
    "愤" : ("憤", ),  # 6124 => 61A4
    "愦" : ("憒", ),  # 6126 => 6192
    "愿" : ("願", ),  # 613F => 9858
    "慑" : ("懾", ),  # 6151 => 61FE
    "憷" : ("怵", ),  # 61B7 => 6035
    "懑" : ("懣", ),  # 61D1 => 61E3
    "懒" : ("懶", ),  # 61D2 => 61F6
    "懔" : ("懍", ),  # 61D4 => 61CD
    "戆" : ("戇", ),  # 6206 => 6207
    "戋" : ("戔", ),  # 620B => 6214
    "戏" : ("戲", ),  # 620F => 6232
    "戗" : ("戧", ),  # 6217 => 6227
    "战" : ("戰", ),  # 6218 => 6230
    "戬" : ("戩", ),  # 622C => 6229
    "户" : ("戶", ),  # 6237 => 6236
    "才" : ("纔", ),  # 624D => 7E94
    "扎" : ("紮", ),  # 624E => 7D2E
    "扑" : ("撲", ),  # 6251 => 64B2
    "扦" : ("扡", ),  # 6266 => 6261
    "执" : ("執", ),  # 6267 => 57F7
    "扩" : ("擴", ),  # 6269 => 64F4
    "扪" : ("捫", ),  # 626A => 636B
    "扫" : ("掃", ),  # 626B => 6383
    "扬" : ("揚", ),  # 626C => 63DA
    "扰" : ("擾", ),  # 6270 => 64FE
    "折" : ("摺", ),  # 6298 => 647A
    "抚" : ("撫", ),  # 629A => 64AB
    "抛" : ("拋", ),  # 629B => 62CB
    "抟" : ("摶", ),  # 629F => 6476
    "抠" : ("摳", ),  # 62A0 => 6473
    "抡" : ("掄", ),  # 62A1 => 6384
    "抢" : ("搶", ),  # 62A2 => 6436
    "护" : ("護", ),  # 62A4 => 8B77
    "报" : ("報", ),  # 62A5 => 5831
    "担" : ("擔", ),  # 62C5 => 64D4
    "拟" : ("擬", ),  # 62DF => 64EC
    "拢" : ("攏", ),  # 62E2 => 650F
    "拣" : ("揀", ),  # 62E3 => 63C0
    "拥" : ("擁", ),  # 62E5 => 64C1
    "拦" : ("攔", ),  # 62E6 => 6514
    "拧" : ("擰", ),  # 62E7 => 64F0
    "拨" : ("撥", ),  # 62E8 => 64A5
    "择" : ("擇", ),  # 62E9 => 64C7
    "挂" : ("掛", ),  # 6302 => 639B
    "挚" : ("摯", ),  # 631A => 646F
    "挛" : ("攣", ),  # 631B => 6523
    "挜" : ("掗", ),  # 631C => 6397
    "挝" : ("撾", ),  # 631D => 64BE
    "挞" : ("撻", ),  # 631E => 64BB
    "挟" : ("挾", ),  # 631F => 633E
    "挠" : ("撓", ),  # 6320 => 6493
    "挡" : ("擋", ),  # 6321 => 64CB
    "挢" : ("撟", ),  # 6322 => 649F
    "挣" : ("掙", ),  # 6323 => 6399
    "挤" : ("擠", ),  # 6324 => 64E0
    "挥" : ("揮", ),  # 6325 => 63EE
    "挦" : ("撏", ),  # 6326 => 648F
    "捞" : ("撈", ),  # 635E => 6488
    "损" : ("損", ),  # 635F => 640D
    "捡" : ("撿", ),  # 6361 => 64BF
    "换" : ("換", ),  # 6362 => 63DB
    "捣" : ("搗", ),  # 6363 => 6417
    "据" : ("據", ),  # 636E => 64DA
    "捻" : ("撚", ),  # 637B => 649A
    "掳" : ("擄", ),  # 63B3 => 64C4
    "掴" : ("摑", ),  # 63B4 => 6451
    "掷" : ("擲", ),  # 63B7 => 64F2
    "掸" : ("撣", ),  # 63B8 => 64A3
    "掺" : ("摻", ),  # 63BA => 647B
    "掼" : ("摜", ),  # 63BC => 645C
    "揸" : ("摣", ),  # 63F8 => 6463
    "揽" : ("攬", ),  # 63FD => 652C
    "揿" : ("撳", ),  # 63FF => 64B3
    "搀" : ("攙", ),  # 6400 => 6519
    "搁" : ("擱", ),  # 6401 => 64F1
    "搂" : ("摟", ),  # 6402 => 645F
    "搅" : ("攪", ),  # 6405 => 652A
    "携" : ("攜", ),  # 643A => 651C
    "摄" : ("攝", ),  # 6444 => 651D
    "摅" : ("攄", ),  # 6445 => 6504
    "摆" : ("擺", "襬"),  # 6446 => 64FA 896C
    "摇" : ("搖", ),  # 6447 => 6416
    "摈" : ("擯", ),  # 6448 => 64EF
    "摊" : ("擹", "攤"),  # 644A => 64F9 6524
    "撄" : ("攖", ),  # 6484 => 6516
    "撑" : ("撐", ),  # 6491 => 6490
    "撵" : ("攆", ),  # 64B5 => 6506
    "撷" : ("擷", ),  # 64B7 => 64F7
    "撸" : ("擼", ),  # 64B8 => 64FC
    "撺" : ("攛", ),  # 64BA => 651B
    "擞" : ("擻", ),  # 64DE => 64FB
    "攒" : ("攢", ),  # 6512 => 6522
    "敌" : ("敵", ),  # 654C => 6575
    "敛" : ("斂", ),  # 655B => 6582
    "数" : ("數", ),  # 6570 => 6578
    "斋" : ("齋", ),  # 658B => 9F4B
    "斓" : ("斕", ),  # 6593 => 6595
    "斗" : ("鬥", ),  # 6597 => 9B25
    "斩" : ("斬", ),  # 65A9 => 65AC
    "断" : ("斷", ),  # 65AD => 65B7
    "旋" : ("鏇", ),  # 65CB => 93C7
    "无" : ("無", ),  # 65E0 => 7121
    "旧" : ("舊", ),  # 65E7 => 820A
    "时" : ("時", ),  # 65F6 => 6642
    "旷" : ("曠", ),  # 65F7 => 66E0
    "旸" : ("暘", ),  # 65F8 => 6698
    "昙" : ("曇", ),  # 6619 => 66C7
    "昼" : ("晝", ),  # 663C => 665D
    "昽" : ("曨", ),  # 663D => 66E8
    "显" : ("顯", ),  # 663E => 986F
    "晋" : ("晉", ),  # 664B => 6649
    "晒" : ("曬", ),  # 6652 => 66EC
    "晓" : ("曉", ),  # 6653 => 66C9
    "晔" : ("曄", ),  # 6654 => 66C4
    "晕" : ("暈", ),  # 6655 => 6688
    "晖" : ("暉", ),  # 6656 => 6689
    "暂" : ("暫", ),  # 6682 => 66AB
    "暧" : ("曖", ),  # 66A7 => 66D6
    "曲" : ("麯", ),  # 66F2 => 9EAF
    "札" : ("劄", ),  # 672D => 5284
    "术" : ("術", ),  # 672F => 8853
    "朱" : ("硃", ),  # 6731 => 7843
    "朴" : ("樸", ),  # 6734 => 6A38
    "机" : ("機", ),  # 673A => 6A5F
    "杀" : ("殺", ),  # 6740 => 6BBA
    "杂" : ("雜", ),  # 6742 => 96DC
    "权" : ("權", ),  # 6743 => 6B0A
    "条" : ("條", ),  # 6761 => 689D
    "来" : ("來", ),  # 6765 => 4F86
    "杨" : ("楊", ),  # 6768 => 694A
    "杩" : ("榪", ),  # 6769 => 69AA
    "杰" : ("傑", ),  # 6770 => 5091
    "松" : ("鬆", ),  # 677E => 9B06
    "板" : ("闆", ),  # 677F => 95C6
    "极" : ("極", ),  # 6781 => 6975
    "构" : ("構", ),  # 6784 => 69CB
    "枞" : ("樅", ),  # 679E => 6A05
    "枢" : ("樞", ),  # 67A2 => 6A1E
    "枣" : ("棗", ),  # 67A3 => 68D7
    "枥" : ("櫪", ),  # 67A5 => 6AEA
    "枧" : ("梘", ),  # 67A7 => 6898
    "枨" : ("棖", ),  # 67A8 => 68D6
    "枪" : ("槍", ),  # 67AA => 69CD
    "枫" : ("楓", ),  # 67AB => 6953
    "枭" : ("梟", ),  # 67AD => 689F
    "柜" : ("櫃", ),  # 67DC => 6AC3
    "柠" : ("檸", ),  # 67E0 => 6AB8
    "柽" : ("檉", ),  # 67FD => 6A89
    "栀" : ("梔", ),  # 6800 => 6894
    "栅" : ("柵", ),  # 6805 => 67F5
    "标" : ("標", ),  # 6807 => 6A19
    "栈" : ("棧", ),  # 6808 => 68E7
    "栉" : ("櫛", ),  # 6809 => 6ADB
    "栊" : ("櫳", ),  # 680A => 6AF3
    "栋" : ("棟", ),  # 680B => 68DF
    "栌" : ("櫨", ),  # 680C => 6AE8
    "栎" : ("櫟", ),  # 680E => 6ADF
    "栏" : ("欄", ),  # 680F => 6B04
    "树" : ("樹", ),  # 6811 => 6A39
    "栖" : ("棲", ),  # 6816 => 68F2
    "样" : ("様", "樣"),  # 6837 => 69D8 6A23
    "栾" : ("欒", ),  # 683E => 6B12
    "桊" : ("棬", ),  # 684A => 68EC
    "桠" : ("椏", ),  # 6860 => 690F
    "桡" : ("橈", ),  # 6861 => 6A48
    "桢" : ("楨", ),  # 6862 => 6968
    "档" : ("檔", ),  # 6863 => 6A94
    "桤" : ("榿", ),  # 6864 => 69BF
    "桥" : ("橋", ),  # 6865 => 6A4B
    "桦" : ("樺", ),  # 6866 => 6A3A
    "桧" : ("檜", ),  # 6867 => 6A9C
    "桨" : ("槳", ),  # 6868 => 69F3
    "桩" : ("樁", ),  # 6869 => 6A01
    "梦" : ("夢", ),  # 68A6 => 5922
    "检" : ("檢", ),  # 68C0 => 6AA2
    "棂" : ("欞", ),  # 68C2 => 6B1E
    "椁" : ("槨", ),  # 6901 => 69E8
    "椟" : ("櫝", ),  # 691F => 6ADD
    "椠" : ("槧", ),  # 6920 => 69E7
    "椤" : ("欏", ),  # 6924 => 6B0F
    "椭" : ("橢", ),  # 692D => 6A62
    "楼" : ("樓", ),  # 697C => 6A13
    "榄" : ("欖", ),  # 6984 => 6B16
    "榇" : ("櫬", ),  # 6987 => 6AEC
    "榈" : ("櫚", ),  # 6988 => 6ADA
    "榉" : ("櫸", ),  # 6989 => 6AF8
    "槚" : ("檟", ),  # 69DA => 6A9F
    "槛" : ("檻", ),  # 69DB => 6ABB
    "槟" : ("檳", ),  # 69DF => 6AB3
    "槠" : ("櫧", ),  # 69E0 => 6AE7
    "横" : ("橫", ),  # 6A2A => 6A6B
    "樯" : ("檣", ),  # 6A2F => 6AA3
    "樱" : ("櫻", ),  # 6A31 => 6AFB
    "橥" : ("櫫", ),  # 6A65 => 6AEB
    "橱" : ("櫥", ),  # 6A71 => 6AE5
    "橹" : ("櫓", ),  # 6A79 => 6AD3
    "橼" : ("櫞", ),  # 6A7C => 6ADE
    "檐" : ("簷", ),  # 6A90 => 7C37
    "檩" : ("檁", ),  # 6AA9 => 6A81
    "欢" : ("歡", ),  # 6B22 => 6B61
    "欤" : ("歟", ),  # 6B24 => 6B5F
    "欧" : ("歐", ),  # 6B27 => 6B50
    "歼" : ("殲", ),  # 6B7C => 6BB2
    "殁" : ("歿", ),  # 6B81 => 6B7F
    "殇" : ("殤", ),  # 6B87 => 6BA4
    "残" : ("殘", ),  # 6B8B => 6B98
    "殒" : ("殞", ),  # 6B92 => 6B9E
    "殓" : ("殮", ),  # 6B93 => 6BAE
    "殚" : ("殫", ),  # 6B9A => 6BAB
    "殡" : ("殯", ),  # 6BA1 => 6BAF
    "殴" : ("毆", ),  # 6BB4 => 6BC6
    "毁" : ("毀", ),  # 6BC1 => 6BC0
    "毂" : ("轂", ),  # 6BC2 => 8F42
    "毕" : ("畢", ),  # 6BD5 => 7562
    "毙" : ("斃", ),  # 6BD9 => 6583
    "毡" : ("氈", ),  # 6BE1 => 6C08
    "毵" : ("毿", ),  # 6BF5 => 6BFF
    "氇" : ("氌", ),  # 6C07 => 6C0C
    "气" : ("氣", ),  # 6C14 => 6C23
    "氢" : ("氫", ),  # 6C22 => 6C2B
    "氩" : ("氬", ),  # 6C29 => 6C2C
    "氲" : ("氳", ),  # 6C32 => 6C33
    "汇" : ("匯", "彙"),  # 6C47 => 532F 5F59
    "汉" : ("漢", ),  # 6C49 => 6F22
    "污" : ("汙", ),  # 6C61 => 6C59
    "汤" : ("湯", ),  # 6C64 => 6E6F
    "汹" : ("洶", ),  # 6C79 => 6D36
    "沈" : ("瀋", ),  # 6C88 => 700B
    "沓" : ("遝", ),  # 6C93 => 905D
    "沟" : ("溝", ),  # 6C9F => 6E9D
    "没" : ("沒", ),  # 6CA1 => 6C92
    "沣" : ("灃", ),  # 6CA3 => 7043
    "沤" : ("漚", ),  # 6CA4 => 6F1A
    "沥" : ("瀝", ),  # 6CA5 => 701D
    "沦" : ("淪", ),  # 6CA6 => 6DEA
    "沧" : ("滄", ),  # 6CA7 => 6EC4
    "沨" : ("渢", ),  # 6CA8 => 6E22
    "沩" : ("溈", ),  # 6CA9 => 6E88
    "沪" : ("滬", ),  # 6CAA => 6EEC
    "泞" : ("濘", ),  # 6CDE => 6FD8
    "泪" : ("淚", ),  # 6CEA => 6DDA
    "泶" : ("澩", ),  # 6CF6 => 6FA9
    "泷" : ("瀧", ),  # 6CF7 => 7027
    "泸" : ("瀘", ),  # 6CF8 => 7018
    "泺" : ("濼", ),  # 6CFA => 6FFC
    "泻" : ("瀉", ),  # 6CFB => 7009
    "泼" : ("潑", ),  # 6CFC => 6F51
    "泽" : ("澤", ),  # 6CFD => 6FA4
    "泾" : ("涇", ),  # 6CFE => 6D87
    "洁" : ("潔", ),  # 6D01 => 6F54
    "洒" : ("灑", ),  # 6D12 => 7051
    "洼" : ("窪", ),  # 6D3C => 7AAA
    "浃" : ("浹", ),  # 6D43 => 6D79
    "浅" : ("淺", ),  # 6D45 => 6DFA
    "浆" : ("漿", ),  # 6D46 => 6F3F
    "浇" : ("澆", ),  # 6D47 => 6F86
    "浈" : ("湞", ),  # 6D48 => 6E5E
    "浉" : ("溮", ),  # 6D49 => 6EAE
    "浊" : ("濁", ),  # 6D4A => 6FC1
    "测" : ("測", ),  # 6D4B => 6E2C
    "浍" : ("澮", ),  # 6D4D => 6FAE
    "济" : ("濟", ),  # 6D4E => 6FDF
    "浏" : ("瀏", ),  # 6D4F => 700F
    "浐" : ("滻", ),  # 6D50 => 6EFB
    "浑" : ("渾", ),  # 6D51 => 6E3E
    "浒" : ("滸", ),  # 6D52 => 6EF8
    "浓" : ("濃", ),  # 6D53 => 6FC3
    "浔" : ("潯", ),  # 6D54 => 6F6F
    "浕" : ("濜", ),  # 6D55 => 6FDC
    "涂" : ("塗", ),  # 6D82 => 5857
    "涌" : ("湧", ),  # 6D8C => 6E67
    "涛" : ("濤", ),  # 6D9B => 6FE4
    "涝" : ("澇", ),  # 6D9D => 6F87
    "涞" : ("淶", ),  # 6D9E => 6DF6
    "涟" : ("漣", ),  # 6D9F => 6F23
    "涠" : ("潿", ),  # 6DA0 => 6F7F
    "涡" : ("渦", ),  # 6DA1 => 6E26
    "涢" : ("溳", ),  # 6DA2 => 6EB3
    "涣" : ("渙", ),  # 6DA3 => 6E19
    "涤" : ("滌", ),  # 6DA4 => 6ECC
    "润" : ("潤", ),  # 6DA6 => 6F64
    "涧" : ("澗", ),  # 6DA7 => 6F97
    "涨" : ("漲", ),  # 6DA8 => 6F32
    "涩" : ("澀", ),  # 6DA9 => 6F80
    "淀" : ("澱", ),  # 6DC0 => 6FB1
    "渊" : ("淵", ),  # 6E0A => 6DF5
    "渌" : ("淥", ),  # 6E0C => 6DE5
    "渍" : ("漬", ),  # 6E0D => 6F2C
    "渎" : ("瀆", ),  # 6E0E => 7006
    "渐" : ("漸", ),  # 6E10 => 6F38
    "渑" : ("澠", ),  # 6E11 => 6FA0
    "渔" : ("漁", ),  # 6E14 => 6F01
    "渖" : ("瀋", ),  # 6E16 => 700B
    "渗" : ("滲", ),  # 6E17 => 6EF2
    "温" : ("溫", ),  # 6E29 => 6EAB
    "湾" : ("灣", ),  # 6E7E => 7063
    "湿" : ("濕", ),  # 6E7F => 6FD5
    "溃" : ("潰", ),  # 6E83 => 6F70
    "溅" : ("濺", ),  # 6E85 => 6FFA
    "溆" : ("漵", ),  # 6E86 => 6F35
    "溇" : ("漊", ),  # 6E87 => 6F0A
    "滗" : ("潷", ),  # 6ED7 => 6F77
    "滚" : ("滾", ),  # 6EDA => 6EFE
    "滞" : ("滯", ),  # 6EDE => 6EEF
    "滟" : ("灧", "灩"),  # 6EDF => 7067 7069
    "滠" : ("灄", ),  # 6EE0 => 7044
    "满" : ("滿", ),  # 6EE1 => 6EFF
    "滢" : ("瀅", ),  # 6EE2 => 7005
    "滤" : ("濾", ),  # 6EE4 => 6FFE
    "滥" : ("濫", ),  # 6EE5 => 6FEB
    "滦" : ("灤", ),  # 6EE6 => 7064
    "滨" : ("濱", ),  # 6EE8 => 6FF1
    "滩" : ("灘", ),  # 6EE9 => 7058
    "滪" : ("澦", ),  # 6EEA => 6FA6
    "漓" : ("灕", ),  # 6F13 => 7055
    "漤" : ("濫", ),  # 6F24 => 6FEB
    "潆" : ("瀠", ),  # 6F46 => 7020
    "潇" : ("瀟", ),  # 6F47 => 701F
    "潋" : ("瀲", ),  # 6F4B => 7032
    "潍" : ("濰", ),  # 6F4D => 6FF0
    "潜" : ("潛", ),  # 6F5C => 6F5B
    "潴" : ("瀦", ),  # 6F74 => 7026
    "澜" : ("瀾", ),  # 6F9C => 703E
    "濑" : ("瀨", ),  # 6FD1 => 7028
    "濒" : ("瀕", ),  # 6FD2 => 7015
    "灏" : ("灝", ),  # 704F => 705D
    "灭" : ("滅", ),  # 706D => 6EC5
    "灯" : ("燈", ),  # 706F => 71C8
    "灵" : ("靈", ),  # 7075 => 9748
    "灶" : ("竈", ),  # 7076 => 7AC8
    "灾" : ("災", ),  # 707E => 707D
    "灿" : ("燦", ),  # 707F => 71E6
    "炀" : ("煬", ),  # 7080 => 716C
    "炉" : ("爐", ),  # 7089 => 7210
    "炖" : ("燉", ),  # 7096 => 71C9
    "炜" : ("煒", ),  # 709C => 7152
    "炝" : ("熗", ),  # 709D => 7197
    "点" : ("點", ),  # 70B9 => 9EDE
    "炼" : ("煉", ),  # 70BC => 7149
    "炽" : ("熾", ),  # 70BD => 71BE
    "烁" : ("爍", ),  # 70C1 => 720D
    "烂" : ("爛", ),  # 70C2 => 721B
    "烃" : ("烴", ),  # 70C3 => 70F4
    "烛" : ("燭", ),  # 70DB => 71ED
    "烟" : ("煙", ),  # 70DF => 7159
    "烦" : ("煩", ),  # 70E6 => 7169
    "烧" : ("焼", "燒"),  # 70E7 => 713C 71D2
    "烨" : ("燁", ),  # 70E8 => 71C1
    "烩" : ("燴", ),  # 70E9 => 71F4
    "烫" : ("燙", ),  # 70EB => 71D9
    "烬" : ("燼", ),  # 70EC => 71FC
    "热" : ("熱", ),  # 70ED => 71B1
    "焕" : ("煥", ),  # 7115 => 7165
    "焖" : ("燜", ),  # 7116 => 71DC
    "焘" : ("燾", ),  # 7118 => 71FE
    "煅" : ("煆", ),  # 7145 => 7146
    "煳" : ("糊", ),  # 7173 => 7CCA
    "煺" : ("退", ),  # 717A => 9000
    "熘" : ("溜", ),  # 7198 => 6E9C
    "爱" : ("愛", ),  # 7231 => 611B
    "爷" : ("爺", ),  # 7237 => 723A
    "牍" : ("牘", ),  # 724D => 7258
    "牦" : ("犛", ),  # 7266 => 729B
    "牵" : ("牽", ),  # 7275 => 727D
    "牺" : ("犧", ),  # 727A => 72A7
    "犊" : ("犢", ),  # 728A => 72A2
    "犟" : ("強", ),  # 729F => 5F37
    "犭" : ("犬", ),  # 72AD => 72AC
    "状" : ("狀", ),  # 72B6 => 72C0
    "犷" : ("獷", ),  # 72B7 => 7377
    "犸" : ("獁", ),  # 72B8 => 7341
    "犹" : ("猶", ),  # 72B9 => 7336
    "狈" : ("狽", ),  # 72C8 => 72FD
    "狍" : ("麅", ),  # 72CD => 9E85
    "狞" : ("獰", ),  # 72DE => 7370
    "独" : ("獨", ),  # 72EC => 7368
    "狭" : ("狹", ),  # 72ED => 72F9
    "狮" : ("獅", ),  # 72EE => 7345
    "狯" : ("獪", ),  # 72EF => 736A
    "狰" : ("猙", ),  # 72F0 => 7319
    "狱" : ("獄", ),  # 72F1 => 7344
    "狲" : ("猻", ),  # 72F2 => 733B
    "猃" : ("獫", ),  # 7303 => 736B
    "猎" : ("獵", ),  # 730E => 7375
    "猕" : ("獼", ),  # 7315 => 737C
    "猡" : ("玀", ),  # 7321 => 7380
    "猪" : ("豬", ),  # 732A => 8C6C
    "猫" : ("貓", ),  # 732B => 8C93
    "猬" : ("蝟", ),  # 732C => 875F
    "献" : ("獻", ),  # 732E => 737B
    "獭" : ("獺", ),  # 736D => 737A
    "玑" : ("璣", ),  # 7391 => 74A3
    "玛" : ("瑪", ),  # 739B => 746A
    "玮" : ("瑋", ),  # 73AE => 744B
    "环" : ("環", ),  # 73AF => 74B0
    "现" : ("現", ),  # 73B0 => 73FE
    "玱" : ("瑲", ),  # 73B1 => 7472
    "玺" : ("壐", "璽"),  # 73BA => 58D0 74BD
    "珉" : ("瑉", ),  # 73C9 => 7449
    "珏" : ("玨", ),  # 73CF => 73A8
    "珐" : ("琺", ),  # 73D0 => 743A
    "珑" : ("瓏", ),  # 73D1 => 74CF
    "珲" : ("琿", ),  # 73F2 => 743F
    "琎" : ("璡", ),  # 740E => 74A1
    "琏" : ("璉", ),  # 740F => 7489
    "琐" : ("瑣", ),  # 7410 => 7463
    "琼" : ("瓊", ),  # 743C => 74CA
    "瑶" : ("瑤", ),  # 7476 => 7464
    "瑷" : ("璦", ),  # 7477 => 74A6
    "璇" : ("璿", ),  # 7487 => 74BF
    "璎" : ("瓔", ),  # 748E => 74D4
    "瓒" : ("瓚", ),  # 74D2 => 74DA
    "瓮" : ("甕", ),  # 74EE => 7515
    "瓯" : ("甌", ),  # 74EF => 750C
    "电" : ("電", ),  # 7535 => 96FB
    "画" : ("畫", ),  # 753B => 756B
    "畅" : ("暢", ),  # 7545 => 66A2
    "畲" : ("佘", ),  # 7572 => 4F58
    "畴" : ("疇", ),  # 7574 => 7587
    "疖" : ("癤", ),  # 7596 => 7664
    "疗" : ("療", ),  # 7597 => 7642
    "疟" : ("瘧", ),  # 759F => 7627
    "疠" : ("癘", ),  # 75A0 => 7658
    "疡" : ("瘍", ),  # 75A1 => 760D
    "疬" : ("癧", "鬁"),  # 75AC => 7667 9B01
    "疮" : ("瘡", ),  # 75AE => 7621
    "疯" : ("瘋", ),  # 75AF => 760B
    "疱" : ("皰", ),  # 75B1 => 76B0
    "疴" : ("屙", ),  # 75B4 => 5C59
    "症" : ("癥", ),  # 75C7 => 7665
    "痈" : ("癰", ),  # 75C8 => 7670
    "痉" : ("痙", ),  # 75C9 => 75D9
    "痒" : ("癢", ),  # 75D2 => 7662
    "痖" : ("瘂", ),  # 75D6 => 7602
    "痨" : ("癆", ),  # 75E8 => 7646
    "痪" : ("瘓", ),  # 75EA => 7613
    "痫" : ("癇", ),  # 75EB => 7647
    "痴" : ("癡", ),  # 75F4 => 7661
    "瘅" : ("癉", ),  # 7605 => 7649
    "瘆" : ("瘮", ),  # 7606 => 762E
    "瘗" : ("瘞", ),  # 7617 => 761E
    "瘘" : ("瘺", "瘻"),  # 7618 => 763A 763B
    "瘪" : ("癟", ),  # 762A => 765F
    "瘫" : ("癱", ),  # 762B => 7671
    "瘾" : ("癮", ),  # 763E => 766E
    "瘿" : ("癭", ),  # 763F => 766D
    "癞" : ("癩", ),  # 765E => 7669
    "癣" : ("癬", ),  # 7663 => 766C
    "癫" : ("癲", ),  # 766B => 7672
    "癯" : ("臒", ),  # 766F => 81D2
    "皑" : ("皚", ),  # 7691 => 769A
    "皱" : ("皺", ),  # 76B1 => 76BA
    "皲" : ("皸", ),  # 76B2 => 76B8
    "盏" : ("盞", ),  # 76CF => 76DE
    "盐" : ("鹽", ),  # 76D0 => 9E7D
    "监" : ("監", ),  # 76D1 => 76E3
    "盖" : ("蓋", ),  # 76D6 => 84CB
    "盗" : ("盜", ),  # 76D7 => 76DC
    "盘" : ("盤", ),  # 76D8 => 76E4
    "眍" : ("瞘", ),  # 770D => 7798
    "眦" : ("眥", ),  # 7726 => 7725
    "着" : ("著", ),  # 7740 => 8457
    "睁" : ("睜", ),  # 7741 => 775C
    "睐" : ("睞", ),  # 7750 => 775E
    "睑" : ("瞼", ),  # 7751 => 77BC
    "瞒" : ("瞞", ),  # 7792 => 779E
    "瞩" : ("矚", ),  # 77A9 => 77DA
    "矫" : ("矯", ),  # 77EB => 77EF
    "矶" : ("磯", ),  # 77F6 => 78EF
    "矾" : ("礬", ),  # 77FE => 792C
    "矿" : ("礦", ),  # 77FF => 7926
    "砀" : ("碭", ),  # 7800 => 78AD
    "码" : ("碼", ),  # 7801 => 78BC
    "砖" : ("磚", ),  # 7816 => 78DA
    "砗" : ("硨", ),  # 7817 => 7868
    "砚" : ("硯", ),  # 781A => 786F
    "砜" : ("碸", ),  # 781C => 78B8
    "砺" : ("礪", ),  # 783A => 792A
    "砻" : ("礱", ),  # 783B => 7931
    "砾" : ("礫", ),  # 783E => 792B
    "础" : ("礎", ),  # 7840 => 790E
    "硅" : ("矽", ),  # 7845 => 77FD
    "硕" : ("碩", ),  # 7855 => 78A9
    "硖" : ("硤", ),  # 7856 => 7864
    "硗" : ("磽", ),  # 7857 => 78FD
    "硙" : ("磑", ),  # 7859 => 78D1
    "硚" : ("礄", ),  # 785A => 7904
    "确" : ("確", ),  # 786E => 78BA
    "硷" : ("鹸", "鹼"),  # 7877 => 9E78 9E7C
    "碍" : ("礙", ),  # 788D => 7919
    "碛" : ("磧", ),  # 789B => 78E7
    "碜" : ("磣", ),  # 789C => 78E3
    "碱" : ("堿", ),  # 78B1 => 583F
    "碹" : ("镟", ),  # 78B9 => 955F
    "磙" : ("滾", ),  # 78D9 => 6EFE
    "礼" : ("禮", ),  # 793C => 79AE
    "祎" : ("禕", ),  # 794E => 7995
    "祢" : ("禰", ),  # 7962 => 79B0
    "祯" : ("禎", ),  # 796F => 798E
    "祷" : ("禱", ),  # 7977 => 79B1
    "祸" : ("禍", ),  # 7978 => 798D
    "禀" : ("稟", ),  # 7980 => 7A1F
    "禄" : ("祿", ),  # 7984 => 797F
    "禅" : ("禪", ),  # 7985 => 79AA
    "离" : ("離", ),  # 79BB => 96E2
    "秃" : ("禿", ),  # 79C3 => 79BF
    "秆" : ("稈", ),  # 79C6 => 7A08
    "秋" : ("鞦", ),  # 79CB => 97A6
    "种" : ("種", ),  # 79CD => 7A2E
    "积" : ("積", ),  # 79EF => 7A4D
    "称" : ("稱", ),  # 79F0 => 7A31
    "秽" : ("穢", ),  # 79FD => 7A62
    "稆" : ("穭", ),  # 7A06 => 7A6D
    "税" : ("稅", ),  # 7A0E => 7A05
    "稣" : ("穌", ),  # 7A23 => 7A4C
    "稳" : ("穩", ),  # 7A33 => 7A69
    "穑" : ("穡", ),  # 7A51 => 7A61
    "穷" : ("窮", ),  # 7A77 => 7AAE
    "窃" : ("竊", ),  # 7A83 => 7ACA
    "窍" : ("竅", ),  # 7A8D => 7AC5
    "窎" : ("窵", ),  # 7A8E => 7AB5
    "窑" : ("窯", ),  # 7A91 => 7AAF
    "窜" : ("竄", ),  # 7A9C => 7AC4
    "窝" : ("窩", ),  # 7A9D => 7AA9
    "窥" : ("窺", ),  # 7AA5 => 7ABA
    "窦" : ("竇", ),  # 7AA6 => 7AC7
    "窭" : ("窶", ),  # 7AAD => 7AB6
    "竖" : ("竪", "豎"),  # 7AD6 => 7AEA 8C4E
    "竞" : ("競", ),  # 7ADE => 7AF6
    "笃" : ("篤", ),  # 7B03 => 7BE4
    "笋" : ("筍", ),  # 7B0B => 7B4D
    "笔" : ("筆", ),  # 7B14 => 7B46
    "笕" : ("筧", ),  # 7B15 => 7B67
    "笺" : ("箋", ),  # 7B3A => 7B8B
    "笼" : ("籠", ),  # 7B3C => 7C60
    "笾" : ("籩", ),  # 7B3E => 7C69
    "筑" : ("築", ),  # 7B51 => 7BC9
    "筚" : ("篳", ),  # 7B5A => 7BF3
    "筛" : ("篩", ),  # 7B5B => 7BE9
    "筝" : ("箏", ),  # 7B5D => 7B8F
    "筹" : ("籌", ),  # 7B79 => 7C4C
    "签" : ("簽", "籤"),  # 7B7E => 7C3D 7C64
    "简" : ("簡", ),  # 7B80 => 7C21
    "箓" : ("籙", ),  # 7B93 => 7C59
    "箦" : ("簀", ),  # 7BA6 => 7C00
    "箧" : ("篋", ),  # 7BA7 => 7BCB
    "箨" : ("籜", ),  # 7BA8 => 7C5C
    "箩" : ("籮", ),  # 7BA9 => 7C6E
    "箪" : ("簞", ),  # 7BAA => 7C1E
    "箫" : ("簫", ),  # 7BAB => 7C2B
    "篑" : ("簣", ),  # 7BD1 => 7C23
    "篓" : ("簍", ),  # 7BD3 => 7C0D
    "篮" : ("籃", ),  # 7BEE => 7C43
    "篱" : ("籬", ),  # 7BF1 => 7C6C
    "簖" : ("籪", ),  # 7C16 => 7C6A
    "籁" : ("籟", ),  # 7C41 => 7C5F
    "籴" : ("糴", ),  # 7C74 => 7CF4
    "类" : ("類", ),  # 7C7B => 985E
    "籼" : ("秈", ),  # 7C7C => 79C8
    "粜" : ("糶", ),  # 7C9C => 7CF6
    "粝" : ("糲", ),  # 7C9D => 7CF2
    "粤" : ("粵", ),  # 7CA4 => 7CB5
    "粪" : ("糞", ),  # 7CAA => 7CDE
    "粮" : ("糧", ),  # 7CAE => 7CE7
    "糁" : ("糝", ),  # 7CC1 => 7CDD
    "糇" : ("餱", ),  # 7CC7 => 9931
    "系" : ("係", "繫"),  # 7CFB => 4FC2 7E6B
    "紧" : ("緊", ),  # 7D27 => 7DCA
    "累" : ("纍", ),  # 7D2F => 7E8D
    "絷" : ("縶", ),  # 7D77 => 7E36
    "纟" : ("糸", ),  # 7E9F => 7CF8
    "纠" : ("糾", ),  # 7EA0 => 7CFE
    "纡" : ("紆", ),  # 7EA1 => 7D06
    "红" : ("紅", ),  # 7EA2 => 7D05
    "纣" : ("紂", ),  # 7EA3 => 7D02
    "纤" : ("縴", "纖"),  # 7EA4 => 7E34 7E96
    "纥" : ("紇", ),  # 7EA5 => 7D07
    "约" : ("約", ),  # 7EA6 => 7D04
    "级" : ("級", ),  # 7EA7 => 7D1A
    "纨" : ("紈", ),  # 7EA8 => 7D08
    "纩" : ("纊", ),  # 7EA9 => 7E8A
    "纪" : ("紀", ),  # 7EAA => 7D00
    "纫" : ("紉", ),  # 7EAB => 7D09
    "纬" : ("緯", ),  # 7EAC => 7DEF
    "纭" : ("紜", ),  # 7EAD => 7D1C
    "纯" : ("純", ),  # 7EAF => 7D14
    "纰" : ("紕", ),  # 7EB0 => 7D15
    "纱" : ("紗", ),  # 7EB1 => 7D17
    "纲" : ("綱", ),  # 7EB2 => 7DB1
    "纳" : ("納", ),  # 7EB3 => 7D0D
    "纴" : ("紝", ),  # 7EB4 => 7D1D
    "纵" : ("縱", ),  # 7EB5 => 7E31
    "纶" : ("綸", ),  # 7EB6 => 7DB8
    "纷" : ("紛", ),  # 7EB7 => 7D1B
    "纸" : ("紙", ),  # 7EB8 => 7D19
    "纹" : ("紋", ),  # 7EB9 => 7D0B
    "纺" : ("紡", ),  # 7EBA => 7D21
    "纼" : ("紖", ),  # 7EBC => 7D16
    "纽" : ("紐", ),  # 7EBD => 7D10
    "纾" : ("紓", ),  # 7EBE => 7D13
    "线" : ("綫", "線"),  # 7EBF => 7DAB 7DDA
    "绀" : ("紺", ),  # 7EC0 => 7D3A
    "绁" : ("紲", "絏"),  # 7EC1 => 7D32 7D4F
    "绂" : ("紱", ),  # 7EC2 => 7D31
    "练" : ("練", ),  # 7EC3 => 7DF4
    "组" : ("組", ),  # 7EC4 => 7D44
    "绅" : ("紳", ),  # 7EC5 => 7D33
    "细" : ("細", ),  # 7EC6 => 7D30
    "织" : ("織", ),  # 7EC7 => 7E54
    "终" : ("終", ),  # 7EC8 => 7D42
    "绉" : ("縐", ),  # 7EC9 => 7E10
    "绊" : ("絆", ),  # 7ECA => 7D46
    "绋" : ("紼", ),  # 7ECB => 7D3C
    "绌" : ("絀", ),  # 7ECC => 7D40
    "绍" : ("紹", ),  # 7ECD => 7D39
    "绎" : ("繹", ),  # 7ECE => 7E79
    "经" : ("經", ),  # 7ECF => 7D93
    "绐" : ("紿", ),  # 7ED0 => 7D3F
    "绑" : ("綁", ),  # 7ED1 => 7D81
    "绒" : ("絨", ),  # 7ED2 => 7D68
    "结" : ("結", ),  # 7ED3 => 7D50
    "绔" : ("絝", ),  # 7ED4 => 7D5D
    "绕" : ("繞", ),  # 7ED5 => 7E5E
    "绖" : ("絰", ),  # 7ED6 => 7D70
    "绗" : ("絎", ),  # 7ED7 => 7D4E
    "绘" : ("繪", ),  # 7ED8 => 7E6A
    "给" : ("給", ),  # 7ED9 => 7D66
    "绚" : ("絢", ),  # 7EDA => 7D62
    "绛" : ("絳", ),  # 7EDB => 7D73
    "络" : ("絡", ),  # 7EDC => 7D61
    "绝" : ("絕", "絶"),  # 7EDD => 7D55 7D76
    "绞" : ("絞", ),  # 7EDE => 7D5E
    "统" : ("統", ),  # 7EDF => 7D71
    "绠" : ("綆", ),  # 7EE0 => 7D86
    "绡" : ("綃", ),  # 7EE1 => 7D83
    "绢" : ("絹", ),  # 7EE2 => 7D79
    "绣" : ("綉", "繡"),  # 7EE3 => 7D89 7E61
    "绥" : ("綏", ),  # 7EE5 => 7D8F
    "绦" : ("絛", "縧"),  # 7EE6 => 7D5B 7E27
    "继" : ("繼", ),  # 7EE7 => 7E7C
    "绨" : ("綈", ),  # 7EE8 => 7D88
    "绩" : ("績", ),  # 7EE9 => 7E3E
    "绪" : ("緒", ),  # 7EEA => 7DD2
    "绫" : ("綾", ),  # 7EEB => 7DBE
    "续" : ("續", ),  # 7EED => 7E8C
    "绮" : ("綺", ),  # 7EEE => 7DBA
    "绯" : ("緋", ),  # 7EEF => 7DCB
    "绰" : ("綽", ),  # 7EF0 => 7DBD
    "绱" : ("緔", ),  # 7EF1 => 7DD4
    "绲" : ("緄", ),  # 7EF2 => 7DC4
    "绳" : ("繩", ),  # 7EF3 => 7E69
    "维" : ("維", ),  # 7EF4 => 7DAD
    "绵" : ("綿", ),  # 7EF5 => 7DBF
    "绶" : ("綬", ),  # 7EF6 => 7DAC
    "绷" : ("綳", "繃"),  # 7EF7 => 7DB3 7E43
    "绸" : ("綢", ),  # 7EF8 => 7DA2
    "绺" : ("綹", ),  # 7EFA => 7DB9
    "绻" : ("綣", ),  # 7EFB => 7DA3
    "综" : ("綜", ),  # 7EFC => 7D9C
    "绽" : ("綻", ),  # 7EFD => 7DBB
    "绾" : ("綰", ),  # 7EFE => 7DB0
    "绿" : ("綠", "緑"),  # 7EFF => 7DA0 7DD1
    "缀" : ("綴", ),  # 7F00 => 7DB4
    "缁" : ("緇", ),  # 7F01 => 7DC7
    "缂" : ("緙", ),  # 7F02 => 7DD9
    "缃" : ("緗", ),  # 7F03 => 7DD7
    "缄" : ("緘", ),  # 7F04 => 7DD8
    "缅" : ("緬", ),  # 7F05 => 7DEC
    "缆" : ("纜", ),  # 7F06 => 7E9C
    "缇" : ("緹", ),  # 7F07 => 7DF9
    "缈" : ("緲", ),  # 7F08 => 7DF2
    "缉" : ("緝", ),  # 7F09 => 7DDD
    "缊" : ("緼", ),  # 7F0A => 7DFC
    "缋" : ("繢", ),  # 7F0B => 7E62
    "缌" : ("緦", ),  # 7F0C => 7DE6
    "缍" : ("綞", ),  # 7F0D => 7D9E
    "缎" : ("緞", ),  # 7F0E => 7DDE
    "缏" : ("緶", ),  # 7F0F => 7DF6
    "缑" : ("緱", ),  # 7F11 => 7DF1
    "缒" : ("縋", ),  # 7F12 => 7E0B
    "缓" : ("緩", ),  # 7F13 => 7DE9
    "缔" : ("締", ),  # 7F14 => 7DE0
    "缕" : ("縷", ),  # 7F15 => 7E37
    "编" : ("編", ),  # 7F16 => 7DE8
    "缗" : ("緡", ),  # 7F17 => 7DE1
    "缘" : ("緣", ),  # 7F18 => 7DE3
    "缙" : ("縉", ),  # 7F19 => 7E09
    "缚" : ("縛", ),  # 7F1A => 7E1B
    "缛" : ("縟", ),  # 7F1B => 7E1F
    "缜" : ("縝", ),  # 7F1C => 7E1D
    "缝" : ("縫", ),  # 7F1D => 7E2B
    "缞" : ("縗", ),  # 7F1E => 7E17
    "缟" : ("縞", ),  # 7F1F => 7E1E
    "缠" : ("纏", ),  # 7F20 => 7E8F
    "缡" : ("縭", ),  # 7F21 => 7E2D
    "缢" : ("縊", ),  # 7F22 => 7E0A
    "缣" : ("縑", ),  # 7F23 => 7E11
    "缤" : ("繽", ),  # 7F24 => 7E7D
    "缥" : ("縹", ),  # 7F25 => 7E39
    "缦" : ("縵", ),  # 7F26 => 7E35
    "缧" : ("縲", ),  # 7F27 => 7E32
    "缨" : ("纓", ),  # 7F28 => 7E93
    "缩" : ("縮", ),  # 7F29 => 7E2E
    "缪" : ("繆", ),  # 7F2A => 7E46
    "缫" : ("繅", ),  # 7F2B => 7E45
    "缬" : ("纈", ),  # 7F2C => 7E88
    "缭" : ("繚", ),  # 7F2D => 7E5A
    "缮" : ("繕", ),  # 7F2E => 7E55
    "缯" : ("繒", ),  # 7F2F => 7E52
    "缰" : ("繮", "韁"),  # 7F30 => 7E6E 97C1
    "缱" : ("繾", ),  # 7F31 => 7E7E
    "缲" : ("繰", ),  # 7F32 => 7E70
    "缳" : ("繯", ),  # 7F33 => 7E6F
    "缴" : ("繳", ),  # 7F34 => 7E73
    "缵" : ("纘", ),  # 7F35 => 7E98
    "罂" : ("罌", ),  # 7F42 => 7F4C
    "网" : ("網", ),  # 7F51 => 7DB2
    "罗" : ("羅", ),  # 7F57 => 7F85
    "罚" : ("罰", "罸"),  # 7F5A => 7F70 7F78
    "罢" : ("罷", ),  # 7F62 => 7F77
    "罴" : ("羆", ),  # 7F74 => 7F86
    "羁" : ("羈", "覊"),  # 7F81 => 7F88 898A
    "羟" : ("羥", ),  # 7F9F => 7FA5
    "羡" : ("羨", ),  # 7FA1 => 7FA8
    "翘" : ("翹", ),  # 7FD8 => 7FF9
    "翚" : ("翬", ),  # 7FDA => 7FEC
    "耢" : ("耮", ),  # 8022 => 802E
    "耧" : ("耬", ),  # 8027 => 802C
    "耸" : ("聳", ),  # 8038 => 8073
    "耻" : ("恥", ),  # 803B => 6065
    "聂" : ("聶", ),  # 8042 => 8076
    "聋" : ("聾", ),  # 804B => 807E
    "职" : ("職", ),  # 804C => 8077
    "聍" : ("聹", ),  # 804D => 8079
    "联" : ("聯", ),  # 8054 => 806F
    "聩" : ("聵", ),  # 8069 => 8075
    "聪" : ("聰", ),  # 806A => 8070
    "肃" : ("肅", ),  # 8083 => 8085
    "肠" : ("腸", ),  # 80A0 => 8178
    "肤" : ("膚", ),  # 80A4 => 819A
    "肮" : ("骯", ),  # 80AE => 9AAF
    "肷" : ("膁", ),  # 80B7 => 8181
    "肾" : ("腎", ),  # 80BE => 814E
    "肿" : ("腫", ),  # 80BF => 816B
    "胀" : ("脹", ),  # 80C0 => 8139
    "胁" : ("脅", ),  # 80C1 => 8105
    "胆" : ("膽", ),  # 80C6 => 81BD
    "胜" : ("勝", ),  # 80DC => 52DD
    "胡" : ("鬍", ),  # 80E1 => 9B0D
    "胧" : ("朧", ),  # 80E7 => 6727
    "胨" : ("腖", ),  # 80E8 => 8156
    "胪" : ("臚", ),  # 80EA => 81DA
    "胫" : ("脛", ),  # 80EB => 811B
    "胶" : ("膠", ),  # 80F6 => 81A0
    "脉" : ("脈", ),  # 8109 => 8108
    "脍" : ("膾", ),  # 810D => 81BE
    "脏" : ("贜", "髒"),  # 810F => 8D1C 9AD2
    "脐" : ("臍", ),  # 8110 => 81CD
    "脑" : ("腦", ),  # 8111 => 8166
    "脓" : ("膿", ),  # 8113 => 81BF
    "脔" : ("臠", ),  # 8114 => 81E0
    "脚" : ("腳", ),  # 811A => 8173
    "脱" : ("脫", ),  # 8131 => 812B
    "脶" : ("腡", ),  # 8136 => 8161
    "脸" : ("臉", ),  # 8138 => 81C9
    "腊" : ("臘", ),  # 814A => 81D8
    "腌" : ("醃", ),  # 814C => 9183
    "腘" : ("膕", ),  # 8158 => 8195
    "腭" : ("齶", ),  # 816D => 9F76
    "腻" : ("膩", ),  # 817B => 81A9
    "腼" : ("靦", ),  # 817C => 9766
    "腽" : ("膃", ),  # 817D => 8183
    "腾" : ("騰", ),  # 817E => 9A30
    "膑" : ("臏", ),  # 8191 => 81CF
    "臜" : ("臢", ),  # 81DC => 81E2
    "致" : ("緻", ),  # 81F4 => 7DFB
    "舆" : ("輿", ),  # 8206 => 8F3F
    "舍" : ("捨", ),  # 820D => 6368
    "舣" : ("艤", ),  # 8223 => 8264
    "舰" : ("艦", ),  # 8230 => 8266
    "舱" : ("艙", ),  # 8231 => 8259
    "舻" : ("艫", ),  # 823B => 826B
    "艰" : ("艱", ),  # 8270 => 8271
    "艳" : ("艶", "豔"),  # 8273 => 8276 8C54
    "艹" : ("艸", ),  # 8279 => 8278
    "艺" : ("兿", "藝"),  # 827A => 517F 85DD
    "节" : ("節", ),  # 8282 => 7BC0
    "芈" : ("羋", ),  # 8288 => 7F8B
    "芗" : ("薌", ),  # 8297 => 858C
    "芜" : ("蕪", ),  # 829C => 856A
    "芦" : ("蘆", ),  # 82A6 => 8606
    "芸" : ("蕓", ),  # 82B8 => 8553
    "苁" : ("蓯", ),  # 82C1 => 84EF
    "苇" : ("葦", ),  # 82C7 => 8466
    "苈" : ("藶", ),  # 82C8 => 85F6
    "苋" : ("莧", ),  # 82CB => 83A7
    "苌" : ("萇", ),  # 82CC => 8407
    "苍" : ("蒼", ),  # 82CD => 84BC
    "苎" : ("苧", ),  # 82CE => 82E7
    "苏" : ("囌", "蘇"),  # 82CF => 56CC 8607
    "苘" : ("檾", ),  # 82D8 => 6ABE
    "苹" : ("蘋", ),  # 82F9 => 860B
    "范" : ("範", ),  # 8303 => 7BC4
    "茎" : ("莖", ),  # 830E => 8396
    "茏" : ("蘢", ),  # 830F => 8622
    "茑" : ("蔦", ),  # 8311 => 8526
    "茔" : ("塋", ),  # 8314 => 584B
    "茕" : ("煢", ),  # 8315 => 7162
    "茧" : ("繭", ),  # 8327 => 7E6D
    "荆" : ("荊", ),  # 8346 => 834A
    "荐" : ("薦", ),  # 8350 => 85A6
    "荚" : ("莢", ),  # 835A => 83A2
    "荛" : ("蕘", ),  # 835B => 8558
    "荜" : ("蓽", ),  # 835C => 84FD
    "荞" : ("蕎", ),  # 835E => 854E
    "荟" : ("薈", ),  # 835F => 8588
    "荠" : ("薺", ),  # 8360 => 85BA
    "荡" : ("蕩", ),  # 8361 => 8569
    "荣" : ("榮", ),  # 8363 => 69AE
    "荤" : ("葷", ),  # 8364 => 8477
    "荥" : ("滎", ),  # 8365 => 6ECE
    "荦" : ("犖", ),  # 8366 => 7296
    "荧" : ("熒", ),  # 8367 => 7192
    "荨" : ("蕁", ),  # 8368 => 8541
    "荩" : ("藎", ),  # 8369 => 85CE
    "荪" : ("蓀", ),  # 836A => 84C0
    "荫" : ("蔭", ),  # 836B => 852D
    "荬" : ("蕒", ),  # 836C => 8552
    "荭" : ("葒", ),  # 836D => 8452
    "荮" : ("葤", ),  # 836E => 8464
    "药" : ("藥", ),  # 836F => 85E5
    "莅" : ("蒞", ),  # 8385 => 849E
    "莜" : ("蓧", ),  # 839C => 84E7
    "莱" : ("萊", ),  # 83B1 => 840A
    "莲" : ("蓮", ),  # 83B2 => 84EE
    "莳" : ("蒔", ),  # 83B3 => 8494
    "莴" : ("萵", ),  # 83B4 => 8435
    "莶" : ("薟", ),  # 83B6 => 859F
    "获" : ("獲", "穫"),  # 83B7 => 7372 7A6B
    "莸" : ("蕕", ),  # 83B8 => 8555
    "莹" : ("瑩", ),  # 83B9 => 7469
    "莺" : ("鶯", ),  # 83BA => 9DAF
    "莼" : ("蒓", "蓴"),  # 83BC => 8493 84F4
    "萚" : ("蘀", ),  # 841A => 8600
    "萝" : ("蘿", ),  # 841D => 863F
    "萤" : ("螢", ),  # 8424 => 87A2
    "营" : ("營", ),  # 8425 => 71DF
    "萦" : ("縈", ),  # 8426 => 7E08
    "萧" : ("蕭", ),  # 8427 => 856D
    "萨" : ("薩", ),  # 8428 => 85A9
    "葱" : ("蔥", ),  # 8471 => 8525
    "蒇" : ("蕆", ),  # 8487 => 8546
    "蒉" : ("蕢", ),  # 8489 => 8562
    "蒋" : ("蔣", ),  # 848B => 8523
    "蒌" : ("蔞", ),  # 848C => 851E
    "蒙" : ("懞", "濛", "矇"),  # 8499 => 61DE 6FDB 77C7
    "蓝" : ("藍", ),  # 84DD => 85CD
    "蓟" : ("薊", ),  # 84DF => 858A
    "蓠" : ("蘺", ),  # 84E0 => 863A
    "蓣" : ("蕷", ),  # 84E3 => 8577
    "蓥" : ("鎣", ),  # 84E5 => 93A3
    "蓦" : ("驀", ),  # 84E6 => 9A40
    "蔑" : ("衊", ),  # 8511 => 884A
    "蔷" : ("薔", ),  # 8537 => 8594
    "蔹" : ("蘞", ),  # 8539 => 861E
    "蔺" : ("藺", ),  # 853A => 85FA
    "蔼" : ("藹", ),  # 853C => 85F9
    "蕲" : ("蘄", ),  # 8572 => 8604
    "蕴" : ("藴", "蘊"),  # 8574 => 85F4 860A
    "薮" : ("藪", ),  # 85AE => 85EA
    "藁" : ("槁", ),  # 85C1 => 69C1
    "藓" : ("蘚", ),  # 85D3 => 861A
    "虏" : ("虜", ),  # 864F => 865C
    "虑" : ("慮", ),  # 8651 => 616E
    "虚" : ("虛", ),  # 865A => 865B
    "虫" : ("蟲", ),  # 866B => 87F2
    "虬" : ("虯", ),  # 866C => 866F
    "虮" : ("蟣", ),  # 866E => 87E3
    "虽" : ("雖", ),  # 867D => 96D6
    "虾" : ("蝦", ),  # 867E => 8766
    "虿" : ("蠆", ),  # 867F => 8806
    "蚀" : ("蝕", ),  # 8680 => 8755
    "蚁" : ("蟻", ),  # 8681 => 87FB
    "蚂" : ("螞", ),  # 8682 => 879E
    "蚕" : ("蠶", ),  # 8695 => 8836
    "蚝" : ("蠔", ),  # 869D => 8814
    "蚬" : ("蜆", ),  # 86AC => 8706
    "蛊" : ("蠱", ),  # 86CA => 8831
    "蛎" : ("蠣", ),  # 86CE => 8823
    "蛏" : ("蟶", ),  # 86CF => 87F6
    "蛮" : ("蠻", ),  # 86EE => 883B
    "蛰" : ("蟄", ),  # 86F0 => 87C4
    "蛱" : ("蛺", ),  # 86F1 => 86FA
    "蛲" : ("蟯", ),  # 86F2 => 87EF
    "蛳" : ("螄", ),  # 86F3 => 8784
    "蛴" : ("蠐", ),  # 86F4 => 8810
    "蜕" : ("蛻", ),  # 8715 => 86FB
    "蜗" : ("蝸", ),  # 8717 => 8778
    "蜡" : ("蠟", ),  # 8721 => 881F
    "蝇" : ("蠅", ),  # 8747 => 8805
    "蝈" : ("蟈", ),  # 8748 => 87C8
    "蝉" : ("蟬", ),  # 8749 => 87EC
    "蝎" : ("蠍", ),  # 874E => 880D
    "蝼" : ("螻", ),  # 877C => 87BB
    "蝾" : ("蠑", ),  # 877E => 8811
    "螨" : ("蟎", ),  # 87A8 => 87CE
    "蟏" : ("蠨", ),  # 87CF => 8828
    "衅" : ("釁", ),  # 8845 => 91C1
    "衔" : ("銜", ),  # 8854 => 929C
    "补" : ("補", ),  # 8865 => 88DC
    "表" : ("錶", ),  # 8868 => 9336
    "衬" : ("襯", ),  # 886C => 896F
    "衮" : ("袞", ),  # 886E => 889E
    "袄" : ("襖", ),  # 8884 => 8956
    "袅" : ("嫋", "裊"),  # 8885 => 5ACB 88CA
    "袜" : ("襪", ),  # 889C => 896A
    "袭" : ("襲", ),  # 88AD => 8972
    "装" : ("裝", ),  # 88C5 => 88DD
    "裆" : ("襠", ),  # 88C6 => 8960
    "裢" : ("褳", ),  # 88E2 => 8933
    "裣" : ("襝", ),  # 88E3 => 895D
    "裤" : ("褲", ),  # 88E4 => 8932
    "裥" : ("襇", ),  # 88E5 => 8947
    "褛" : ("褸", ),  # 891B => 8938
    "褴" : ("襤", ),  # 8934 => 8964
    "襁" : ("繈", ),  # 8941 => 7E48
    "见" : ("見", ),  # 89C1 => 898B
    "观" : ("觀", ),  # 89C2 => 89C0
    "觃" : ("覎", ),  # 89C3 => 898E
    "规" : ("規", ),  # 89C4 => 898F
    "觅" : ("覓", ),  # 89C5 => 8993
    "视" : ("視", ),  # 89C6 => 8996
    "觇" : ("覘", ),  # 89C7 => 8998
    "览" : ("覧", "覽"),  # 89C8 => 89A7 89BD
    "觉" : ("覺", ),  # 89C9 => 89BA
    "觊" : ("覬", ),  # 89CA => 89AC
    "觋" : ("覡", ),  # 89CB => 89A1
    "觌" : ("覿", ),  # 89CC => 89BF
    "觎" : ("覦", ),  # 89CE => 89A6
    "觏" : ("覯", ),  # 89CF => 89AF
    "觐" : ("覲", ),  # 89D0 => 89B2
    "觑" : ("覷", ),  # 89D1 => 89B7
    "觞" : ("觴", ),  # 89DE => 89F4
    "触" : ("觸", ),  # 89E6 => 89F8
    "觯" : ("觶", ),  # 89EF => 89F6
    "誉" : ("譽", ),  # 8A89 => 8B7D
    "誊" : ("謄", ),  # 8A8A => 8B04
    "讠" : ("訁", ),  # 8BA0 => 8A01
    "计" : ("計", ),  # 8BA1 => 8A08
    "订" : ("訂", ),  # 8BA2 => 8A02
    "讣" : ("訃", ),  # 8BA3 => 8A03
    "认" : ("認", ),  # 8BA4 => 8A8D
    "讥" : ("譏", ),  # 8BA5 => 8B4F
    "讦" : ("訐", ),  # 8BA6 => 8A10
    "讧" : ("訌", ),  # 8BA7 => 8A0C
    "讨" : ("討", ),  # 8BA8 => 8A0E
    "让" : ("讓", ),  # 8BA9 => 8B93
    "讪" : ("訕", ),  # 8BAA => 8A15
    "讫" : ("訖", ),  # 8BAB => 8A16
    "训" : ("訓", ),  # 8BAD => 8A13
    "议" : ("議", ),  # 8BAE => 8B70
    "讯" : ("訊", ),  # 8BAF => 8A0A
    "记" : ("記", ),  # 8BB0 => 8A18
    "讲" : ("講", ),  # 8BB2 => 8B1B
    "讳" : ("諱", ),  # 8BB3 => 8AF1
    "讴" : ("謳", ),  # 8BB4 => 8B33
    "讵" : ("詎", ),  # 8BB5 => 8A4E
    "讶" : ("訝", ),  # 8BB6 => 8A1D
    "讷" : ("訥", ),  # 8BB7 => 8A25
    "许" : ("許", ),  # 8BB8 => 8A31
    "讹" : ("訛", ),  # 8BB9 => 8A1B
    "论" : ("論", ),  # 8BBA => 8AD6
    "讻" : ("訩", ),  # 8BBB => 8A29
    "讼" : ("訟", ),  # 8BBC => 8A1F
    "讽" : ("諷", ),  # 8BBD => 8AF7
    "设" : ("設", ),  # 8BBE => 8A2D
    "访" : ("訪", ),  # 8BBF => 8A2A
    "诀" : ("訣", ),  # 8BC0 => 8A23
    "证" : ("證", ),  # 8BC1 => 8B49
    "诂" : ("詁", ),  # 8BC2 => 8A41
    "诃" : ("訶", ),  # 8BC3 => 8A36
    "评" : ("評", ),  # 8BC4 => 8A55
    "诅" : ("詛", ),  # 8BC5 => 8A5B
    "识" : ("識", ),  # 8BC6 => 8B58
    "诇" : ("詗", ),  # 8BC7 => 8A57
    "诈" : ("詐", ),  # 8BC8 => 8A50
    "诉" : ("訴", ),  # 8BC9 => 8A34
    "诊" : ("診", ),  # 8BCA => 8A3A
    "诋" : ("詆", ),  # 8BCB => 8A46
    "诌" : ("謅", ),  # 8BCC => 8B05
    "词" : ("詞", ),  # 8BCD => 8A5E
    "诎" : ("詘", ),  # 8BCE => 8A58
    "诏" : ("詔", ),  # 8BCF => 8A54
    "译" : ("譯", ),  # 8BD1 => 8B6F
    "诒" : ("詒", ),  # 8BD2 => 8A52
    "诓" : ("誆", ),  # 8BD3 => 8A86
    "诔" : ("誄", ),  # 8BD4 => 8A84
    "试" : ("試", ),  # 8BD5 => 8A66
    "诖" : ("詿", ),  # 8BD6 => 8A7F
    "诗" : ("詩", ),  # 8BD7 => 8A69
    "诘" : ("詰", ),  # 8BD8 => 8A70
    "诙" : ("詼", ),  # 8BD9 => 8A7C
    "诚" : ("誠", ),  # 8BDA => 8AA0
    "诛" : ("誅", ),  # 8BDB => 8A85
    "诜" : ("詵", ),  # 8BDC => 8A75
    "话" : ("話", ),  # 8BDD => 8A71
    "诞" : ("誕", ),  # 8BDE => 8A95
    "诟" : ("詬", ),  # 8BDF => 8A6C
    "诠" : ("詮", ),  # 8BE0 => 8A6E
    "诡" : ("詭", ),  # 8BE1 => 8A6D
    "询" : ("詢", ),  # 8BE2 => 8A62
    "诣" : ("詣", ),  # 8BE3 => 8A63
    "诤" : ("諍", ),  # 8BE4 => 8ACD
    "该" : ("該", ),  # 8BE5 => 8A72
    "详" : ("詳", ),  # 8BE6 => 8A73
    "诧" : ("詫", ),  # 8BE7 => 8A6B
    "诨" : ("諢", ),  # 8BE8 => 8AE2
    "诩" : ("詡", ),  # 8BE9 => 8A61
    "诫" : ("誡", ),  # 8BEB => 8AA1
    "诬" : ("誣", ),  # 8BEC => 8AA3
    "语" : ("語", ),  # 8BED => 8A9E
    "诮" : ("誚", ),  # 8BEE => 8A9A
    "误" : ("誤", ),  # 8BEF => 8AA4
    "诰" : ("誥", ),  # 8BF0 => 8AA5
    "诱" : ("誘", ),  # 8BF1 => 8A98
    "诲" : ("誨", ),  # 8BF2 => 8AA8
    "诳" : ("誑", ),  # 8BF3 => 8A91
    "说" : ("說", "説"),  # 8BF4 => 8AAA 8AAC
    "诵" : ("誦", ),  # 8BF5 => 8AA6
    "诶" : ("誒", ),  # 8BF6 => 8A92
    "请" : ("請", ),  # 8BF7 => 8ACB
    "诸" : ("諸", ),  # 8BF8 => 8AF8
    "诹" : ("諏", ),  # 8BF9 => 8ACF
    "诺" : ("諾", ),  # 8BFA => 8AFE
    "读" : ("讀", ),  # 8BFB => 8B80
    "诼" : ("諑", ),  # 8BFC => 8AD1
    "诽" : ("誹", ),  # 8BFD => 8AB9
    "课" : ("課", ),  # 8BFE => 8AB2
    "诿" : ("諉", ),  # 8BFF => 8AC9
    "谀" : ("諛", ),  # 8C00 => 8ADB
    "谁" : ("誰", ),  # 8C01 => 8AB0
    "谂" : ("諗", ),  # 8C02 => 8AD7
    "调" : ("調", ),  # 8C03 => 8ABF
    "谄" : ("諂", ),  # 8C04 => 8AC2
    "谅" : ("諒", ),  # 8C05 => 8AD2
    "谆" : ("諄", ),  # 8C06 => 8AC4
    "谇" : ("誶", ),  # 8C07 => 8AB6
    "谈" : ("談", ),  # 8C08 => 8AC7
    "谉" : ("讅", ),  # 8C09 => 8B85
    "谊" : ("誼", ),  # 8C0A => 8ABC
    "谋" : ("謀", ),  # 8C0B => 8B00
    "谌" : ("諶", ),  # 8C0C => 8AF6
    "谍" : ("諜", ),  # 8C0D => 8ADC
    "谎" : ("謊", ),  # 8C0E => 8B0A
    "谏" : ("諫", ),  # 8C0F => 8AEB
    "谐" : ("諧", ),  # 8C10 => 8AE7
    "谑" : ("謔", ),  # 8C11 => 8B14
    "谒" : ("謁", ),  # 8C12 => 8B01
    "谓" : ("謂", ),  # 8C13 => 8B02
    "谔" : ("諤", ),  # 8C14 => 8AE4
    "谕" : ("諭", ),  # 8C15 => 8AED
    "谖" : ("諼", ),  # 8C16 => 8AFC
    "谗" : ("讒", ),  # 8C17 => 8B92
    "谘" : ("諮", ),  # 8C18 => 8AEE
    "谙" : ("諳", ),  # 8C19 => 8AF3
    "谚" : ("諺", ),  # 8C1A => 8AFA
    "谛" : ("諦", ),  # 8C1B => 8AE6
    "谜" : ("謎", ),  # 8C1C => 8B0E
    "谝" : ("諞", ),  # 8C1D => 8ADE
    "谞" : ("諝", ),  # 8C1E => 8ADD
    "谟" : ("謨", ),  # 8C1F => 8B28
    "谠" : ("讜", ),  # 8C20 => 8B9C
    "谡" : ("謖", ),  # 8C21 => 8B16
    "谢" : ("謝", ),  # 8C22 => 8B1D
    "谣" : ("謠", "謡"),  # 8C23 => 8B20 8B21
    "谤" : ("謗", ),  # 8C24 => 8B17
    "谥" : ("諡", "謚"),  # 8C25 => 8AE1 8B1A
    "谦" : ("謙", ),  # 8C26 => 8B19
    "谧" : ("謐", ),  # 8C27 => 8B10
    "谨" : ("謹", ),  # 8C28 => 8B39
    "谩" : ("謾", ),  # 8C29 => 8B3E
    "谪" : ("謫", ),  # 8C2A => 8B2B
    "谫" : ("譾", ),  # 8C2B => 8B7E
    "谬" : ("謬", ),  # 8C2C => 8B2C
    "谭" : ("譚", ),  # 8C2D => 8B5A
    "谮" : ("譖", ),  # 8C2E => 8B56
    "谯" : ("譙", ),  # 8C2F => 8B59
    "谰" : ("讕", ),  # 8C30 => 8B95
    "谱" : ("譜", ),  # 8C31 => 8B5C
    "谲" : ("譎", ),  # 8C32 => 8B4E
    "谳" : ("讞", ),  # 8C33 => 8B9E
    "谴" : ("譴", ),  # 8C34 => 8B74
    "谵" : ("譫", ),  # 8C35 => 8B6B
    "谶" : ("讖", ),  # 8C36 => 8B96
    "谷" : ("榖", ),  # 8C37 => 6996
    "豮" : ("豶", ),  # 8C6E => 8C76
    "贝" : ("貝", ),  # 8D1D => 8C9D
    "贞" : ("貞", ),  # 8D1E => 8C9E
    "负" : ("負", ),  # 8D1F => 8CA0
    "贡" : ("貢", ),  # 8D21 => 8CA2
    "财" : ("財", ),  # 8D22 => 8CA1
    "责" : ("責", ),  # 8D23 => 8CAC
    "贤" : ("賢", ),  # 8D24 => 8CE2
    "败" : ("敗", ),  # 8D25 => 6557
    "账" : ("賬", ),  # 8D26 => 8CEC
    "货" : ("貨", ),  # 8D27 => 8CA8
    "质" : ("質", ),  # 8D28 => 8CEA
    "贩" : ("販", ),  # 8D29 => 8CA9
    "贪" : ("貪", ),  # 8D2A => 8CAA
    "贫" : ("貧", ),  # 8D2B => 8CA7
    "贬" : ("貶", ),  # 8D2C => 8CB6
    "购" : ("購", ),  # 8D2D => 8CFC
    "贮" : ("貯", ),  # 8D2E => 8CAF
    "贯" : ("貫", ),  # 8D2F => 8CAB
    "贰" : ("貳", ),  # 8D30 => 8CB3
    "贱" : ("賤", ),  # 8D31 => 8CE4
    "贲" : ("賁", ),  # 8D32 => 8CC1
    "贳" : ("貰", ),  # 8D33 => 8CB0
    "贴" : ("貼", ),  # 8D34 => 8CBC
    "贵" : ("貴", ),  # 8D35 => 8CB4
    "贶" : ("貺", ),  # 8D36 => 8CBA
    "贷" : ("貸", ),  # 8D37 => 8CB8
    "贸" : ("貿", ),  # 8D38 => 8CBF
    "费" : ("費", ),  # 8D39 => 8CBB
    "贺" : ("賀", ),  # 8D3A => 8CC0
    "贻" : ("貽", ),  # 8D3B => 8CBD
    "贼" : ("賊", ),  # 8D3C => 8CCA
    "贽" : ("贄", ),  # 8D3D => 8D04
    "贾" : ("賈", ),  # 8D3E => 8CC8
    "贿" : ("賄", ),  # 8D3F => 8CC4
    "赀" : ("貲", ),  # 8D40 => 8CB2
    "赁" : ("賃", ),  # 8D41 => 8CC3
    "赂" : ("賂", ),  # 8D42 => 8CC2
    "赃" : ("臓", "贓"),  # 8D43 => 81D3 8D13
    "资" : ("資", ),  # 8D44 => 8CC7
    "赅" : ("賅", ),  # 8D45 => 8CC5
    "赆" : ("贐", ),  # 8D46 => 8D10
    "赇" : ("賕", ),  # 8D47 => 8CD5
    "赈" : ("賑", ),  # 8D48 => 8CD1
    "赉" : ("賚", ),  # 8D49 => 8CDA
    "赊" : ("賒", ),  # 8D4A => 8CD2
    "赋" : ("賦", ),  # 8D4B => 8CE6
    "赌" : ("賭", ),  # 8D4C => 8CED
    "赍" : ("賫", "齎"),  # 8D4D => 8CEB 9F4E
    "赎" : ("贖", ),  # 8D4E => 8D16
    "赏" : ("賞", ),  # 8D4F => 8CDE
    "赐" : ("賜", ),  # 8D50 => 8CDC
    "赒" : ("賙", ),  # 8D52 => 8CD9
    "赓" : ("賡", ),  # 8D53 => 8CE1
    "赔" : ("賠", ),  # 8D54 => 8CE0
    "赕" : ("賧", ),  # 8D55 => 8CE7
    "赖" : ("賴", ),  # 8D56 => 8CF4
    "赗" : ("賵", ),  # 8D57 => 8CF5
    "赘" : ("贅", ),  # 8D58 => 8D05
    "赙" : ("賻", ),  # 8D59 => 8CFB
    "赚" : ("賺", ),  # 8D5A => 8CFA
    "赛" : ("賽", ),  # 8D5B => 8CFD
    "赜" : ("賾", ),  # 8D5C => 8CFE
    "赝" : ("贋", "贗"),  # 8D5D => 8D0B 8D17
    "赞" : ("贊", ),  # 8D5E => 8D0A
    "赠" : ("贈", ),  # 8D60 => 8D08
    "赡" : ("贍", ),  # 8D61 => 8D0D
    "赢" : ("贏", ),  # 8D62 => 8D0F
    "赣" : ("贛", ),  # 8D63 => 8D1B
    "赪" : ("赬", ),  # 8D6A => 8D6C
    "赵" : ("趙", ),  # 8D75 => 8D99
    "赶" : ("趕", ),  # 8D76 => 8D95
    "趋" : ("趨", ),  # 8D8B => 8DA8
    "趱" : ("趲", ),  # 8DB1 => 8DB2
    "趸" : ("躉", ),  # 8DB8 => 8E89
    "跃" : ("躍", ),  # 8DC3 => 8E8D
    "跄" : ("蹌", ),  # 8DC4 => 8E4C
    "跖" : ("蹠", ),  # 8DD6 => 8E60
    "跞" : ("躒", ),  # 8DDE => 8E92
    "践" : ("踐", ),  # 8DF5 => 8E10
    "跷" : ("蹺", ),  # 8DF7 => 8E7A
    "跸" : ("蹕", ),  # 8DF8 => 8E55
    "跹" : ("躚", ),  # 8DF9 => 8E9A
    "跻" : ("躋", ),  # 8DFB => 8E8B
    "踊" : ("踴", ),  # 8E0A => 8E34
    "踌" : ("躊", ),  # 8E0C => 8E8A
    "踪" : ("蹤", ),  # 8E2A => 8E64
    "踬" : ("躓", ),  # 8E2C => 8E93
    "踯" : ("躑", ),  # 8E2F => 8E91
    "蹑" : ("躡", ),  # 8E51 => 8EA1
    "蹒" : ("蹣", ),  # 8E52 => 8E63
    "蹰" : ("躕", ),  # 8E70 => 8E95
    "蹿" : ("躥", ),  # 8E7F => 8EA5
    "躏" : ("躪", ),  # 8E8F => 8EAA
    "躜" : ("躦", ),  # 8E9C => 8EA6
    "躯" : ("軀", ),  # 8EAF => 8EC0
    "车" : ("車", ),  # 8F66 => 8ECA
    "轧" : ("軋", ),  # 8F67 => 8ECB
    "轨" : ("軌", ),  # 8F68 => 8ECC
    "轩" : ("軒", ),  # 8F69 => 8ED2
    "轫" : ("軔", ),  # 8F6B => 8ED4
    "转" : ("轉", ),  # 8F6C => 8F49
    "轭" : ("軛", ),  # 8F6D => 8EDB
    "轮" : ("輪", ),  # 8F6E => 8F2A
    "软" : ("軟", ),  # 8F6F => 8EDF
    "轰" : ("轟", ),  # 8F70 => 8F5F
    "轱" : ("軲", ),  # 8F71 => 8EF2
    "轲" : ("軻", ),  # 8F72 => 8EFB
    "轳" : ("轤", ),  # 8F73 => 8F64
    "轴" : ("軸", ),  # 8F74 => 8EF8
    "轵" : ("軹", ),  # 8F75 => 8EF9
    "轶" : ("軼", ),  # 8F76 => 8EFC
    "轷" : ("軤", ),  # 8F77 => 8EE4
    "轸" : ("軫", ),  # 8F78 => 8EEB
    "轹" : ("轢", ),  # 8F79 => 8F62
    "轺" : ("軺", ),  # 8F7A => 8EFA
    "轻" : ("輕", ),  # 8F7B => 8F15
    "轼" : ("軾", ),  # 8F7C => 8EFE
    "载" : ("載", ),  # 8F7D => 8F09
    "轾" : ("輊", ),  # 8F7E => 8F0A
    "轿" : ("轎", ),  # 8F7F => 8F4E
    "辁" : ("輇", ),  # 8F81 => 8F07
    "辂" : ("輅", ),  # 8F82 => 8F05
    "较" : ("較", ),  # 8F83 => 8F03
    "辄" : ("輒", ),  # 8F84 => 8F12
    "辅" : ("輔", ),  # 8F85 => 8F14
    "辆" : ("輛", ),  # 8F86 => 8F1B
    "辇" : ("輦", ),  # 8F87 => 8F26
    "辈" : ("輩", ),  # 8F88 => 8F29
    "辉" : ("輝", ),  # 8F89 => 8F1D
    "辊" : ("輥", ),  # 8F8A => 8F25
    "辋" : ("輞", ),  # 8F8B => 8F1E
    "辍" : ("輟", ),  # 8F8D => 8F1F
    "辎" : ("輜", ),  # 8F8E => 8F1C
    "辏" : ("輳", ),  # 8F8F => 8F33
    "辐" : ("輻", ),  # 8F90 => 8F3B
    "辑" : ("輯", ),  # 8F91 => 8F2F
    "输" : ("輸", ),  # 8F93 => 8F38
    "辔" : ("轡", ),  # 8F94 => 8F61
    "辕" : ("轅", ),  # 8F95 => 8F45
    "辖" : ("轄", ),  # 8F96 => 8F44
    "辗" : ("輾", ),  # 8F97 => 8F3E
    "辘" : ("轆", ),  # 8F98 => 8F46
    "辙" : ("轍", ),  # 8F99 => 8F4D
    "辚" : ("轔", ),  # 8F9A => 8F54
    "辞" : ("辭", ),  # 8F9E => 8FAD
    "辟" : ("闢", ),  # 8F9F => 95E2
    "辩" : ("辯", ),  # 8FA9 => 8FAF
    "辫" : ("辮", ),  # 8FAB => 8FAE
    "边" : ("邊", ),  # 8FB9 => 908A
    "辽" : ("遼", ),  # 8FBD => 907C
    "达" : ("達", ),  # 8FBE => 9054
    "迁" : ("遷", ),  # 8FC1 => 9077
    "过" : ("過", ),  # 8FC7 => 904E
    "迈" : ("邁", ),  # 8FC8 => 9081
    "运" : ("運", ),  # 8FD0 => 904B
    "还" : ("還", ),  # 8FD8 => 9084
    "这" : ("這", ),  # 8FD9 => 9019
    "进" : ("進", ),  # 8FDB => 9032
    "远" : ("遠", ),  # 8FDC => 9060
    "违" : ("違", ),  # 8FDD => 9055
    "连" : ("連", ),  # 8FDE => 9023
    "迟" : ("遲", ),  # 8FDF => 9072
    "迩" : ("邇", ),  # 8FE9 => 9087
    "迳" : ("逕", ),  # 8FF3 => 9015
    "迹" : ("跡", ),  # 8FF9 => 8DE1
    "适" : ("適", ),  # 9002 => 9069
    "选" : ("選", ),  # 9009 => 9078
    "逊" : ("遜", ),  # 900A => 905C
    "递" : ("遞", ),  # 9012 => 905E
    "逦" : ("邐", ),  # 9026 => 9090
    "逻" : ("邏", ),  # 903B => 908F
    "遗" : ("遺", ),  # 9057 => 907A
    "遥" : ("遙", ),  # 9065 => 9059
    "邓" : ("鄧", ),  # 9093 => 9127
    "邝" : ("鄺", ),  # 909D => 913A
    "邬" : ("鄔", ),  # 90AC => 9114
    "邮" : ("郵", ),  # 90AE => 90F5
    "邹" : ("鄒", ),  # 90B9 => 9112
    "邺" : ("鄴", ),  # 90BA => 9134
    "邻" : ("鄰", ),  # 90BB => 9130
    "郁" : ("鬱", ),  # 90C1 => 9B31
    "郄" : ("郤", ),  # 90C4 => 90E4
    "郏" : ("郟", ),  # 90CF => 90DF
    "郐" : ("鄶", ),  # 90D0 => 9136
    "郑" : ("鄭", ),  # 90D1 => 912D
    "郓" : ("鄆", ),  # 90D3 => 9106
    "郦" : ("酈", ),  # 90E6 => 9148
    "郧" : ("鄖", ),  # 90E7 => 9116
    "郸" : ("鄲", ),  # 90F8 => 9132
    "酝" : ("醖", "醞"),  # 915D => 9196 919E
    "酰" : ("醯", ),  # 9170 => 91AF
    "酱" : ("醤", "醬"),  # 9171 => 91A4 91AC
    "酽" : ("釅", ),  # 917D => 91C5
    "酾" : ("釃", ),  # 917E => 91C3
    "酿" : ("釀", ),  # 917F => 91C0
    "释" : ("釋", ),  # 91CA => 91CB
    "里" : ("裏", ),  # 91CC => 88CF
    "鉴" : ("鑒", ),  # 9274 => 9452
    "銮" : ("鑾", ),  # 92AE => 947E
    "錾" : ("鏨", ),  # 933E => 93E8
    "钆" : ("釓", ),  # 9486 => 91D3
    "钇" : ("釔", ),  # 9487 => 91D4
    "针" : ("針", ),  # 9488 => 91DD
    "钉" : ("釘", ),  # 9489 => 91D8
    "钊" : ("釗", ),  # 948A => 91D7
    "钋" : ("釙", ),  # 948B => 91D9
    "钌" : ("釕", ),  # 948C => 91D5
    "钍" : ("釷", ),  # 948D => 91F7
    "钎" : ("釺", ),  # 948E => 91FA
    "钏" : ("釧", ),  # 948F => 91E7
    "钐" : ("釤", ),  # 9490 => 91E4
    "钒" : ("釩", ),  # 9492 => 91E9
    "钓" : ("釣", ),  # 9493 => 91E3
    "钔" : ("鍆", ),  # 9494 => 9346
    "钕" : ("釹", ),  # 9495 => 91F9
    "钖" : ("鍚", ),  # 9496 => 935A
    "钗" : ("釵", ),  # 9497 => 91F5
    "钘" : ("鈃", ),  # 9498 => 9203
    "钙" : ("鈣", ),  # 9499 => 9223
    "钚" : ("鈈", ),  # 949A => 9208
    "钛" : ("鈦", ),  # 949B => 9226
    "钝" : ("鈍", ),  # 949D => 920D
    "钞" : ("鈔", ),  # 949E => 9214
    "钟" : ("鐘", ),  # 949F => 9418
    "钠" : ("鈉", ),  # 94A0 => 9209
    "钡" : ("鋇", ),  # 94A1 => 92C7
    "钢" : ("鋼", ),  # 94A2 => 92FC
    "钣" : ("鈑", ),  # 94A3 => 9211
    "钤" : ("鈐", ),  # 94A4 => 9210
    "钥" : ("鑰", ),  # 94A5 => 9470
    "钦" : ("欽", ),  # 94A6 => 6B3D
    "钧" : ("鈞", ),  # 94A7 => 921E
    "钨" : ("鎢", ),  # 94A8 => 93A2
    "钩" : ("鈎", "鉤"),  # 94A9 => 920E 9264
    "钪" : ("鈧", ),  # 94AA => 9227
    "钫" : ("鈁", ),  # 94AB => 9201
    "钬" : ("鈥", ),  # 94AC => 9225
    "钭" : ("鈄", ),  # 94AD => 9204
    "钮" : ("鈕", ),  # 94AE => 9215
    "钯" : ("鈀", ),  # 94AF => 9200
    "钰" : ("鈺", ),  # 94B0 => 923A
    "钱" : ("錢", ),  # 94B1 => 9322
    "钲" : ("鉦", ),  # 94B2 => 9266
    "钳" : ("鉗", ),  # 94B3 => 9257
    "钴" : ("鈷", ),  # 94B4 => 9237
    "钵" : ("缽", "鉢"),  # 94B5 => 7F3D 9262
    "钶" : ("鈳", ),  # 94B6 => 9233
    "钷" : ("鉕", ),  # 94B7 => 9255
    "钸" : ("鈽", ),  # 94B8 => 923D
    "钹" : ("鈸", ),  # 94B9 => 9238
    "钺" : ("鉞", ),  # 94BA => 925E
    "钻" : ("鑽", ),  # 94BB => 947D
    "钼" : ("鉬", ),  # 94BC => 926C
    "钽" : ("鉭", ),  # 94BD => 926D
    "钾" : ("鉀", ),  # 94BE => 9240
    "钿" : ("鈿", ),  # 94BF => 923F
    "铀" : ("鈾", ),  # 94C0 => 923E
    "铁" : ("鐵", ),  # 94C1 => 9435
    "铂" : ("鉑", ),  # 94C2 => 9251
    "铃" : ("鈴", ),  # 94C3 => 9234
    "铄" : ("鑠", ),  # 94C4 => 9460
    "铅" : ("鉛", ),  # 94C5 => 925B
    "铆" : ("鉚", ),  # 94C6 => 925A
    "铈" : ("鈰", ),  # 94C8 => 9230
    "铉" : ("鉉", ),  # 94C9 => 9249
    "铊" : ("鉈", ),  # 94CA => 9248
    "铋" : ("鉍", ),  # 94CB => 924D
    "铌" : ("鈮", ),  # 94CC => 922E
    "铍" : ("鈹", ),  # 94CD => 9239
    "铎" : ("鐸", ),  # 94CE => 9438
    "铏" : ("鉶", ),  # 94CF => 9276
    "铐" : ("銬", ),  # 94D0 => 92AC
    "铑" : ("銠", ),  # 94D1 => 92A0
    "铒" : ("鉺", ),  # 94D2 => 927A
    "铓" : ("鋩", ),  # 94D3 => 92E9
    "铕" : ("銪", ),  # 94D5 => 92AA
    "铖" : ("鋮", ),  # 94D6 => 92EE
    "铗" : ("鋏", ),  # 94D7 => 92CF
    "铘" : ("鋣", ),  # 94D8 => 92E3
    "铙" : ("鐃", ),  # 94D9 => 9403
    "铛" : ("鐺", ),  # 94DB => 943A
    "铜" : ("銅", ),  # 94DC => 9285
    "铝" : ("鋁", ),  # 94DD => 92C1
    "铞" : ("銱", ),  # 94DE => 92B1
    "铟" : ("銦", ),  # 94DF => 92A6
    "铠" : ("鎧", ),  # 94E0 => 93A7
    "铡" : ("鍘", ),  # 94E1 => 9358
    "铢" : ("銖", ),  # 94E2 => 9296
    "铣" : ("銑", ),  # 94E3 => 9291
    "铤" : ("鋌", ),  # 94E4 => 92CC
    "铥" : ("銩", ),  # 94E5 => 92A9
    "铧" : ("鏵", ),  # 94E7 => 93F5
    "铨" : ("銓", ),  # 94E8 => 9293
    "铩" : ("鎩", ),  # 94E9 => 93A9
    "铪" : ("鉿", ),  # 94EA => 927F
    "铫" : ("銚", ),  # 94EB => 929A
    "铬" : ("鉻", ),  # 94EC => 927B
    "铭" : ("銘", ),  # 94ED => 9298
    "铮" : ("錚", ),  # 94EE => 931A
    "铯" : ("銫", ),  # 94EF => 92AB
    "铰" : ("鉸", ),  # 94F0 => 9278
    "铱" : ("銥", ),  # 94F1 => 92A5
    "铲" : ("鏟", ),  # 94F2 => 93DF
    "铳" : ("銃", ),  # 94F3 => 9283
    "铴" : ("鐋", ),  # 94F4 => 940B
    "铵" : ("銨", ),  # 94F5 => 92A8
    "银" : ("銀", ),  # 94F6 => 9280
    "铷" : ("銣", ),  # 94F7 => 92A3
    "铸" : ("鑄", ),  # 94F8 => 9444
    "铹" : ("鐒", ),  # 94F9 => 9412
    "铺" : ("鋪", ),  # 94FA => 92EA
    "铼" : ("錸", ),  # 94FC => 9338
    "铽" : ("鋱", ),  # 94FD => 92F1
    "链" : ("鏈", ),  # 94FE => 93C8
    "铿" : ("鏗", ),  # 94FF => 93D7
    "销" : ("銷", ),  # 9500 => 92B7
    "锁" : ("鎖", ),  # 9501 => 9396
    "锂" : ("鋰", ),  # 9502 => 92F0
    "锃" : ("鋥", ),  # 9503 => 92E5
    "锄" : ("鋤", ),  # 9504 => 92E4
    "锅" : ("鍋", ),  # 9505 => 934B
    "锆" : ("鋯", ),  # 9506 => 92EF
    "锇" : ("鋨", ),  # 9507 => 92E8
    "锈" : ("銹", "鏽"),  # 9508 => 92B9 93FD
    "锉" : ("銼", ),  # 9509 => 92BC
    "锊" : ("鋝", ),  # 950A => 92DD
    "锋" : ("鋒", ),  # 950B => 92D2
    "锌" : ("鋅", ),  # 950C => 92C5
    "锍" : ("鋶", ),  # 950D => 92F6
    "锎" : ("鉲", "鐦"),  # 950E => 9272 9426
    "锏" : ("鐧", ),  # 950F => 9427
    "锐" : ("銳", "鋭"),  # 9510 => 92B3 92ED
    "锑" : ("銻", ),  # 9511 => 92BB
    "锒" : ("鋃", ),  # 9512 => 92C3
    "锓" : ("鋟", ),  # 9513 => 92DF
    "锔" : ("鋦", ),  # 9514 => 92E6
    "锕" : ("錒", ),  # 9515 => 9312
    "锖" : ("錆", ),  # 9516 => 9306
    "锗" : ("鍺", ),  # 9517 => 937A
    "锘" : ("鍩", ),  # 9518 => 9369
    "错" : ("錯", ),  # 9519 => 932F
    "锚" : ("錨", ),  # 951A => 9328
    "锛" : ("錛", ),  # 951B => 931B
    "锝" : ("鍀", ),  # 951D => 9340
    "锞" : ("錁", ),  # 951E => 9301
    "锟" : ("錕", ),  # 951F => 9315
    "锡" : ("錫", ),  # 9521 => 932B
    "锢" : ("錮", ),  # 9522 => 932E
    "锣" : ("鑼", ),  # 9523 => 947C
    "锤" : ("錘", ),  # 9524 => 9318
    "锥" : ("錐", ),  # 9525 => 9310
    "锦" : ("錦", ),  # 9526 => 9326
    "锧" : ("鑕", ),  # 9527 => 9455
    "锨" : ("鍁", ),  # 9528 => 9341
    "锩" : ("錈", ),  # 9529 => 9308
    "锪" : ("鍃", ),  # 952A => 9343
    "锫" : ("錇", ),  # 952B => 9307
    "锬" : ("錟", ),  # 952C => 931F
    "锭" : ("錠", ),  # 952D => 9320
    "键" : ("鍵", ),  # 952E => 9375
    "锯" : ("鋸", ),  # 952F => 92F8
    "锰" : ("錳", ),  # 9530 => 9333
    "锱" : ("錙", ),  # 9531 => 9319
    "锲" : ("鍥", ),  # 9532 => 9365
    "锴" : ("鍇", ),  # 9534 => 9347
    "锵" : ("鏘", ),  # 9535 => 93D8
    "锶" : ("鍶", ),  # 9536 => 9376
    "锷" : ("鍔", ),  # 9537 => 9354
    "锸" : ("鍤", ),  # 9538 => 9364
    "锹" : ("鍬", ),  # 9539 => 936C
    "锺" : ("鍾", ),  # 953A => 937E
    "锻" : ("鍛", ),  # 953B => 935B
    "锼" : ("鎪", ),  # 953C => 93AA
    "锾" : ("鍰", ),  # 953E => 9370
    "锿" : ("鎄", ),  # 953F => 9384
    "镀" : ("鍍", ),  # 9540 => 934D
    "镁" : ("鎂", ),  # 9541 => 9382
    "镂" : ("鏤", ),  # 9542 => 93E4
    "镃" : ("鎡", ),  # 9543 => 93A1
    "镄" : ("鐨", ),  # 9544 => 9428
    "镅" : ("鋂", "鎇"),  # 9545 => 92C2 9387
    "镆" : ("鏌", ),  # 9546 => 93CC
    "镇" : ("鎮", ),  # 9547 => 93AE
    "镉" : ("鎘", ),  # 9549 => 9398
    "镊" : ("鑷", ),  # 954A => 9477
    "镋" : ("钂", ),  # 954B => 9482
    "镌" : ("鎸", "鐫"),  # 954C => 93B8 942B
    "镍" : ("鎳", ),  # 954D => 93B3
    "镎" : ("錼", "鎿"),  # 954E => 933C 93BF
    "镏" : ("鎦", ),  # 954F => 93A6
    "镐" : ("鎬", ),  # 9550 => 93AC
    "镑" : ("鎊", ),  # 9551 => 938A
    "镒" : ("鎰", ),  # 9552 => 93B0
    "镓" : ("鎵", ),  # 9553 => 93B5
    "镔" : ("鑌", ),  # 9554 => 944C
    "镖" : ("鏢", ),  # 9556 => 93E2
    "镗" : ("鏜", ),  # 9557 => 93DC
    "镘" : ("鏝", ),  # 9558 => 93DD
    "镙" : ("鏍", ),  # 9559 => 93CD
    "镚" : ("鏰", ),  # 955A => 93F0
    "镛" : ("鏞", ),  # 955B => 93DE
    "镜" : ("鏡", ),  # 955C => 93E1
    "镝" : ("鏑", ),  # 955D => 93D1
    "镞" : ("鏃", ),  # 955E => 93C3
    "镟" : ("鏇", ),  # 955F => 93C7
    "镡" : ("鐔", ),  # 9561 => 9414
    "镢" : ("鐝", "钁"),  # 9562 => 941D 9481
    "镣" : ("鐐", ),  # 9563 => 9410
    "镤" : ("鏷", ),  # 9564 => 93F7
    "镥" : ("鑥", ),  # 9565 => 9465
    "镦" : ("鐓", ),  # 9566 => 9413
    "镧" : ("鑭", ),  # 9567 => 946D
    "镨" : ("鐠", ),  # 9568 => 9420
    "镩" : ("鑹", ),  # 9569 => 9479
    "镪" : ("鏹", ),  # 956A => 93F9
    "镫" : ("鐙", ),  # 956B => 9419
    "镬" : ("鑊", ),  # 956C => 944A
    "镭" : ("鐳", ),  # 956D => 9433
    "镮" : ("鐶", ),  # 956E => 9436
    "镯" : ("鐲", ),  # 956F => 9432
    "镰" : ("鐮", ),  # 9570 => 942E
    "镱" : ("鐿", ),  # 9571 => 943F
    "镲" : ("鑔", ),  # 9572 => 9454
    "镳" : ("鑣", ),  # 9573 => 9463
    "镴" : ("鑞", ),  # 9574 => 945E
    "镶" : ("鑲", ),  # 9576 => 9472
    "长" : ("長", ),  # 957F => 9577
    "门" : ("門", ),  # 95E8 => 9580
    "闩" : ("閂", ),  # 95E9 => 9582
    "闪" : ("閃", ),  # 95EA => 9583
    "闫" : ("閆", ),  # 95EB => 9586
    "闭" : ("閉", ),  # 95ED => 9589
    "问" : ("問", ),  # 95EE => 554F
    "闯" : ("闖", ),  # 95EF => 95D6
    "闰" : ("閏", ),  # 95F0 => 958F
    "闱" : ("闈", ),  # 95F1 => 95C8
    "闲" : ("閑", ),  # 95F2 => 9591
    "闳" : ("閎", ),  # 95F3 => 958E
    "间" : ("間", ),  # 95F4 => 9593
    "闵" : ("閔", ),  # 95F5 => 9594
    "闶" : ("閌", ),  # 95F6 => 958C
    "闷" : ("悶", ),  # 95F7 => 60B6
    "闸" : ("閘", ),  # 95F8 => 9598
    "闹" : ("閙", "鬧"),  # 95F9 => 9599 9B27
    "闺" : ("閨", ),  # 95FA => 95A8
    "闻" : ("聞", ),  # 95FB => 805E
    "闼" : ("闥", ),  # 95FC => 95E5
    "闽" : ("閩", ),  # 95FD => 95A9
    "闾" : ("閭", ),  # 95FE => 95AD
    "闿" : ("闓", ),  # 95FF => 95D3
    "阀" : ("閥", ),  # 9600 => 95A5
    "阁" : ("閣", ),  # 9601 => 95A3
    "阂" : ("閡", ),  # 9602 => 95A1
    "阃" : ("閫", ),  # 9603 => 95AB
    "阄" : ("鬮", ),  # 9604 => 9B2E
    "阅" : ("閱", "閲"),  # 9605 => 95B1 95B2
    "阆" : ("閬", ),  # 9606 => 95AC
    "阈" : ("閾", ),  # 9608 => 95BE
    "阉" : ("閹", ),  # 9609 => 95B9
    "阊" : ("閶", ),  # 960A => 95B6
    "阋" : ("鬩", ),  # 960B => 9B29
    "阌" : ("閿", ),  # 960C => 95BF
    "阍" : ("閽", ),  # 960D => 95BD
    "阎" : ("閻", ),  # 960E => 95BB
    "阏" : ("閼", ),  # 960F => 95BC
    "阐" : ("闡", ),  # 9610 => 95E1
    "阑" : ("闌", ),  # 9611 => 95CC
    "阒" : ("闃", ),  # 9612 => 95C3
    "阔" : ("闊", ),  # 9614 => 95CA
    "阕" : ("闋", ),  # 9615 => 95CB
    "阖" : ("闔", ),  # 9616 => 95D4
    "阗" : ("闐", ),  # 9617 => 95D0
    "阙" : ("闕", ),  # 9619 => 95D5
    "阚" : ("闞", ),  # 961A => 95DE
    "队" : ("隊", ),  # 961F => 968A
    "阳" : ("陽", ),  # 9633 => 967D
    "阴" : ("陰", ),  # 9634 => 9670
    "阵" : ("陣", ),  # 9635 => 9663
    "阶" : ("階", ),  # 9636 => 968E
    "际" : ("際", ),  # 9645 => 969B
    "陆" : ("陸", ),  # 9646 => 9678
    "陇" : ("隴", ),  # 9647 => 96B4
    "陈" : ("陳", ),  # 9648 => 9673
    "陉" : ("陘", ),  # 9649 => 9658
    "陕" : ("陝", ),  # 9655 => 965D
    "陧" : ("隉", ),  # 9667 => 9689
    "陨" : ("隕", ),  # 9668 => 9695
    "险" : ("險", ),  # 9669 => 96AA
    "随" : ("隨", ),  # 968F => 96A8
    "隐" : ("隱", ),  # 9690 => 96B1
    "隶" : ("隷", "隸"),  # 96B6 => 96B7 96B8
    "隽" : ("雋", ),  # 96BD => 96CB
    "难" : ("難", ),  # 96BE => 96E3
    "雏" : ("雛", ),  # 96CF => 96DB
    "雠" : ("讎", ),  # 96E0 => 8B8E
    "雳" : ("靂", ),  # 96F3 => 9742
    "雾" : ("霧", ),  # 96FE => 9727
    "霁" : ("霽", ),  # 9701 => 973D
    "霉" : ("黴", ),  # 9709 => 9EF4
    "霭" : ("靄", ),  # 972D => 9744
    "靓" : ("靚", ),  # 9753 => 975A
    "静" : ("靜", ),  # 9759 => 975C
    "面" : ("麵", ),  # 9762 => 9EB5
    "靥" : ("靨", ),  # 9765 => 9768
    "鞑" : ("韃", ),  # 9791 => 97C3
    "鞒" : ("鞽", ),  # 9792 => 97BD
    "鞯" : ("韉", ),  # 97AF => 97C9
    "鞴" : ("韝", ),  # 97B4 => 97DD
    "韦" : ("韋", ),  # 97E6 => 97CB
    "韧" : ("韌", ),  # 97E7 => 97CC
    "韨" : ("韍", ),  # 97E8 => 97CD
    "韩" : ("韓", ),  # 97E9 => 97D3
    "韪" : ("韙", ),  # 97EA => 97D9
    "韫" : ("韞", ),  # 97EB => 97DE
    "韬" : ("韜", ),  # 97EC => 97DC
    "韵" : ("韻", ),  # 97F5 => 97FB
    "页" : ("頁", ),  # 9875 => 9801
    "顶" : ("頂", ),  # 9876 => 9802
    "顷" : ("頃", ),  # 9877 => 9803
    "顸" : ("頇", ),  # 9878 => 9807
    "项" : ("項", ),  # 9879 => 9805
    "顺" : ("順", ),  # 987A => 9806
    "须" : ("須", "鬚"),  # 987B => 9808 9B1A
    "顼" : ("頊", ),  # 987C => 980A
    "顽" : ("頑", ),  # 987D => 9811
    "顾" : ("顧", ),  # 987E => 9867
    "顿" : ("頓", ),  # 987F => 9813
    "颀" : ("頎", ),  # 9880 => 980E
    "颁" : ("頒", ),  # 9881 => 9812
    "颂" : ("頌", ),  # 9882 => 980C
    "颃" : ("頏", ),  # 9883 => 980F
    "预" : ("預", ),  # 9884 => 9810
    "颅" : ("顱", ),  # 9885 => 9871
    "领" : ("領", ),  # 9886 => 9818
    "颇" : ("頗", ),  # 9887 => 9817
    "颈" : ("頸", ),  # 9888 => 9838
    "颉" : ("頡", ),  # 9889 => 9821
    "颊" : ("頰", ),  # 988A => 9830
    "颋" : ("頲", ),  # 988B => 9832
    "颌" : ("頜", ),  # 988C => 981C
    "颍" : ("潁", ),  # 988D => 6F41
    "颏" : ("頦", ),  # 988F => 9826
    "颐" : ("頤", ),  # 9890 => 9824
    "频" : ("頻", ),  # 9891 => 983B
    "颓" : ("頹", "頽"),  # 9893 => 9839 983D
    "颔" : ("頷", ),  # 9894 => 9837
    "颖" : ("穎", ),  # 9896 => 7A4E
    "颗" : ("顆", ),  # 9897 => 9846
    "题" : ("題", ),  # 9898 => 984C
    "颙" : ("顒", ),  # 9899 => 9852
    "颚" : ("顎", ),  # 989A => 984E
    "颛" : ("顓", ),  # 989B => 9853
    "颜" : ("顏", "顔"),  # 989C => 984F 9854
    "额" : ("額", ),  # 989D => 984D
    "颞" : ("顳", ),  # 989E => 9873
    "颟" : ("顢", ),  # 989F => 9862
    "颠" : ("顛", ),  # 98A0 => 985B
    "颡" : ("顙", ),  # 98A1 => 9859
    "颢" : ("顥", ),  # 98A2 => 9865
    "颤" : ("顫", ),  # 98A4 => 986B
    "颥" : ("顬", ),  # 98A5 => 986C
    "颦" : ("顰", ),  # 98A6 => 9870
    "颧" : ("顴", ),  # 98A7 => 9874
    "风" : ("風", ),  # 98CE => 98A8
    "飑" : ("颮", ),  # 98D1 => 98AE
    "飒" : ("颯", ),  # 98D2 => 98AF
    "飓" : ("颶", ),  # 98D3 => 98B6
    "飔" : ("颸", ),  # 98D4 => 98B8
    "飕" : ("颼", ),  # 98D5 => 98BC
    "飗" : ("飀", ),  # 98D7 => 98C0
    "飘" : ("飄", ),  # 98D8 => 98C4
    "飙" : ("飆", ),  # 98D9 => 98C6
    "飚" : ("飆", ),  # 98DA => 98C6
    "飞" : ("飛", ),  # 98DE => 98DB
    "飨" : ("饗", ),  # 98E8 => 9957
    "餍" : ("饜", ),  # 990D => 995C
    "饥" : ("饑", ),  # 9965 => 9951
    "饦" : ("飥", ),  # 9966 => 98E5
    "饧" : ("餳", ),  # 9967 => 9933
    "饨" : ("飩", ),  # 9968 => 98E9
    "饩" : ("餼", ),  # 9969 => 993C
    "饪" : ("飪", ),  # 996A => 98EA
    "饫" : ("飫", ),  # 996B => 98EB
    "饬" : ("飭", ),  # 996C => 98ED
    "饭" : ("飯", ),  # 996D => 98EF
    "饮" : ("飲", ),  # 996E => 98F2
    "饯" : ("餞", ),  # 996F => 991E
    "饰" : ("飾", ),  # 9970 => 98FE
    "饱" : ("飽", ),  # 9971 => 98FD
    "饲" : ("飼", ),  # 9972 => 98FC
    "饳" : ("飿", ),  # 9973 => 98FF
    "饴" : ("飴", ),  # 9974 => 98F4
    "饵" : ("餌", ),  # 9975 => 990C
    "饶" : ("饒", ),  # 9976 => 9952
    "饷" : ("餉", ),  # 9977 => 9909
    "饸" : ("餄", ),  # 9978 => 9904
    "饹" : ("餎", ),  # 9979 => 990E
    "饺" : ("餃", ),  # 997A => 9903
    "饻" : ("餏", ),  # 997B => 990F
    "饼" : ("餅", "餠"),  # 997C => 9905 9920
    "饽" : ("餑", ),  # 997D => 9911
    "饿" : ("餓", ),  # 997F => 9913
    "馀" : ("餘", ),  # 9980 => 9918
    "馁" : ("餒", ),  # 9981 => 9912
    "馃" : ("餜", ),  # 9983 => 991C
    "馄" : ("餛", ),  # 9984 => 991B
    "馅" : ("餡", ),  # 9985 => 9921
    "馆" : ("館", ),  # 9986 => 9928
    "馇" : ("餷", ),  # 9987 => 9937
    "馈" : ("饋", ),  # 9988 => 994B
    "馉" : ("餶", ),  # 9989 => 9936
    "馊" : ("餿", ),  # 998A => 993F
    "馋" : ("饞", ),  # 998B => 995E
    "馍" : ("饃", ),  # 998D => 9943
    "馎" : ("餺", ),  # 998E => 993A
    "馏" : ("餾", ),  # 998F => 993E
    "馐" : ("饈", ),  # 9990 => 9948
    "馑" : ("饉", ),  # 9991 => 9949
    "馒" : ("饅", ),  # 9992 => 9945
    "馓" : ("饊", ),  # 9993 => 994A
    "馔" : ("饌", ),  # 9994 => 994C
    "馕" : ("饟", "饢"),  # 9995 => 995F 9962
    "马" : ("馬", ),  # 9A6C => 99AC
    "驭" : ("馭", ),  # 9A6D => 99AD
    "驮" : ("馱", ),  # 9A6E => 99B1
    "驯" : ("馴", ),  # 9A6F => 99B4
    "驰" : ("馳", ),  # 9A70 => 99B3
    "驱" : ("驅", ),  # 9A71 => 9A45
    "驳" : ("駁", ),  # 9A73 => 99C1
    "驴" : ("驢", ),  # 9A74 => 9A62
    "驵" : ("駔", ),  # 9A75 => 99D4
    "驶" : ("駛", ),  # 9A76 => 99DB
    "驷" : ("駟", ),  # 9A77 => 99DF
    "驸" : ("駙", ),  # 9A78 => 99D9
    "驹" : ("駒", ),  # 9A79 => 99D2
    "驺" : ("騶", ),  # 9A7A => 9A36
    "驻" : ("駐", ),  # 9A7B => 99D0
    "驼" : ("駝", ),  # 9A7C => 99DD
    "驽" : ("駑", ),  # 9A7D => 99D1
    "驾" : ("駕", ),  # 9A7E => 99D5
    "驿" : ("驛", ),  # 9A7F => 9A5B
    "骀" : ("駘", ),  # 9A80 => 99D8
    "骁" : ("驍", ),  # 9A81 => 9A4D
    "骂" : ("罵", "駡"),  # 9A82 => 7F75 99E1
    "骄" : ("驕", ),  # 9A84 => 9A55
    "骅" : ("驊", ),  # 9A85 => 9A4A
    "骆" : ("駱", ),  # 9A86 => 99F1
    "骇" : ("駭", ),  # 9A87 => 99ED
    "骈" : ("駢", ),  # 9A88 => 99E2
    "骊" : ("驪", ),  # 9A8A => 9A6A
    "骋" : ("騁", ),  # 9A8B => 9A01
    "验" : ("驗", ),  # 9A8C => 9A57
    "骎" : ("駸", ),  # 9A8E => 99F8
    "骏" : ("駿", ),  # 9A8F => 99FF
    "骐" : ("騏", ),  # 9A90 => 9A0F
    "骑" : ("騎", ),  # 9A91 => 9A0E
    "骒" : ("騍", ),  # 9A92 => 9A0D
    "骓" : ("騅", ),  # 9A93 => 9A05
    "骖" : ("驂", ),  # 9A96 => 9A42
    "骗" : ("騙", ),  # 9A97 => 9A19
    "骘" : ("騭", ),  # 9A98 => 9A2D
    "骚" : ("騷", ),  # 9A9A => 9A37
    "骛" : ("騖", ),  # 9A9B => 9A16
    "骜" : ("驁", ),  # 9A9C => 9A41
    "骝" : ("騮", ),  # 9A9D => 9A2E
    "骞" : ("騫", ),  # 9A9E => 9A2B
    "骟" : ("騸", ),  # 9A9F => 9A38
    "骠" : ("驃", ),  # 9AA0 => 9A43
    "骡" : ("騾", ),  # 9AA1 => 9A3E
    "骢" : ("驄", ),  # 9AA2 => 9A44
    "骣" : ("驏", ),  # 9AA3 => 9A4F
    "骤" : ("驟", ),  # 9AA4 => 9A5F
    "骥" : ("驥", ),  # 9AA5 => 9A65
    "骧" : ("驤", ),  # 9AA7 => 9A64
    "髅" : ("髏", ),  # 9AC5 => 9ACF
    "髋" : ("髖", ),  # 9ACB => 9AD6
    "髌" : ("髕", ),  # 9ACC => 9AD5
    "鬓" : ("鬢", ),  # 9B13 => 9B22
    "魇" : ("魘", ),  # 9B47 => 9B58
    "魉" : ("魎", ),  # 9B49 => 9B4E
    "鱼" : ("魚", ),  # 9C7C => 9B5A
    "鱽" : ("魛", ),  # 9C7D => 9B5B
    "鱿" : ("魷", ),  # 9C7F => 9B77
    "鲁" : ("魯", ),  # 9C81 => 9B6F
    "鲂" : ("魴", ),  # 9C82 => 9B74
    "鲅" : ("鮁", ),  # 9C85 => 9B81
    "鲆" : ("鮃", ),  # 9C86 => 9B83
    "鲇" : ("鯰", ),  # 9C87 => 9BF0
    "鲈" : ("鱸", ),  # 9C88 => 9C78
    "鲊" : ("鮓", ),  # 9C8A => 9B93
    "鲋" : ("鮒", ),  # 9C8B => 9B92
    "鲍" : ("鮑", ),  # 9C8D => 9B91
    "鲎" : ("鱟", ),  # 9C8E => 9C5F
    "鲏" : ("鮍", ),  # 9C8F => 9B8D
    "鲐" : ("鮐", ),  # 9C90 => 9B90
    "鲑" : ("鮭", ),  # 9C91 => 9BAD
    "鲒" : ("鮚", ),  # 9C92 => 9B9A
    "鲔" : ("鮪", ),  # 9C94 => 9BAA
    "鲕" : ("鮞", ),  # 9C95 => 9B9E
    "鲖" : ("鮦", ),  # 9C96 => 9BA6
    "鲗" : ("鰂", ),  # 9C97 => 9C02
    "鲙" : ("鱠", ),  # 9C99 => 9C60
    "鲚" : ("鱭", ),  # 9C9A => 9C6D
    "鲛" : ("鮫", ),  # 9C9B => 9BAB
    "鲜" : ("鮮", ),  # 9C9C => 9BAE
    "鲝" : ("鮺", ),  # 9C9D => 9BBA
    "鲞" : ("鯗", ),  # 9C9E => 9BD7
    "鲟" : ("鱘", ),  # 9C9F => 9C58
    "鲠" : ("鯁", ),  # 9CA0 => 9BC1
    "鲡" : ("鱺", ),  # 9CA1 => 9C7A
    "鲢" : ("鰱", ),  # 9CA2 => 9C31
    "鲣" : ("鰹", ),  # 9CA3 => 9C39
    "鲤" : ("鯉", ),  # 9CA4 => 9BC9
    "鲥" : ("鰣", ),  # 9CA5 => 9C23
    "鲦" : ("鰷", ),  # 9CA6 => 9C37
    "鲧" : ("鯀", ),  # 9CA7 => 9BC0
    "鲨" : ("鯊", ),  # 9CA8 => 9BCA
    "鲩" : ("鯇", ),  # 9CA9 => 9BC7
    "鲫" : ("鯽", ),  # 9CAB => 9BFD
    "鲭" : ("鯖", ),  # 9CAD => 9BD6
    "鲮" : ("鯪", ),  # 9CAE => 9BEA
    "鲰" : ("鯫", ),  # 9CB0 => 9BEB
    "鲱" : ("鯡", ),  # 9CB1 => 9BE1
    "鲲" : ("鯤", ),  # 9CB2 => 9BE4
    "鲳" : ("鯧", ),  # 9CB3 => 9BE7
    "鲴" : ("鯝", ),  # 9CB4 => 9BDD
    "鲵" : ("鯢", ),  # 9CB5 => 9BE2
    "鲶" : ("鯰", ),  # 9CB6 => 9BF0
    "鲷" : ("鯛", ),  # 9CB7 => 9BDB
    "鲸" : ("鯨", ),  # 9CB8 => 9BE8
    "鲺" : ("鯴", ),  # 9CBA => 9BF4
    "鲻" : ("鯔", ),  # 9CBB => 9BD4
    "鲼" : ("鱝", ),  # 9CBC => 9C5D
    "鲽" : ("鰈", ),  # 9CBD => 9C08
    "鲿" : ("鱨", ),  # 9CBF => 9C68
    "鳁" : ("鰛", ),  # 9CC1 => 9C1B
    "鳃" : ("鰓", ),  # 9CC3 => 9C13
    "鳄" : ("鰐", "鱷"),  # 9CC4 => 9C10 9C77
    "鳅" : ("鰍", ),  # 9CC5 => 9C0D
    "鳆" : ("鰒", ),  # 9CC6 => 9C12
    "鳇" : ("鰉", ),  # 9CC7 => 9C09
    "鳊" : ("鯿", ),  # 9CCA => 9BFF
    "鳋" : ("鰠", ),  # 9CCB => 9C20
    "鳌" : ("鰲", "鼇"),  # 9CCC => 9C32 9F07
    "鳍" : ("鰭", ),  # 9CCD => 9C2D
    "鳎" : ("鰨", ),  # 9CCE => 9C28
    "鳏" : ("鰥", ),  # 9CCF => 9C25
    "鳐" : ("鰩", ),  # 9CD0 => 9C29
    "鳑" : ("鰟", ),  # 9CD1 => 9C1F
    "鳒" : ("鰜", ),  # 9CD2 => 9C1C
    "鳓" : ("鰳", ),  # 9CD3 => 9C33
    "鳔" : ("鰾", ),  # 9CD4 => 9C3E
    "鳕" : ("鱈", ),  # 9CD5 => 9C48
    "鳖" : ("鱉", ),  # 9CD6 => 9C49
    "鳗" : ("鰻", ),  # 9CD7 => 9C3B
    "鳘" : ("鰵", ),  # 9CD8 => 9C35
    "鳙" : ("鱅", ),  # 9CD9 => 9C45
    "鳛" : ("鰼", ),  # 9CDB => 9C3C
    "鳜" : ("鱖", ),  # 9CDC => 9C56
    "鳝" : ("鱔", ),  # 9CDD => 9C54
    "鳞" : ("鱗", ),  # 9CDE => 9C57
    "鳟" : ("鱒", ),  # 9CDF => 9C52
    "鳢" : ("鱧", ),  # 9CE2 => 9C67
    "鳣" : ("鱣", ),  # 9CE3 => 9C63
    "鸟" : ("鳥", ),  # 9E1F => 9CE5
    "鸠" : ("鳩", ),  # 9E20 => 9CE9
    "鸡" : ("雞", "鷄"),  # 9E21 => 96DE 9DC4
    "鸢" : ("鳶", ),  # 9E22 => 9CF6
    "鸣" : ("鳴", ),  # 9E23 => 9CF4
    "鸥" : ("鷗", ),  # 9E25 => 9DD7
    "鸦" : ("鴉", ),  # 9E26 => 9D09
    "鸧" : ("鶬", ),  # 9E27 => 9DAC
    "鸨" : ("鴇", ),  # 9E28 => 9D07
    "鸩" : ("鴆", ),  # 9E29 => 9D06
    "鸪" : ("鴣", ),  # 9E2A => 9D23
    "鸫" : ("鶇", ),  # 9E2B => 9D87
    "鸬" : ("鸕", ),  # 9E2C => 9E15
    "鸭" : ("鴨", ),  # 9E2D => 9D28
    "鸮" : ("鴞", ),  # 9E2E => 9D1E
    "鸯" : ("鴦", ),  # 9E2F => 9D26
    "鸰" : ("鴒", ),  # 9E30 => 9D12
    "鸱" : ("鴟", ),  # 9E31 => 9D1F
    "鸲" : ("鴝", ),  # 9E32 => 9D1D
    "鸳" : ("鴛", ),  # 9E33 => 9D1B
    "鸵" : ("鴕", ),  # 9E35 => 9D15
    "鸶" : ("鷥", ),  # 9E36 => 9DE5
    "鸷" : ("鷙", ),  # 9E37 => 9DD9
    "鸸" : ("鴯", ),  # 9E38 => 9D2F
    "鸹" : ("鴰", ),  # 9E39 => 9D30
    "鸺" : ("鵂", ),  # 9E3A => 9D42
    "鸻" : ("鴴", ),  # 9E3B => 9D34
    "鸼" : ("鵃", ),  # 9E3C => 9D43
    "鸽" : ("鴿", ),  # 9E3D => 9D3F
    "鸾" : ("鵉", "鸞"),  # 9E3E => 9D49 9E1E
    "鸿" : ("鴻", ),  # 9E3F => 9D3B
    "鹁" : ("鵓", ),  # 9E41 => 9D53
    "鹂" : ("鸝", ),  # 9E42 => 9E1D
    "鹃" : ("鵑", ),  # 9E43 => 9D51
    "鹄" : ("鵠", ),  # 9E44 => 9D60
    "鹅" : ("鵝", ),  # 9E45 => 9D5D
    "鹆" : ("鵒", ),  # 9E46 => 9D52
    "鹇" : ("鷳", ),  # 9E47 => 9DF3
    "鹈" : ("鵜", ),  # 9E48 => 9D5C
    "鹉" : ("鵡", ),  # 9E49 => 9D61
    "鹊" : ("鵲", ),  # 9E4A => 9D72
    "鹋" : ("鶓", ),  # 9E4B => 9D93
    "鹌" : ("鵪", ),  # 9E4C => 9D6A
    "鹎" : ("鵯", ),  # 9E4E => 9D6F
    "鹏" : ("鵬", ),  # 9E4F => 9D6C
    "鹐" : ("鵮", ),  # 9E50 => 9D6E
    "鹑" : ("鶉", ),  # 9E51 => 9D89
    "鹒" : ("鶊", ),  # 9E52 => 9D8A
    "鹕" : ("鶘", ),  # 9E55 => 9D98
    "鹖" : ("鶡", ),  # 9E56 => 9DA1
    "鹗" : ("鶚", ),  # 9E57 => 9D9A
    "鹘" : ("鶻", ),  # 9E58 => 9DBB
    "鹙" : ("鶖", ),  # 9E59 => 9D96
    "鹚" : ("鶿", "鷀"),  # 9E5A => 9DBF 9DC0
    "鹛" : ("鶥", ),  # 9E5B => 9DA5
    "鹜" : ("鶩", ),  # 9E5C => 9DA9
    "鹞" : ("鷂", ),  # 9E5E => 9DC2
    "鹡" : ("鶺", ),  # 9E61 => 9DBA
    "鹣" : ("鶼", ),  # 9E63 => 9DBC
    "鹤" : ("鶴", ),  # 9E64 => 9DB4
    "鹥" : ("鷖", ),  # 9E65 => 9DD6
    "鹦" : ("鸚", ),  # 9E66 => 9E1A
    "鹧" : ("鷓", ),  # 9E67 => 9DD3
    "鹨" : ("鷚", ),  # 9E68 => 9DDA
    "鹩" : ("鷯", ),  # 9E69 => 9DEF
    "鹪" : ("鷦", ),  # 9E6A => 9DE6
    "鹫" : ("鷲", ),  # 9E6B => 9DF2
    "鹬" : ("鷸", ),  # 9E6C => 9DF8
    "鹭" : ("鷺", ),  # 9E6D => 9DFA
    "鹯" : ("鸇", ),  # 9E6F => 9E07
    "鹰" : ("鷹", ),  # 9E70 => 9DF9
    "鹱" : ("鸌", ),  # 9E71 => 9E0C
    "鹳" : ("鸛", ),  # 9E73 => 9E1B
    "鹾" : ("鹺", ),  # 9E7E => 9E7A
    "麦" : ("麥", ),  # 9EA6 => 9EA5
    "麸" : ("麩", ),  # 9EB8 => 9EA9
    "黄" : ("黃", ),  # 9EC4 => 9EC3
    "黉" : ("黌", ),  # 9EC9 => 9ECC
    "黡" : ("黶", ),  # 9EE1 => 9EF6
    "黩" : ("黷", ),  # 9EE9 => 9EF7
    "黪" : ("黲", ),  # 9EEA => 9EF2
    "黾" : ("黽", ),  # 9EFE => 9EFD
    "鼋" : ("黿", ),  # 9F0B => 9EFF
    "鼍" : ("鼉", ),  # 9F0D => 9F09
    "鼗" : ("鞀", ),  # 9F17 => 9780
    "鼹" : ("鼴", ),  # 9F39 => 9F34
    "齄" : ("齇", ),  # 9F44 => 9F47
    "齐" : ("齊", ),  # 9F50 => 9F4A
    "齑" : ("齏", ),  # 9F51 => 9F4F
    "齿" : ("齒", ),  # 9F7F => 9F52
    "龀" : ("齔", ),  # 9F80 => 9F54
    "龃" : ("齟", ),  # 9F83 => 9F5F
    "龄" : ("齡", ),  # 9F84 => 9F61
    "龅" : ("齙", ),  # 9F85 => 9F59
    "龆" : ("齠", ),  # 9F86 => 9F60
    "龇" : ("齜", ),  # 9F87 => 9F5C
    "龈" : ("齦", ),  # 9F88 => 9F66
    "龉" : ("齬", ),  # 9F89 => 9F6C
    "龊" : ("齪", ),  # 9F8A => 9F6A
    "龋" : ("齲", ),  # 9F8B => 9F72
    "龌" : ("齷", ),  # 9F8C => 9F77
    "龙" : ("龍", ),  # 9F99 => 9F8D
    "龚" : ("龔", ),  # 9F9A => 9F94
    "龛" : ("龕", ),  # 9F9B => 9F95
    "龟" : ("龜", ),  # 9F9F => 9F9C
}

# Traditional Chinese to Simplified Chinese
T_2_S = {
    "㑳" : ("㑇", ),  # 3473 => 3447
    "㘚" : ("㘎", ),  # 361A => 360E
    "㥮" : ("㤘", ),  # 396E => 3918
    "㩳" : ("㧐", ),  # 3A73 => 39D0
    "䎱" : ("䎬", ),  # 43B1 => 43AC
    "䙡" : ("䙌", ),  # 4661 => 464C
    "䝼" : ("䞍", ),  # 477C => 478D
    "䥇" : ("䦂", ),  # 4947 => 4982
    "䦛" : ("䦶", ),  # 499B => 49B6
    "䦟" : ("䦷", ),  # 499F => 49B7
    "䱷" : ("䲣", ),  # 4C77 => 4CA3
    "丟" : ("丢", ),  # 4E1F => 4E22
    "並" : ("并", ),  # 4E26 => 5E76
    "么" : ("幺", ),  # 4E48 => 5E7A
    "乾" : ("干", ),  # 4E7E => 5E72
    "亂" : ("乱", ),  # 4E82 => 4E71
    "亙" : ("亘", ),  # 4E99 => 4E98
    "亞" : ("亚", ),  # 4E9E => 4E9A
    "佇" : ("伫", ),  # 4F47 => 4F2B
    "佘" : ("畲", ),  # 4F58 => 7572
    "來" : ("来", ),  # 4F86 => 6765
    "侖" : ("仑", ),  # 4F96 => 4ED1
    "侶" : ("侣", ),  # 4FB6 => 4FA3
    "俁" : ("俣", ),  # 4FC1 => 4FE3
    "係" : ("系", ),  # 4FC2 => 7CFB
    "俠" : ("侠", ),  # 4FE0 => 4FA0
    "倀" : ("伥", ),  # 5000 => 4F25
    "倆" : ("俩", ),  # 5006 => 4FE9
    "倉" : ("仓", ),  # 5009 => 4ED3
    "個" : ("个", ),  # 500B => 4E2A
    "們" : ("们", ),  # 5011 => 4EEC
    "倫" : ("伦", ),  # 502B => 4F26
    "偉" : ("伟", ),  # 5049 => 4F1F
    "側" : ("侧", ),  # 5074 => 4FA7
    "偵" : ("侦", ),  # 5075 => 4FA6
    "偽" : ("伪", ),  # 507D => 4F2A
    "傑" : ("杰", ),  # 5091 => 6770
    "傖" : ("伧", ),  # 5096 => 4F27
    "傘" : ("伞", ),  # 5098 => 4F1E
    "備" : ("备", ),  # 5099 => 5907
    "傢" : ("家", ),  # 50A2 => 5BB6
    "傭" : ("佣", ),  # 50AD => 4F63
    "傯" : ("偬", ),  # 50AF => 506C
    "傳" : ("传", ),  # 50B3 => 4F20
    "傴" : ("伛", ),  # 50B4 => 4F1B
    "債" : ("债", ),  # 50B5 => 503A
    "傷" : ("伤", ),  # 50B7 => 4F24
    "傾" : ("倾", ),  # 50BE => 503E
    "僂" : ("偻", ),  # 50C2 => 507B
    "僅" : ("仅", ),  # 50C5 => 4EC5
    "僉" : ("佥", ),  # 50C9 => 4F65
    "僑" : ("侨", ),  # 50D1 => 4FA8
    "僕" : ("仆", ),  # 50D5 => 4EC6
    "僞" : ("伪", ),  # 50DE => 4F2A
    "僥" : ("侥", ),  # 50E5 => 4FA5
    "僨" : ("偾", ),  # 50E8 => 507E
    "價" : ("价", ),  # 50F9 => 4EF7
    "儀" : ("仪", ),  # 5100 => 4EEA
    "儂" : ("侬", ),  # 5102 => 4FAC
    "億" : ("亿", ),  # 5104 => 4EBF
    "儈" : ("侩", ),  # 5108 => 4FA9
    "儉" : ("俭", ),  # 5109 => 4FED
    "儐" : ("傧", ),  # 5110 => 50A7
    "儔" : ("俦", ),  # 5114 => 4FE6
    "儕" : ("侪", ),  # 5115 => 4FAA
    "儘" : ("尽", ),  # 5118 => 5C3D
    "償" : ("偿", ),  # 511F => 507F
    "優" : ("优", ),  # 512A => 4F18
    "儲" : ("储", ),  # 5132 => 50A8
    "儷" : ("俪", ),  # 5137 => 4FEA
    "儺" : ("傩", ),  # 513A => 50A9
    "儻" : ("傥", ),  # 513B => 50A5
    "儼" : ("俨", ),  # 513C => 4FE8
    "兌" : ("兑", ),  # 514C => 5151
    "兒" : ("儿", ),  # 5152 => 513F
    "兗" : ("兖", ),  # 5157 => 5156
    "內" : ("内", ),  # 5167 => 5185
    "兩" : ("两", ),  # 5169 => 4E24
    "兿" : ("艺", ),  # 517F => 827A
    "冊" : ("册", ),  # 518A => 518C
    "冪" : ("幂", ),  # 51AA => 5E42
    "凍" : ("冻", ),  # 51CD => 51BB
    "凖" : ("准", ),  # 51D6 => 51C6
    "凜" : ("凛", ),  # 51DC => 51DB
    "凱" : ("凯", ),  # 51F1 => 51EF
    "別" : ("别", ),  # 5225 => 522B
    "刪" : ("删", ),  # 522A => 5220
    "剄" : ("刭", ),  # 5244 => 522D
    "則" : ("则", ),  # 5247 => 5219
    "剋" : ("克", ),  # 524B => 514B
    "剗" : ("刬", ),  # 5257 => 522C
    "剛" : ("刚", ),  # 525B => 521A
    "剝" : ("剥", ),  # 525D => 5265
    "剮" : ("剐", ),  # 526E => 5250
    "剴" : ("剀", ),  # 5274 => 5240
    "創" : ("创", ),  # 5275 => 521B
    "劃" : ("划", ),  # 5283 => 5212
    "劄" : ("札", ),  # 5284 => 672D
    "劇" : ("剧", ),  # 5287 => 5267
    "劈" : ("噼", ),  # 5288 => 567C
    "劉" : ("刘", ),  # 5289 => 5218
    "劊" : ("刽", ),  # 528A => 523D
    "劌" : ("刿", ),  # 528C => 523F
    "劍" : ("剑", ),  # 528D => 5251
    "劑" : ("剂", ),  # 5291 => 5242
    "勁" : ("劲", ),  # 52C1 => 52B2
    "動" : ("动", ),  # 52D5 => 52A8
    "務" : ("务", ),  # 52D9 => 52A1
    "勛" : ("勋", ),  # 52DB => 52CB
    "勝" : ("胜", ),  # 52DD => 80DC
    "勞" : ("劳", ),  # 52DE => 52B3
    "勢" : ("势", ),  # 52E2 => 52BF
    "勩" : ("勚", ),  # 52E9 => 52DA
    "勱" : ("劢", ),  # 52F1 => 52A2
    "勳" : ("勋", ),  # 52F3 => 52CB
    "勵" : ("励", ),  # 52F5 => 52B1
    "勸" : ("劝", ),  # 52F8 => 529D
    "勻" : ("匀", ),  # 52FB => 5300
    "匭" : ("匦", ),  # 532D => 5326
    "匯" : ("汇", ),  # 532F => 6C47
    "匱" : ("匮", ),  # 5331 => 532E
    "區" : ("区", ),  # 5340 => 533A
    "協" : ("协", ),  # 5354 => 534F
    "卻" : ("却", ),  # 537B => 5374
    "厙" : ("厍", ),  # 5399 => 538D
    "原" : ("塬", ),  # 539F => 586C
    "厠" : ("厕", ),  # 53A0 => 5395
    "厭" : ("厌", ),  # 53AD => 538C
    "厲" : ("厉", ),  # 53B2 => 5389
    "厴" : ("厣", ),  # 53B4 => 53A3
    "參" : ("叁", "参"),  # 53C3 => 53C1 53C2
    "叢" : ("丛", ),  # 53E2 => 4E1B
    "吒" : ("咤", ),  # 5412 => 54A4
    "吳" : ("吴", ),  # 5433 => 5434
    "呂" : ("吕", ),  # 5442 => 5415
    "呱" : ("哌", ),  # 5471 => 54CC
    "呵" : ("嗬", ),  # 5475 => 55EC
    "呼" : ("唿", ),  # 547C => 553F
    "咼" : ("呙", ),  # 54BC => 5459
    "員" : ("员", ),  # 54E1 => 5458
    "哢" : ("咔", ),  # 54E2 => 5494
    "唄" : ("呗", ),  # 5504 => 5457
    "唕" : ("唣", ),  # 5515 => 5523
    "唚" : ("吣", ),  # 551A => 5423
    "問" : ("问", ),  # 554F => 95EE
    "啓" : ("启", ),  # 5553 => 542F
    "啞" : ("哑", ),  # 555E => 54D1
    "啟" : ("启", ),  # 555F => 542F
    "啢" : ("唡", ),  # 5562 => 5521
    "喎" : ("㖞", ),  # 558E => 359E
    "喚" : ("唤", ),  # 559A => 5524
    "喪" : ("丧", ),  # 55AA => 4E27
    "喬" : ("乔", ),  # 55AC => 4E54
    "單" : ("单", ),  # 55AE => 5355
    "喲" : ("哟", ),  # 55B2 => 54DF
    "嗆" : ("呛", ),  # 55C6 => 545B
    "嗇" : ("啬", ),  # 55C7 => 556C
    "嗊" : ("唝", ),  # 55CA => 551D
    "嗎" : ("吗", ),  # 55CE => 5417
    "嗚" : ("呜", ),  # 55DA => 545C
    "嗩" : ("唢", ),  # 55E9 => 5522
    "嗶" : ("哔", ),  # 55F6 => 54D4
    "嘆" : ("叹", ),  # 5606 => 53F9
    "嘍" : ("喽", ),  # 560D => 55BD
    "嘔" : ("呕", ),  # 5614 => 5455
    "嘖" : ("啧", ),  # 5616 => 5567
    "嘗" : ("尝", ),  # 5617 => 5C1D
    "嘜" : ("唛", ),  # 561C => 551B
    "嘩" : ("哗", ),  # 5629 => 54D7
    "嘮" : ("唠", ),  # 562E => 5520
    "嘯" : ("啸", ),  # 562F => 5578
    "嘰" : ("叽", ),  # 5630 => 53FD
    "嘵" : ("哓", ),  # 5635 => 54D3
    "嘸" : ("呒", ),  # 5638 => 5452
    "噁" : ("恶", ),  # 5641 => 6076
    "噅" : ("咴", ),  # 5645 => 54B4
    "噓" : ("嘘", ),  # 5653 => 5618
    "噝" : ("咝", ),  # 565D => 549D
    "噠" : ("哒", ),  # 5660 => 54D2
    "噥" : ("哝", ),  # 5665 => 54DD
    "噦" : ("哕", ),  # 5666 => 54D5
    "噯" : ("嗳", ),  # 566F => 55F3
    "噲" : ("哙", ),  # 5672 => 54D9
    "噴" : ("喷", ),  # 5674 => 55B7
    "噸" : ("吨", ),  # 5678 => 5428
    "噹" : ("当", ),  # 5679 => 5F53
    "嚀" : ("咛", ),  # 5680 => 549B
    "嚇" : ("吓", ),  # 5687 => 5413
    "嚌" : ("哜", ),  # 568C => 54DC
    "嚕" : ("噜", ),  # 5695 => 565C
    "嚙" : ("啮", ),  # 5699 => 556E
    "嚦" : ("呖", ),  # 56A6 => 5456
    "嚨" : ("咙", ),  # 56A8 => 5499
    "嚮" : ("向", ),  # 56AE => 5411
    "嚳" : ("喾", ),  # 56B3 => 55BE
    "嚴" : ("严", ),  # 56B4 => 4E25
    "嚶" : ("嘤", ),  # 56B6 => 5624
    "囀" : ("啭", ),  # 56C0 => 556D
    "囁" : ("嗫", ),  # 56C1 => 55EB
    "囂" : ("嚣", ),  # 56C2 => 56A3
    "囅" : ("冁", ),  # 56C5 => 5181
    "囈" : ("呓", ),  # 56C8 => 5453
    "囉" : ("啰", ),  # 56C9 => 5570
    "囌" : ("苏", ),  # 56CC => 82CF
    "囑" : ("嘱", ),  # 56D1 => 5631
    "囪" : ("囱", ),  # 56EA => 56F1
    "圇" : ("囵", ),  # 5707 => 56F5
    "國" : ("国", ),  # 570B => 56FD
    "圍" : ("围", ),  # 570D => 56F4
    "園" : ("园", ),  # 5712 => 56ED
    "圓" : ("圆", ),  # 5713 => 5706
    "圖" : ("图", ),  # 5716 => 56FE
    "團" : ("团", ),  # 5718 => 56E2
    "坰" : ("垧", ),  # 5770 => 57A7
    "垵" : ("埯", ),  # 57B5 => 57EF
    "埡" : ("垭", ),  # 57E1 => 57AD
    "執" : ("执", ),  # 57F7 => 6267
    "堅" : ("坚", ),  # 5805 => 575A
    "堊" : ("垩", ),  # 580A => 57A9
    "堖" : ("垴", ),  # 5816 => 57B4
    "堝" : ("埚", ),  # 581D => 57DA
    "堯" : ("尧", ),  # 582F => 5C27
    "報" : ("报", ),  # 5831 => 62A5
    "場" : ("场", ),  # 5834 => 573A
    "堿" : ("碱", ),  # 583F => 78B1
    "塊" : ("块", ),  # 584A => 5757
    "塋" : ("茔", ),  # 584B => 8314
    "塏" : ("垲", ),  # 584F => 57B2
    "塒" : ("埘", ),  # 5852 => 57D8
    "塗" : ("涂", ),  # 5857 => 6D82
    "塚" : ("冢", ),  # 585A => 51A2
    "塢" : ("坞", ),  # 5862 => 575E
    "塤" : ("埙", ),  # 5864 => 57D9
    "塵" : ("尘", ),  # 5875 => 5C18
    "塹" : ("堑", ),  # 5879 => 5811
    "墊" : ("垫", "埝"),  # 588A => 57AB 57DD
    "墜" : ("坠", ),  # 589C => 5760
    "墮" : ("堕", ),  # 58AE => 5815
    "墳" : ("坟", ),  # 58B3 => 575F
    "墻" : ("墙", ),  # 58BB => 5899
    "墾" : ("垦", ),  # 58BE => 57A6
    "壇" : ("坛", ),  # 58C7 => 575B
    "壐" : ("玺", ),  # 58D0 => 73BA
    "壓" : ("压", ),  # 58D3 => 538B
    "壘" : ("垒", ),  # 58D8 => 5792
    "壙" : ("圹", ),  # 58D9 => 5739
    "壚" : ("垆", ),  # 58DA => 5786
    "壞" : ("坏", ),  # 58DE => 574F
    "壟" : ("垄", "垅"),  # 58DF => 5784 5785
    "壢" : ("坜", ),  # 58E2 => 575C
    "壩" : ("坝", ),  # 58E9 => 575D
    "壯" : ("壮", ),  # 58EF => 58EE
    "壺" : ("壶", ),  # 58FA => 58F6
    "壽" : ("寿", ),  # 58FD => 5BFF
    "夀" : ("寿", ),  # 5900 => 5BFF
    "夠" : ("够", ),  # 5920 => 591F
    "夢" : ("梦", ),  # 5922 => 68A6
    "夥" : ("伙", ),  # 5925 => 4F19
    "夾" : ("夹", ),  # 593E => 5939
    "奐" : ("奂", ),  # 5950 => 5942
    "奧" : ("奥", ),  # 5967 => 5965
    "奩" : ("奁", ),  # 5969 => 5941
    "奪" : ("夺", ),  # 596A => 593A
    "奬" : ("奖", ),  # 596C => 5956
    "奮" : ("奋", ),  # 596E => 594B
    "妝" : ("妆", ),  # 599D => 5986
    "姍" : ("姗", ),  # 59CD => 59D7
    "娛" : ("娱", ),  # 5A1B => 5A31
    "婁" : ("娄", ),  # 5A41 => 5A04
    "婦" : ("妇", ),  # 5A66 => 5987
    "婭" : ("娅", ),  # 5A6D => 5A05
    "媧" : ("娲", ),  # 5AA7 => 5A32
    "媯" : ("妫", ),  # 5AAF => 59AB
    "媼" : ("媪", ),  # 5ABC => 5AAA
    "媽" : ("妈", ),  # 5ABD => 5988
    "嫋" : ("袅", ),  # 5ACB => 8885
    "嫗" : ("妪", ),  # 5AD7 => 59AA
    "嫵" : ("妩", ),  # 5AF5 => 59A9
    "嫻" : ("娴", ),  # 5AFB => 5A34
    "嫿" : ("婳", ),  # 5AFF => 5A73
    "嬈" : ("娆", ),  # 5B08 => 5A06
    "嬋" : ("婵", ),  # 5B0B => 5A75
    "嬌" : ("娇", ),  # 5B0C => 5A07
    "嬙" : ("嫱", ),  # 5B19 => 5AF1
    "嬡" : ("嫒", ),  # 5B21 => 5AD2
    "嬤" : ("嬷", ),  # 5B24 => 5B37
    "嬪" : ("嫔", ),  # 5B2A => 5AD4
    "嬰" : ("婴", ),  # 5B30 => 5A74
    "嬸" : ("婶", ),  # 5B38 => 5A76
    "孌" : ("娈", ),  # 5B4C => 5A08
    "孫" : ("孙", ),  # 5B6B => 5B59
    "學" : ("学", ),  # 5B78 => 5B66
    "孿" : ("孪", ),  # 5B7F => 5B6A
    "宮" : ("宫", ),  # 5BAE => 5BAB
    "寜" : ("宁", ),  # 5BDC => 5B81
    "寢" : ("寝", ),  # 5BE2 => 5BDD
    "實" : ("实", ),  # 5BE6 => 5B9E
    "審" : ("审", ),  # 5BE9 => 5BA1
    "寫" : ("写", ),  # 5BEB => 5199
    "寬" : ("宽", ),  # 5BEC => 5BBD
    "寵" : ("宠", ),  # 5BF5 => 5BA0
    "寶" : ("宝", ),  # 5BF6 => 5B9D
    "將" : ("将", ),  # 5C07 => 5C06
    "專" : ("专", ),  # 5C08 => 4E13
    "尋" : ("寻", ),  # 5C0B => 5BFB
    "對" : ("对", ),  # 5C0D => 5BF9
    "導" : ("导", ),  # 5C0E => 5BFC
    "尷" : ("尴", ),  # 5C37 => 5C34
    "屆" : ("届", ),  # 5C46 => 5C4A
    "屍" : ("尸", ),  # 5C4D => 5C38
    "屙" : ("疴", ),  # 5C59 => 75B4
    "屜" : ("屉", ),  # 5C5C => 5C49
    "屢" : ("屡", ),  # 5C62 => 5C61
    "層" : ("层", ),  # 5C64 => 5C42
    "屨" : ("屦", ),  # 5C68 => 5C66
    "屬" : ("属", ),  # 5C6C => 5C5E
    "岡" : ("冈", ),  # 5CA1 => 5188
    "峴" : ("岘", ),  # 5CF4 => 5C98
    "島" : ("岛", ),  # 5CF6 => 5C9B
    "峽" : ("峡", ),  # 5CFD => 5CE1
    "崍" : ("崃", ),  # 5D0D => 5D03
    "崗" : ("岗", ),  # 5D17 => 5C97
    "崠" : ("岽", ),  # 5D20 => 5CBD
    "崢" : ("峥", ),  # 5D22 => 5CE5
    "崬" : ("岽", ),  # 5D2C => 5CBD
    "崳" : ("嵛", ),  # 5D33 => 5D5B
    "嵐" : ("岚", ),  # 5D50 => 5C9A
    "嵗" : ("岁", ),  # 5D57 => 5C81
    "嶁" : ("嵝", ),  # 5D81 => 5D5D
    "嶄" : ("崭", ),  # 5D84 => 5D2D
    "嶇" : ("岖", ),  # 5D87 => 5C96
    "嶔" : ("嵚", ),  # 5D94 => 5D5A
    "嶗" : ("崂", ),  # 5D97 => 5D02
    "嶠" : ("峤", ),  # 5DA0 => 5CE4
    "嶢" : ("峣", ),  # 5DA2 => 5CE3
    "嶧" : ("峄", ),  # 5DA7 => 5CC4
    "嶨" : ("峃", ),  # 5DA8 => 5CC3
    "嶴" : ("岙", ),  # 5DB4 => 5C99
    "嶸" : ("嵘", ),  # 5DB8 => 5D58
    "嶺" : ("岭", ),  # 5DBA => 5CAD
    "嶼" : ("屿", ),  # 5DBC => 5C7F
    "嶽" : ("岳", ),  # 5DBD => 5CB3
    "巋" : ("岿", ),  # 5DCB => 5CBF
    "巒" : ("峦", ),  # 5DD2 => 5CE6
    "巔" : ("巅", ),  # 5DD4 => 5DC5
    "巰" : ("巯", ),  # 5DF0 => 5DEF
    "巹" : ("卺", ),  # 5DF9 => 537A
    "帥" : ("帅", ),  # 5E25 => 5E05
    "師" : ("师", ),  # 5E2B => 5E08
    "帳" : ("帐", ),  # 5E33 => 5E10
    "帶" : ("带", ),  # 5E36 => 5E26
    "幀" : ("帧", ),  # 5E40 => 5E27
    "幃" : ("帏", ),  # 5E43 => 5E0F
    "幗" : ("帼", ),  # 5E57 => 5E3C
    "幘" : ("帻", ),  # 5E58 => 5E3B
    "幟" : ("帜", ),  # 5E5F => 5E1C
    "幣" : ("币", ),  # 5E63 => 5E01
    "幫" : ("帮", ),  # 5E6B => 5E2E
    "幬" : ("帱", ),  # 5E6C => 5E31
    "幹" : ("干", ),  # 5E79 => 5E72
    "幾" : ("几", ),  # 5E7E => 51E0
    "庫" : ("库", ),  # 5EAB => 5E93
    "廁" : ("厕", ),  # 5EC1 => 5395
    "廂" : ("厢", ),  # 5EC2 => 53A2
    "廄" : ("厩", ),  # 5EC4 => 53A9
    "廈" : ("厦", ),  # 5EC8 => 53A6
    "廎" : ("庼", ),  # 5ECE => 5EBC
    "廚" : ("厨", ),  # 5EDA => 53A8
    "廝" : ("厮", ),  # 5EDD => 53AE
    "廟" : ("庙", ),  # 5EDF => 5E99
    "廠" : ("厂", ),  # 5EE0 => 5382
    "廡" : ("庑", ),  # 5EE1 => 5E91
    "廢" : ("废", ),  # 5EE2 => 5E9F
    "廣" : ("广", ),  # 5EE3 => 5E7F
    "廩" : ("廪", ),  # 5EE9 => 5EEA
    "廬" : ("庐", ),  # 5EEC => 5E90
    "廳" : ("厅", ),  # 5EF3 => 5385
    "弳" : ("弪", ),  # 5F33 => 5F2A
    "張" : ("张", ),  # 5F35 => 5F20
    "強" : ("强", "犟"),  # 5F37 => 5F3A 729F
    "彆" : ("别", ),  # 5F46 => 522B
    "彈" : ("弹", ),  # 5F48 => 5F39
    "彌" : ("弥", ),  # 5F4C => 5F25
    "彎" : ("弯", ),  # 5F4E => 5F2F
    "彙" : ("汇", ),  # 5F59 => 6C47
    "彥" : ("彦", ),  # 5F65 => 5F66
    "後" : ("后", ),  # 5F8C => 540E
    "徑" : ("径", ),  # 5F91 => 5F84
    "從" : ("从", ),  # 5F9E => 4ECE
    "徠" : ("徕", ),  # 5FA0 => 5F95
    "復" : ("复", ),  # 5FA9 => 590D
    "徵" : ("征", ),  # 5FB5 => 5F81
    "徹" : ("彻", ),  # 5FB9 => 5F7B
    "怵" : ("憷", ),  # 6035 => 61B7
    "恥" : ("耻", ),  # 6065 => 803B
    "悅" : ("悦", ),  # 6085 => 60A6
    "悵" : ("怅", ),  # 60B5 => 6005
    "悶" : ("闷", ),  # 60B6 => 95F7
    "惡" : ("恶", ),  # 60E1 => 6076
    "惱" : ("恼", ),  # 60F1 => 607C
    "惲" : ("恽", ),  # 60F2 => 607D
    "惻" : ("恻", ),  # 60FB => 607B
    "愛" : ("爱", ),  # 611B => 7231
    "愜" : ("惬", ),  # 611C => 60EC
    "愨" : ("悫", ),  # 6128 => 60AB
    "愴" : ("怆", ),  # 6134 => 6006
    "愷" : ("恺", ),  # 6137 => 607A
    "愾" : ("忾", ),  # 613E => 5FFE
    "態" : ("态", ),  # 614B => 6001
    "慍" : ("愠", ),  # 614D => 6120
    "慘" : ("惨", ),  # 6158 => 60E8
    "慚" : ("惭", ),  # 615A => 60ED
    "慟" : ("恸", ),  # 615F => 6078
    "慣" : ("惯", ),  # 6163 => 60EF
    "慤" : ("悫", ),  # 6164 => 60AB
    "慪" : ("怄", ),  # 616A => 6004
    "慫" : ("怂", ),  # 616B => 6002
    "慮" : ("虑", ),  # 616E => 8651
    "慳" : ("悭", ),  # 6173 => 60AD
    "慶" : ("庆", ),  # 6176 => 5E86
    "憂" : ("忧", ),  # 6182 => 5FE7
    "憊" : ("惫", ),  # 618A => 60EB
    "憐" : ("怜", ),  # 6190 => 601C
    "憑" : ("凭", ),  # 6191 => 51ED
    "憒" : ("愦", ),  # 6192 => 6126
    "憚" : ("惮", ),  # 619A => 60EE
    "憤" : ("愤", ),  # 61A4 => 6124
    "憫" : ("悯", ),  # 61AB => 60AF
    "憮" : ("怃", ),  # 61AE => 6003
    "憲" : ("宪", ),  # 61B2 => 5BAA
    "憶" : ("忆", ),  # 61B6 => 5FC6
    "懇" : ("恳", ),  # 61C7 => 6073
    "應" : ("应", ),  # 61C9 => 5E94
    "懌" : ("怿", ),  # 61CC => 603F
    "懍" : ("懔", ),  # 61CD => 61D4
    "懞" : ("蒙", ),  # 61DE => 8499
    "懟" : ("怼", ),  # 61DF => 603C
    "懣" : ("懑", ),  # 61E3 => 61D1
    "懨" : ("恹", ),  # 61E8 => 6079
    "懲" : ("惩", ),  # 61F2 => 60E9
    "懶" : ("懒", ),  # 61F6 => 61D2
    "懷" : ("怀", ),  # 61F7 => 6000
    "懸" : ("悬", ),  # 61F8 => 60AC
    "懺" : ("忏", ),  # 61FA => 5FCF
    "懼" : ("惧", ),  # 61FC => 60E7
    "懾" : ("慑", ),  # 61FE => 6151
    "戀" : ("恋", ),  # 6200 => 604B
    "戇" : ("戆", ),  # 6207 => 6206
    "戔" : ("戋", ),  # 6214 => 620B
    "戠" : ("只", ),  # 6220 => 53EA
    "戧" : ("戗", ),  # 6227 => 6217
    "戩" : ("戬", ),  # 6229 => 622C
    "戰" : ("战", ),  # 6230 => 6218
    "戲" : ("戏", ),  # 6232 => 620F
    "戶" : ("户", ),  # 6236 => 6237
    "扡" : ("扦", ),  # 6261 => 6266
    "拋" : ("抛", ),  # 62CB => 629B
    "挾" : ("挟", ),  # 633E => 631F
    "捨" : ("舍", ),  # 6368 => 820D
    "捫" : ("扪", ),  # 636B => 626A
    "捲" : ("卷", ),  # 6372 => 5377
    "掃" : ("扫", ),  # 6383 => 626B
    "掄" : ("抡", ),  # 6384 => 62A1
    "掆" : ("㧏", ),  # 6386 => 39CF
    "掗" : ("挜", ),  # 6397 => 631C
    "掙" : ("挣", ),  # 6399 => 6323
    "掛" : ("挂", ),  # 639B => 6302
    "揀" : ("拣", ),  # 63C0 => 62E3
    "揚" : ("扬", ),  # 63DA => 626C
    "換" : ("换", ),  # 63DB => 6362
    "揮" : ("挥", ),  # 63EE => 6325
    "損" : ("损", ),  # 640D => 635F
    "搖" : ("摇", ),  # 6416 => 6447
    "搗" : ("捣", ),  # 6417 => 6363
    "搶" : ("抢", ),  # 6436 => 62A2
    "摑" : ("掴", ),  # 6451 => 63B4
    "摜" : ("掼", ),  # 645C => 63BC
    "摟" : ("搂", ),  # 645F => 6402
    "摣" : ("揸", ),  # 6463 => 63F8
    "摯" : ("挚", ),  # 646F => 631A
    "摳" : ("抠", ),  # 6473 => 62A0
    "摶" : ("抟", ),  # 6476 => 629F
    "摺" : ("折", ),  # 647A => 6298
    "摻" : ("掺", ),  # 647B => 63BA
    "撃" : ("击", ),  # 6483 => 51FB
    "撈" : ("捞", ),  # 6488 => 635E
    "撏" : ("挦", ),  # 648F => 6326
    "撐" : ("撑", ),  # 6490 => 6491
    "撓" : ("挠", ),  # 6493 => 6320
    "撚" : ("捻", ),  # 649A => 637B
    "撟" : ("挢", ),  # 649F => 6322
    "撣" : ("掸", ),  # 64A3 => 63B8
    "撥" : ("拨", ),  # 64A5 => 62E8
    "撫" : ("抚", ),  # 64AB => 629A
    "撲" : ("扑", ),  # 64B2 => 6251
    "撳" : ("揿", ),  # 64B3 => 63FF
    "撻" : ("挞", ),  # 64BB => 631E
    "撾" : ("挝", ),  # 64BE => 631D
    "撿" : ("捡", ),  # 64BF => 6361
    "擁" : ("拥", ),  # 64C1 => 62E5
    "擄" : ("掳", ),  # 64C4 => 63B3
    "擇" : ("择", ),  # 64C7 => 62E9
    "擊" : ("击", ),  # 64CA => 51FB
    "擋" : ("挡", ),  # 64CB => 6321
    "擓" : ("㧟", ),  # 64D3 => 39DF
    "擔" : ("担", ),  # 64D4 => 62C5
    "據" : ("据", ),  # 64DA => 636E
    "擠" : ("挤", ),  # 64E0 => 6324
    "擬" : ("拟", ),  # 64EC => 62DF
    "擯" : ("摈", ),  # 64EF => 6448
    "擰" : ("拧", ),  # 64F0 => 62E7
    "擱" : ("搁", ),  # 64F1 => 6401
    "擲" : ("掷", ),  # 64F2 => 63B7
    "擴" : ("扩", ),  # 64F4 => 6269
    "擷" : ("撷", ),  # 64F7 => 64B7
    "擹" : ("摊", ),  # 64F9 => 644A
    "擺" : ("摆", ),  # 64FA => 6446
    "擻" : ("擞", ),  # 64FB => 64DE
    "擼" : ("撸", ),  # 64FC => 64B8
    "擾" : ("扰", ),  # 64FE => 6270
    "攄" : ("摅", ),  # 6504 => 6445
    "攆" : ("撵", ),  # 6506 => 64B5
    "攏" : ("拢", ),  # 650F => 62E2
    "攔" : ("拦", ),  # 6514 => 62E6
    "攖" : ("撄", ),  # 6516 => 6484
    "攙" : ("搀", ),  # 6519 => 6400
    "攛" : ("撺", ),  # 651B => 64BA
    "攜" : ("携", ),  # 651C => 643A
    "攝" : ("摄", ),  # 651D => 6444
    "攢" : ("攒", ),  # 6522 => 6512
    "攣" : ("挛", ),  # 6523 => 631B
    "攤" : ("摊", ),  # 6524 => 644A
    "攪" : ("搅", ),  # 652A => 6405
    "攬" : ("揽", ),  # 652C => 63FD
    "敗" : ("败", ),  # 6557 => 8D25
    "敘" : ("叙", ),  # 6558 => 53D9
    "敵" : ("敌", ),  # 6575 => 654C
    "數" : ("数", ),  # 6578 => 6570
    "斂" : ("敛", ),  # 6582 => 655B
    "斃" : ("毙", ),  # 6583 => 6BD9
    "斕" : ("斓", ),  # 6595 => 6593
    "斬" : ("斩", ),  # 65AC => 65A9
    "斷" : ("断", ),  # 65B7 => 65AD
    "時" : ("时", ),  # 6642 => 65F6
    "晉" : ("晋", ),  # 6649 => 664B
    "晝" : ("昼", ),  # 665D => 663C
    "暈" : ("晕", ),  # 6688 => 6655
    "暉" : ("晖", ),  # 6689 => 6656
    "暘" : ("旸", ),  # 6698 => 65F8
    "暢" : ("畅", ),  # 66A2 => 7545
    "暫" : ("暂", ),  # 66AB => 6682
    "曄" : ("晔", ),  # 66C4 => 6654
    "曆" : ("历", ),  # 66C6 => 5386
    "曇" : ("昙", ),  # 66C7 => 6619
    "曉" : ("晓", ),  # 66C9 => 6653
    "曖" : ("暧", ),  # 66D6 => 66A7
    "曠" : ("旷", ),  # 66E0 => 65F7
    "曨" : ("昽", ),  # 66E8 => 663D
    "曬" : ("晒", ),  # 66EC => 6652
    "書" : ("书", ),  # 66F8 => 4E66
    "會" : ("会", ),  # 6703 => 4F1A
    "朧" : ("胧", ),  # 6727 => 80E7
    "東" : ("东", ),  # 6771 => 4E1C
    "柵" : ("栅", ),  # 67F5 => 6805
    "梔" : ("栀", ),  # 6894 => 6800
    "梘" : ("枧", ),  # 6898 => 67A7
    "條" : ("条", ),  # 689D => 6761
    "梟" : ("枭", ),  # 689F => 67AD
    "棄" : ("弃", ),  # 68C4 => 5F03
    "棖" : ("枨", ),  # 68D6 => 67A8
    "棗" : ("枣", ),  # 68D7 => 67A3
    "棟" : ("栋", ),  # 68DF => 680B
    "棡" : ("㭎", ),  # 68E1 => 3B4E
    "棧" : ("栈", ),  # 68E7 => 6808
    "棬" : ("桊", ),  # 68EC => 684A
    "棲" : ("栖", ),  # 68F2 => 6816
    "椏" : ("桠", ),  # 690F => 6860
    "楊" : ("杨", ),  # 694A => 6768
    "楓" : ("枫", ),  # 6953 => 67AB
    "楨" : ("桢", ),  # 6968 => 6862
    "業" : ("业", ),  # 696D => 4E1A
    "極" : ("极", ),  # 6975 => 6781
    "榖" : ("谷", ),  # 6996 => 8C37
    "榪" : ("杩", ),  # 69AA => 6769
    "榮" : ("荣", ),  # 69AE => 8363
    "榿" : ("桤", ),  # 69BF => 6864
    "槁" : ("藁", ),  # 69C1 => 85C1
    "構" : ("构", ),  # 69CB => 6784
    "槍" : ("枪", ),  # 69CD => 67AA
    "様" : ("样", ),  # 69D8 => 6837
    "槧" : ("椠", ),  # 69E7 => 6920
    "槨" : ("椁", ),  # 69E8 => 6901
    "槳" : ("桨", ),  # 69F3 => 6868
    "樁" : ("桩", ),  # 6A01 => 6869
    "樂" : ("乐", ),  # 6A02 => 4E50
    "樅" : ("枞", ),  # 6A05 => 679E
    "樓" : ("楼", ),  # 6A13 => 697C
    "標" : ("标", ),  # 6A19 => 6807
    "樞" : ("枢", ),  # 6A1E => 67A2
    "樣" : ("样", ),  # 6A23 => 6837
    "樸" : ("朴", ),  # 6A38 => 6734
    "樹" : ("树", ),  # 6A39 => 6811
    "樺" : ("桦", ),  # 6A3A => 6866
    "橈" : ("桡", ),  # 6A48 => 6861
    "橋" : ("桥", ),  # 6A4B => 6865
    "機" : ("机", ),  # 6A5F => 673A
    "橢" : ("椭", ),  # 6A62 => 692D
    "橫" : ("横", ),  # 6A6B => 6A2A
    "檁" : ("檩", ),  # 6A81 => 6AA9
    "檉" : ("柽", ),  # 6A89 => 67FD
    "檔" : ("档", ),  # 6A94 => 6863
    "檜" : ("桧", ),  # 6A9C => 6867
    "檟" : ("槚", ),  # 6A9F => 69DA
    "檢" : ("检", ),  # 6AA2 => 68C0
    "檣" : ("樯", ),  # 6AA3 => 6A2F
    "檯" : ("台", ),  # 6AAF => 53F0
    "檳" : ("槟", ),  # 6AB3 => 69DF
    "檸" : ("柠", ),  # 6AB8 => 67E0
    "檻" : ("槛", ),  # 6ABB => 69DB
    "檾" : ("苘", ),  # 6ABE => 82D8
    "櫃" : ("柜", ),  # 6AC3 => 67DC
    "櫓" : ("橹", ),  # 6AD3 => 6A79
    "櫚" : ("榈", ),  # 6ADA => 6988
    "櫛" : ("栉", ),  # 6ADB => 6809
    "櫝" : ("椟", ),  # 6ADD => 691F
    "櫞" : ("橼", ),  # 6ADE => 6A7C
    "櫟" : ("栎", ),  # 6ADF => 680E
    "櫥" : ("橱", ),  # 6AE5 => 6A71
    "櫧" : ("槠", ),  # 6AE7 => 69E0
    "櫨" : ("栌", ),  # 6AE8 => 680C
    "櫪" : ("枥", ),  # 6AEA => 67A5
    "櫫" : ("橥", ),  # 6AEB => 6A65
    "櫬" : ("榇", ),  # 6AEC => 6987
    "櫳" : ("栊", ),  # 6AF3 => 680A
    "櫸" : ("榉", ),  # 6AF8 => 6989
    "櫻" : ("樱", ),  # 6AFB => 6A31
    "欄" : ("栏", ),  # 6B04 => 680F
    "權" : ("权", ),  # 6B0A => 6743
    "欏" : ("椤", ),  # 6B0F => 6924
    "欒" : ("栾", ),  # 6B12 => 683E
    "欖" : ("榄", ),  # 6B16 => 6984
    "欞" : ("棂", ),  # 6B1E => 68C2
    "欽" : ("钦", ),  # 6B3D => 94A6
    "歎" : ("叹", ),  # 6B4E => 53F9
    "歐" : ("欧", ),  # 6B50 => 6B27
    "歟" : ("欤", ),  # 6B5F => 6B24
    "歡" : ("欢", ),  # 6B61 => 6B22
    "歲" : ("岁", ),  # 6B72 => 5C81
    "歷" : ("历", ),  # 6B77 => 5386
    "歸" : ("归", ),  # 6B78 => 5F52
    "歿" : ("殁", ),  # 6B7F => 6B81
    "殘" : ("残", ),  # 6B98 => 6B8B
    "殞" : ("殒", ),  # 6B9E => 6B92
    "殤" : ("殇", ),  # 6BA4 => 6B87
    "殫" : ("殚", ),  # 6BAB => 6B9A
    "殮" : ("殓", ),  # 6BAE => 6B93
    "殯" : ("殡", ),  # 6BAF => 6BA1
    "殲" : ("歼", ),  # 6BB2 => 6B7C
    "殺" : ("杀", ),  # 6BBA => 6740
    "殻" : ("壳", ),  # 6BBB => 58F3
    "殼" : ("壳", ),  # 6BBC => 58F3
    "毀" : ("毁", ),  # 6BC0 => 6BC1
    "毆" : ("殴", ),  # 6BC6 => 6BB4
    "毿" : ("毵", ),  # 6BFF => 6BF5
    "氈" : ("毡", ),  # 6C08 => 6BE1
    "氌" : ("氇", ),  # 6C0C => 6C07
    "氣" : ("气", ),  # 6C23 => 6C14
    "氫" : ("氢", ),  # 6C2B => 6C22
    "氬" : ("氩", ),  # 6C2C => 6C29
    "氳" : ("氲", ),  # 6C33 => 6C32
    "氹" : ("凼", ),  # 6C39 => 51FC
    "汙" : ("污", ),  # 6C59 => 6C61
    "決" : ("决", ),  # 6C7A => 51B3
    "沒" : ("没", ),  # 6C92 => 6CA1
    "沖" : ("冲", ),  # 6C96 => 51B2
    "況" : ("况", ),  # 6CC1 => 51B5
    "洶" : ("汹", ),  # 6D36 => 6C79
    "浹" : ("浃", ),  # 6D79 => 6D43
    "涇" : ("泾", ),  # 6D87 => 6CFE
    "涼" : ("凉", ),  # 6DBC => 51C9
    "淒" : ("凄", ),  # 6DD2 => 51C4
    "淚" : ("泪", ),  # 6DDA => 6CEA
    "淥" : ("渌", ),  # 6DE5 => 6E0C
    "淨" : ("净", ),  # 6DE8 => 51C0
    "淩" : ("凌", ),  # 6DE9 => 51CC
    "淪" : ("沦", ),  # 6DEA => 6CA6
    "淵" : ("渊", ),  # 6DF5 => 6E0A
    "淶" : ("涞", ),  # 6DF6 => 6D9E
    "淺" : ("浅", ),  # 6DFA => 6D45
    "渙" : ("涣", ),  # 6E19 => 6DA3
    "減" : ("减", ),  # 6E1B => 51CF
    "渢" : ("沨", ),  # 6E22 => 6CA8
    "渦" : ("涡", ),  # 6E26 => 6DA1
    "測" : ("测", ),  # 6E2C => 6D4B
    "渾" : ("浑", ),  # 6E3E => 6D51
    "湊" : ("凑", ),  # 6E4A => 51D1
    "湞" : ("浈", ),  # 6E5E => 6D48
    "湣" : ("愍", ),  # 6E63 => 610D
    "湧" : ("涌", ),  # 6E67 => 6D8C
    "湯" : ("汤", ),  # 6E6F => 6C64
    "溈" : ("沩", ),  # 6E88 => 6CA9
    "溜" : ("熘", ),  # 6E9C => 7198
    "溝" : ("沟", ),  # 6E9D => 6C9F
    "溫" : ("温", ),  # 6EAB => 6E29
    "溮" : ("浉", ),  # 6EAE => 6D49
    "溳" : ("涢", ),  # 6EB3 => 6DA2
    "滄" : ("沧", ),  # 6EC4 => 6CA7
    "滅" : ("灭", ),  # 6EC5 => 706D
    "滌" : ("涤", ),  # 6ECC => 6DA4
    "滎" : ("荥", ),  # 6ECE => 8365
    "滬" : ("沪", ),  # 6EEC => 6CAA
    "滯" : ("滞", ),  # 6EEF => 6EDE
    "滲" : ("渗", ),  # 6EF2 => 6E17
    "滷" : ("卤", ),  # 6EF7 => 5364
    "滸" : ("浒", ),  # 6EF8 => 6D52
    "滻" : ("浐", ),  # 6EFB => 6D50
    "滾" : ("滚", "磙"),  # 6EFE => 6EDA 78D9
    "滿" : ("满", ),  # 6EFF => 6EE1
    "漁" : ("渔", ),  # 6F01 => 6E14
    "漊" : ("溇", ),  # 6F0A => 6E87
    "漚" : ("沤", ),  # 6F1A => 6CA4
    "漢" : ("汉", ),  # 6F22 => 6C49
    "漣" : ("涟", ),  # 6F23 => 6D9F
    "漬" : ("渍", ),  # 6F2C => 6E0D
    "漲" : ("涨", ),  # 6F32 => 6DA8
    "漵" : ("溆", ),  # 6F35 => 6E86
    "漸" : ("渐", ),  # 6F38 => 6E10
    "漿" : ("浆", ),  # 6F3F => 6D46
    "潁" : ("颍", ),  # 6F41 => 988D
    "潑" : ("泼", ),  # 6F51 => 6CFC
    "潔" : ("洁", ),  # 6F54 => 6D01
    "潛" : ("潜", ),  # 6F5B => 6F5C
    "潤" : ("润", ),  # 6F64 => 6DA6
    "潯" : ("浔", ),  # 6F6F => 6D54
    "潰" : ("溃", ),  # 6F70 => 6E83
    "潷" : ("滗", ),  # 6F77 => 6ED7
    "潿" : ("涠", ),  # 6F7F => 6DA0
    "澀" : ("涩", ),  # 6F80 => 6DA9
    "澆" : ("浇", ),  # 6F86 => 6D47
    "澇" : ("涝", ),  # 6F87 => 6D9D
    "澗" : ("涧", ),  # 6F97 => 6DA7
    "澠" : ("渑", ),  # 6FA0 => 6E11
    "澤" : ("泽", ),  # 6FA4 => 6CFD
    "澦" : ("滪", ),  # 6FA6 => 6EEA
    "澩" : ("泶", ),  # 6FA9 => 6CF6
    "澮" : ("浍", ),  # 6FAE => 6D4D
    "澱" : ("淀", ),  # 6FB1 => 6DC0
    "澾" : ("㳠", ),  # 6FBE => 3CE0
    "濁" : ("浊", ),  # 6FC1 => 6D4A
    "濃" : ("浓", ),  # 6FC3 => 6D53
    "濕" : ("湿", ),  # 6FD5 => 6E7F
    "濘" : ("泞", ),  # 6FD8 => 6CDE
    "濛" : ("蒙", ),  # 6FDB => 8499
    "濜" : ("浕", ),  # 6FDC => 6D55
    "濟" : ("济", ),  # 6FDF => 6D4E
    "濤" : ("涛", ),  # 6FE4 => 6D9B
    "濫" : ("滥", "漤"),  # 6FEB => 6EE5 6F24
    "濰" : ("潍", ),  # 6FF0 => 6F4D
    "濱" : ("滨", ),  # 6FF1 => 6EE8
    "濺" : ("溅", ),  # 6FFA => 6E85
    "濼" : ("泺", ),  # 6FFC => 6CFA
    "濾" : ("滤", ),  # 6FFE => 6EE4
    "瀅" : ("滢", ),  # 7005 => 6EE2
    "瀆" : ("渎", ),  # 7006 => 6E0E
    "瀉" : ("泻", ),  # 7009 => 6CFB
    "瀋" : ("沈", "渖"),  # 700B => 6C88 6E16
    "瀏" : ("浏", ),  # 700F => 6D4F
    "瀕" : ("濒", ),  # 7015 => 6FD2
    "瀘" : ("泸", ),  # 7018 => 6CF8
    "瀝" : ("沥", ),  # 701D => 6CA5
    "瀟" : ("潇", ),  # 701F => 6F47
    "瀠" : ("潆", ),  # 7020 => 6F46
    "瀦" : ("潴", ),  # 7026 => 6F74
    "瀧" : ("泷", ),  # 7027 => 6CF7
    "瀨" : ("濑", ),  # 7028 => 6FD1
    "瀰" : ("弥", ),  # 7030 => 5F25
    "瀲" : ("潋", ),  # 7032 => 6F4B
    "瀾" : ("澜", ),  # 703E => 6F9C
    "灃" : ("沣", ),  # 7043 => 6CA3
    "灄" : ("滠", ),  # 7044 => 6EE0
    "灑" : ("洒", ),  # 7051 => 6D12
    "灕" : ("漓", ),  # 7055 => 6F13
    "灘" : ("滩", ),  # 7058 => 6EE9
    "灝" : ("灏", ),  # 705D => 704F
    "灣" : ("湾", ),  # 7063 => 6E7E
    "灤" : ("滦", ),  # 7064 => 6EE6
    "灧" : ("滟", ),  # 7067 => 6EDF
    "灩" : ("滟", ),  # 7069 => 6EDF
    "災" : ("灾", ),  # 707D => 707E
    "為" : ("为", ),  # 70BA => 4E3A
    "烏" : ("乌", ),  # 70CF => 4E4C
    "烴" : ("烃", ),  # 70F4 => 70C3
    "無" : ("无", ),  # 7121 => 65E0
    "焼" : ("烧", ),  # 713C => 70E7
    "煆" : ("煅", ),  # 7146 => 7145
    "煉" : ("炼", ),  # 7149 => 70BC
    "煒" : ("炜", ),  # 7152 => 709C
    "煙" : ("烟", ),  # 7159 => 70DF
    "煢" : ("茕", ),  # 7162 => 8315
    "煥" : ("焕", ),  # 7165 => 7115
    "煩" : ("烦", ),  # 7169 => 70E6
    "煬" : ("炀", ),  # 716C => 7080
    "熒" : ("荧", ),  # 7192 => 8367
    "熗" : ("炝", ),  # 7197 => 709D
    "熱" : ("热", ),  # 71B1 => 70ED
    "熾" : ("炽", ),  # 71BE => 70BD
    "燁" : ("烨", ),  # 71C1 => 70E8
    "燈" : ("灯", ),  # 71C8 => 706F
    "燉" : ("炖", ),  # 71C9 => 7096
    "燒" : ("烧", ),  # 71D2 => 70E7
    "燙" : ("烫", ),  # 71D9 => 70EB
    "燜" : ("焖", ),  # 71DC => 7116
    "營" : ("营", ),  # 71DF => 8425
    "燦" : ("灿", ),  # 71E6 => 707F
    "燭" : ("烛", ),  # 71ED => 70DB
    "燴" : ("烩", ),  # 71F4 => 70E9
    "燼" : ("烬", ),  # 71FC => 70EC
    "燾" : ("焘", ),  # 71FE => 7118
    "爍" : ("烁", ),  # 720D => 70C1
    "爐" : ("炉", ),  # 7210 => 7089
    "爛" : ("烂", ),  # 721B => 70C2
    "爭" : ("争", ),  # 722D => 4E89
    "爺" : ("爷", ),  # 723A => 7237
    "爾" : ("尔", ),  # 723E => 5C14
    "爿" : ("丬", ),  # 723F => 4E2C
    "牆" : ("墙", ),  # 7246 => 5899
    "牘" : ("牍", ),  # 7258 => 724D
    "牽" : ("牵", ),  # 727D => 7275
    "犖" : ("荦", ),  # 7296 => 8366
    "犛" : ("牦", ),  # 729B => 7266
    "犢" : ("犊", ),  # 72A2 => 728A
    "犧" : ("牺", ),  # 72A7 => 727A
    "犬" : ("犭", ),  # 72AC => 72AD
    "狀" : ("状", ),  # 72C0 => 72B6
    "狹" : ("狭", ),  # 72F9 => 72ED
    "狽" : ("狈", ),  # 72FD => 72C8
    "猙" : ("狰", ),  # 7319 => 72F0
    "猛" : ("勐", ),  # 731B => 52D0
    "猶" : ("犹", ),  # 7336 => 72B9
    "猻" : ("狲", ),  # 733B => 72F2
    "獁" : ("犸", ),  # 7341 => 72B8
    "獄" : ("狱", ),  # 7344 => 72F1
    "獅" : ("狮", ),  # 7345 => 72EE
    "獎" : ("奖", ),  # 734E => 5956
    "獨" : ("独", ),  # 7368 => 72EC
    "獪" : ("狯", ),  # 736A => 72EF
    "獫" : ("猃", ),  # 736B => 7303
    "獰" : ("狞", ),  # 7370 => 72DE
    "獲" : ("获", ),  # 7372 => 83B7
    "獵" : ("猎", ),  # 7375 => 730E
    "獷" : ("犷", ),  # 7377 => 72B7
    "獸" : ("兽", ),  # 7378 => 517D
    "獺" : ("獭", ),  # 737A => 736D
    "獻" : ("献", ),  # 737B => 732E
    "獼" : ("猕", ),  # 737C => 7315
    "玀" : ("猡", ),  # 7380 => 7321
    "玨" : ("珏", ),  # 73A8 => 73CF
    "現" : ("现", ),  # 73FE => 73B0
    "琺" : ("珐", ),  # 743A => 73D0
    "琿" : ("珲", ),  # 743F => 73F2
    "瑉" : ("珉", ),  # 7449 => 73C9
    "瑋" : ("玮", ),  # 744B => 73AE
    "瑣" : ("琐", ),  # 7463 => 7410
    "瑤" : ("瑶", ),  # 7464 => 7476
    "瑩" : ("莹", ),  # 7469 => 83B9
    "瑪" : ("玛", ),  # 746A => 739B
    "瑲" : ("玱", ),  # 7472 => 73B1
    "璉" : ("琏", ),  # 7489 => 740F
    "璡" : ("琎", ),  # 74A1 => 740E
    "璣" : ("玑", ),  # 74A3 => 7391
    "璦" : ("瑷", ),  # 74A6 => 7477
    "環" : ("环", ),  # 74B0 => 73AF
    "璽" : ("玺", ),  # 74BD => 73BA
    "璿" : ("璇", ),  # 74BF => 7487
    "瓊" : ("琼", ),  # 74CA => 743C
    "瓏" : ("珑", ),  # 74CF => 73D1
    "瓔" : ("璎", ),  # 74D4 => 748E
    "瓚" : ("瓒", ),  # 74DA => 74D2
    "甌" : ("瓯", ),  # 750C => 74EF
    "甕" : ("瓮", ),  # 7515 => 74EE
    "產" : ("产", ),  # 7522 => 4EA7
    "産" : ("产", ),  # 7523 => 4EA7
    "甯" : ("宁", ),  # 752F => 5B81
    "畝" : ("亩", ),  # 755D => 4EA9
    "畢" : ("毕", ),  # 7562 => 6BD5
    "畫" : ("画", ),  # 756B => 753B
    "異" : ("异", ),  # 7570 => 5F02
    "當" : ("当", ),  # 7576 => 5F53
    "疇" : ("畴", ),  # 7587 => 7574
    "疊" : ("叠", ),  # 758A => 53E0
    "痙" : ("痉", ),  # 75D9 => 75C9
    "瘂" : ("痖", ),  # 7602 => 75D6
    "瘋" : ("疯", ),  # 760B => 75AF
    "瘍" : ("疡", ),  # 760D => 75A1
    "瘓" : ("痪", ),  # 7613 => 75EA
    "瘞" : ("瘗", ),  # 761E => 7617
    "瘡" : ("疮", ),  # 7621 => 75AE
    "瘧" : ("疟", ),  # 7627 => 759F
    "瘮" : ("瘆", ),  # 762E => 7606
    "瘺" : ("瘘", ),  # 763A => 7618
    "瘻" : ("瘘", ),  # 763B => 7618
    "療" : ("疗", ),  # 7642 => 7597
    "癆" : ("痨", ),  # 7646 => 75E8
    "癇" : ("痫", ),  # 7647 => 75EB
    "癉" : ("瘅", ),  # 7649 => 7605
    "癘" : ("疠", ),  # 7658 => 75A0
    "癟" : ("瘪", ),  # 765F => 762A
    "癡" : ("痴", ),  # 7661 => 75F4
    "癢" : ("痒", ),  # 7662 => 75D2
    "癤" : ("疖", ),  # 7664 => 7596
    "癥" : ("症", ),  # 7665 => 75C7
    "癧" : ("疬", ),  # 7667 => 75AC
    "癩" : ("癞", ),  # 7669 => 765E
    "癬" : ("癣", ),  # 766C => 7663
    "癭" : ("瘿", ),  # 766D => 763F
    "癮" : ("瘾", ),  # 766E => 763E
    "癰" : ("痈", ),  # 7670 => 75C8
    "癱" : ("瘫", ),  # 7671 => 762B
    "癲" : ("癫", ),  # 7672 => 766B
    "發" : ("发", ),  # 767C => 53D1
    "皚" : ("皑", ),  # 769A => 7691
    "皰" : ("疱", ),  # 76B0 => 75B1
    "皸" : ("皲", ),  # 76B8 => 76B2
    "皺" : ("皱", ),  # 76BA => 76B1
    "盜" : ("盗", ),  # 76DC => 76D7
    "盞" : ("盏", ),  # 76DE => 76CF
    "盡" : ("尽", ),  # 76E1 => 5C3D
    "監" : ("监", ),  # 76E3 => 76D1
    "盤" : ("盘", ),  # 76E4 => 76D8
    "盧" : ("卢", ),  # 76E7 => 5362
    "眥" : ("眦", ),  # 7725 => 7726
    "眾" : ("众", ),  # 773E => 4F17
    "睏" : ("困", ),  # 774F => 56F0
    "睜" : ("睁", ),  # 775C => 7741
    "睞" : ("睐", ),  # 775E => 7750
    "瞘" : ("眍", ),  # 7798 => 770D
    "瞜" : ("䁖", ),  # 779C => 4056
    "瞞" : ("瞒", ),  # 779E => 7792
    "瞭" : ("了", ),  # 77AD => 4E86
    "瞼" : ("睑", ),  # 77BC => 7751
    "矇" : ("蒙", ),  # 77C7 => 8499
    "矚" : ("瞩", ),  # 77DA => 77A9
    "矯" : ("矫", ),  # 77EF => 77EB
    "矽" : ("硅", ),  # 77FD => 7845
    "硃" : ("朱", ),  # 7843 => 6731
    "硤" : ("硖", ),  # 7864 => 7856
    "硨" : ("砗", ),  # 7868 => 7817
    "硯" : ("砚", ),  # 786F => 781A
    "碩" : ("硕", ),  # 78A9 => 7855
    "碭" : ("砀", ),  # 78AD => 7800
    "碸" : ("砜", ),  # 78B8 => 781C
    "確" : ("确", ),  # 78BA => 786E
    "碼" : ("码", ),  # 78BC => 7801
    "磑" : ("硙", ),  # 78D1 => 7859
    "磚" : ("砖", ),  # 78DA => 7816
    "磣" : ("碜", ),  # 78E3 => 789C
    "磧" : ("碛", ),  # 78E7 => 789B
    "磯" : ("矶", ),  # 78EF => 77F6
    "磽" : ("硗", ),  # 78FD => 7857
    "礄" : ("硚", ),  # 7904 => 785A
    "礎" : ("础", ),  # 790E => 7840
    "礙" : ("碍", ),  # 7919 => 788D
    "礦" : ("矿", ),  # 7926 => 77FF
    "礪" : ("砺", ),  # 792A => 783A
    "礫" : ("砾", ),  # 792B => 783E
    "礬" : ("矾", ),  # 792C => 77FE
    "礱" : ("砻", ),  # 7931 => 783B
    "祗" : ("只", ),  # 7957 => 53EA
    "祿" : ("禄", ),  # 797F => 7984
    "禍" : ("祸", ),  # 798D => 7978
    "禎" : ("祯", ),  # 798E => 796F
    "禕" : ("祎", ),  # 7995 => 794E
    "禦" : ("御", ),  # 79A6 => 5FA1
    "禪" : ("禅", ),  # 79AA => 7985
    "禮" : ("礼", ),  # 79AE => 793C
    "禰" : ("祢", ),  # 79B0 => 7962
    "禱" : ("祷", ),  # 79B1 => 7977
    "禿" : ("秃", ),  # 79BF => 79C3
    "秈" : ("籼", ),  # 79C8 => 7C7C
    "稅" : ("税", ),  # 7A05 => 7A0E
    "稈" : ("秆", ),  # 7A08 => 79C6
    "稟" : ("禀", ),  # 7A1F => 7980
    "種" : ("种", ),  # 7A2E => 79CD
    "稱" : ("称", ),  # 7A31 => 79F0
    "穇" : ("䅟", ),  # 7A47 => 415F
    "穌" : ("稣", ),  # 7A4C => 7A23
    "積" : ("积", ),  # 7A4D => 79EF
    "穎" : ("颖", ),  # 7A4E => 9896
    "穡" : ("穑", ),  # 7A61 => 7A51
    "穢" : ("秽", ),  # 7A62 => 79FD
    "穩" : ("稳", ),  # 7A69 => 7A33
    "穫" : ("获", ),  # 7A6B => 83B7
    "穭" : ("稆", ),  # 7A6D => 7A06
    "窩" : ("窝", ),  # 7AA9 => 7A9D
    "窪" : ("洼", ),  # 7AAA => 6D3C
    "窮" : ("穷", ),  # 7AAE => 7A77
    "窯" : ("窑", ),  # 7AAF => 7A91
    "窵" : ("窎", ),  # 7AB5 => 7A8E
    "窶" : ("窭", ),  # 7AB6 => 7AAD
    "窺" : ("窥", ),  # 7ABA => 7AA5
    "竄" : ("窜", ),  # 7AC4 => 7A9C
    "竅" : ("窍", ),  # 7AC5 => 7A8D
    "竇" : ("窦", ),  # 7AC7 => 7AA6
    "竈" : ("灶", ),  # 7AC8 => 7076
    "竊" : ("窃", ),  # 7ACA => 7A83
    "竪" : ("竖", ),  # 7AEA => 7AD6
    "競" : ("竞", ),  # 7AF6 => 7ADE
    "筆" : ("笔", ),  # 7B46 => 7B14
    "筍" : ("笋", ),  # 7B4D => 7B0B
    "筧" : ("笕", ),  # 7B67 => 7B15
    "箋" : ("笺", ),  # 7B8B => 7B3A
    "箏" : ("筝", ),  # 7B8F => 7B5D
    "節" : ("节", ),  # 7BC0 => 8282
    "範" : ("范", ),  # 7BC4 => 8303
    "築" : ("筑", ),  # 7BC9 => 7B51
    "篋" : ("箧", ),  # 7BCB => 7BA7
    "篤" : ("笃", ),  # 7BE4 => 7B03
    "篩" : ("筛", ),  # 7BE9 => 7B5B
    "篳" : ("筚", ),  # 7BF3 => 7B5A
    "簀" : ("箦", ),  # 7C00 => 7BA6
    "簍" : ("篓", ),  # 7C0D => 7BD3
    "簞" : ("箪", ),  # 7C1E => 7BAA
    "簡" : ("简", ),  # 7C21 => 7B80
    "簣" : ("篑", ),  # 7C23 => 7BD1
    "簫" : ("箫", ),  # 7C2B => 7BAB
    "簷" : ("檐", ),  # 7C37 => 6A90
    "簽" : ("签", ),  # 7C3D => 7B7E
    "簾" : ("帘", ),  # 7C3E => 5E18
    "籃" : ("篮", ),  # 7C43 => 7BEE
    "籌" : ("筹", ),  # 7C4C => 7B79
    "籙" : ("箓", ),  # 7C59 => 7B93
    "籜" : ("箨", ),  # 7C5C => 7BA8
    "籟" : ("籁", ),  # 7C5F => 7C41
    "籠" : ("笼", ),  # 7C60 => 7B3C
    "籤" : ("签", ),  # 7C64 => 7B7E
    "籩" : ("笾", ),  # 7C69 => 7B3E
    "籪" : ("簖", ),  # 7C6A => 7C16
    "籬" : ("篱", ),  # 7C6C => 7BF1
    "籮" : ("箩", ),  # 7C6E => 7BA9
    "籲" : ("吁", ),  # 7C72 => 5401
    "粵" : ("粤", ),  # 7CB5 => 7CA4
    "糊" : ("煳", ),  # 7CCA => 7173
    "糝" : ("糁", ),  # 7CDD => 7CC1
    "糞" : ("粪", ),  # 7CDE => 7CAA
    "糧" : ("粮", ),  # 7CE7 => 7CAE
    "糰" : ("团", ),  # 7CF0 => 56E2
    "糲" : ("粝", ),  # 7CF2 => 7C9D
    "糴" : ("籴", ),  # 7CF4 => 7C74
    "糶" : ("粜", ),  # 7CF6 => 7C9C
    "糸" : ("纟", ),  # 7CF8 => 7E9F
    "糾" : ("纠", ),  # 7CFE => 7EA0
    "紀" : ("纪", ),  # 7D00 => 7EAA
    "紂" : ("纣", ),  # 7D02 => 7EA3
    "約" : ("约", ),  # 7D04 => 7EA6
    "紅" : ("红", ),  # 7D05 => 7EA2
    "紆" : ("纡", ),  # 7D06 => 7EA1
    "紇" : ("纥", ),  # 7D07 => 7EA5
    "紈" : ("纨", ),  # 7D08 => 7EA8
    "紉" : ("纫", ),  # 7D09 => 7EAB
    "紋" : ("纹", ),  # 7D0B => 7EB9
    "納" : ("纳", ),  # 7D0D => 7EB3
    "紐" : ("纽", ),  # 7D10 => 7EBD
    "紓" : ("纾", ),  # 7D13 => 7EBE
    "純" : ("纯", ),  # 7D14 => 7EAF
    "紕" : ("纰", ),  # 7D15 => 7EB0
    "紖" : ("纼", ),  # 7D16 => 7EBC
    "紗" : ("纱", ),  # 7D17 => 7EB1
    "紙" : ("纸", ),  # 7D19 => 7EB8
    "級" : ("级", ),  # 7D1A => 7EA7
    "紛" : ("纷", ),  # 7D1B => 7EB7
    "紜" : ("纭", ),  # 7D1C => 7EAD
    "紝" : ("纴", ),  # 7D1D => 7EB4
    "紡" : ("纺", ),  # 7D21 => 7EBA
    "紬" : ("䌷", ),  # 7D2C => 4337
    "紮" : ("扎", ),  # 7D2E => 624E
    "細" : ("细", ),  # 7D30 => 7EC6
    "紱" : ("绂", ),  # 7D31 => 7EC2
    "紲" : ("绁", ),  # 7D32 => 7EC1
    "紳" : ("绅", ),  # 7D33 => 7EC5
    "紹" : ("绍", ),  # 7D39 => 7ECD
    "紺" : ("绀", ),  # 7D3A => 7EC0
    "紼" : ("绋", ),  # 7D3C => 7ECB
    "紿" : ("绐", ),  # 7D3F => 7ED0
    "絀" : ("绌", ),  # 7D40 => 7ECC
    "終" : ("终", ),  # 7D42 => 7EC8
    "組" : ("组", ),  # 7D44 => 7EC4
    "絆" : ("绊", ),  # 7D46 => 7ECA
    "絎" : ("绗", ),  # 7D4E => 7ED7
    "絏" : ("绁", ),  # 7D4F => 7EC1
    "結" : ("结", ),  # 7D50 => 7ED3
    "絕" : ("绝", ),  # 7D55 => 7EDD
    "絛" : ("绦", ),  # 7D5B => 7EE6
    "絝" : ("绔", ),  # 7D5D => 7ED4
    "絞" : ("绞", ),  # 7D5E => 7EDE
    "絡" : ("络", ),  # 7D61 => 7EDC
    "絢" : ("绚", ),  # 7D62 => 7EDA
    "給" : ("给", ),  # 7D66 => 7ED9
    "絨" : ("绒", ),  # 7D68 => 7ED2
    "絰" : ("绖", ),  # 7D70 => 7ED6
    "統" : ("统", ),  # 7D71 => 7EDF
    "絲" : ("丝", ),  # 7D72 => 4E1D
    "絳" : ("绛", ),  # 7D73 => 7EDB
    "絶" : ("绝", ),  # 7D76 => 7EDD
    "絹" : ("绢", ),  # 7D79 => 7EE2
    "綁" : ("绑", ),  # 7D81 => 7ED1
    "綃" : ("绡", ),  # 7D83 => 7EE1
    "綆" : ("绠", ),  # 7D86 => 7EE0
    "綈" : ("绨", ),  # 7D88 => 7EE8
    "綉" : ("绣", ),  # 7D89 => 7EE3
    "綏" : ("绥", ),  # 7D8F => 7EE5
    "經" : ("经", ),  # 7D93 => 7ECF
    "綜" : ("综", ),  # 7D9C => 7EFC
    "綞" : ("缍", ),  # 7D9E => 7F0D
    "綠" : ("绿", ),  # 7DA0 => 7EFF
    "綢" : ("绸", ),  # 7DA2 => 7EF8
    "綣" : ("绻", ),  # 7DA3 => 7EFB
    "綫" : ("线", ),  # 7DAB => 7EBF
    "綬" : ("绶", ),  # 7DAC => 7EF6
    "維" : ("维", ),  # 7DAD => 7EF4
    "綰" : ("绾", ),  # 7DB0 => 7EFE
    "綱" : ("纲", ),  # 7DB1 => 7EB2
    "網" : ("网", ),  # 7DB2 => 7F51
    "綳" : ("绷", ),  # 7DB3 => 7EF7
    "綴" : ("缀", ),  # 7DB4 => 7F00
    "綸" : ("纶", ),  # 7DB8 => 7EB6
    "綹" : ("绺", ),  # 7DB9 => 7EFA
    "綺" : ("绮", ),  # 7DBA => 7EEE
    "綻" : ("绽", ),  # 7DBB => 7EFD
    "綽" : ("绰", ),  # 7DBD => 7EF0
    "綾" : ("绫", ),  # 7DBE => 7EEB
    "綿" : ("绵", ),  # 7DBF => 7EF5
    "緄" : ("绲", ),  # 7DC4 => 7EF2
    "緇" : ("缁", ),  # 7DC7 => 7F01
    "緊" : ("紧", ),  # 7DCA => 7D27
    "緋" : ("绯", ),  # 7DCB => 7EEF
    "緑" : ("绿", ),  # 7DD1 => 7EFF
    "緒" : ("绪", ),  # 7DD2 => 7EEA
    "緔" : ("绱", ),  # 7DD4 => 7EF1
    "緗" : ("缃", ),  # 7DD7 => 7F03
    "緘" : ("缄", ),  # 7DD8 => 7F04
    "緙" : ("缂", ),  # 7DD9 => 7F02
    "線" : ("线", ),  # 7DDA => 7EBF
    "緝" : ("缉", ),  # 7DDD => 7F09
    "緞" : ("缎", ),  # 7DDE => 7F0E
    "締" : ("缔", ),  # 7DE0 => 7F14
    "緡" : ("缗", ),  # 7DE1 => 7F17
    "緣" : ("缘", ),  # 7DE3 => 7F18
    "緦" : ("缌", ),  # 7DE6 => 7F0C
    "編" : ("编", ),  # 7DE8 => 7F16
    "緩" : ("缓", ),  # 7DE9 => 7F13
    "緬" : ("缅", ),  # 7DEC => 7F05
    "緯" : ("纬", ),  # 7DEF => 7EAC
    "緱" : ("缑", ),  # 7DF1 => 7F11
    "緲" : ("缈", ),  # 7DF2 => 7F08
    "練" : ("练", ),  # 7DF4 => 7EC3
    "緶" : ("缏", ),  # 7DF6 => 7F0F
    "緹" : ("缇", ),  # 7DF9 => 7F07
    "緻" : ("致", ),  # 7DFB => 81F4
    "緼" : ("缊", ),  # 7DFC => 7F0A
    "縈" : ("萦", ),  # 7E08 => 8426
    "縉" : ("缙", ),  # 7E09 => 7F19
    "縊" : ("缢", ),  # 7E0A => 7F22
    "縋" : ("缒", ),  # 7E0B => 7F12
    "縐" : ("绉", ),  # 7E10 => 7EC9
    "縑" : ("缣", ),  # 7E11 => 7F23
    "縗" : ("缞", ),  # 7E17 => 7F1E
    "縛" : ("缚", ),  # 7E1B => 7F1A
    "縝" : ("缜", ),  # 7E1D => 7F1C
    "縞" : ("缟", ),  # 7E1E => 7F1F
    "縟" : ("缛", ),  # 7E1F => 7F1B
    "縣" : ("县", ),  # 7E23 => 53BF
    "縧" : ("绦", ),  # 7E27 => 7EE6
    "縫" : ("缝", ),  # 7E2B => 7F1D
    "縭" : ("缡", ),  # 7E2D => 7F21
    "縮" : ("缩", ),  # 7E2E => 7F29
    "縱" : ("纵", ),  # 7E31 => 7EB5
    "縲" : ("缧", ),  # 7E32 => 7F27
    "縴" : ("纤", ),  # 7E34 => 7EA4
    "縵" : ("缦", ),  # 7E35 => 7F26
    "縶" : ("絷", ),  # 7E36 => 7D77
    "縷" : ("缕", ),  # 7E37 => 7F15
    "縹" : ("缥", ),  # 7E39 => 7F25
    "總" : ("总", ),  # 7E3D => 603B
    "績" : ("绩", ),  # 7E3E => 7EE9
    "繃" : ("绷", ),  # 7E43 => 7EF7
    "繅" : ("缫", ),  # 7E45 => 7F2B
    "繆" : ("缪", ),  # 7E46 => 7F2A
    "繈" : ("襁", ),  # 7E48 => 8941
    "繒" : ("缯", ),  # 7E52 => 7F2F
    "織" : ("织", ),  # 7E54 => 7EC7
    "繕" : ("缮", ),  # 7E55 => 7F2E
    "繚" : ("缭", ),  # 7E5A => 7F2D
    "繞" : ("绕", ),  # 7E5E => 7ED5
    "繡" : ("绣", ),  # 7E61 => 7EE3
    "繢" : ("缋", ),  # 7E62 => 7F0B
    "繩" : ("绳", ),  # 7E69 => 7EF3
    "繪" : ("绘", ),  # 7E6A => 7ED8
    "繫" : ("系", ),  # 7E6B => 7CFB
    "繭" : ("茧", ),  # 7E6D => 8327
    "繮" : ("缰", ),  # 7E6E => 7F30
    "繯" : ("缳", ),  # 7E6F => 7F33
    "繰" : ("缲", ),  # 7E70 => 7F32
    "繳" : ("缴", ),  # 7E73 => 7F34
    "繹" : ("绎", ),  # 7E79 => 7ECE
    "繼" : ("继", ),  # 7E7C => 7EE7
    "繽" : ("缤", ),  # 7E7D => 7F24
    "繾" : ("缱", ),  # 7E7E => 7F31
    "纈" : ("缬", ),  # 7E88 => 7F2C
    "纊" : ("纩", ),  # 7E8A => 7EA9
    "續" : ("续", ),  # 7E8C => 7EED
    "纍" : ("累", ),  # 7E8D => 7D2F
    "纏" : ("缠", ),  # 7E8F => 7F20
    "纓" : ("缨", ),  # 7E93 => 7F28
    "纔" : ("才", ),  # 7E94 => 624D
    "纖" : ("纤", ),  # 7E96 => 7EA4
    "纘" : ("缵", ),  # 7E98 => 7F35
    "纜" : ("缆", ),  # 7E9C => 7F06
    "缽" : ("钵", ),  # 7F3D => 94B5
    "罌" : ("罂", ),  # 7F4C => 7F42
    "罎" : ("坛", ),  # 7F4E => 575B
    "罰" : ("罚", ),  # 7F70 => 7F5A
    "罵" : ("骂", ),  # 7F75 => 9A82
    "罷" : ("罢", ),  # 7F77 => 7F62
    "罸" : ("罚", ),  # 7F78 => 7F5A
    "羅" : ("罗", ),  # 7F85 => 7F57
    "羆" : ("罴", ),  # 7F86 => 7F74
    "羈" : ("羁", ),  # 7F88 => 7F81
    "羋" : ("芈", ),  # 7F8B => 8288
    "羥" : ("羟", ),  # 7FA5 => 7F9F
    "羨" : ("羡", ),  # 7FA8 => 7FA1
    "義" : ("义", ),  # 7FA9 => 4E49
    "習" : ("习", ),  # 7FD2 => 4E60
    "翬" : ("翚", ),  # 7FEC => 7FDA
    "翹" : ("翘", ),  # 7FF9 => 7FD8
    "耬" : ("耧", ),  # 802C => 8027
    "耮" : ("耢", ),  # 802E => 8022
    "聖" : ("圣", ),  # 8056 => 5723
    "聞" : ("闻", ),  # 805E => 95FB
    "聯" : ("联", ),  # 806F => 8054
    "聰" : ("聪", ),  # 8070 => 806A
    "聲" : ("声", ),  # 8072 => 58F0
    "聳" : ("耸", ),  # 8073 => 8038
    "聵" : ("聩", ),  # 8075 => 8069
    "聶" : ("聂", ),  # 8076 => 8042
    "職" : ("职", ),  # 8077 => 804C
    "聹" : ("聍", ),  # 8079 => 804D
    "聽" : ("听", ),  # 807D => 542C
    "聾" : ("聋", ),  # 807E => 804B
    "肅" : ("肃", ),  # 8085 => 8083
    "脅" : ("胁", ),  # 8105 => 80C1
    "脈" : ("脉", ),  # 8108 => 8109
    "脊" : ("嵴", ),  # 810A => 5D74
    "脛" : ("胫", ),  # 811B => 80EB
    "脫" : ("脱", ),  # 812B => 8131
    "脹" : ("胀", ),  # 8139 => 80C0
    "腎" : ("肾", ),  # 814E => 80BE
    "腖" : ("胨", ),  # 8156 => 80E8
    "腡" : ("脶", ),  # 8161 => 8136
    "腦" : ("脑", ),  # 8166 => 8111
    "腫" : ("肿", ),  # 816B => 80BF
    "腳" : ("脚", ),  # 8173 => 811A
    "腸" : ("肠", ),  # 8178 => 80A0
    "膁" : ("肷", ),  # 8181 => 80B7
    "膃" : ("腽", ),  # 8183 => 817D
    "膕" : ("腘", ),  # 8195 => 8158
    "膚" : ("肤", ),  # 819A => 80A4
    "膞" : ("䏝", ),  # 819E => 43DD
    "膠" : ("胶", ),  # 81A0 => 80F6
    "膩" : ("腻", ),  # 81A9 => 817B
    "膽" : ("胆", ),  # 81BD => 80C6
    "膾" : ("脍", ),  # 81BE => 810D
    "膿" : ("脓", ),  # 81BF => 8113
    "臉" : ("脸", ),  # 81C9 => 8138
    "臍" : ("脐", ),  # 81CD => 8110
    "臏" : ("膑", ),  # 81CF => 8191
    "臒" : ("癯", ),  # 81D2 => 766F
    "臓" : ("赃", ),  # 81D3 => 8D43
    "臘" : ("腊", ),  # 81D8 => 814A
    "臚" : ("胪", ),  # 81DA => 80EA
    "臠" : ("脔", ),  # 81E0 => 8114
    "臢" : ("臜", ),  # 81E2 => 81DC
    "臥" : ("卧", ),  # 81E5 => 5367
    "臨" : ("临", ),  # 81E8 => 4E34
    "臺" : ("台", ),  # 81FA => 53F0
    "與" : ("与", ),  # 8207 => 4E0E
    "興" : ("兴", ),  # 8208 => 5174
    "舉" : ("举", ),  # 8209 => 4E3E
    "舊" : ("旧", ),  # 820A => 65E7
    "艙" : ("舱", ),  # 8259 => 8231
    "艤" : ("舣", ),  # 8264 => 8223
    "艦" : ("舰", ),  # 8266 => 8230
    "艫" : ("舻", ),  # 826B => 823B
    "艱" : ("艰", ),  # 8271 => 8270
    "艶" : ("艳", ),  # 8276 => 8273
    "艸" : ("艹", ),  # 8278 => 8279
    "芻" : ("刍", ),  # 82BB => 520D
    "苧" : ("苎", ),  # 82E7 => 82CE
    "茲" : ("兹", ),  # 8332 => 5179
    "荊" : ("荆", ),  # 834A => 8346
    "莊" : ("庄", ),  # 838A => 5E84
    "莖" : ("茎", ),  # 8396 => 830E
    "莢" : ("荚", ),  # 83A2 => 835A
    "莧" : ("苋", ),  # 83A7 => 82CB
    "華" : ("华", ),  # 83EF => 534E
    "萇" : ("苌", ),  # 8407 => 82CC
    "萊" : ("莱", ),  # 840A => 83B1
    "萬" : ("万", ),  # 842C => 4E07
    "萵" : ("莴", ),  # 8435 => 83B4
    "葉" : ("叶", ),  # 8449 => 53F6
    "葒" : ("荭", ),  # 8452 => 836D
    "著" : ("着", ),  # 8457 => 7740
    "葤" : ("荮", ),  # 8464 => 836E
    "葦" : ("苇", ),  # 8466 => 82C7
    "葷" : ("荤", ),  # 8477 => 8364
    "蒓" : ("莼", ),  # 8493 => 83BC
    "蒔" : ("莳", ),  # 8494 => 83B3
    "蒞" : ("莅", ),  # 849E => 8385
    "蒼" : ("苍", ),  # 84BC => 82CD
    "蓀" : ("荪", ),  # 84C0 => 836A
    "蓋" : ("盖", ),  # 84CB => 76D6
    "蓧" : ("莜", ),  # 84E7 => 839C
    "蓮" : ("莲", ),  # 84EE => 83B2
    "蓯" : ("苁", ),  # 84EF => 82C1
    "蓴" : ("莼", ),  # 84F4 => 83BC
    "蓽" : ("荜", ),  # 84FD => 835C
    "蔔" : ("卜", ),  # 8514 => 535C
    "蔞" : ("蒌", ),  # 851E => 848C
    "蔣" : ("蒋", ),  # 8523 => 848B
    "蔥" : ("葱", ),  # 8525 => 8471
    "蔦" : ("茑", ),  # 8526 => 8311
    "蔭" : ("荫", ),  # 852D => 836B
    "蕁" : ("荨", ),  # 8541 => 8368
    "蕆" : ("蒇", ),  # 8546 => 8487
    "蕎" : ("荞", ),  # 854E => 835E
    "蕒" : ("荬", ),  # 8552 => 836C
    "蕓" : ("芸", ),  # 8553 => 82B8
    "蕕" : ("莸", ),  # 8555 => 83B8
    "蕘" : ("荛", ),  # 8558 => 835B
    "蕢" : ("蒉", ),  # 8562 => 8489
    "蕩" : ("荡", ),  # 8569 => 8361
    "蕪" : ("芜", ),  # 856A => 829C
    "蕭" : ("萧", ),  # 856D => 8427
    "蕷" : ("蓣", ),  # 8577 => 84E3
    "薈" : ("荟", ),  # 8588 => 835F
    "薊" : ("蓟", ),  # 858A => 84DF
    "薌" : ("芗", ),  # 858C => 8297
    "薑" : ("姜", ),  # 8591 => 59DC
    "薔" : ("蔷", ),  # 8594 => 8537
    "薟" : ("莶", ),  # 859F => 83B6
    "薦" : ("荐", ),  # 85A6 => 8350
    "薩" : ("萨", ),  # 85A9 => 8428
    "薺" : ("荠", ),  # 85BA => 8360
    "藉" : ("借", ),  # 85C9 => 501F
    "藍" : ("蓝", ),  # 85CD => 84DD
    "藎" : ("荩", ),  # 85CE => 8369
    "藝" : ("艺", ),  # 85DD => 827A
    "藥" : ("药", ),  # 85E5 => 836F
    "藪" : ("薮", ),  # 85EA => 85AE
    "藭" : ("䓖", ),  # 85ED => 44D6
    "藴" : ("蕴", ),  # 85F4 => 8574
    "藶" : ("苈", ),  # 85F6 => 82C8
    "藹" : ("蔼", ),  # 85F9 => 853C
    "藺" : ("蔺", ),  # 85FA => 853A
    "蘀" : ("萚", ),  # 8600 => 841A
    "蘄" : ("蕲", ),  # 8604 => 8572
    "蘆" : ("芦", ),  # 8606 => 82A6
    "蘇" : ("苏", ),  # 8607 => 82CF
    "蘊" : ("蕴", ),  # 860A => 8574
    "蘋" : ("苹", ),  # 860B => 82F9
    "蘚" : ("藓", ),  # 861A => 85D3
    "蘞" : ("蔹", ),  # 861E => 8539
    "蘢" : ("茏", ),  # 8622 => 830F
    "蘭" : ("兰", ),  # 862D => 5170
    "蘺" : ("蓠", ),  # 863A => 84E0
    "蘿" : ("萝", ),  # 863F => 841D
    "處" : ("处", ),  # 8655 => 5904
    "虛" : ("虚", ),  # 865B => 865A
    "虜" : ("虏", ),  # 865C => 864F
    "號" : ("号", ),  # 865F => 53F7
    "虧" : ("亏", ),  # 8667 => 4E8F
    "虯" : ("虬", ),  # 866F => 866C
    "蛺" : ("蛱", ),  # 86FA => 86F1
    "蛻" : ("蜕", ),  # 86FB => 8715
    "蜆" : ("蚬", ),  # 8706 => 86AC
    "蝕" : ("蚀", ),  # 8755 => 8680
    "蝟" : ("猬", ),  # 875F => 732C
    "蝦" : ("虾", ),  # 8766 => 867E
    "蝸" : ("蜗", ),  # 8778 => 8717
    "螄" : ("蛳", ),  # 8784 => 86F3
    "螞" : ("蚂", ),  # 879E => 8682
    "螢" : ("萤", ),  # 87A2 => 8424
    "螻" : ("蝼", ),  # 87BB => 877C
    "蟄" : ("蛰", ),  # 87C4 => 86F0
    "蟈" : ("蝈", ),  # 87C8 => 8748
    "蟎" : ("螨", ),  # 87CE => 87A8
    "蟣" : ("虮", ),  # 87E3 => 866E
    "蟬" : ("蝉", ),  # 87EC => 8749
    "蟯" : ("蛲", ),  # 87EF => 86F2
    "蟲" : ("虫", ),  # 87F2 => 866B
    "蟶" : ("蛏", ),  # 87F6 => 86CF
    "蟻" : ("蚁", ),  # 87FB => 8681
    "蠅" : ("蝇", ),  # 8805 => 8747
    "蠆" : ("虿", ),  # 8806 => 867F
    "蠍" : ("蝎", ),  # 880D => 874E
    "蠐" : ("蛴", ),  # 8810 => 86F4
    "蠑" : ("蝾", ),  # 8811 => 877E
    "蠔" : ("蚝", ),  # 8814 => 869D
    "蠟" : ("蜡", ),  # 881F => 8721
    "蠣" : ("蛎", ),  # 8823 => 86CE
    "蠨" : ("蟏", ),  # 8828 => 87CF
    "蠱" : ("蛊", ),  # 8831 => 86CA
    "蠶" : ("蚕", ),  # 8836 => 8695
    "蠻" : ("蛮", ),  # 883B => 86EE
    "衆" : ("众", ),  # 8846 => 4F17
    "衊" : ("蔑", ),  # 884A => 8511
    "術" : ("术", ),  # 8853 => 672F
    "衛" : ("卫", ),  # 885B => 536B
    "衝" : ("冲", ),  # 885D => 51B2
    "衹" : ("只", ),  # 8879 => 53EA
    "袞" : ("衮", ),  # 889E => 886E
    "裊" : ("袅", ),  # 88CA => 8885
    "裏" : ("里", ),  # 88CF => 91CC
    "補" : ("补", ),  # 88DC => 8865
    "裝" : ("装", ),  # 88DD => 88C5
    "製" : ("制", ),  # 88FD => 5236
    "複" : ("复", ),  # 8907 => 590D
    "褲" : ("裤", ),  # 8932 => 88E4
    "褳" : ("裢", ),  # 8933 => 88E2
    "褸" : ("褛", ),  # 8938 => 891B
    "褻" : ("亵", ),  # 893B => 4EB5
    "襆" : ("幞", ),  # 8946 => 5E5E
    "襇" : ("裥", ),  # 8947 => 88E5
    "襖" : ("袄", ),  # 8956 => 8884
    "襝" : ("裣", ),  # 895D => 88E3
    "襠" : ("裆", ),  # 8960 => 88C6
    "襤" : ("褴", ),  # 8964 => 8934
    "襪" : ("袜", ),  # 896A => 889C
    "襬" : ("摆", ),  # 896C => 6446
    "襯" : ("衬", ),  # 896F => 886C
    "襲" : ("袭", ),  # 8972 => 88AD
    "覊" : ("羁", ),  # 898A => 7F81
    "見" : ("见", ),  # 898B => 89C1
    "覎" : ("觃", ),  # 898E => 89C3
    "規" : ("规", ),  # 898F => 89C4
    "覓" : ("觅", ),  # 8993 => 89C5
    "視" : ("视", ),  # 8996 => 89C6
    "覘" : ("觇", ),  # 8998 => 89C7
    "覡" : ("觋", ),  # 89A1 => 89CB
    "覦" : ("觎", ),  # 89A6 => 89CE
    "覧" : ("览", ),  # 89A7 => 89C8
    "親" : ("亲", ),  # 89AA => 4EB2
    "覬" : ("觊", ),  # 89AC => 89CA
    "覯" : ("觏", ),  # 89AF => 89CF
    "覲" : ("觐", ),  # 89B2 => 89D0
    "覷" : ("觑", ),  # 89B7 => 89D1
    "覺" : ("觉", ),  # 89BA => 89C9
    "覽" : ("览", ),  # 89BD => 89C8
    "覿" : ("觌", ),  # 89BF => 89CC
    "觀" : ("观", ),  # 89C0 => 89C2
    "觴" : ("觞", ),  # 89F4 => 89DE
    "觶" : ("觯", ),  # 89F6 => 89EF
    "觸" : ("触", ),  # 89F8 => 89E6
    "訁" : ("讠", ),  # 8A01 => 8BA0
    "訂" : ("订", ),  # 8A02 => 8BA2
    "訃" : ("讣", ),  # 8A03 => 8BA3
    "計" : ("计", ),  # 8A08 => 8BA1
    "訊" : ("讯", ),  # 8A0A => 8BAF
    "訌" : ("讧", ),  # 8A0C => 8BA7
    "討" : ("讨", ),  # 8A0E => 8BA8
    "訐" : ("讦", ),  # 8A10 => 8BA6
    "訓" : ("训", ),  # 8A13 => 8BAD
    "訕" : ("讪", ),  # 8A15 => 8BAA
    "訖" : ("讫", ),  # 8A16 => 8BAB
    "記" : ("记", ),  # 8A18 => 8BB0
    "訛" : ("讹", ),  # 8A1B => 8BB9
    "訝" : ("讶", ),  # 8A1D => 8BB6
    "訟" : ("讼", ),  # 8A1F => 8BBC
    "訢" : ("䜣", ),  # 8A22 => 4723
    "訣" : ("诀", ),  # 8A23 => 8BC0
    "訥" : ("讷", ),  # 8A25 => 8BB7
    "訩" : ("讻", ),  # 8A29 => 8BBB
    "訪" : ("访", ),  # 8A2A => 8BBF
    "設" : ("设", ),  # 8A2D => 8BBE
    "許" : ("许", ),  # 8A31 => 8BB8
    "訴" : ("诉", ),  # 8A34 => 8BC9
    "訶" : ("诃", ),  # 8A36 => 8BC3
    "診" : ("诊", ),  # 8A3A => 8BCA
    "詁" : ("诂", ),  # 8A41 => 8BC2
    "詆" : ("诋", ),  # 8A46 => 8BCB
    "詎" : ("讵", ),  # 8A4E => 8BB5
    "詐" : ("诈", ),  # 8A50 => 8BC8
    "詒" : ("诒", ),  # 8A52 => 8BD2
    "詔" : ("诏", ),  # 8A54 => 8BCF
    "評" : ("评", ),  # 8A55 => 8BC4
    "詗" : ("诇", ),  # 8A57 => 8BC7
    "詘" : ("诎", ),  # 8A58 => 8BCE
    "詛" : ("诅", ),  # 8A5B => 8BC5
    "詞" : ("词", ),  # 8A5E => 8BCD
    "詠" : ("咏", ),  # 8A60 => 548F
    "詡" : ("诩", ),  # 8A61 => 8BE9
    "詢" : ("询", ),  # 8A62 => 8BE2
    "詣" : ("诣", ),  # 8A63 => 8BE3
    "試" : ("试", ),  # 8A66 => 8BD5
    "詩" : ("诗", ),  # 8A69 => 8BD7
    "詫" : ("诧", ),  # 8A6B => 8BE7
    "詬" : ("诟", ),  # 8A6C => 8BDF
    "詭" : ("诡", ),  # 8A6D => 8BE1
    "詮" : ("诠", ),  # 8A6E => 8BE0
    "詰" : ("诘", ),  # 8A70 => 8BD8
    "話" : ("话", ),  # 8A71 => 8BDD
    "該" : ("该", ),  # 8A72 => 8BE5
    "詳" : ("详", ),  # 8A73 => 8BE6
    "詵" : ("诜", ),  # 8A75 => 8BDC
    "詼" : ("诙", ),  # 8A7C => 8BD9
    "詿" : ("诖", ),  # 8A7F => 8BD6
    "誄" : ("诔", ),  # 8A84 => 8BD4
    "誅" : ("诛", ),  # 8A85 => 8BDB
    "誆" : ("诓", ),  # 8A86 => 8BD3
    "誇" : ("夸", ),  # 8A87 => 5938
    "認" : ("认", ),  # 8A8D => 8BA4
    "誑" : ("诳", ),  # 8A91 => 8BF3
    "誒" : ("诶", ),  # 8A92 => 8BF6
    "誕" : ("诞", ),  # 8A95 => 8BDE
    "誘" : ("诱", ),  # 8A98 => 8BF1
    "誚" : ("诮", ),  # 8A9A => 8BEE
    "語" : ("语", ),  # 8A9E => 8BED
    "誠" : ("诚", ),  # 8AA0 => 8BDA
    "誡" : ("诫", ),  # 8AA1 => 8BEB
    "誣" : ("诬", ),  # 8AA3 => 8BEC
    "誤" : ("误", ),  # 8AA4 => 8BEF
    "誥" : ("诰", ),  # 8AA5 => 8BF0
    "誦" : ("诵", ),  # 8AA6 => 8BF5
    "誨" : ("诲", ),  # 8AA8 => 8BF2
    "說" : ("说", ),  # 8AAA => 8BF4
    "説" : ("说", ),  # 8AAC => 8BF4
    "誰" : ("谁", ),  # 8AB0 => 8C01
    "課" : ("课", ),  # 8AB2 => 8BFE
    "誶" : ("谇", ),  # 8AB6 => 8C07
    "誹" : ("诽", ),  # 8AB9 => 8BFD
    "誼" : ("谊", ),  # 8ABC => 8C0A
    "調" : ("调", ),  # 8ABF => 8C03
    "諂" : ("谄", ),  # 8AC2 => 8C04
    "諄" : ("谆", ),  # 8AC4 => 8C06
    "談" : ("谈", ),  # 8AC7 => 8C08
    "諉" : ("诿", ),  # 8AC9 => 8BFF
    "請" : ("请", ),  # 8ACB => 8BF7
    "諍" : ("诤", ),  # 8ACD => 8BE4
    "諏" : ("诹", ),  # 8ACF => 8BF9
    "諑" : ("诼", ),  # 8AD1 => 8BFC
    "諒" : ("谅", ),  # 8AD2 => 8C05
    "論" : ("论", ),  # 8AD6 => 8BBA
    "諗" : ("谂", ),  # 8AD7 => 8C02
    "諛" : ("谀", ),  # 8ADB => 8C00
    "諜" : ("谍", ),  # 8ADC => 8C0D
    "諝" : ("谞", ),  # 8ADD => 8C1E
    "諞" : ("谝", ),  # 8ADE => 8C1D
    "諡" : ("谥", ),  # 8AE1 => 8C25
    "諢" : ("诨", ),  # 8AE2 => 8BE8
    "諤" : ("谔", ),  # 8AE4 => 8C14
    "諦" : ("谛", ),  # 8AE6 => 8C1B
    "諧" : ("谐", ),  # 8AE7 => 8C10
    "諫" : ("谏", ),  # 8AEB => 8C0F
    "諭" : ("谕", ),  # 8AED => 8C15
    "諮" : ("谘", ),  # 8AEE => 8C18
    "諱" : ("讳", ),  # 8AF1 => 8BB3
    "諳" : ("谙", ),  # 8AF3 => 8C19
    "諶" : ("谌", ),  # 8AF6 => 8C0C
    "諷" : ("讽", ),  # 8AF7 => 8BBD
    "諸" : ("诸", ),  # 8AF8 => 8BF8
    "諺" : ("谚", ),  # 8AFA => 8C1A
    "諼" : ("谖", ),  # 8AFC => 8C16
    "諾" : ("诺", ),  # 8AFE => 8BFA
    "謀" : ("谋", ),  # 8B00 => 8C0B
    "謁" : ("谒", ),  # 8B01 => 8C12
    "謂" : ("谓", ),  # 8B02 => 8C13
    "謄" : ("誊", ),  # 8B04 => 8A8A
    "謅" : ("诌", ),  # 8B05 => 8BCC
    "謊" : ("谎", ),  # 8B0A => 8C0E
    "謎" : ("谜", ),  # 8B0E => 8C1C
    "謐" : ("谧", ),  # 8B10 => 8C27
    "謔" : ("嚯", "谑"),  # 8B14 => 56AF 8C11
    "謖" : ("谡", ),  # 8B16 => 8C21
    "謗" : ("谤", ),  # 8B17 => 8C24
    "謙" : ("谦", ),  # 8B19 => 8C26
    "謚" : ("谥", ),  # 8B1A => 8C25
    "講" : ("讲", ),  # 8B1B => 8BB2
    "謝" : ("谢", ),  # 8B1D => 8C22
    "謠" : ("谣", ),  # 8B20 => 8C23
    "謡" : ("谣", ),  # 8B21 => 8C23
    "謨" : ("谟", ),  # 8B28 => 8C1F
    "謫" : ("谪", ),  # 8B2B => 8C2A
    "謬" : ("谬", ),  # 8B2C => 8C2C
    "謳" : ("讴", ),  # 8B33 => 8BB4
    "謹" : ("谨", ),  # 8B39 => 8C28
    "謾" : ("谩", ),  # 8B3E => 8C29
    "證" : ("证", ),  # 8B49 => 8BC1
    "譎" : ("谲", ),  # 8B4E => 8C32
    "譏" : ("讥", ),  # 8B4F => 8BA5
    "譖" : ("谮", ),  # 8B56 => 8C2E
    "識" : ("识", ),  # 8B58 => 8BC6
    "譙" : ("谯", ),  # 8B59 => 8C2F
    "譚" : ("谭", ),  # 8B5A => 8C2D
    "譜" : ("谱", ),  # 8B5C => 8C31
    "譫" : ("谵", ),  # 8B6B => 8C35
    "譯" : ("译", ),  # 8B6F => 8BD1
    "議" : ("议", ),  # 8B70 => 8BAE
    "譴" : ("谴", ),  # 8B74 => 8C34
    "護" : ("护", ),  # 8B77 => 62A4
    "譽" : ("誉", ),  # 8B7D => 8A89
    "譾" : ("谫", ),  # 8B7E => 8C2B
    "讀" : ("读", ),  # 8B80 => 8BFB
    "讅" : ("谉", ),  # 8B85 => 8C09
    "變" : ("变", ),  # 8B8A => 53D8
    "讌" : ("䜩", ),  # 8B8C => 4729
    "讎" : ("雠", ),  # 8B8E => 96E0
    "讒" : ("谗", ),  # 8B92 => 8C17
    "讓" : ("让", ),  # 8B93 => 8BA9
    "讕" : ("谰", ),  # 8B95 => 8C30
    "讖" : ("谶", ),  # 8B96 => 8C36
    "讜" : ("谠", ),  # 8B9C => 8C20
    "讞" : ("谳", ),  # 8B9E => 8C33
    "豈" : ("岂", ),  # 8C48 => 5C82
    "豎" : ("竖", ),  # 8C4E => 7AD6
    "豐" : ("丰", ),  # 8C50 => 4E30
    "豔" : ("艳", ),  # 8C54 => 8273
    "豬" : ("猪", ),  # 8C6C => 732A
    "豶" : ("豮", ),  # 8C76 => 8C6E
    "貓" : ("猫", ),  # 8C93 => 732B
    "貝" : ("贝", ),  # 8C9D => 8D1D
    "貞" : ("贞", ),  # 8C9E => 8D1E
    "負" : ("负", ),  # 8CA0 => 8D1F
    "財" : ("财", ),  # 8CA1 => 8D22
    "貢" : ("贡", ),  # 8CA2 => 8D21
    "貧" : ("贫", ),  # 8CA7 => 8D2B
    "貨" : ("货", ),  # 8CA8 => 8D27
    "販" : ("贩", ),  # 8CA9 => 8D29
    "貪" : ("贪", ),  # 8CAA => 8D2A
    "貫" : ("贯", ),  # 8CAB => 8D2F
    "責" : ("责", ),  # 8CAC => 8D23
    "貯" : ("贮", ),  # 8CAF => 8D2E
    "貰" : ("贳", ),  # 8CB0 => 8D33
    "貲" : ("赀", ),  # 8CB2 => 8D40
    "貳" : ("贰", ),  # 8CB3 => 8D30
    "貴" : ("贵", ),  # 8CB4 => 8D35
    "貶" : ("贬", ),  # 8CB6 => 8D2C
    "買" : ("买", ),  # 8CB7 => 4E70
    "貸" : ("贷", ),  # 8CB8 => 8D37
    "貺" : ("贶", ),  # 8CBA => 8D36
    "費" : ("费", ),  # 8CBB => 8D39
    "貼" : ("贴", ),  # 8CBC => 8D34
    "貽" : ("贻", ),  # 8CBD => 8D3B
    "貿" : ("贸", ),  # 8CBF => 8D38
    "賀" : ("贺", ),  # 8CC0 => 8D3A
    "賁" : ("贲", ),  # 8CC1 => 8D32
    "賂" : ("赂", ),  # 8CC2 => 8D42
    "賃" : ("赁", ),  # 8CC3 => 8D41
    "賄" : ("贿", ),  # 8CC4 => 8D3F
    "賅" : ("赅", ),  # 8CC5 => 8D45
    "資" : ("资", ),  # 8CC7 => 8D44
    "賈" : ("贾", ),  # 8CC8 => 8D3E
    "賊" : ("贼", ),  # 8CCA => 8D3C
    "賑" : ("赈", ),  # 8CD1 => 8D48
    "賒" : ("赊", ),  # 8CD2 => 8D4A
    "賓" : ("宾", ),  # 8CD3 => 5BBE
    "賕" : ("赇", ),  # 8CD5 => 8D47
    "賙" : ("赒", ),  # 8CD9 => 8D52
    "賚" : ("赉", ),  # 8CDA => 8D49
    "賜" : ("赐", ),  # 8CDC => 8D50
    "賞" : ("赏", ),  # 8CDE => 8D4F
    "賠" : ("赔", ),  # 8CE0 => 8D54
    "賡" : ("赓", ),  # 8CE1 => 8D53
    "賢" : ("贤", ),  # 8CE2 => 8D24
    "賣" : ("卖", ),  # 8CE3 => 5356
    "賤" : ("贱", ),  # 8CE4 => 8D31
    "賦" : ("赋", ),  # 8CE6 => 8D4B
    "賧" : ("赕", ),  # 8CE7 => 8D55
    "質" : ("质", ),  # 8CEA => 8D28
    "賫" : ("赍", ),  # 8CEB => 8D4D
    "賬" : ("账", ),  # 8CEC => 8D26
    "賭" : ("赌", ),  # 8CED => 8D4C
    "賴" : ("赖", ),  # 8CF4 => 8D56
    "賵" : ("赗", ),  # 8CF5 => 8D57
    "賺" : ("赚", ),  # 8CFA => 8D5A
    "賻" : ("赙", ),  # 8CFB => 8D59
    "購" : ("购", ),  # 8CFC => 8D2D
    "賽" : ("赛", ),  # 8CFD => 8D5B
    "賾" : ("赜", ),  # 8CFE => 8D5C
    "贄" : ("贽", ),  # 8D04 => 8D3D
    "贅" : ("赘", ),  # 8D05 => 8D58
    "贈" : ("赠", ),  # 8D08 => 8D60
    "贊" : ("赞", ),  # 8D0A => 8D5E
    "贋" : ("赝", ),  # 8D0B => 8D5D
    "贍" : ("赡", ),  # 8D0D => 8D61
    "贏" : ("赢", ),  # 8D0F => 8D62
    "贐" : ("赆", ),  # 8D10 => 8D46
    "贓" : ("赃", ),  # 8D13 => 8D43
    "贖" : ("赎", ),  # 8D16 => 8D4E
    "贗" : ("赝", ),  # 8D17 => 8D5D
    "贛" : ("赣", ),  # 8D1B => 8D63
    "贜" : ("脏", ),  # 8D1C => 810F
    "赬" : ("赪", ),  # 8D6C => 8D6A
    "趕" : ("赶", ),  # 8D95 => 8D76
    "趙" : ("赵", ),  # 8D99 => 8D75
    "趨" : ("趋", ),  # 8DA8 => 8D8B
    "趲" : ("趱", ),  # 8DB2 => 8DB1
    "跡" : ("迹", ),  # 8DE1 => 8FF9
    "踐" : ("践", ),  # 8E10 => 8DF5
    "踴" : ("踊", ),  # 8E34 => 8E0A
    "蹌" : ("跄", ),  # 8E4C => 8DC4
    "蹕" : ("跸", ),  # 8E55 => 8DF8
    "蹠" : ("跖", ),  # 8E60 => 8DD6
    "蹣" : ("蹒", ),  # 8E63 => 8E52
    "蹤" : ("踪", ),  # 8E64 => 8E2A
    "蹺" : ("跷", ),  # 8E7A => 8DF7
    "躉" : ("趸", ),  # 8E89 => 8DB8
    "躊" : ("踌", ),  # 8E8A => 8E0C
    "躋" : ("跻", ),  # 8E8B => 8DFB
    "躍" : ("跃", ),  # 8E8D => 8DC3
    "躑" : ("踯", ),  # 8E91 => 8E2F
    "躒" : ("跞", ),  # 8E92 => 8DDE
    "躓" : ("踬", ),  # 8E93 => 8E2C
    "躕" : ("蹰", ),  # 8E95 => 8E70
    "躚" : ("跹", ),  # 8E9A => 8DF9
    "躡" : ("蹑", ),  # 8EA1 => 8E51
    "躥" : ("蹿", ),  # 8EA5 => 8E7F
    "躦" : ("躜", ),  # 8EA6 => 8E9C
    "躪" : ("躏", ),  # 8EAA => 8E8F
    "軀" : ("躯", ),  # 8EC0 => 8EAF
    "車" : ("车", ),  # 8ECA => 8F66
    "軋" : ("轧", ),  # 8ECB => 8F67
    "軌" : ("轨", ),  # 8ECC => 8F68
    "軍" : ("军", ),  # 8ECD => 519B
    "軒" : ("轩", ),  # 8ED2 => 8F69
    "軔" : ("轫", ),  # 8ED4 => 8F6B
    "軛" : ("轭", ),  # 8EDB => 8F6D
    "軟" : ("软", ),  # 8EDF => 8F6F
    "軤" : ("轷", ),  # 8EE4 => 8F77
    "軫" : ("轸", ),  # 8EEB => 8F78
    "軲" : ("轱", ),  # 8EF2 => 8F71
    "軸" : ("轴", ),  # 8EF8 => 8F74
    "軹" : ("轵", ),  # 8EF9 => 8F75
    "軺" : ("轺", ),  # 8EFA => 8F7A
    "軻" : ("轲", ),  # 8EFB => 8F72
    "軼" : ("轶", ),  # 8EFC => 8F76
    "軾" : ("轼", ),  # 8EFE => 8F7C
    "較" : ("较", ),  # 8F03 => 8F83
    "輅" : ("辂", ),  # 8F05 => 8F82
    "輇" : ("辁", ),  # 8F07 => 8F81
    "載" : ("载", ),  # 8F09 => 8F7D
    "輊" : ("轾", ),  # 8F0A => 8F7E
    "輒" : ("辄", ),  # 8F12 => 8F84
    "輔" : ("辅", ),  # 8F14 => 8F85
    "輕" : ("轻", ),  # 8F15 => 8F7B
    "輛" : ("辆", ),  # 8F1B => 8F86
    "輜" : ("辎", ),  # 8F1C => 8F8E
    "輝" : ("辉", ),  # 8F1D => 8F89
    "輞" : ("辋", ),  # 8F1E => 8F8B
    "輟" : ("辍", ),  # 8F1F => 8F8D
    "輥" : ("辊", ),  # 8F25 => 8F8A
    "輦" : ("辇", ),  # 8F26 => 8F87
    "輩" : ("辈", ),  # 8F29 => 8F88
    "輪" : ("轮", ),  # 8F2A => 8F6E
    "輯" : ("辑", ),  # 8F2F => 8F91
    "輳" : ("辏", ),  # 8F33 => 8F8F
    "輸" : ("输", ),  # 8F38 => 8F93
    "輻" : ("辐", ),  # 8F3B => 8F90
    "輾" : ("辗", ),  # 8F3E => 8F97
    "輿" : ("舆", ),  # 8F3F => 8206
    "轂" : ("毂", ),  # 8F42 => 6BC2
    "轄" : ("辖", ),  # 8F44 => 8F96
    "轅" : ("辕", ),  # 8F45 => 8F95
    "轆" : ("辘", ),  # 8F46 => 8F98
    "轉" : ("转", ),  # 8F49 => 8F6C
    "轍" : ("辙", ),  # 8F4D => 8F99
    "轎" : ("轿", ),  # 8F4E => 8F7F
    "轔" : ("辚", ),  # 8F54 => 8F9A
    "轟" : ("轰", ),  # 8F5F => 8F70
    "轡" : ("辔", ),  # 8F61 => 8F94
    "轢" : ("轹", ),  # 8F62 => 8F79
    "轤" : ("轳", ),  # 8F64 => 8F73
    "辦" : ("办", ),  # 8FA6 => 529E
    "辭" : ("辞", ),  # 8FAD => 8F9E
    "辮" : ("辫", ),  # 8FAE => 8FAB
    "辯" : ("辩", ),  # 8FAF => 8FA9
    "農" : ("农", ),  # 8FB2 => 519C
    "迴" : ("回", ),  # 8FF4 => 56DE
    "退" : ("煺", ),  # 9000 => 717A
    "逕" : ("迳", ),  # 9015 => 8FF3
    "這" : ("这", ),  # 9019 => 8FD9
    "連" : ("连", ),  # 9023 => 8FDE
    "進" : ("进", ),  # 9032 => 8FDB
    "運" : ("运", ),  # 904B => 8FD0
    "過" : ("过", ),  # 904E => 8FC7
    "達" : ("达", ),  # 9054 => 8FBE
    "違" : ("违", ),  # 9055 => 8FDD
    "遙" : ("遥", ),  # 9059 => 9065
    "遜" : ("逊", ),  # 905C => 900A
    "遝" : ("沓", ),  # 905D => 6C93
    "遞" : ("递", ),  # 905E => 9012
    "遠" : ("远", ),  # 9060 => 8FDC
    "適" : ("适", ),  # 9069 => 9002
    "遲" : ("迟", ),  # 9072 => 8FDF
    "遷" : ("迁", ),  # 9077 => 8FC1
    "選" : ("选", ),  # 9078 => 9009
    "遺" : ("遗", ),  # 907A => 9057
    "遼" : ("辽", ),  # 907C => 8FBD
    "邁" : ("迈", ),  # 9081 => 8FC8
    "還" : ("还", ),  # 9084 => 8FD8
    "邇" : ("迩", ),  # 9087 => 8FE9
    "邊" : ("边", ),  # 908A => 8FB9
    "邏" : ("逻", ),  # 908F => 903B
    "邐" : ("逦", ),  # 9090 => 9026
    "郟" : ("郏", ),  # 90DF => 90CF
    "郤" : ("郄", ),  # 90E4 => 90C4
    "郵" : ("邮", ),  # 90F5 => 90AE
    "鄆" : ("郓", ),  # 9106 => 90D3
    "鄉" : ("乡", ),  # 9109 => 4E61
    "鄒" : ("邹", ),  # 9112 => 90B9
    "鄔" : ("邬", ),  # 9114 => 90AC
    "鄖" : ("郧", ),  # 9116 => 90E7
    "鄧" : ("邓", ),  # 9127 => 9093
    "鄭" : ("郑", ),  # 912D => 90D1
    "鄰" : ("邻", ),  # 9130 => 90BB
    "鄲" : ("郸", ),  # 9132 => 90F8
    "鄴" : ("邺", ),  # 9134 => 90BA
    "鄶" : ("郐", ),  # 9136 => 90D0
    "鄺" : ("邝", ),  # 913A => 909D
    "酈" : ("郦", ),  # 9148 => 90E6
    "醃" : ("腌", ),  # 9183 => 814C
    "醖" : ("酝", ),  # 9196 => 915D
    "醜" : ("丑", ),  # 919C => 4E11
    "醞" : ("酝", ),  # 919E => 915D
    "醤" : ("酱", ),  # 91A4 => 9171
    "醫" : ("医", ),  # 91AB => 533B
    "醬" : ("酱", ),  # 91AC => 9171
    "醯" : ("酰", ),  # 91AF => 9170
    "釀" : ("酿", ),  # 91C0 => 917F
    "釁" : ("衅", ),  # 91C1 => 8845
    "釃" : ("酾", ),  # 91C3 => 917E
    "釅" : ("酽", ),  # 91C5 => 917D
    "釋" : ("释", ),  # 91CB => 91CA
    "釓" : ("钆", ),  # 91D3 => 9486
    "釔" : ("钇", ),  # 91D4 => 9487
    "釕" : ("钌", ),  # 91D5 => 948C
    "釗" : ("钊", ),  # 91D7 => 948A
    "釘" : ("钉", ),  # 91D8 => 9489
    "釙" : ("钋", ),  # 91D9 => 948B
    "針" : ("针", ),  # 91DD => 9488
    "釣" : ("钓", ),  # 91E3 => 9493
    "釤" : ("钐", ),  # 91E4 => 9490
    "釧" : ("钏", ),  # 91E7 => 948F
    "釩" : ("钒", ),  # 91E9 => 9492
    "釵" : ("钗", ),  # 91F5 => 9497
    "釷" : ("钍", ),  # 91F7 => 948D
    "釹" : ("钕", ),  # 91F9 => 9495
    "釺" : ("钎", ),  # 91FA => 948E
    "釾" : ("䥺", ),  # 91FE => 497A
    "鈀" : ("钯", ),  # 9200 => 94AF
    "鈁" : ("钫", ),  # 9201 => 94AB
    "鈃" : ("钘", ),  # 9203 => 9498
    "鈄" : ("钭", ),  # 9204 => 94AD
    "鈈" : ("钚", ),  # 9208 => 949A
    "鈉" : ("钠", ),  # 9209 => 94A0
    "鈍" : ("钝", ),  # 920D => 949D
    "鈎" : ("钩", ),  # 920E => 94A9
    "鈐" : ("钤", ),  # 9210 => 94A4
    "鈑" : ("钣", ),  # 9211 => 94A3
    "鈔" : ("钞", ),  # 9214 => 949E
    "鈕" : ("钮", ),  # 9215 => 94AE
    "鈞" : ("钧", ),  # 921E => 94A7
    "鈣" : ("钙", ),  # 9223 => 9499
    "鈥" : ("钬", ),  # 9225 => 94AC
    "鈦" : ("钛", ),  # 9226 => 949B
    "鈧" : ("钪", ),  # 9227 => 94AA
    "鈮" : ("铌", ),  # 922E => 94CC
    "鈰" : ("铈", ),  # 9230 => 94C8
    "鈳" : ("钶", ),  # 9233 => 94B6
    "鈴" : ("铃", ),  # 9234 => 94C3
    "鈷" : ("钴", ),  # 9237 => 94B4
    "鈸" : ("钹", ),  # 9238 => 94B9
    "鈹" : ("铍", ),  # 9239 => 94CD
    "鈺" : ("钰", ),  # 923A => 94B0
    "鈽" : ("钸", ),  # 923D => 94B8
    "鈾" : ("铀", ),  # 923E => 94C0
    "鈿" : ("钿", ),  # 923F => 94BF
    "鉀" : ("钾", ),  # 9240 => 94BE
    "鉈" : ("铊", ),  # 9248 => 94CA
    "鉉" : ("铉", ),  # 9249 => 94C9
    "鉍" : ("铋", ),  # 924D => 94CB
    "鉑" : ("铂", ),  # 9251 => 94C2
    "鉕" : ("钷", ),  # 9255 => 94B7
    "鉗" : ("钳", ),  # 9257 => 94B3
    "鉚" : ("铆", ),  # 925A => 94C6
    "鉛" : ("铅", ),  # 925B => 94C5
    "鉞" : ("钺", ),  # 925E => 94BA
    "鉢" : ("钵", ),  # 9262 => 94B5
    "鉤" : ("钩", ),  # 9264 => 94A9
    "鉦" : ("钲", ),  # 9266 => 94B2
    "鉬" : ("钼", ),  # 926C => 94BC
    "鉭" : ("钽", ),  # 926D => 94BD
    "鉲" : ("锎", ),  # 9272 => 950E
    "鉶" : ("铏", ),  # 9276 => 94CF
    "鉸" : ("铰", ),  # 9278 => 94F0
    "鉺" : ("铒", ),  # 927A => 94D2
    "鉻" : ("铬", ),  # 927B => 94EC
    "鉿" : ("铪", ),  # 927F => 94EA
    "銀" : ("银", ),  # 9280 => 94F6
    "銃" : ("铳", ),  # 9283 => 94F3
    "銅" : ("铜", ),  # 9285 => 94DC
    "銑" : ("铣", ),  # 9291 => 94E3
    "銓" : ("铨", ),  # 9293 => 94E8
    "銖" : ("铢", ),  # 9296 => 94E2
    "銘" : ("铭", ),  # 9298 => 94ED
    "銚" : ("铫", ),  # 929A => 94EB
    "銜" : ("衔", ),  # 929C => 8854
    "銠" : ("铑", ),  # 92A0 => 94D1
    "銣" : ("铷", ),  # 92A3 => 94F7
    "銥" : ("铱", ),  # 92A5 => 94F1
    "銦" : ("铟", ),  # 92A6 => 94DF
    "銨" : ("铵", ),  # 92A8 => 94F5
    "銩" : ("铥", ),  # 92A9 => 94E5
    "銪" : ("铕", ),  # 92AA => 94D5
    "銫" : ("铯", ),  # 92AB => 94EF
    "銬" : ("铐", ),  # 92AC => 94D0
    "銱" : ("铞", ),  # 92B1 => 94DE
    "銳" : ("锐", ),  # 92B3 => 9510
    "銷" : ("销", ),  # 92B7 => 9500
    "銹" : ("锈", ),  # 92B9 => 9508
    "銻" : ("锑", ),  # 92BB => 9511
    "銼" : ("锉", ),  # 92BC => 9509
    "鋁" : ("铝", ),  # 92C1 => 94DD
    "鋂" : ("镅", ),  # 92C2 => 9545
    "鋃" : ("锒", ),  # 92C3 => 9512
    "鋅" : ("锌", ),  # 92C5 => 950C
    "鋇" : ("钡", ),  # 92C7 => 94A1
    "鋌" : ("铤", ),  # 92CC => 94E4
    "鋏" : ("铗", ),  # 92CF => 94D7
    "鋒" : ("锋", ),  # 92D2 => 950B
    "鋝" : ("锊", ),  # 92DD => 950A
    "鋟" : ("锓", ),  # 92DF => 9513
    "鋣" : ("铘", ),  # 92E3 => 94D8
    "鋤" : ("锄", ),  # 92E4 => 9504
    "鋥" : ("锃", ),  # 92E5 => 9503
    "鋦" : ("锔", ),  # 92E6 => 9514
    "鋨" : ("锇", ),  # 92E8 => 9507
    "鋩" : ("铓", ),  # 92E9 => 94D3
    "鋪" : ("铺", ),  # 92EA => 94FA
    "鋭" : ("锐", ),  # 92ED => 9510
    "鋮" : ("铖", ),  # 92EE => 94D6
    "鋯" : ("锆", ),  # 92EF => 9506
    "鋰" : ("锂", ),  # 92F0 => 9502
    "鋱" : ("铽", ),  # 92F1 => 94FD
    "鋶" : ("锍", ),  # 92F6 => 950D
    "鋸" : ("锯", ),  # 92F8 => 952F
    "鋼" : ("钢", ),  # 92FC => 94A2
    "錁" : ("锞", ),  # 9301 => 951E
    "錄" : ("录", ),  # 9304 => 5F55
    "錆" : ("锖", ),  # 9306 => 9516
    "錇" : ("锫", ),  # 9307 => 952B
    "錈" : ("锩", ),  # 9308 => 9529
    "錐" : ("锥", ),  # 9310 => 9525
    "錒" : ("锕", ),  # 9312 => 9515
    "錕" : ("锟", ),  # 9315 => 951F
    "錘" : ("锤", ),  # 9318 => 9524
    "錙" : ("锱", ),  # 9319 => 9531
    "錚" : ("铮", ),  # 931A => 94EE
    "錛" : ("锛", ),  # 931B => 951B
    "錟" : ("锬", ),  # 931F => 952C
    "錠" : ("锭", ),  # 9320 => 952D
    "錢" : ("钱", ),  # 9322 => 94B1
    "錦" : ("锦", ),  # 9326 => 9526
    "錨" : ("锚", ),  # 9328 => 951A
    "錫" : ("锡", ),  # 932B => 9521
    "錮" : ("锢", ),  # 932E => 9522
    "錯" : ("错", ),  # 932F => 9519
    "録" : ("录", ),  # 9332 => 5F55
    "錳" : ("锰", ),  # 9333 => 9530
    "錶" : ("表", ),  # 9336 => 8868
    "錸" : ("铼", ),  # 9338 => 94FC
    "錼" : ("镎", ),  # 933C => 954E
    "鍀" : ("锝", ),  # 9340 => 951D
    "鍁" : ("锨", ),  # 9341 => 9528
    "鍃" : ("锪", ),  # 9343 => 952A
    "鍆" : ("钔", ),  # 9346 => 9494
    "鍇" : ("锴", ),  # 9347 => 9534
    "鍋" : ("锅", ),  # 934B => 9505
    "鍍" : ("镀", ),  # 934D => 9540
    "鍔" : ("锷", ),  # 9354 => 9537
    "鍘" : ("铡", ),  # 9358 => 94E1
    "鍚" : ("钖", ),  # 935A => 9496
    "鍛" : ("锻", ),  # 935B => 953B
    "鍤" : ("锸", ),  # 9364 => 9538
    "鍥" : ("锲", ),  # 9365 => 9532
    "鍩" : ("锘", ),  # 9369 => 9518
    "鍬" : ("锹", ),  # 936C => 9539
    "鍰" : ("锾", ),  # 9370 => 953E
    "鍵" : ("键", ),  # 9375 => 952E
    "鍶" : ("锶", ),  # 9376 => 9536
    "鍺" : ("锗", ),  # 937A => 9517
    "鍾" : ("锺", ),  # 937E => 953A
    "鎂" : ("镁", ),  # 9382 => 9541
    "鎄" : ("锿", ),  # 9384 => 953F
    "鎇" : ("镅", ),  # 9387 => 9545
    "鎊" : ("镑", ),  # 938A => 9551
    "鎖" : ("锁", ),  # 9396 => 9501
    "鎘" : ("镉", ),  # 9398 => 9549
    "鎡" : ("镃", ),  # 93A1 => 9543
    "鎢" : ("钨", ),  # 93A2 => 94A8
    "鎣" : ("蓥", ),  # 93A3 => 84E5
    "鎦" : ("镏", ),  # 93A6 => 954F
    "鎧" : ("铠", ),  # 93A7 => 94E0
    "鎩" : ("铩", ),  # 93A9 => 94E9
    "鎪" : ("锼", ),  # 93AA => 953C
    "鎬" : ("镐", ),  # 93AC => 9550
    "鎮" : ("镇", ),  # 93AE => 9547
    "鎰" : ("镒", ),  # 93B0 => 9552
    "鎳" : ("镍", ),  # 93B3 => 954D
    "鎵" : ("镓", ),  # 93B5 => 9553
    "鎸" : ("镌", ),  # 93B8 => 954C
    "鎿" : ("镎", ),  # 93BF => 954E
    "鏃" : ("镞", ),  # 93C3 => 955E
    "鏇" : ("旋", "镟"),  # 93C7 => 65CB 955F
    "鏈" : ("链", ),  # 93C8 => 94FE
    "鏌" : ("镆", ),  # 93CC => 9546
    "鏍" : ("镙", ),  # 93CD => 9559
    "鏑" : ("镝", ),  # 93D1 => 955D
    "鏗" : ("铿", ),  # 93D7 => 94FF
    "鏘" : ("锵", ),  # 93D8 => 9535
    "鏜" : ("镗", ),  # 93DC => 9557
    "鏝" : ("镘", ),  # 93DD => 9558
    "鏞" : ("镛", ),  # 93DE => 955B
    "鏟" : ("铲", ),  # 93DF => 94F2
    "鏡" : ("镜", ),  # 93E1 => 955C
    "鏢" : ("镖", ),  # 93E2 => 9556
    "鏤" : ("镂", ),  # 93E4 => 9542
    "鏨" : ("錾", ),  # 93E8 => 933E
    "鏰" : ("镚", ),  # 93F0 => 955A
    "鏵" : ("铧", ),  # 93F5 => 94E7
    "鏷" : ("镤", ),  # 93F7 => 9564
    "鏹" : ("镪", ),  # 93F9 => 956A
    "鏺" : ("䥽", ),  # 93FA => 497D
    "鏽" : ("锈", ),  # 93FD => 9508
    "鐃" : ("铙", ),  # 9403 => 94D9
    "鐋" : ("铴", ),  # 940B => 94F4
    "鐐" : ("镣", ),  # 9410 => 9563
    "鐒" : ("铹", ),  # 9412 => 94F9
    "鐓" : ("镦", ),  # 9413 => 9566
    "鐔" : ("镡", ),  # 9414 => 9561
    "鐘" : ("钟", ),  # 9418 => 949F
    "鐙" : ("镫", ),  # 9419 => 956B
    "鐝" : ("镢", ),  # 941D => 9562
    "鐠" : ("镨", ),  # 9420 => 9568
    "鐥" : ("䦅", ),  # 9425 => 4985
    "鐦" : ("锎", ),  # 9426 => 950E
    "鐧" : ("锏", ),  # 9427 => 950F
    "鐨" : ("镄", ),  # 9428 => 9544
    "鐫" : ("镌", ),  # 942B => 954C
    "鐮" : ("镰", ),  # 942E => 9570
    "鐯" : ("䦃", ),  # 942F => 4983
    "鐲" : ("镯", ),  # 9432 => 956F
    "鐳" : ("镭", ),  # 9433 => 956D
    "鐵" : ("铁", ),  # 9435 => 94C1
    "鐶" : ("镮", ),  # 9436 => 956E
    "鐸" : ("铎", ),  # 9438 => 94CE
    "鐺" : ("铛", ),  # 943A => 94DB
    "鐿" : ("镱", ),  # 943F => 9571
    "鑄" : ("铸", ),  # 9444 => 94F8
    "鑊" : ("镬", ),  # 944A => 956C
    "鑌" : ("镔", ),  # 944C => 9554
    "鑒" : ("鉴", ),  # 9452 => 9274
    "鑔" : ("镲", ),  # 9454 => 9572
    "鑕" : ("锧", ),  # 9455 => 9527
    "鑞" : ("镴", ),  # 945E => 9574
    "鑠" : ("铄", ),  # 9460 => 94C4
    "鑣" : ("镳", ),  # 9463 => 9573
    "鑥" : ("镥", ),  # 9465 => 9565
    "鑭" : ("镧", ),  # 946D => 9567
    "鑰" : ("钥", ),  # 9470 => 94A5
    "鑲" : ("镶", ),  # 9472 => 9576
    "鑷" : ("镊", ),  # 9477 => 954A
    "鑹" : ("镩", ),  # 9479 => 9569
    "鑼" : ("锣", ),  # 947C => 9523
    "鑽" : ("钻", ),  # 947D => 94BB
    "鑾" : ("銮", ),  # 947E => 92AE
    "鑿" : ("凿", ),  # 947F => 51FF
    "钁" : ("䦆", "镢"),  # 9481 => 4986 9562
    "钂" : ("镋", ),  # 9482 => 954B
    "镟" : ("碹", ),  # 955F => 78B9
    "長" : ("长", ),  # 9577 => 957F
    "門" : ("门", ),  # 9580 => 95E8
    "閂" : ("闩", ),  # 9582 => 95E9
    "閃" : ("闪", ),  # 9583 => 95EA
    "閆" : ("闫", ),  # 9586 => 95EB
    "閉" : ("闭", ),  # 9589 => 95ED
    "開" : ("开", ),  # 958B => 5F00
    "閌" : ("闶", ),  # 958C => 95F6
    "閎" : ("闳", ),  # 958E => 95F3
    "閏" : ("闰", ),  # 958F => 95F0
    "閑" : ("闲", ),  # 9591 => 95F2
    "間" : ("间", ),  # 9593 => 95F4
    "閔" : ("闵", ),  # 9594 => 95F5
    "閘" : ("闸", ),  # 9598 => 95F8
    "閙" : ("闹", ),  # 9599 => 95F9
    "閡" : ("阂", ),  # 95A1 => 9602
    "閣" : ("阁", ),  # 95A3 => 9601
    "閤" : ("合", ),  # 95A4 => 5408
    "閥" : ("阀", ),  # 95A5 => 9600
    "閨" : ("闺", ),  # 95A8 => 95FA
    "閩" : ("闽", ),  # 95A9 => 95FD
    "閫" : ("阃", ),  # 95AB => 9603
    "閬" : ("阆", ),  # 95AC => 9606
    "閭" : ("闾", ),  # 95AD => 95FE
    "閱" : ("阅", ),  # 95B1 => 9605
    "閲" : ("阅", ),  # 95B2 => 9605
    "閶" : ("阊", ),  # 95B6 => 960A
    "閹" : ("阉", ),  # 95B9 => 9609
    "閻" : ("阎", ),  # 95BB => 960E
    "閼" : ("阏", ),  # 95BC => 960F
    "閽" : ("阍", ),  # 95BD => 960D
    "閾" : ("阈", ),  # 95BE => 9608
    "閿" : ("阌", ),  # 95BF => 960C
    "闃" : ("阒", ),  # 95C3 => 9612
    "闆" : ("板", ),  # 95C6 => 677F
    "闈" : ("闱", ),  # 95C8 => 95F1
    "闊" : ("阔", ),  # 95CA => 9614
    "闋" : ("阕", ),  # 95CB => 9615
    "闌" : ("阑", ),  # 95CC => 9611
    "闐" : ("阗", ),  # 95D0 => 9617
    "闓" : ("闿", ),  # 95D3 => 95FF
    "闔" : ("阖", ),  # 95D4 => 9616
    "闕" : ("阙", ),  # 95D5 => 9619
    "闖" : ("闯", ),  # 95D6 => 95EF
    "關" : ("关", ),  # 95DC => 5173
    "闞" : ("阚", ),  # 95DE => 961A
    "闡" : ("阐", ),  # 95E1 => 9610
    "闢" : ("辟", ),  # 95E2 => 8F9F
    "闥" : ("闼", ),  # 95E5 => 95FC
    "阪" : ("坂", ),  # 962A => 5742
    "陘" : ("陉", ),  # 9658 => 9649
    "陝" : ("陕", ),  # 965D => 9655
    "陣" : ("阵", ),  # 9663 => 9635
    "陰" : ("阴", ),  # 9670 => 9634
    "陳" : ("陈", ),  # 9673 => 9648
    "陸" : ("陆", ),  # 9678 => 9646
    "陽" : ("阳", ),  # 967D => 9633
    "隉" : ("陧", ),  # 9689 => 9667
    "隊" : ("队", ),  # 968A => 961F
    "階" : ("阶", ),  # 968E => 9636
    "隕" : ("陨", ),  # 9695 => 9668
    "際" : ("际", ),  # 969B => 9645
    "隨" : ("随", ),  # 96A8 => 968F
    "險" : ("险", ),  # 96AA => 9669
    "隱" : ("隐", ),  # 96B1 => 9690
    "隴" : ("陇", ),  # 96B4 => 9647
    "隷" : ("隶", ),  # 96B7 => 96B6
    "隸" : ("隶", ),  # 96B8 => 96B6
    "隻" : ("只", ),  # 96BB => 53EA
    "雋" : ("隽", ),  # 96CB => 96BD
    "雖" : ("虽", ),  # 96D6 => 867D
    "雙" : ("双", ),  # 96D9 => 53CC
    "雛" : ("雏", ),  # 96DB => 96CF
    "雜" : ("杂", ),  # 96DC => 6742
    "雞" : ("鸡", ),  # 96DE => 9E21
    "離" : ("离", ),  # 96E2 => 79BB
    "難" : ("难", ),  # 96E3 => 96BE
    "雲" : ("云", ),  # 96F2 => 4E91
    "電" : ("电", ),  # 96FB => 7535
    "霧" : ("雾", ),  # 9727 => 96FE
    "霽" : ("霁", ),  # 973D => 9701
    "靂" : ("雳", ),  # 9742 => 96F3
    "靄" : ("霭", ),  # 9744 => 972D
    "靆" : ("叇", ),  # 9746 => 53C7
    "靈" : ("灵", ),  # 9748 => 7075
    "靉" : ("叆", ),  # 9749 => 53C6
    "靚" : ("靓", ),  # 975A => 9753
    "靜" : ("静", ),  # 975C => 9759
    "靦" : ("腼", ),  # 9766 => 817C
    "靨" : ("靥", ),  # 9768 => 9765
    "鞀" : ("鼗", ),  # 9780 => 9F17
    "鞏" : ("巩", ),  # 978F => 5DE9
    "鞦" : ("秋", ),  # 97A6 => 79CB
    "鞽" : ("鞒", ),  # 97BD => 9792
    "韁" : ("缰", ),  # 97C1 => 7F30
    "韃" : ("鞑", ),  # 97C3 => 9791
    "韆" : ("千", ),  # 97C6 => 5343
    "韉" : ("鞯", ),  # 97C9 => 97AF
    "韋" : ("韦", ),  # 97CB => 97E6
    "韌" : ("韧", ),  # 97CC => 97E7
    "韍" : ("韨", ),  # 97CD => 97E8
    "韓" : ("韩", ),  # 97D3 => 97E9
    "韙" : ("韪", ),  # 97D9 => 97EA
    "韜" : ("韬", ),  # 97DC => 97EC
    "韝" : ("鞴", ),  # 97DD => 97B4
    "韞" : ("韫", ),  # 97DE => 97EB
    "韻" : ("韵", ),  # 97FB => 97F5
    "響" : ("响", ),  # 97FF => 54CD
    "頁" : ("页", ),  # 9801 => 9875
    "頂" : ("顶", ),  # 9802 => 9876
    "頃" : ("顷", ),  # 9803 => 9877
    "項" : ("项", ),  # 9805 => 9879
    "順" : ("顺", ),  # 9806 => 987A
    "頇" : ("顸", ),  # 9807 => 9878
    "須" : ("须", ),  # 9808 => 987B
    "頊" : ("顼", ),  # 980A => 987C
    "頌" : ("颂", ),  # 980C => 9882
    "頎" : ("颀", ),  # 980E => 9880
    "頏" : ("颃", ),  # 980F => 9883
    "預" : ("预", ),  # 9810 => 9884
    "頑" : ("顽", ),  # 9811 => 987D
    "頒" : ("颁", ),  # 9812 => 9881
    "頓" : ("顿", ),  # 9813 => 987F
    "頗" : ("颇", ),  # 9817 => 9887
    "領" : ("领", ),  # 9818 => 9886
    "頜" : ("颌", ),  # 981C => 988C
    "頡" : ("颉", ),  # 9821 => 9889
    "頤" : ("颐", ),  # 9824 => 9890
    "頦" : ("颏", ),  # 9826 => 988F
    "頭" : ("头", ),  # 982D => 5934
    "頰" : ("颊", ),  # 9830 => 988A
    "頲" : ("颋", ),  # 9832 => 988B
    "頷" : ("颔", ),  # 9837 => 9894
    "頸" : ("颈", ),  # 9838 => 9888
    "頹" : ("颓", ),  # 9839 => 9893
    "頻" : ("频", ),  # 983B => 9891
    "頽" : ("颓", ),  # 983D => 9893
    "顆" : ("颗", ),  # 9846 => 9897
    "題" : ("题", ),  # 984C => 9898
    "額" : ("额", ),  # 984D => 989D
    "顎" : ("颚", ),  # 984E => 989A
    "顏" : ("颜", ),  # 984F => 989C
    "顒" : ("颙", ),  # 9852 => 9899
    "顓" : ("颛", ),  # 9853 => 989B
    "顔" : ("颜", ),  # 9854 => 989C
    "願" : ("愿", ),  # 9858 => 613F
    "顙" : ("颡", ),  # 9859 => 98A1
    "顛" : ("颠", ),  # 985B => 98A0
    "類" : ("类", ),  # 985E => 7C7B
    "顢" : ("颟", ),  # 9862 => 989F
    "顥" : ("颢", ),  # 9865 => 98A2
    "顧" : ("顾", ),  # 9867 => 987E
    "顫" : ("颤", ),  # 986B => 98A4
    "顬" : ("颥", ),  # 986C => 98A5
    "顯" : ("显", ),  # 986F => 663E
    "顰" : ("颦", ),  # 9870 => 98A6
    "顱" : ("颅", ),  # 9871 => 9885
    "顳" : ("颞", ),  # 9873 => 989E
    "顴" : ("颧", ),  # 9874 => 98A7
    "風" : ("风", ),  # 98A8 => 98CE
    "颮" : ("飑", ),  # 98AE => 98D1
    "颯" : ("飒", ),  # 98AF => 98D2
    "颱" : ("台", ),  # 98B1 => 53F0
    "颳" : ("刮", ),  # 98B3 => 522E
    "颶" : ("飓", ),  # 98B6 => 98D3
    "颸" : ("飔", ),  # 98B8 => 98D4
    "颼" : ("飕", ),  # 98BC => 98D5
    "飀" : ("飗", ),  # 98C0 => 98D7
    "飄" : ("飘", ),  # 98C4 => 98D8
    "飆" : ("飙", "飚"),  # 98C6 => 98D9 98DA
    "飛" : ("飞", ),  # 98DB => 98DE
    "飥" : ("饦", ),  # 98E5 => 9966
    "飩" : ("饨", ),  # 98E9 => 9968
    "飪" : ("饪", ),  # 98EA => 996A
    "飫" : ("饫", ),  # 98EB => 996B
    "飭" : ("饬", ),  # 98ED => 996C
    "飯" : ("饭", ),  # 98EF => 996D
    "飲" : ("饮", ),  # 98F2 => 996E
    "飴" : ("饴", ),  # 98F4 => 9974
    "飼" : ("饲", ),  # 98FC => 9972
    "飽" : ("饱", ),  # 98FD => 9971
    "飾" : ("饰", ),  # 98FE => 9970
    "飿" : ("饳", ),  # 98FF => 9973
    "餃" : ("饺", ),  # 9903 => 997A
    "餄" : ("饸", ),  # 9904 => 9978
    "餅" : ("饼", ),  # 9905 => 997C
    "餉" : ("饷", ),  # 9909 => 9977
    "養" : ("养", ),  # 990A => 517B
    "餌" : ("饵", ),  # 990C => 9975
    "餎" : ("饹", ),  # 990E => 9979
    "餏" : ("饻", ),  # 990F => 997B
    "餑" : ("饽", ),  # 9911 => 997D
    "餒" : ("馁", ),  # 9912 => 9981
    "餓" : ("饿", ),  # 9913 => 997F
    "餘" : ("余", "馀"),  # 9918 => 4F59 9980
    "餛" : ("馄", ),  # 991B => 9984
    "餜" : ("馃", ),  # 991C => 9983
    "餞" : ("饯", ),  # 991E => 996F
    "餠" : ("饼", ),  # 9920 => 997C
    "餡" : ("馅", ),  # 9921 => 9985
    "館" : ("馆", ),  # 9928 => 9986
    "餱" : ("糇", ),  # 9931 => 7CC7
    "餳" : ("饧", ),  # 9933 => 9967
    "餶" : ("馉", ),  # 9936 => 9989
    "餷" : ("馇", ),  # 9937 => 9987
    "餺" : ("馎", ),  # 993A => 998E
    "餼" : ("饩", ),  # 993C => 9969
    "餾" : ("馏", ),  # 993E => 998F
    "餿" : ("馊", ),  # 993F => 998A
    "饃" : ("馍", ),  # 9943 => 998D
    "饅" : ("馒", ),  # 9945 => 9992
    "饈" : ("馐", ),  # 9948 => 9990
    "饉" : ("馑", ),  # 9949 => 9991
    "饊" : ("馓", ),  # 994A => 9993
    "饋" : ("馈", ),  # 994B => 9988
    "饌" : ("馔", ),  # 994C => 9994
    "饑" : ("饥", ),  # 9951 => 9965
    "饒" : ("饶", ),  # 9952 => 9976
    "饗" : ("飨", ),  # 9957 => 98E8
    "饜" : ("餍", ),  # 995C => 990D
    "饞" : ("馋", ),  # 995E => 998B
    "饟" : ("馕", ),  # 995F => 9995
    "饢" : ("馕", ),  # 9962 => 9995
    "馬" : ("马", ),  # 99AC => 9A6C
    "馭" : ("驭", ),  # 99AD => 9A6D
    "馮" : ("冯", ),  # 99AE => 51AF
    "馱" : ("驮", ),  # 99B1 => 9A6E
    "馳" : ("驰", ),  # 99B3 => 9A70
    "馴" : ("驯", ),  # 99B4 => 9A6F
    "駁" : ("驳", ),  # 99C1 => 9A73
    "駐" : ("驻", ),  # 99D0 => 9A7B
    "駑" : ("驽", ),  # 99D1 => 9A7D
    "駒" : ("驹", ),  # 99D2 => 9A79
    "駔" : ("驵", ),  # 99D4 => 9A75
    "駕" : ("驾", ),  # 99D5 => 9A7E
    "駘" : ("骀", ),  # 99D8 => 9A80
    "駙" : ("驸", ),  # 99D9 => 9A78
    "駛" : ("驶", ),  # 99DB => 9A76
    "駝" : ("驼", ),  # 99DD => 9A7C
    "駟" : ("驷", ),  # 99DF => 9A77
    "駡" : ("骂", ),  # 99E1 => 9A82
    "駢" : ("骈", ),  # 99E2 => 9A88
    "駭" : ("骇", ),  # 99ED => 9A87
    "駱" : ("骆", ),  # 99F1 => 9A86
    "駸" : ("骎", ),  # 99F8 => 9A8E
    "駿" : ("骏", ),  # 99FF => 9A8F
    "騁" : ("骋", ),  # 9A01 => 9A8B
    "騅" : ("骓", ),  # 9A05 => 9A93
    "騍" : ("骒", ),  # 9A0D => 9A92
    "騎" : ("骑", ),  # 9A0E => 9A91
    "騏" : ("骐", ),  # 9A0F => 9A90
    "騖" : ("骛", ),  # 9A16 => 9A9B
    "騙" : ("骗", ),  # 9A19 => 9A97
    "騫" : ("骞", ),  # 9A2B => 9A9E
    "騭" : ("骘", ),  # 9A2D => 9A98
    "騮" : ("骝", ),  # 9A2E => 9A9D
    "騰" : ("腾", ),  # 9A30 => 817E
    "騶" : ("驺", ),  # 9A36 => 9A7A
    "騷" : ("骚", ),  # 9A37 => 9A9A
    "騸" : ("骟", ),  # 9A38 => 9A9F
    "騾" : ("骡", ),  # 9A3E => 9AA1
    "驀" : ("蓦", ),  # 9A40 => 84E6
    "驁" : ("骜", ),  # 9A41 => 9A9C
    "驂" : ("骖", ),  # 9A42 => 9A96
    "驃" : ("骠", ),  # 9A43 => 9AA0
    "驄" : ("骢", ),  # 9A44 => 9AA2
    "驅" : ("驱", ),  # 9A45 => 9A71
    "驊" : ("骅", ),  # 9A4A => 9A85
    "驍" : ("骁", ),  # 9A4D => 9A81
    "驏" : ("骣", ),  # 9A4F => 9AA3
    "驕" : ("骄", ),  # 9A55 => 9A84
    "驗" : ("验", ),  # 9A57 => 9A8C
    "驚" : ("惊", ),  # 9A5A => 60CA
    "驛" : ("驿", ),  # 9A5B => 9A7F
    "驟" : ("骤", ),  # 9A5F => 9AA4
    "驢" : ("驴", ),  # 9A62 => 9A74
    "驤" : ("骧", ),  # 9A64 => 9AA7
    "驥" : ("骥", ),  # 9A65 => 9AA5
    "驪" : ("骊", ),  # 9A6A => 9A8A
    "骯" : ("肮", ),  # 9AAF => 80AE
    "髏" : ("髅", ),  # 9ACF => 9AC5
    "髒" : ("脏", ),  # 9AD2 => 810F
    "體" : ("体", ),  # 9AD4 => 4F53
    "髕" : ("髌", ),  # 9AD5 => 9ACC
    "髖" : ("髋", ),  # 9AD6 => 9ACB
    "髮" : ("发", ),  # 9AEE => 53D1
    "鬁" : ("疬", ),  # 9B01 => 75AC
    "鬆" : ("松", ),  # 9B06 => 677E
    "鬍" : ("胡", ),  # 9B0D => 80E1
    "鬚" : ("须", ),  # 9B1A => 987B
    "鬢" : ("鬓", ),  # 9B22 => 9B13
    "鬥" : ("斗", ),  # 9B25 => 6597
    "鬧" : ("闹", ),  # 9B27 => 95F9
    "鬩" : ("阋", ),  # 9B29 => 960B
    "鬮" : ("阄", ),  # 9B2E => 9604
    "鬱" : ("郁", ),  # 9B31 => 90C1
    "魎" : ("魉", ),  # 9B4E => 9B49
    "魘" : ("魇", ),  # 9B58 => 9B47
    "魚" : ("鱼", ),  # 9B5A => 9C7C
    "魛" : ("鱽", ),  # 9B5B => 9C7D
    "魯" : ("鲁", ),  # 9B6F => 9C81
    "魴" : ("鲂", ),  # 9B74 => 9C82
    "魷" : ("鱿", ),  # 9B77 => 9C7F
    "鮁" : ("鲅", ),  # 9B81 => 9C85
    "鮃" : ("鲆", ),  # 9B83 => 9C86
    "鮍" : ("鲏", ),  # 9B8D => 9C8F
    "鮐" : ("鲐", ),  # 9B90 => 9C90
    "鮑" : ("鲍", ),  # 9B91 => 9C8D
    "鮒" : ("鲋", ),  # 9B92 => 9C8B
    "鮓" : ("鲊", ),  # 9B93 => 9C8A
    "鮚" : ("鲒", ),  # 9B9A => 9C92
    "鮞" : ("鲕", ),  # 9B9E => 9C95
    "鮣" : ("䲟", ),  # 9BA3 => 4C9F
    "鮦" : ("鲖", ),  # 9BA6 => 9C96
    "鮪" : ("鲔", ),  # 9BAA => 9C94
    "鮫" : ("鲛", ),  # 9BAB => 9C9B
    "鮭" : ("鲑", ),  # 9BAD => 9C91
    "鮮" : ("鲜", ),  # 9BAE => 9C9C
    "鮺" : ("鲝", ),  # 9BBA => 9C9D
    "鯀" : ("鲧", ),  # 9BC0 => 9CA7
    "鯁" : ("鲠", ),  # 9BC1 => 9CA0
    "鯇" : ("鲩", ),  # 9BC7 => 9CA9
    "鯉" : ("鲤", ),  # 9BC9 => 9CA4
    "鯊" : ("鲨", ),  # 9BCA => 9CA8
    "鯔" : ("鲻", ),  # 9BD4 => 9CBB
    "鯖" : ("鲭", ),  # 9BD6 => 9CAD
    "鯗" : ("鲞", ),  # 9BD7 => 9C9E
    "鯛" : ("鲷", ),  # 9BDB => 9CB7
    "鯝" : ("鲴", ),  # 9BDD => 9CB4
    "鯡" : ("鲱", ),  # 9BE1 => 9CB1
    "鯢" : ("鲵", ),  # 9BE2 => 9CB5
    "鯤" : ("鲲", ),  # 9BE4 => 9CB2
    "鯧" : ("鲳", ),  # 9BE7 => 9CB3
    "鯨" : ("鲸", ),  # 9BE8 => 9CB8
    "鯪" : ("鲮", ),  # 9BEA => 9CAE
    "鯫" : ("鲰", ),  # 9BEB => 9CB0
    "鯰" : ("鲇", "鲶"),  # 9BF0 => 9C87 9CB6
    "鯴" : ("鲺", ),  # 9BF4 => 9CBA
    "鯽" : ("鲫", ),  # 9BFD => 9CAB
    "鯿" : ("鳊", ),  # 9BFF => 9CCA
    "鰂" : ("鲗", ),  # 9C02 => 9C97
    "鰆" : ("䲠", ),  # 9C06 => 4CA0
    "鰈" : ("鲽", ),  # 9C08 => 9CBD
    "鰉" : ("鳇", ),  # 9C09 => 9CC7
    "鰌" : ("䲡", ),  # 9C0C => 4CA1
    "鰍" : ("鳅", ),  # 9C0D => 9CC5
    "鰐" : ("鳄", ),  # 9C10 => 9CC4
    "鰒" : ("鳆", ),  # 9C12 => 9CC6
    "鰓" : ("鳃", ),  # 9C13 => 9CC3
    "鰛" : ("鳁", ),  # 9C1B => 9CC1
    "鰜" : ("鳒", ),  # 9C1C => 9CD2
    "鰟" : ("鳑", ),  # 9C1F => 9CD1
    "鰠" : ("鳋", ),  # 9C20 => 9CCB
    "鰣" : ("鲥", ),  # 9C23 => 9CA5
    "鰥" : ("鳏", ),  # 9C25 => 9CCF
    "鰧" : ("䲢", ),  # 9C27 => 4CA2
    "鰨" : ("鳎", ),  # 9C28 => 9CCE
    "鰩" : ("鳐", ),  # 9C29 => 9CD0
    "鰭" : ("鳍", ),  # 9C2D => 9CCD
    "鰱" : ("鲢", ),  # 9C31 => 9CA2
    "鰲" : ("鳌", ),  # 9C32 => 9CCC
    "鰳" : ("鳓", ),  # 9C33 => 9CD3
    "鰵" : ("鳘", ),  # 9C35 => 9CD8
    "鰷" : ("鲦", ),  # 9C37 => 9CA6
    "鰹" : ("鲣", ),  # 9C39 => 9CA3
    "鰻" : ("鳗", ),  # 9C3B => 9CD7
    "鰼" : ("鳛", ),  # 9C3C => 9CDB
    "鰾" : ("鳔", ),  # 9C3E => 9CD4
    "鱅" : ("鳙", ),  # 9C45 => 9CD9
    "鱈" : ("鳕", ),  # 9C48 => 9CD5
    "鱉" : ("鳖", ),  # 9C49 => 9CD6
    "鱒" : ("鳟", ),  # 9C52 => 9CDF
    "鱔" : ("鳝", ),  # 9C54 => 9CDD
    "鱖" : ("鳜", ),  # 9C56 => 9CDC
    "鱗" : ("鳞", ),  # 9C57 => 9CDE
    "鱘" : ("鲟", ),  # 9C58 => 9C9F
    "鱝" : ("鲼", ),  # 9C5D => 9CBC
    "鱟" : ("鲎", ),  # 9C5F => 9C8E
    "鱠" : ("鲙", ),  # 9C60 => 9C99
    "鱣" : ("鳣", ),  # 9C63 => 9CE3
    "鱧" : ("鳢", ),  # 9C67 => 9CE2
    "鱨" : ("鲿", ),  # 9C68 => 9CBF
    "鱭" : ("鲚", ),  # 9C6D => 9C9A
    "鱷" : ("鳄", ),  # 9C77 => 9CC4
    "鱸" : ("鲈", ),  # 9C78 => 9C88
    "鱺" : ("鲡", ),  # 9C7A => 9CA1
    "鳥" : ("鸟", ),  # 9CE5 => 9E1F
    "鳧" : ("凫", ),  # 9CE7 => 51EB
    "鳩" : ("鸠", ),  # 9CE9 => 9E20
    "鳬" : ("凫", ),  # 9CEC => 51EB
    "鳳" : ("凤", ),  # 9CF3 => 51E4
    "鳴" : ("鸣", ),  # 9CF4 => 9E23
    "鳶" : ("鸢", ),  # 9CF6 => 9E22
    "鳾" : ("䴓", ),  # 9CFE => 4D13
    "鴆" : ("鸩", ),  # 9D06 => 9E29
    "鴇" : ("鸨", ),  # 9D07 => 9E28
    "鴉" : ("鸦", ),  # 9D09 => 9E26
    "鴒" : ("鸰", ),  # 9D12 => 9E30
    "鴕" : ("鸵", ),  # 9D15 => 9E35
    "鴛" : ("鸳", ),  # 9D1B => 9E33
    "鴝" : ("鸲", ),  # 9D1D => 9E32
    "鴞" : ("鸮", ),  # 9D1E => 9E2E
    "鴟" : ("鸱", ),  # 9D1F => 9E31
    "鴣" : ("鸪", ),  # 9D23 => 9E2A
    "鴦" : ("鸯", ),  # 9D26 => 9E2F
    "鴨" : ("鸭", ),  # 9D28 => 9E2D
    "鴯" : ("鸸", ),  # 9D2F => 9E38
    "鴰" : ("鸹", ),  # 9D30 => 9E39
    "鴴" : ("鸻", ),  # 9D34 => 9E3B
    "鴷" : ("䴕", ),  # 9D37 => 4D15
    "鴻" : ("鸿", ),  # 9D3B => 9E3F
    "鴿" : ("鸽", ),  # 9D3F => 9E3D
    "鵁" : ("䴔", ),  # 9D41 => 4D14
    "鵂" : ("鸺", ),  # 9D42 => 9E3A
    "鵃" : ("鸼", ),  # 9D43 => 9E3C
    "鵉" : ("鸾", ),  # 9D49 => 9E3E
    "鵑" : ("鹃", ),  # 9D51 => 9E43
    "鵒" : ("鹆", ),  # 9D52 => 9E46
    "鵓" : ("鹁", ),  # 9D53 => 9E41
    "鵜" : ("鹈", ),  # 9D5C => 9E48
    "鵝" : ("鹅", ),  # 9D5D => 9E45
    "鵠" : ("鹄", ),  # 9D60 => 9E44
    "鵡" : ("鹉", ),  # 9D61 => 9E49
    "鵪" : ("鹌", ),  # 9D6A => 9E4C
    "鵬" : ("鹏", ),  # 9D6C => 9E4F
    "鵮" : ("鹐", ),  # 9D6E => 9E50
    "鵯" : ("鹎", ),  # 9D6F => 9E4E
    "鵲" : ("鹊", ),  # 9D72 => 9E4A
    "鶄" : ("䴖", ),  # 9D84 => 4D16
    "鶇" : ("鸫", ),  # 9D87 => 9E2B
    "鶉" : ("鹑", ),  # 9D89 => 9E51
    "鶊" : ("鹒", ),  # 9D8A => 9E52
    "鶓" : ("鹋", ),  # 9D93 => 9E4B
    "鶖" : ("鹙", ),  # 9D96 => 9E59
    "鶘" : ("鹕", ),  # 9D98 => 9E55
    "鶚" : ("鹗", ),  # 9D9A => 9E57
    "鶡" : ("鹖", ),  # 9DA1 => 9E56
    "鶥" : ("鹛", ),  # 9DA5 => 9E5B
    "鶩" : ("鹜", ),  # 9DA9 => 9E5C
    "鶪" : ("䴗", ),  # 9DAA => 4D17
    "鶬" : ("鸧", ),  # 9DAC => 9E27
    "鶯" : ("莺", ),  # 9DAF => 83BA
    "鶴" : ("鹤", ),  # 9DB4 => 9E64
    "鶺" : ("鹡", ),  # 9DBA => 9E61
    "鶻" : ("鹘", ),  # 9DBB => 9E58
    "鶼" : ("鹣", ),  # 9DBC => 9E63
    "鶿" : ("鹚", ),  # 9DBF => 9E5A
    "鷀" : ("鹚", ),  # 9DC0 => 9E5A
    "鷂" : ("鹞", ),  # 9DC2 => 9E5E
    "鷄" : ("鸡", ),  # 9DC4 => 9E21
    "鷉" : ("䴘", ),  # 9DC9 => 4D18
    "鷓" : ("鹧", ),  # 9DD3 => 9E67
    "鷖" : ("鹥", ),  # 9DD6 => 9E65
    "鷗" : ("鸥", ),  # 9DD7 => 9E25
    "鷙" : ("鸷", ),  # 9DD9 => 9E37
    "鷚" : ("鹨", ),  # 9DDA => 9E68
    "鷥" : ("鸶", ),  # 9DE5 => 9E36
    "鷦" : ("鹪", ),  # 9DE6 => 9E6A
    "鷯" : ("鹩", ),  # 9DEF => 9E69
    "鷲" : ("鹫", ),  # 9DF2 => 9E6B
    "鷳" : ("鹇", ),  # 9DF3 => 9E47
    "鷸" : ("鹬", ),  # 9DF8 => 9E6C
    "鷹" : ("鹰", ),  # 9DF9 => 9E70
    "鷺" : ("鹭", ),  # 9DFA => 9E6D
    "鸇" : ("鹯", ),  # 9E07 => 9E6F
    "鸊" : ("䴙", ),  # 9E0A => 4D19
    "鸌" : ("鹱", ),  # 9E0C => 9E71
    "鸕" : ("鸬", ),  # 9E15 => 9E2C
    "鸚" : ("鹦", ),  # 9E1A => 9E66
    "鸛" : ("鹳", ),  # 9E1B => 9E73
    "鸝" : ("鹂", ),  # 9E1D => 9E42
    "鸞" : ("鸾", ),  # 9E1E => 9E3E
    "鹵" : ("卤", ),  # 9E75 => 5364
    "鹸" : ("硷", ),  # 9E78 => 7877
    "鹹" : ("咸", ),  # 9E79 => 54B8
    "鹺" : ("鹾", ),  # 9E7A => 9E7E
    "鹼" : ("硷", ),  # 9E7C => 7877
    "鹽" : ("盐", ),  # 9E7D => 76D0
    "麅" : ("狍", ),  # 9E85 => 72CD
    "麗" : ("丽", ),  # 9E97 => 4E3D
    "麥" : ("麦", ),  # 9EA5 => 9EA6
    "麩" : ("麸", ),  # 9EA9 => 9EB8
    "麯" : ("曲", ),  # 9EAF => 66F2
    "麵" : ("面", ),  # 9EB5 => 9762
    "麼" : ("么", ),  # 9EBC => 4E48
    "麽" : ("么", ),  # 9EBD => 4E48
    "黃" : ("黄", ),  # 9EC3 => 9EC4
    "黌" : ("黉", ),  # 9ECC => 9EC9
    "點" : ("点", ),  # 9EDE => 70B9
    "黨" : ("党", ),  # 9EE8 => 515A
    "黲" : ("黪", ),  # 9EF2 => 9EEA
    "黴" : ("霉", ),  # 9EF4 => 9709
    "黶" : ("黡", ),  # 9EF6 => 9EE1
    "黷" : ("黩", ),  # 9EF7 => 9EE9
    "黽" : ("黾", ),  # 9EFD => 9EFE
    "黿" : ("鼋", ),  # 9EFF => 9F0B
    "鼇" : ("鳌", ),  # 9F07 => 9CCC
    "鼉" : ("鼍", ),  # 9F09 => 9F0D
    "鼕" : ("冬", ),  # 9F15 => 51AC
    "鼴" : ("鼹", ),  # 9F34 => 9F39
    "齇" : ("齄", ),  # 9F47 => 9F44
    "齊" : ("齐", ),  # 9F4A => 9F50
    "齋" : ("斋", ),  # 9F4B => 658B
    "齎" : ("赍", ),  # 9F4E => 8D4D
    "齏" : ("齑", ),  # 9F4F => 9F51
    "齒" : ("齿", ),  # 9F52 => 9F7F
    "齔" : ("龀", ),  # 9F54 => 9F80
    "齙" : ("龅", ),  # 9F59 => 9F85
    "齜" : ("龇", ),  # 9F5C => 9F87
    "齟" : ("龃", ),  # 9F5F => 9F83
    "齠" : ("龆", ),  # 9F60 => 9F86
    "齡" : ("龄", ),  # 9F61 => 9F84
    "齣" : ("出", ),  # 9F63 => 51FA
    "齦" : ("龈", ),  # 9F66 => 9F88
    "齧" : ("啮", ),  # 9F67 => 556E
    "齪" : ("龊", ),  # 9F6A => 9F8A
    "齬" : ("龉", ),  # 9F6C => 9F89
    "齲" : ("龋", ),  # 9F72 => 9F8B
    "齶" : ("腭", ),  # 9F76 => 816D
    "齷" : ("龌", ),  # 9F77 => 9F8C
    "龍" : ("龙", ),  # 9F8D => 9F99
    "龐" : ("庞", ),  # 9F90 => 5E9E
    "龑" : ("䶮", ),  # 9F91 => 4DAE
    "龔" : ("龚", ),  # 9F94 => 9F9A
    "龕" : ("龛", ),  # 9F95 => 9F9B
    "龜" : ("龟", ),  # 9F9C => 9F9F
}
