/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_00 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 2000, "epsg", 2000,
        "Anguilla 1957 / British West Indies Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Anguilla_1957", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
        "_0=400000 +y_0=0 +ellps=clrk80 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Anguilla 1957 / British West Indies Grid\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Anguilla 1957\",DATUM[\"Anguilla_1957\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7012\"]],AUTHORITY[\"EPSG\",\"6600\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4600\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-62],PARAMETER[\"scale_factor\",0.9995],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",400000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"2000\"]]");
    p = add_epsg_def_ex (filter, first, last, 2001, "epsg", 2001,
        "Antigua 1943 / British West Indies Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Antigua_1943", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
        "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=-255,-15,71,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Antigua 1943 / British West Indies Grid\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Antigua 1943\",DATUM[\"Antigua_1943\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7012\"]],AUTHORITY[\"EPSG\",\"6601\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4601\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-62],PARAMETER[\"scale_factor\",0.9995],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",400000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"2001\"]]");
    p = add_epsg_def_ex (filter, first, last, 2002, "epsg", 2002,
        "Dominica 1945 / British West Indies Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Dominica_1945", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
        "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=725,685,536,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Dominica 1945 / British West Indies Grid\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Dominica 1945\",DATUM[\"Dominica_1945\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7012\"]],AUTHORITY[\"EPSG\",\"6602\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4602\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-62],PARAMETER[\"scale_factor\",0.9995],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",400000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"2002\"]]");
    p = add_epsg_def_ex (filter, first, last, 2003, "epsg", 2003,
        "Grenada 1953 / British West Indies Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Grenada_1953", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
        "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=72,213.7,93,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Grenada 1953 / British West Indies Grid\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Grenada 1953\",DATUM[\"Grenada_1953\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7012\"]],AUTHORITY[\"EPSG\",\"6603\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4603\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-62],PARAMETER[\"scale_factor\",0.9995],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",400000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"2003\"]]");
    p = add_epsg_def_ex (filter, first, last, 2004, "epsg", 2004,
        "Montserrat 1958 / British West Indies Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Montserrat_1958", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
        "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=174,359,365,0,0,");
    add_proj4text (p, 2,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Montserrat 1958 / British West Indies Grid\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"Montserrat 1958\",DATUM[\"Montserrat_1958\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6604\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4604\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-62],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "995],PARAMETER[\"false_easting\",400000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"2004\"]]");
    p = add_epsg_def_ex (filter, first, last, 2005, "epsg", 2005,
        "St. Kitts 1955 / British West Indies Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "St_Kitts_1955", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
        "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=9,183,236,0,0,0,");
    add_proj4text (p, 2,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"St. Kitts 1955 / British West Indies Grid\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"St. Kitts 1955\",DATUM[\"St_Kitts_1955\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6605\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4605\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-62],PARAMETER[\"scale_factor\",0.9995]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",400000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"2005\"]]");
    p = add_epsg_def_ex (filter, first, last, 2006, "epsg", 2006,
        "St. Lucia 1955 / British West Indies Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "St_Lucia_1955", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
        "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=-149,128,296,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"St. Lucia 1955 / British West Indies Grid\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"St. Lucia 1955\",DATUM[\"St_Lucia_1955\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6606\"]],PRIMEM[\"G");
    add_srs_wkt (p, 4,
        "reenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree");
    add_srs_wkt (p, 5,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTH");
    add_srs_wkt (p, 6,
        "ORITY[\"EPSG\",\"4606\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 7,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 8,
        "ntral_meridian\",-62],PARAMETER[\"scale_factor\",0.9995]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",400000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"2006\"]]");
    p = add_epsg_def_ex (filter, first, last, 2007, "epsg", 2007,
        "St. Vincent 45 / British West Indies Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "St_Vincent_1945", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
        "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=195.671,332.517,");
    add_proj4text (p, 2,
        "274.607,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"St. Vincent 45 / British West Indies Grid\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"St. Vincent 1945\",DATUM[\"St_Vincent_1945\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7012\"]],AUTHORITY[\"EPSG\",\"6607\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4607\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-62],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "995],PARAMETER[\"false_easting\",400000],PARAMETER[\"fal");
    add_srs_wkt (p, 10,
        "se_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 11,
        "001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],");
    add_srs_wkt (p, 12,
        "AUTHORITY[\"EPSG\",\"2007\"]]");
    p = add_epsg_def_ex (filter, first, last, 2008, "epsg", 2008,
        "NAD27(CGQ77) / SCoPQ zone 2 (deprecated)", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-55.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 2 (deprecated)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD27(CGQ77)\",DATUM[\"North_American_Datum_1927_CG");
    add_srs_wkt (p, 2,
        "Q77\",SPHEROID[\"Clarke 1866\",6378206.4,294.97869821389");
    add_srs_wkt (p, 3,
        "8,AUTHORITY[\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"660");
    add_srs_wkt (p, 4,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"T");
    add_srs_wkt (p, 7,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"central_meridian\",-55.5],PARAMETER[\"scal");
    add_srs_wkt (p, 9,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",304800],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"2008\"]]");
    p = add_epsg_def_ex (filter, first, last, 2009, "epsg", 2009,
        "NAD27(CGQ77) / SCoPQ zone 3", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-58.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 3\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
        "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-58.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "99],PARAMETER[\"false_easting\",304800],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"2009\"]]");
    p = add_epsg_def_ex (filter, first, last, 2010, "epsg", 2010,
        "NAD27(CGQ77) / SCoPQ zone 4", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-61.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 4\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
        "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-61.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "99],PARAMETER[\"false_easting\",304800],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"2010\"]]");
    p = add_epsg_def_ex (filter, first, last, 2011, "epsg", 2011,
        "NAD27(CGQ77) / SCoPQ zone 5", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-64.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 5\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
        "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-64.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "99],PARAMETER[\"false_easting\",304800],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"2011\"]]");
    p = add_epsg_def_ex (filter, first, last, 2012, "epsg", 2012,
        "NAD27(CGQ77) / SCoPQ zone 6", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-67.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 6\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
        "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-67.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "99],PARAMETER[\"false_easting\",304800],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"2012\"]]");
    p = add_epsg_def_ex (filter, first, last, 2013, "epsg", 2013,
        "NAD27(CGQ77) / SCoPQ zone 7", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-70.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 7\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
        "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-70.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "99],PARAMETER[\"false_easting\",304800],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"2013\"]]");
    p = add_epsg_def_ex (filter, first, last, 2014, "epsg", 2014,
        "NAD27(CGQ77) / SCoPQ zone 8", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 8\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
        "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-73.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "99],PARAMETER[\"false_easting\",304800],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"2014\"]]");
    p = add_epsg_def_ex (filter, first, last, 2015, "epsg", 2015,
        "NAD27(CGQ77) / SCoPQ zone 9", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 9\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
        "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-76.5],PARAMETER[\"scale_factor\",0.99");
    add_srs_wkt (p, 9,
        "99],PARAMETER[\"false_easting\",304800],PARAMETER[\"fals");
    add_srs_wkt (p, 10,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 11,
        "01\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],A");
    add_srs_wkt (p, 12,
        "UTHORITY[\"EPSG\",\"2015\"]]");
    p = add_epsg_def_ex (filter, first, last, 2016, "epsg", 2016,
        "NAD27(CGQ77) / SCoPQ zone 10", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / SCoPQ zone 10\",GEOGCS[\"NAD27(C");
    add_srs_wkt (p, 1,
        "GQ77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM");
    add_srs_wkt (p, 4,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 5,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Me");
    add_srs_wkt (p, 7,
        "rcator\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-79.5],PARAMETER[\"scale_factor\",0");
    add_srs_wkt (p, 9,
        ".9999],PARAMETER[\"false_easting\",304800],PARAMETER[\"f");
    add_srs_wkt (p, 10,
        "alse_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"2016\"]]");
    p = add_epsg_def_ex (filter, first, last, 2017, "epsg", 2017,
        "NAD27(76) / MTM zone 8", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-73.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / MTM zone 8\",GEOGCS[\"NAD27(76)\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clark");
    add_srs_wkt (p, 2,
        "e 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-73.5],PARAMETER[\"scale_factor\",0.9999],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",304800],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"2017\"]]");
    p = add_epsg_def_ex (filter, first, last, 2018, "epsg", 2018,
        "NAD27(76) / MTM zone 9", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-76.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / MTM zone 9\",GEOGCS[\"NAD27(76)\",D");
    add_srs_wkt (p, 1,
        "ATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clark");
    add_srs_wkt (p, 2,
        "e 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_me");
    add_srs_wkt (p, 8,
        "ridian\",-76.5],PARAMETER[\"scale_factor\",0.9999],PARAM");
    add_srs_wkt (p, 9,
        "ETER[\"false_easting\",304800],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"2018\"]]");
    p = add_epsg_def_ex (filter, first, last, 2019, "epsg", 2019,
        "NAD27(76) / MTM zone 10", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-79.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / MTM zone 10\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-79.5],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",304800],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"2019\"]]");
    p = add_epsg_def_ex (filter, first, last, 2020, "epsg", 2020,
        "NAD27(76) / MTM zone 11", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-82.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / MTM zone 11\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-82.5],PARAMETER[\"scale_factor\",0.9999],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_easting\",304800],PARAMETER[\"false_nort");
    add_srs_wkt (p, 10,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 11,
        ",AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORI");
    add_srs_wkt (p, 12,
        "TY[\"EPSG\",\"2020\"]]");
    p = add_epsg_def_ex (filter, first, last, 2021, "epsg", 2021,
        "NAD27(76) / MTM zone 12", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / MTM zone 12\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-81],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",304800],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"2021\"]]");
    p = add_epsg_def_ex (filter, first, last, 2022, "epsg", 2022,
        "NAD27(76) / MTM zone 13", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / MTM zone 13\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-84],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",304800],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"2022\"]]");
    p = add_epsg_def_ex (filter, first, last, 2023, "epsg", 2023,
        "NAD27(76) / MTM zone 14", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / MTM zone 14\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-87],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",304800],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"2023\"]]");
    p = add_epsg_def_ex (filter, first, last, 2024, "epsg", 2024,
        "NAD27(76) / MTM zone 15", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / MTM zone 15\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-90],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",304800],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"2024\"]]");
    p = add_epsg_def_ex (filter, first, last, 2025, "epsg", 2025,
        "NAD27(76) / MTM zone 16", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / MTM zone 16\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-93],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",304800],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"2025\"]]");
    p = add_epsg_def_ex (filter, first, last, 2026, "epsg", 2026,
        "NAD27(76) / MTM zone 17", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-96 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / MTM zone 17\",GEOGCS[\"NAD27(76)\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Clar");
    add_srs_wkt (p, 2,
        "ke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 3,
        "\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 4,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 5,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"]");
    add_srs_wkt (p, 7,
        ",PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central");
    add_srs_wkt (p, 8,
        "_meridian\",-96],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",304800],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"2026\"]]");
    p = add_epsg_def_ex (filter, first, last, 2027, "epsg", 2027,
        "NAD27(76) / UTM zone 15N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / UTM zone 15N\",GEOGCS[\"NAD27(76)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-93],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2027\"]]");
    p = add_epsg_def_ex (filter, first, last, 2028, "epsg", 2028,
        "NAD27(76) / UTM zone 16N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / UTM zone 16N\",GEOGCS[\"NAD27(76)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-87],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2028\"]]");
    p = add_epsg_def_ex (filter, first, last, 2029, "epsg", 2029,
        "NAD27(76) / UTM zone 17N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / UTM zone 17N\",GEOGCS[\"NAD27(76)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-81],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2029\"]]");
    p = add_epsg_def_ex (filter, first, last, 2030, "epsg", 2030,
        "NAD27(76) / UTM zone 18N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_1976", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(76) / UTM zone 18N\",GEOGCS[\"NAD27(76)\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927_1976\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7008\"]],AUTHORITY[\"EPSG\",\"6608\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4608\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-75],PARAMETER[\"scale_factor\",0.9996],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"false_easting\",500000],PARAMETER[\"false_north");
    add_srs_wkt (p, 10,
        "ing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],");
    add_srs_wkt (p, 11,
        "AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"2030\"]]");
    p = add_epsg_def_ex (filter, first, last, 2031, "epsg", 2031,
        "NAD27(CGQ77) / UTM zone 17N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=17 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / UTM zone 17N\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
        "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-81],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2031\"]]");
    p = add_epsg_def_ex (filter, first, last, 2032, "epsg", 2032,
        "NAD27(CGQ77) / UTM zone 18N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=18 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / UTM zone 18N\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
        "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-75],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2032\"]]");
    p = add_epsg_def_ex (filter, first, last, 2033, "epsg", 2033,
        "NAD27(CGQ77) / UTM zone 19N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / UTM zone 19N\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
        "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-69],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2033\"]]");
    p = add_epsg_def_ex (filter, first, last, 2034, "epsg", 2034,
        "NAD27(CGQ77) / UTM zone 20N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / UTM zone 20N\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
        "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-63],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2034\"]]");
    p = add_epsg_def_ex (filter, first, last, 2035, "epsg", 2035,
        "NAD27(CGQ77) / UTM zone 21N", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927_CGQ77", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=21 +ellps=clrk66 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27(CGQ77) / UTM zone 21N\",GEOGCS[\"NAD27(CG");
    add_srs_wkt (p, 1,
        "Q77)\",DATUM[\"North_American_Datum_1927_CGQ77\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866\",6378206.4,294.978698213898,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7008\"]],AUTHORITY[\"EPSG\",\"6609\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4609\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-57],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2035\"]]");
    p = add_epsg_def_ex (filter, first, last, 2036, "epsg", 2036,
        "NAD83(CSRS98) / New Brunswick Stereo (deprecated)", 0, 1,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Oblique_Stereographic", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=sterea +lat_0=46.5 +lon_0=-66.5 +k=0.999912 +x_0=2");
    add_proj4text (p, 1,
        "500000 +y_0=7500000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / New Brunswick Stereo (deprecate");
    add_srs_wkt (p, 1,
        "d)\",GEOGCS[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83");
    add_srs_wkt (p, 2,
        "_Canadian_Spatial_Reference_System\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree minute second he");
    add_srs_wkt (p, 6,
        "misphere\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"");
    add_srs_wkt (p, 7,
        "]],AUTHORITY[\"EPSG\",\"4140\"]],PROJECTION[\"Oblique_St");
    add_srs_wkt (p, 8,
        "ereographic\"],PARAMETER[\"latitude_of_origin\",46.5],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",-66.5],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.999912],PARAMETER[\"false_easting\",2500000],PA");
    add_srs_wkt (p, 11,
        "RAMETER[\"false_northing\",7500000],UNIT[\"metre\",1,AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS");
    add_srs_wkt (p, 13,
        "[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2036\"]]");
    p = add_epsg_def_ex (filter, first, last, 2037, "epsg", 2037,
        "NAD83(CSRS98) / UTM zone 19N (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / UTM zone 19N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadia");
    add_srs_wkt (p, 2,
        "n_Spatial_Reference_System\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree minute second hemisphere");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-69],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2037\"]]");
    p = add_epsg_def_ex (filter, first, last, 2038, "epsg", 2038,
        "NAD83(CSRS98) / UTM zone 20N (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS98) / UTM zone 20N (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD83(CSRS98) (deprecated)\",DATUM[\"NAD83_Canadia");
    add_srs_wkt (p, 2,
        "n_Spatial_Reference_System\",SPHEROID[\"GRS 1980\",63781");
    add_srs_wkt (p, 3,
        "37,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree minute second hemisphere");
    add_srs_wkt (p, 6,
        "\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9108\"]],AUTH");
    add_srs_wkt (p, 7,
        "ORITY[\"EPSG\",\"4140\"]],PROJECTION[\"Transverse_Mercat");
    add_srs_wkt (p, 8,
        "or\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"ce");
    add_srs_wkt (p, 9,
        "ntral_meridian\",-63],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 10,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 11,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 12,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"2038\"]]");
    p = add_epsg_def_ex (filter, first, last, 2039, "epsg", 2039,
        "Israel 1993 / Israeli TM Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Israel_1993", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=31.73439361111111 +lon_0=35.204516944");
    add_proj4text (p, 1,
        "44445 +k=1.0000067 +x_0=219529.584 +y_0=626907.39 +ellps");
    add_proj4text (p, 2,
        "=GRS80 +towgs84=-48,55,52,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Israel 1993 / Israeli TM Grid\",GEOGCS[\"Israel");
    add_srs_wkt (p, 1,
        " 1993\",DATUM[\"Israel_1993\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 2,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],AUTHORIT");
    add_srs_wkt (p, 3,
        "Y[\"EPSG\",\"6141\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4141\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",31.7343936111111],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",35.2045169444444],PARAMETER[\"scale_factor\",1.00");
    add_srs_wkt (p, 9,
        "00067],PARAMETER[\"false_easting\",219529.584],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"false_northing\",626907.39],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 11,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 12,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"2039\"]]");
    p = add_epsg_def_ex (filter, first, last, 2040, "epsg", 2040,
        "Locodjo 1965 / UTM zone 30N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Locodjo_1965", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=clrk80 +towgs84=-125,53,467,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Locodjo 1965 / UTM zone 30N\",GEOGCS[\"Locodjo ");
    add_srs_wkt (p, 1,
        "1965\",DATUM[\"Locodjo_1965\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6142\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4142\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"204");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 2041, "epsg", 2041,
        "Abidjan 1987 / UTM zone 30N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Abidjan_1987", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=30 +ellps=clrk80 +towgs84=-124.76,53,466");
    add_proj4text (p, 1,
        ".79,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Abidjan 1987 / UTM zone 30N\",GEOGCS[\"Abidjan ");
    add_srs_wkt (p, 1,
        "1987\",DATUM[\"Abidjan_1987\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6143\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4143\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"204");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 2042, "epsg", 2042,
        "Locodjo 1965 / UTM zone 29N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Locodjo_1965", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=clrk80 +towgs84=-125,53,467,0,");
    add_proj4text (p, 1,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Locodjo 1965 / UTM zone 29N\",GEOGCS[\"Locodjo ");
    add_srs_wkt (p, 1,
        "1965\",DATUM[\"Locodjo_1965\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6142\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4142\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"204");
    add_srs_wkt (p, 12,
        "2\"]]");
    p = add_epsg_def_ex (filter, first, last, 2043, "epsg", 2043,
        "Abidjan 1987 / UTM zone 29N", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Abidjan_1987", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +ellps=clrk80 +towgs84=-124.76,53,466");
    add_proj4text (p, 1,
        ".79,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Abidjan 1987 / UTM zone 29N\",GEOGCS[\"Abidjan ");
    add_srs_wkt (p, 1,
        "1987\",DATUM[\"Abidjan_1987\",SPHEROID[\"Clarke 1880 (RG");
    add_srs_wkt (p, 2,
        "S)\",6378249.145,293.465,AUTHORITY[\"EPSG\",\"7012\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6143\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4143\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",-");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"204");
    add_srs_wkt (p, 12,
        "3\"]]");
    p = add_epsg_def_ex (filter, first, last, 2044, "epsg", 2044,
        "Hanoi 1972 / Gauss-Kruger zone 18", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Hanoi_1972", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=18500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hanoi 1972 / Gauss-Kruger zone 18\",GEOGCS[\"Ha");
    add_srs_wkt (p, 1,
        "noi 1972\",DATUM[\"Hanoi_1972\",SPHEROID[\"Krassowsky 19");
    add_srs_wkt (p, 2,
        "40\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6147\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4147\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",105],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",18500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2044\"]]");
    p = add_epsg_def_ex (filter, first, last, 2045, "epsg", 2045,
        "Hanoi 1972 / Gauss-Kruger zone 19", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Hanoi_1972", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=19500000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +u");
    add_proj4text (p, 2,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hanoi 1972 / Gauss-Kruger zone 19\",GEOGCS[\"Ha");
    add_srs_wkt (p, 1,
        "noi 1972\",DATUM[\"Hanoi_1972\",SPHEROID[\"Krassowsky 19");
    add_srs_wkt (p, 2,
        "40\",6378245,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6147\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4147\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",111],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",19500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2045\"]]");
    p = add_epsg_def_ex (filter, first, last, 2046, "epsg", 2046,
        "Hartebeesthoek94 / Lo15", 0, 0,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hartebeesthoek94 / Lo15\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
        "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
        "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6148\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4148\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator_South_Orientated\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",15],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Westing");
    add_srs_wkt (p, 11,
        "\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "046\"]]");
    p = add_epsg_def_ex (filter, first, last, 2047, "epsg", 2047,
        "Hartebeesthoek94 / Lo17", 0, 0,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hartebeesthoek94 / Lo17\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
        "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
        "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6148\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4148\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator_South_Orientated\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",17],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Westing");
    add_srs_wkt (p, 11,
        "\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "047\"]]");
    p = add_epsg_def_ex (filter, first, last, 2048, "epsg", 2048,
        "Hartebeesthoek94 / Lo19", 0, 0,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hartebeesthoek94 / Lo19\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
        "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
        "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6148\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4148\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator_South_Orientated\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",19],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Westing");
    add_srs_wkt (p, 11,
        "\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "048\"]]");
    p = add_epsg_def_ex (filter, first, last, 2049, "epsg", 2049,
        "Hartebeesthoek94 / Lo21", 0, 0,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hartebeesthoek94 / Lo21\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
        "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
        "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6148\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4148\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator_South_Orientated\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",21],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Westing");
    add_srs_wkt (p, 11,
        "\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "049\"]]");
    p = add_epsg_def_ex (filter, first, last, 2050, "epsg", 2050,
        "Hartebeesthoek94 / Lo23", 0, 0,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hartebeesthoek94 / Lo23\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
        "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
        "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6148\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4148\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator_South_Orientated\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",23],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Westing");
    add_srs_wkt (p, 11,
        "\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "050\"]]");
    p = add_epsg_def_ex (filter, first, last, 2051, "epsg", 2051,
        "Hartebeesthoek94 / Lo25", 0, 0,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hartebeesthoek94 / Lo25\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
        "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
        "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6148\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4148\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator_South_Orientated\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",25],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Westing");
    add_srs_wkt (p, 11,
        "\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "051\"]]");
    p = add_epsg_def_ex (filter, first, last, 2052, "epsg", 2052,
        "Hartebeesthoek94 / Lo27", 0, 0,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hartebeesthoek94 / Lo27\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
        "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
        "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6148\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4148\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator_South_Orientated\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",27],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Westing");
    add_srs_wkt (p, 11,
        "\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "052\"]]");
    p = add_epsg_def_ex (filter, first, last, 2053, "epsg", 2053,
        "Hartebeesthoek94 / Lo29", 0, 0,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=29 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hartebeesthoek94 / Lo29\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
        "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
        "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6148\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4148\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator_South_Orientated\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",29],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Westing");
    add_srs_wkt (p, 11,
        "\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "053\"]]");
    p = add_epsg_def_ex (filter, first, last, 2054, "epsg", 2054,
        "Hartebeesthoek94 / Lo31", 0, 0,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=31 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hartebeesthoek94 / Lo31\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
        "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
        "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6148\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4148\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator_South_Orientated\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",31],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Westing");
    add_srs_wkt (p, 11,
        "\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "054\"]]");
    p = add_epsg_def_ex (filter, first, last, 2055, "epsg", 2055,
        "Hartebeesthoek94 / Lo33", 0, 0,
        "WGS 84", "Greenwich",
        "Hartebeesthoek94", "Transverse_Mercator_South_Orientated", "metre",
        "Westing", "West", "Southing", "South");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=0 +y_0=0 +axis=");
    add_proj4text (p, 1,
        "wsu +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hartebeesthoek94 / Lo33\",GEOGCS[\"Hartebeestho");
    add_srs_wkt (p, 1,
        "ek94\",DATUM[\"Hartebeesthoek94\",SPHEROID[\"WGS 84\",63");
    add_srs_wkt (p, 2,
        "78137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6148\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4148\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator_South_Orientated\"],");
    add_srs_wkt (p, 7,
        "PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",33],PARAMETER[\"scale_factor\",1],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_easting\",0],PARAMETER[\"false_northing\",0],UNIT[");
    add_srs_wkt (p, 10,
        "\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Westing");
    add_srs_wkt (p, 11,
        "\",WEST],AXIS[\"Southing\",SOUTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 12,
        "055\"]]");
    p = add_epsg_def_ex (filter, first, last, 2056, "epsg", 2056,
        "CH1903+ / LV95", 0, 0,
        "Bessel 1841", "Greenwich",
        "CH1903+", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=somerc +lat_0=46.95240555555556 +lon_0=7.439583333");
    add_proj4text (p, 1,
        "333333 +k_0=1 +x_0=2600000 +y_0=1200000 +ellps=bessel +t");
    add_proj4text (p, 2,
        "owgs84=674.374,15.056,405.346,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"CH1903+ / LV95\",GEOGCS[\"CH1903+\",DATUM[\"CH1");
    add_srs_wkt (p, 1,
        "903+\",SPHEROID[\"Bessel 1841\",6377397.155,299.1528128,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"EPSG\",\"6150\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4150\"]],PROJECTION[\"Hoti");
    add_srs_wkt (p, 6,
        "ne_Oblique_Mercator_Azimuth_Center\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 7,
        "de_of_center\",46.9524055555556],PARAMETER[\"longitude_o");
    add_srs_wkt (p, 8,
        "f_center\",7.43958333333333],PARAMETER[\"azimuth\",90],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"rectified_grid_angle\",90],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",1],PARAMETER[\"false_easting\",2600000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",1200000],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"2056\"]]");
    p = add_epsg_def_ex (filter, first, last, 2057, "epsg", 2057,
        "Rassadiran / Nakhl e Taqi", 0, 0,
        "International 1924", "Greenwich",
        "Rassadiran", "Hotine_Oblique_Mercator_Azimuth_Center", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=omerc +lat_0=27.51882880555555 +lonc=52.6035391666");
    add_proj4text (p, 1,
        "6667 +alpha=0.5716611944444444 +k=0.999895934 +x_0=65837");
    add_proj4text (p, 2,
        "7.437 +y_0=3044969.194 +gamma=0.5716611944444444 +ellps=");
    add_proj4text (p, 3,
        "intl +towgs84=-133.63,-157.5,-158.62,0,0,0,0 +units=m +n");
    add_proj4text (p, 4,
        "o_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Rassadiran / Nakhl e Taqi\",GEOGCS[\"Rassadiran");
    add_srs_wkt (p, 1,
        "\",DATUM[\"Rassadiran\",SPHEROID[\"International 1924\",");
    add_srs_wkt (p, 2,
        "6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"6153\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4153\"]],PROJE");
    add_srs_wkt (p, 6,
        "CTION[\"Hotine_Oblique_Mercator_Azimuth_Center\"],PARAME");
    add_srs_wkt (p, 7,
        "TER[\"latitude_of_center\",27.5188288055556],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "longitude_of_center\",52.6035391666667],PARAMETER[\"azim");
    add_srs_wkt (p, 9,
        "uth\",0.571661194444444],PARAMETER[\"rectified_grid_angl");
    add_srs_wkt (p, 10,
        "e\",0.571661194444444],PARAMETER[\"scale_factor\",0.9998");
    add_srs_wkt (p, 11,
        "95934],PARAMETER[\"false_easting\",658377.437],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",3044969.194],UNIT[\"metre\",1,AUTHOR");
    add_srs_wkt (p, 13,
        "ITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"No");
    add_srs_wkt (p, 14,
        "rthing\",NORTH],AUTHORITY[\"EPSG\",\"2057\"]]");
    p = add_epsg_def_ex (filter, first, last, 2058, "epsg", 2058,
        "ED50(ED77) / UTM zone 38N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950_1977", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=intl +towgs84=-117,-132,-164,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50(ED77) / UTM zone 38N\",GEOGCS[\"ED50(ED77)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"European_Datum_1950_1977\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6154\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4154\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",4");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"205");
    add_srs_wkt (p, 12,
        "8\"]]");
    p = add_epsg_def_ex (filter, first, last, 2059, "epsg", 2059,
        "ED50(ED77) / UTM zone 39N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950_1977", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=intl +towgs84=-117,-132,-164,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50(ED77) / UTM zone 39N\",GEOGCS[\"ED50(ED77)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"European_Datum_1950_1977\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6154\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4154\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "1],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"205");
    add_srs_wkt (p, 12,
        "9\"]]");
    p = add_epsg_def_ex (filter, first, last, 2060, "epsg", 2060,
        "ED50(ED77) / UTM zone 40N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950_1977", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=40 +ellps=intl +towgs84=-117,-132,-164,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50(ED77) / UTM zone 40N\",GEOGCS[\"ED50(ED77)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"European_Datum_1950_1977\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6154\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4154\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",5");
    add_srs_wkt (p, 8,
        "7],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"206");
    add_srs_wkt (p, 12,
        "0\"]]");
    p = add_epsg_def_ex (filter, first, last, 2061, "epsg", 2061,
        "ED50(ED77) / UTM zone 41N", 0, 0,
        "International 1924", "Greenwich",
        "European_Datum_1950_1977", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=41 +ellps=intl +towgs84=-117,-132,-164,0");
    add_proj4text (p, 1,
        ",0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ED50(ED77) / UTM zone 41N\",GEOGCS[\"ED50(ED77)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"European_Datum_1950_1977\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6154\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4154\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",0],PARAMETER[\"central_meridian\",6");
    add_srs_wkt (p, 8,
        "3],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_");
    add_srs_wkt (p, 9,
        "easting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\"");
    add_srs_wkt (p, 11,
        ",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"206");
    add_srs_wkt (p, 12,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 2062, "epsg", 2062,
        "Madrid 1870 (Madrid) / Spain LCC", 0, 0,
        "Struve 1860", "Madrid",
        "Madrid_1870_Madrid", "Lambert_Conformal_Conic_1SP", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40 +lat_0=40 +lon_0=0 +k_0=0.9988085293");
    add_proj4text (p, 1,
        " +x_0=600000 +y_0=600000 +a=6378298.3 +b=6356657.1426695");
    add_proj4text (p, 2,
        "61 +pm=madrid +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Madrid 1870 (Madrid) / Spain LCC\",GEOGCS[\"Mad");
    add_srs_wkt (p, 1,
        "rid 1870 (Madrid)\",DATUM[\"Madrid_1870_Madrid\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Struve 1860\",6378298.3,294.73,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7028\"]],AUTHORITY[\"EPSG\",\"6903\"]],PRIMEM[\"Madrid\"");
    add_srs_wkt (p, 4,
        ",-3.687375,AUTHORITY[\"EPSG\",\"8905\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4903\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 7,
        "onic_1SP\"],PARAMETER[\"latitude_of_origin\",40],PARAMET");
    add_srs_wkt (p, 8,
        "ER[\"central_meridian\",0],PARAMETER[\"scale_factor\",0.");
    add_srs_wkt (p, 9,
        "9988085293],PARAMETER[\"false_easting\",600000],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_northing\",600000],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 12,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"2062\"]]");
    p = add_epsg_def_ex (filter, first, last, 2063, "epsg", 2063,
        "Dabola 1981 / UTM zone 28N (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Conakry_1905", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +a=6378249.2 +b=6356515 +towgs84=-23,");
    add_proj4text (p, 1,
        "259,-9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Dabola 1981 / UTM zone 28N (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Conakry 1905\",DATUM[\"Conakry_1905\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6315\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4315\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-15],PARAMETER[\"scale_factor\",0.9996");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"false_easting\",500000],PARAMETER[\"false_");
    add_srs_wkt (p, 10,
        "northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001");
    add_srs_wkt (p, 11,
        "\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUT");
    add_srs_wkt (p, 12,
        "HORITY[\"EPSG\",\"2063\"]]");
    p = add_epsg_def_ex (filter, first, last, 2064, "epsg", 2064,
        "Dabola 1981 / UTM zone 29N (deprecated)", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Conakry_1905", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=29 +a=6378249.2 +b=6356515 +towgs84=-23,");
    add_proj4text (p, 1,
        "259,-9,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Dabola 1981 / UTM zone 29N (deprecated)\",GEOGC");
    add_srs_wkt (p, 1,
        "S[\"Conakry 1905\",DATUM[\"Conakry_1905\",SPHEROID[\"Cla");
    add_srs_wkt (p, 2,
        "rke 1880 (IGN)\",6378249.2,293.466021293627,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7011\"]],AUTHORITY[\"EPSG\",\"6315\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"4315\"]],PROJECTION[\"Transverse_Merca");
    add_srs_wkt (p, 7,
        "tor\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-9],PARAMETER[\"scale_factor\",0.9996]");
    add_srs_wkt (p, 9,
        ",PARAMETER[\"false_easting\",500000],PARAMETER[\"false_n");
    add_srs_wkt (p, 10,
        "orthing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 11,
        "]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHO");
    add_srs_wkt (p, 12,
        "RITY[\"EPSG\",\"2064\"]]");
    p = add_epsg_def_ex (filter, first, last, 2065, "epsg", 2065,
        "S-JTSK (Ferro) / Krovak", 0, 0,
        "Bessel 1841", "Ferro",
        "System_of_the_Unified_Trigonometrical_Cadastral_Network_Ferro", "Krovak", "metre",
        "Southing", "South", "Westing", "West");
    add_proj4text (p, 0,
        "+proj=krovak +lat_0=49.5 +lon_0=42.5 +alpha=30.288139722");
    add_proj4text (p, 1,
        "22222 +k=0.9999 +x_0=0 +y_0=0 +ellps=bessel +towgs84=570");
    add_proj4text (p, 2,
        ".8,85.7,462.8,4.998,1.587,5.261,3.56 +pm=ferro +units=m ");
    add_proj4text (p, 3,
        "+no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"S-JTSK (Ferro) / Krovak\",GEOGCS[\"S-JTSK (Ferr");
    add_srs_wkt (p, 1,
        "o)\",DATUM[\"System_of_the_Unified_Trigonometrical_Cadas");
    add_srs_wkt (p, 2,
        "tral_Network_Ferro\",SPHEROID[\"Bessel 1841\",6377397.15");
    add_srs_wkt (p, 3,
        "5,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"6818\"]],PRIMEM[\"Ferro\",-17.6666666666667,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8909\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4818\"]],PROJECTION[\"Krovak\"],PARAMETER[\"latitude_of_");
    add_srs_wkt (p, 8,
        "center\",49.5],PARAMETER[\"longitude_of_center\",42.5],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"azimuth\",30.2881397527778],PARAMETER[\"pseud");
    add_srs_wkt (p, 10,
        "o_standard_parallel_1\",78.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",0.9999],PARAMETER[\"false_easting\",0],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "01\"]],AXIS[\"Southing\",SOUTH],AXIS[\"Westing\",WEST],A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"2065\"]]");
    p = add_epsg_def_ex (filter, first, last, 2066, "epsg", 2066,
        "Mount Dillon / Tobago Grid", 0, 0,
        "Clarke 1858", "Greenwich",
        "Mount_Dillon", "Cassini_Soldner", "Clarke's link",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=11.25217861111111 +lon_0=-60.686008888");
    add_proj4text (p, 1,
        "88889 +x_0=37718.66159325 +y_0=36209.91512952 +a=6378293");
    add_proj4text (p, 2,
        ".645208759 +b=6356617.987679838 +to_meter=0.201166195164");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Mount Dillon / Tobago Grid\",GEOGCS[\"Mount Dil");
    add_srs_wkt (p, 1,
        "lon\",DATUM[\"Mount_Dillon\",SPHEROID[\"Clarke 1858\",63");
    add_srs_wkt (p, 2,
        "78293.64520876,294.260676369261,AUTHORITY[\"EPSG\",\"700");
    add_srs_wkt (p, 3,
        "7\"]],AUTHORITY[\"EPSG\",\"6157\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4157\"]],PROJECTION[\"Cassini_Soldner\"],PARAMETE");
    add_srs_wkt (p, 7,
        "R[\"latitude_of_origin\",11.2521786111111],PARAMETER[\"c");
    add_srs_wkt (p, 8,
        "entral_meridian\",-60.6860088888889],PARAMETER[\"false_e");
    add_srs_wkt (p, 9,
        "asting\",187500],PARAMETER[\"false_northing\",180000],UN");
    add_srs_wkt (p, 10,
        "IT[\"Clarke's link\",0.201166195164,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 11,
        "9039\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH]");
    add_srs_wkt (p, 12,
        ",AUTHORITY[\"EPSG\",\"2066\"]]");
    p = add_epsg_def_ex (filter, first, last, 2067, "epsg", 2067,
        "Naparima 1955 / UTM zone 20N", 0, 0,
        "International 1924", "Greenwich",
        "Naparima_1955", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=20 +ellps=intl +towgs84=-0.465,372.095,1");
    add_proj4text (p, 1,
        "71.736,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Naparima 1955 / UTM zone 20N\",GEOGCS[\"Naparim");
    add_srs_wkt (p, 1,
        "a 1955\",DATUM[\"Naparima_1955\",SPHEROID[\"Internationa");
    add_srs_wkt (p, 2,
        "l 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHO");
    add_srs_wkt (p, 3,
        "RITY[\"EPSG\",\"6158\"]],PRIMEM[\"Greenwich\",0,AUTHORIT");
    add_srs_wkt (p, 4,
        "Y[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433");
    add_srs_wkt (p, 5,
        ",AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4158");
    add_srs_wkt (p, 6,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 7,
        "itude_of_origin\",0],PARAMETER[\"central_meridian\",-63]");
    add_srs_wkt (p, 8,
        ",PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"m");
    add_srs_wkt (p, 10,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",");
    add_srs_wkt (p, 11,
        "EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2067");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2068, "epsg", 2068,
        "ELD79 / Libya zone 5", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=9 +k=0.9999 +x_0=200000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,0");
    add_proj4text (p, 2,
        ",0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / Libya zone 5\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",9],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2068\"]]");
    p = add_epsg_def_ex (filter, first, last, 2069, "epsg", 2069,
        "ELD79 / Libya zone 6", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / Libya zone 6\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",11],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9999],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2069\"]]");
    p = add_epsg_def_ex (filter, first, last, 2070, "epsg", 2070,
        "ELD79 / Libya zone 7", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=13 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / Libya zone 7\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",13],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9999],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2070\"]]");
    p = add_epsg_def_ex (filter, first, last, 2071, "epsg", 2071,
        "ELD79 / Libya zone 8", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=15 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / Libya zone 8\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",15],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9999],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2071\"]]");
    p = add_epsg_def_ex (filter, first, last, 2072, "epsg", 2072,
        "ELD79 / Libya zone 9", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=17 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / Libya zone 9\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",17],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9999],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",200000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2072\"]]");
    p = add_epsg_def_ex (filter, first, last, 2073, "epsg", 2073,
        "ELD79 / Libya zone 10", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=19 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / Libya zone 10\",GEOGCS[\"ELD79\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Libyan_Datum_1979\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",19],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",200000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2073\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2074, "epsg", 2074,
        "ELD79 / Libya zone 11", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / Libya zone 11\",GEOGCS[\"ELD79\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Libyan_Datum_1979\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",21],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",200000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2074\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2075, "epsg", 2075,
        "ELD79 / Libya zone 12", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=23 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / Libya zone 12\",GEOGCS[\"ELD79\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Libyan_Datum_1979\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",23],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",200000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2075\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2076, "epsg", 2076,
        "ELD79 / Libya zone 13", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=25 +k=0.9999 +x_0=200000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / Libya zone 13\",GEOGCS[\"ELD79\",DATUM[");
    add_srs_wkt (p, 1,
        "\"European_Libyan_Datum_1979\",SPHEROID[\"International ");
    add_srs_wkt (p, 2,
        "1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORI");
    add_srs_wkt (p, 3,
        "TY[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[");
    add_srs_wkt (p, 4,
        "\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",25],PA");
    add_srs_wkt (p, 8,
        "RAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",200000],PARAMETER[\"false_northing\",0],UNIT[\"metr");
    add_srs_wkt (p, 10,
        "e\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAS");
    add_srs_wkt (p, 11,
        "T],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2076\"]");
    add_srs_wkt (p, 12,
        "]");
    p = add_epsg_def_ex (filter, first, last, 2077, "epsg", 2077,
        "ELD79 / UTM zone 32N", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=32 +ellps=intl +towgs84=-115.8543,-99.05");
    add_proj4text (p, 1,
        "83,-152.4616,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / UTM zone 32N\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",9],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2077\"]]");
    p = add_epsg_def_ex (filter, first, last, 2078, "epsg", 2078,
        "ELD79 / UTM zone 33N", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=33 +ellps=intl +towgs84=-115.8543,-99.05");
    add_proj4text (p, 1,
        "83,-152.4616,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / UTM zone 33N\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",15],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2078\"]]");
    p = add_epsg_def_ex (filter, first, last, 2079, "epsg", 2079,
        "ELD79 / UTM zone 34N", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=34 +ellps=intl +towgs84=-115.8543,-99.05");
    add_proj4text (p, 1,
        "83,-152.4616,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / UTM zone 34N\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",21],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2079\"]]");
    p = add_epsg_def_ex (filter, first, last, 2080, "epsg", 2080,
        "ELD79 / UTM zone 35N", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=35 +ellps=intl +towgs84=-115.8543,-99.05");
    add_proj4text (p, 1,
        "83,-152.4616,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / UTM zone 35N\",GEOGCS[\"ELD79\",DATUM[\"");
    add_srs_wkt (p, 1,
        "European_Libyan_Datum_1979\",SPHEROID[\"International 19");
    add_srs_wkt (p, 2,
        "24\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY");
    add_srs_wkt (p, 3,
        "[\"EPSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 4,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]]");
    add_srs_wkt (p, 6,
        ",PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitud");
    add_srs_wkt (p, 7,
        "e_of_origin\",0],PARAMETER[\"central_meridian\",27],PARA");
    add_srs_wkt (p, 8,
        "METER[\"scale_factor\",0.9996],PARAMETER[\"false_easting");
    add_srs_wkt (p, 9,
        "\",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\"");
    add_srs_wkt (p, 10,
        ",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],");
    add_srs_wkt (p, 11,
        "AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2080\"]]");
    p = add_epsg_def_ex (filter, first, last, 2081, "epsg", 2081,
        "Chos Malal 1914 / Argentina 2", 0, 1,
        "International 1924", "Greenwich",
        "Chos_Malal_1914", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Chos Malal 1914 / Argentina 2\",GEOGCS[\"Chos M");
    add_srs_wkt (p, 1,
        "alal 1914\",DATUM[\"Chos_Malal_1914\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6160\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4160\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-90],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-69],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",2500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2081");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2082, "epsg", 2082,
        "Pampa del Castillo / Argentina 2", 0, 1,
        "International 1924", "Greenwich",
        "Pampa_del_Castillo", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=27.5,14,186.4,0,0,0,0 +units=m +");
    add_proj4text (p, 2,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Pampa del Castillo / Argentina 2\",GEOGCS[\"Pam");
    add_srs_wkt (p, 1,
        "pa del Castillo\",DATUM[\"Pampa_del_Castillo\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"International 1924\",6378388,297,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7022\"]],AUTHORITY[\"EPSG\",\"6161\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4161\"]],PROJECTION[\"Transverse_Mercator\"],PA");
    add_srs_wkt (p, 7,
        "RAMETER[\"latitude_of_origin\",-90],PARAMETER[\"central_");
    add_srs_wkt (p, 8,
        "meridian\",-69],PARAMETER[\"scale_factor\",1],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"false_easting\",2500000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"2082\"]]");
    p = add_epsg_def_ex (filter, first, last, 2083, "epsg", 2083,
        "Hito XVIII 1963 / Argentina 2", 0, 1,
        "International 1924", "Greenwich",
        "Hito_XVIII_1963", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=-90 +lon_0=-69 +k=1 +x_0=2500000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=intl +towgs84=16,196,93,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hito XVIII 1963 / Argentina 2\",GEOGCS[\"Hito X");
    add_srs_wkt (p, 1,
        "VIII 1963\",DATUM[\"Hito_XVIII_1963\",SPHEROID[\"Interna");
    add_srs_wkt (p, 2,
        "tional 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],");
    add_srs_wkt (p, 3,
        "AUTHORITY[\"EPSG\",\"6254\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 4,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 5,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4254\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",-90],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-69],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_ea");
    add_srs_wkt (p, 9,
        "sting\",2500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2083");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2084, "epsg", 2084,
        "Hito XVIII 1963 / UTM zone 19S", 0, 0,
        "International 1924", "Greenwich",
        "Hito_XVIII_1963", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=19 +south +ellps=intl +towgs84=16,196,93");
    add_proj4text (p, 1,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hito XVIII 1963 / UTM zone 19S\",GEOGCS[\"Hito ");
    add_srs_wkt (p, 1,
        "XVIII 1963\",DATUM[\"Hito_XVIII_1963\",SPHEROID[\"Intern");
    add_srs_wkt (p, 2,
        "ational 1924\",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6254\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4254\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",-69],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",500000],PARAMETER[\"false_northing\",100000");
    add_srs_wkt (p, 10,
        "00],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"2084\"]]");
    p = add_epsg_def_ex (filter, first, last, 2085, "epsg", 2085,
        "NAD27 / Cuba Norte (deprecated)", 0, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_1SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=22.35 +lat_0=22.35 +lon_0=-81 +k_0=0.99");
    add_proj4text (p, 1,
        "993602 +x_0=500000 +y_0=280296.016 +datum=NAD27 +units=m");
    add_proj4text (p, 2,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Cuba Norte (deprecated)\",GEOGCS[\"NAD2");
    add_srs_wkt (p, 1,
        "7\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clark");
    add_srs_wkt (p, 2,
        "e 1866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_1");
    add_srs_wkt (p, 7,
        "SP\"],PARAMETER[\"latitude_of_origin\",22.35],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"central_meridian\",-81],PARAMETER[\"scale_factor\",0.9");
    add_srs_wkt (p, 9,
        "9993602],PARAMETER[\"false_easting\",500000],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "false_northing\",280296.016],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 11,
        "\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"East");
    add_srs_wkt (p, 12,
        "ing\",EAST],AUTHORITY[\"EPSG\",\"2085\"]]");
    p = add_epsg_def_ex (filter, first, last, 2086, "epsg", 2086,
        "NAD27 / Cuba Sur (deprecated)", 0, 1,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_1SP", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=20.71666666666667 +lat_0=20.71666666666");
    add_proj4text (p, 1,
        "667 +lon_0=-76.83333333333333 +k_0=0.99994848 +x_0=50000");
    add_proj4text (p, 2,
        "0 +y_0=229126.939 +datum=NAD27 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Cuba Sur (deprecated)\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.978698213898,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_1SP");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",20.7166666666667],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"central_meridian\",-76.8333333333333],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"scale_factor\",0.99994848],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 10,
        "g\",500000],PARAMETER[\"false_northing\",229126.939],UNI");
    add_srs_wkt (p, 11,
        "T[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"North");
    add_srs_wkt (p, 12,
        "ing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "2086\"]]");
    p = add_epsg_def_ex (filter, first, last, 2087, "epsg", 2087,
        "ELD79 / TM 12 NE", 0, 0,
        "International 1924", "Greenwich",
        "European_Libyan_Datum_1979", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=12 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=intl +towgs84=-115.8543,-99.0583,-152.4616,0,");
    add_proj4text (p, 2,
        "0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"ELD79 / TM 12 NE\",GEOGCS[\"ELD79\",DATUM[\"Eur");
    add_srs_wkt (p, 1,
        "opean_Libyan_Datum_1979\",SPHEROID[\"International 1924\"");
    add_srs_wkt (p, 2,
        ",6378388,297,AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 3,
        "PSG\",\"6159\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 4,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4159\"]],PRO");
    add_srs_wkt (p, 6,
        "JECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 7,
        "_origin\",0],PARAMETER[\"central_meridian\",12],PARAMETE");
    add_srs_wkt (p, 8,
        "R[\"scale_factor\",0.9996],PARAMETER[\"false_easting\",5");
    add_srs_wkt (p, 9,
        "00000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 10,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2087\"]]");
    p = add_epsg_def_ex (filter, first, last, 2088, "epsg", 2088,
        "Carthage / TM 11 NE", 0, 0,
        "Clarke 1880 (IGN)", "Greenwich",
        "Carthage", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=11 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +a=6378249.2 +b=6356515 +towgs84=-263,6,431,0,0,0,0 ");
    add_proj4text (p, 2,
        "+units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Carthage / TM 11 NE\",GEOGCS[\"Carthage\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Carthage\",SPHEROID[\"Clarke 1880 (IGN)\",6378249.2,2");
    add_srs_wkt (p, 2,
        "93.466021293627,AUTHORITY[\"EPSG\",\"7011\"]],AUTHORITY[");
    add_srs_wkt (p, 3,
        "\"EPSG\",\"6223\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTH");
    add_srs_wkt (p, 5,
        "ORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4223\"]],");
    add_srs_wkt (p, 6,
        "PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitude");
    add_srs_wkt (p, 7,
        "_of_origin\",0],PARAMETER[\"central_meridian\",11],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"scale_factor\",0.9996],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 9,
        ",500000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 10,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],A");
    add_srs_wkt (p, 11,
        "XIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2088\"]]");
    p = add_epsg_def_ex (filter, first, last, 2089, "epsg", 2089,
        "Yemen NGN96 / UTM zone 38N", 0, 0,
        "WGS 84", "Greenwich",
        "Yemen_National_Geodetic_Network_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=38 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Yemen NGN96 / UTM zone 38N\",GEOGCS[\"Yemen NGN");
    add_srs_wkt (p, 1,
        "96\",DATUM[\"Yemen_National_Geodetic_Network_1996\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"6163\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4163\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",45],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"2089\"]]");
    p = add_epsg_def_ex (filter, first, last, 2090, "epsg", 2090,
        "Yemen NGN96 / UTM zone 39N", 0, 0,
        "WGS 84", "Greenwich",
        "Yemen_National_Geodetic_Network_1996", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=39 +ellps=WGS84 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Yemen NGN96 / UTM zone 39N\",GEOGCS[\"Yemen NGN");
    add_srs_wkt (p, 1,
        "96\",DATUM[\"Yemen_National_Geodetic_Network_1996\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7030\"]],AUTHORITY[\"EPSG\",\"6163\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4163\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",51],PARAMETER[\"scale_factor\",0.9996],PARA");
    add_srs_wkt (p, 9,
        "METER[\"false_easting\",500000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 10,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 11,
        "XIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY");
    add_srs_wkt (p, 12,
        "[\"EPSG\",\"2090\"]]");
    p = add_epsg_def_ex (filter, first, last, 2091, "epsg", 2091,
        "South Yemen / Gauss Kruger zone 8 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "South_Yemen", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=8500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"South Yemen / Gauss Kruger zone 8 (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"South Yemen\",DATUM[\"South_Yemen\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6164\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4164\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",45],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",8500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"2091\"]]");
    p = add_epsg_def_ex (filter, first, last, 2092, "epsg", 2092,
        "South Yemen / Gauss Kruger zone 9 (deprecated)", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "South_Yemen", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=9500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=-76,-138,67,0,0,0,0 +units=m +no_d");
    add_proj4text (p, 2,
        "efs");
    add_srs_wkt (p, 0,
        "PROJCS[\"South Yemen / Gauss Kruger zone 9 (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"South Yemen\",DATUM[\"South_Yemen\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Krassowsky 1940\",6378245,298.3,AUTHORITY[\"EPSG\",\"702");
    add_srs_wkt (p, 3,
        "4\"]],AUTHORITY[\"EPSG\",\"6164\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EP");
    add_srs_wkt (p, 6,
        "SG\",\"4164\"]],PROJECTION[\"Transverse_Mercator\"],PARA");
    add_srs_wkt (p, 7,
        "METER[\"latitude_of_origin\",0],PARAMETER[\"central_meri");
    add_srs_wkt (p, 8,
        "dian\",51],PARAMETER[\"scale_factor\",1],PARAMETER[\"fal");
    add_srs_wkt (p, 9,
        "se_easting\",9500000],PARAMETER[\"false_northing\",0],UN");
    add_srs_wkt (p, 10,
        "IT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Nort");
    add_srs_wkt (p, 11,
        "hing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 12,
        "\"2092\"]]");
    p = add_epsg_def_ex (filter, first, last, 2093, "epsg", 2093,
        "Hanoi 1972 / GK 106 NE", 0, 1,
        "Krassowsky 1940", "Greenwich",
        "Hanoi_1972", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=106 +k=1 +x_0=500000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=krass +towgs84=-17.51,-108.32,-62.39,0,0,0,0 +uni");
    add_proj4text (p, 2,
        "ts=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Hanoi 1972 / GK 106 NE\",GEOGCS[\"Hanoi 1972\",");
    add_srs_wkt (p, 1,
        "DATUM[\"Hanoi_1972\",SPHEROID[\"Krassowsky 1940\",637824");
    add_srs_wkt (p, 2,
        "5,298.3,AUTHORITY[\"EPSG\",\"7024\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"6147\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4147\"]],PROJECTI");
    add_srs_wkt (p, 6,
        "ON[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_orig");
    add_srs_wkt (p, 7,
        "in\",0],PARAMETER[\"central_meridian\",106],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "scale_factor\",1],PARAMETER[\"false_easting\",500000],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY");
    add_srs_wkt (p, 10,
        "[\"EPSG\",\"9001\"]],AXIS[\"Northing\",NORTH],AXIS[\"Eas");
    add_srs_wkt (p, 11,
        "ting\",EAST],AUTHORITY[\"EPSG\",\"2093\"]]");
    p = add_epsg_def_ex (filter, first, last, 2094, "epsg", 2094,
        "WGS 72BE / TM 106 NE", 0, 0,
        "WGS 72", "Greenwich",
        "WGS_72_Transit_Broadcast_Ephemeris", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=106 +k=0.9996 +x_0=500000 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=WGS72 +towgs84=0,0,1.9,0,0,0.814,-0.38 +unit");
    add_proj4text (p, 2,
        "s=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"WGS 72BE / TM 106 NE\",GEOGCS[\"WGS 72BE\",DATU");
    add_srs_wkt (p, 1,
        "M[\"WGS_72_Transit_Broadcast_Ephemeris\",SPHEROID[\"WGS ");
    add_srs_wkt (p, 2,
        "72\",6378135,298.26,AUTHORITY[\"EPSG\",\"7043\"]],AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"6324\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 5,
        "AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4324\"");
    add_srs_wkt (p, 6,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 7,
        "ude_of_origin\",0],PARAMETER[\"central_meridian\",106],P");
    add_srs_wkt (p, 8,
        "ARAMETER[\"scale_factor\",0.9996],PARAMETER[\"false_east");
    add_srs_wkt (p, 9,
        "ing\",500000],PARAMETER[\"false_northing\",0],UNIT[\"met");
    add_srs_wkt (p, 10,
        "re\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EA");
    add_srs_wkt (p, 11,
        "ST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"2094\"");
    add_srs_wkt (p, 12,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 2095, "epsg", 2095,
        "Bissau / UTM zone 28N", 0, 0,
        "International 1924", "Greenwich",
        "Bissau", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=28 +ellps=intl +towgs84=-173,253,27,0,0,");
    add_proj4text (p, 1,
        "0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Bissau / UTM zone 28N\",GEOGCS[\"Bissau\",DATUM");
    add_srs_wkt (p, 1,
        "[\"Bissau\",SPHEROID[\"International 1924\",6378388,297,");
    add_srs_wkt (p, 2,
        "AUTHORITY[\"EPSG\",\"7022\"]],AUTHORITY[\"EPSG\",\"6165\"");
    add_srs_wkt (p, 3,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 4,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "9122\"]],AUTHORITY[\"EPSG\",\"4165\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 6,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0],P");
    add_srs_wkt (p, 7,
        "ARAMETER[\"central_meridian\",-15],PARAMETER[\"scale_fac");
    add_srs_wkt (p, 8,
        "tor\",0.9996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 10,
        "PSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AUTHORITY[\"EPSG\",\"2095\"]]");
    p = add_epsg_def_ex (filter, first, last, 2096, "epsg", 2096,
        "Korean 1985 / East Belt", 0, 1,
        "Bessel 1841", "Greenwich",
        "Korean_Datum_1985", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=129 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "00000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korean 1985 / East Belt\",GEOGCS[\"Korean 1985\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Korean_Datum_1985\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"416");
    add_srs_wkt (p, 6,
        "2\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",38],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 8,
        "9],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",200000],PARAMETER[\"false_northing\",500000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2096");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2097, "epsg", 2097,
        "Korean 1985 / Central Belt", 0, 1,
        "Bessel 1841", "Greenwich",
        "Korean_Datum_1985", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=127 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "00000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korean 1985 / Central Belt\",GEOGCS[\"Korean 19");
    add_srs_wkt (p, 1,
        "85\",DATUM[\"Korean_Datum_1985\",SPHEROID[\"Bessel 1841\"");
    add_srs_wkt (p, 2,
        ",6377397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "4162\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"");
    add_srs_wkt (p, 7,
        "latitude_of_origin\",38],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 8,
        "127],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_eas");
    add_srs_wkt (p, 9,
        "ting\",200000],PARAMETER[\"false_northing\",500000],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northi");
    add_srs_wkt (p, 11,
        "ng\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "2097\"]]");
    p = add_epsg_def_ex (filter, first, last, 2098, "epsg", 2098,
        "Korean 1985 / West Belt", 0, 1,
        "Bessel 1841", "Greenwich",
        "Korean_Datum_1985", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=38 +lon_0=125 +k=1 +x_0=200000 +y_0=5");
    add_proj4text (p, 1,
        "00000 +ellps=bessel +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Korean 1985 / West Belt\",GEOGCS[\"Korean 1985\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Korean_Datum_1985\",SPHEROID[\"Bessel 1841\",63");
    add_srs_wkt (p, 2,
        "77397.155,299.1528128,AUTHORITY[\"EPSG\",\"7004\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6162\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"416");
    add_srs_wkt (p, 6,
        "2\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 7,
        "titude_of_origin\",38],PARAMETER[\"central_meridian\",12");
    add_srs_wkt (p, 8,
        "5],PARAMETER[\"scale_factor\",1],PARAMETER[\"false_easti");
    add_srs_wkt (p, 9,
        "ng\",200000],PARAMETER[\"false_northing\",500000],UNIT[\"");
    add_srs_wkt (p, 10,
        "metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPSG\",\"2098");
    add_srs_wkt (p, 12,
        "\"]]");
    p = add_epsg_def_ex (filter, first, last, 2099, "epsg", 2099,
        "Qatar 1948 / Qatar Grid", 0, 0,
        "Helmert 1906", "Greenwich",
        "Qatar_1948", "Cassini_Soldner", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=cass +lat_0=25.38236111111111 +lon_0=50.7613888888");
    add_proj4text (p, 1,
        "8889 +x_0=100000 +y_0=100000 +ellps=helmert +units=m +no");
    add_proj4text (p, 2,
        "_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Qatar 1948 / Qatar Grid\",GEOGCS[\"Qatar 1948\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Qatar_1948\",SPHEROID[\"Helmert 1906\",6378200,");
    add_srs_wkt (p, 2,
        "298.3,AUTHORITY[\"EPSG\",\"7020\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "6286\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 4,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 5,
        "G\",\"9122\"]],AUTHORITY[\"EPSG\",\"4286\"]],PROJECTION[");
    add_srs_wkt (p, 6,
        "\"Cassini_Soldner\"],PARAMETER[\"latitude_of_origin\",25");
    add_srs_wkt (p, 7,
        ".3823611111111],PARAMETER[\"central_meridian\",50.761388");
    add_srs_wkt (p, 8,
        "8888889],PARAMETER[\"false_easting\",100000],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "false_northing\",100000],UNIT[\"metre\",1,AUTHORITY[\"EP");
    add_srs_wkt (p, 10,
        "SG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northing\"");
    add_srs_wkt (p, 11,
        ",NORTH],AUTHORITY[\"EPSG\",\"2099\"]]");
    p = add_epsg_def_ex (filter, first, last, 2100, "epsg", 2100,
        "GGRS87 / Greek Grid", 0, 0,
        "GRS 1980", "Greenwich",
        "Greek_Geodetic_Reference_System_1987", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=0.9996 +x_0=500000 +y_");
    add_proj4text (p, 1,
        "0=0 +ellps=GRS80 +towgs84=-199.87,74.79,246.62,0,0,0,0 +");
    add_proj4text (p, 2,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GGRS87 / Greek Grid\",GEOGCS[\"GGRS87\",DATUM[\"");
    add_srs_wkt (p, 1,
        "Greek_Geodetic_Reference_System_1987\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6121\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 6,
        "\"4121\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER");
    add_srs_wkt (p, 7,
        "[\"latitude_of_origin\",0],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 8,
        ",24],PARAMETER[\"scale_factor\",0.9996],PARAMETER[\"fals");
    add_srs_wkt (p, 9,
        "e_easting\",500000],PARAMETER[\"false_northing\",0],UNIT");
    add_srs_wkt (p, 10,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Eastin");
    add_srs_wkt (p, 11,
        "g\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 12,
        "2100\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

