/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * OsmUploadDialog.java
 *
 * Created on 12 sept. 2009, 22:58:29
 */

package bt747.j2se_view;

import gps.log.out.GPSConversionParameters;

import bt747.model.Model;
import bt747.model.AppSettings;

/**
 *
 * @author Mario
 */
public class OsmUploadDialog extends javax.swing.JDialog {
    /**
     * 
     */
    private static final long serialVersionUID = -6732563315133816897L;
    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;

    
    private Model m;
    private J2SEAppController c;

    /** Creates new form OsmUploadDialog */
    public OsmUploadDialog(final J2SEAppController pC, java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        setLocationRelativeTo(parent);
        init(pC);
    }

    public void init(final J2SEAppController pC) {
        c = pC;
        m = c.getModel();
        
        cbVisibility.setModel(new javax.swing.DefaultComboBoxModel(new String[] {
                J2SEAppController.getString(GPSConversionParameters.OSM_PRIVATE),
                J2SEAppController.getString(GPSConversionParameters.OSM_PUBLIC),
                J2SEAppController.getString(GPSConversionParameters.OSM_TRACKABLE),
                J2SEAppController.getString(GPSConversionParameters.OSM_IDENTIFIABLE),
                }));
        cbVisibility.setSelectedIndex(0);
        //m.addListener(this);
        //initAppData();
        txtLogin.setText(m.getStringOpt(AppSettings.OSMLOGIN));
        txtPassword.setText(m.getStringOpt(AppSettings.OSMPASS));
        tfDescription.setText("");
        tfTags.setText("");
    }

    
    public final String getVisibility() {
        return (new String[] {GPSConversionParameters.OSM_PRIVATE,
                GPSConversionParameters.OSM_PUBLIC,
                GPSConversionParameters.OSM_TRACKABLE,
                GPSConversionParameters.OSM_IDENTIFIABLE,
                })[cbVisibility.getSelectedIndex()];
    }
    
    /** Set the description field.
     * @param description
     */
    public final void setDescription(final String description) {
       tfDescription.setText(description); 
    }
    
    public final String getDescription() {
        return tfDescription.getText();
    }
    
    /** Set the tags field.
     * @param tags
     */
    public final void setTags(final String tags) {
        tfTags.setText(tags);
    }
    
    public final String getTags() {
        return tfTags.getText();
    }

    /** @return the return status of this dialog - one of RET_OK or RET_CANCEL */
    public int getReturnStatus() {
        return returnStatus;
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    private void initComponents() {//GEN-BEGIN:initComponents

        pnInstructions = new javax.swing.JPanel();
        lbInstructions = new javax.swing.JLabel();
        osmAccountPanel = new javax.swing.JPanel();
        lbLogin = new javax.swing.JLabel();
        txtLogin = new javax.swing.JTextField();
        lbPassword = new javax.swing.JLabel();
        txtPassword = new javax.swing.JPasswordField();
        pnOsmTrackProps = new javax.swing.JPanel();
        lbDescription = new javax.swing.JLabel();
        tfDescription = new javax.swing.JTextField();
        cbVisibility = new javax.swing.JComboBox();
        lbVisibility = new javax.swing.JLabel();
        tfTags = new javax.swing.JTextField();
        lbTags = new javax.swing.JLabel();
        lbCommaSeparated = new javax.swing.JLabel();
        cancelButton = new javax.swing.JButton();
        okButton = new javax.swing.JButton();

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("bt747/j2se_view/Bundle"); // NOI18N
        setTitle(bundle.getString("OsmUploadDialog.title")); // NOI18N
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        pnInstructions.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("OsmUploadDialog.pnInstructions.border.title"))); // NOI18N

        lbInstructions.setText(bundle.getString("OsmUploadDialog.lbInstructions.text")); // NOI18N

        org.jdesktop.layout.GroupLayout pnInstructionsLayout = new org.jdesktop.layout.GroupLayout(pnInstructions);
        pnInstructions.setLayout(pnInstructionsLayout);
        pnInstructionsLayout.setHorizontalGroup(
            pnInstructionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(lbInstructions, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 575, Short.MAX_VALUE)
        );
        pnInstructionsLayout.setVerticalGroup(
            pnInstructionsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnInstructionsLayout.createSequentialGroup()
                .add(lbInstructions)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        osmAccountPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("AgpsPanel.osmAccountPanel.border.title"))); // NOI18N
        osmAccountPanel.setToolTipText(bundle.getString("AgpsPanel.osmAccountPanel.toolTipText")); // NOI18N

        lbLogin.setLabelFor(txtLogin);
        lbLogin.setText(bundle.getString("AgpsPanel.lbLogin.text")); // NOI18N

        txtLogin.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                txtLoginFocusLost(evt);
            }
        });

        lbPassword.setLabelFor(txtPassword);
        lbPassword.setText(bundle.getString("AgpsPanel.lbPassword.text")); // NOI18N

        txtPassword.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                txtPasswordFocusLost(evt);
            }
        });

        org.jdesktop.layout.GroupLayout osmAccountPanelLayout = new org.jdesktop.layout.GroupLayout(osmAccountPanel);
        osmAccountPanel.setLayout(osmAccountPanelLayout);
        osmAccountPanelLayout.setHorizontalGroup(
            osmAccountPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(osmAccountPanelLayout.createSequentialGroup()
                .add(osmAccountPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, lbLogin)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, lbPassword))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(osmAccountPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(txtPassword)
                    .add(txtLogin, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 103, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        );
        osmAccountPanelLayout.setVerticalGroup(
            osmAccountPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(osmAccountPanelLayout.createSequentialGroup()
                .add(osmAccountPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(txtLogin, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lbLogin))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(osmAccountPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lbPassword)
                    .add(txtPassword, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
        );

        pnOsmTrackProps.setBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("OsmUploadDialog.pnOsmTrackProps.border.title"))); // NOI18N

        lbDescription.setLabelFor(tfDescription);
        lbDescription.setText(bundle.getString("OsmUploadDialog.lbDescription.text")); // NOI18N

        tfDescription.setToolTipText(bundle.getString("OsmUploadDialog.tfDescription.toolTipText")); // NOI18N

        cbVisibility.setToolTipText(bundle.getString("OsmUploadDialog.cbVisibility.toolTipText")); // NOI18N

        lbVisibility.setLabelFor(cbVisibility);
        lbVisibility.setText(bundle.getString("OsmUploadDialog.lbVisibility.text")); // NOI18N

        tfTags.setToolTipText(bundle.getString("OsmUploadDialog.tfTags.toolTipText")); // NOI18N

        lbTags.setLabelFor(lbTags);
        lbTags.setText(bundle.getString("OsmUploadDialog.lbTags.text")); // NOI18N

        lbCommaSeparated.setText(bundle.getString("OsmUploadDialog.lbCommaSeparated.text")); // NOI18N

        org.jdesktop.layout.GroupLayout pnOsmTrackPropsLayout = new org.jdesktop.layout.GroupLayout(pnOsmTrackProps);
        pnOsmTrackProps.setLayout(pnOsmTrackPropsLayout);
        pnOsmTrackPropsLayout.setHorizontalGroup(
            pnOsmTrackPropsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnOsmTrackPropsLayout.createSequentialGroup()
                .addContainerGap()
                .add(pnOsmTrackPropsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(lbDescription)
                    .add(lbVisibility)
                    .add(lbTags))
                .add(pnOsmTrackPropsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(pnOsmTrackPropsLayout.createSequentialGroup()
                        .add(tfTags, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 399, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(lbCommaSeparated))
                    .add(cbVisibility, 0, 498, Short.MAX_VALUE)
                    .add(tfDescription, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 498, Short.MAX_VALUE))
                .addContainerGap())
        );
        pnOsmTrackPropsLayout.setVerticalGroup(
            pnOsmTrackPropsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(pnOsmTrackPropsLayout.createSequentialGroup()
                .add(pnOsmTrackPropsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lbDescription)
                    .add(tfDescription, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnOsmTrackPropsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cbVisibility, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lbVisibility))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnOsmTrackPropsLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(tfTags, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lbTags)
                    .add(lbCommaSeparated))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        cancelButton.setText(bundle.getString("OsmUploadDialog.cancelButton.text")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });

        okButton.setText(bundle.getString("OsmUploadDialog.okButton.text")); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(osmAccountPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(pnOsmTrackProps, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(pnInstructions, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                        .addContainerGap(435, Short.MAX_VALUE)
                        .add(okButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 67, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .add(18, 18, 18)
                        .add(cancelButton)))
                .addContainerGap())
        );

        layout.linkSize(new java.awt.Component[] {cancelButton, okButton}, org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(osmAccountPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnOsmTrackProps, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(pnInstructions, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(cancelButton)
                    .add(okButton))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        pack();
    }//GEN-END:initComponents

    private void okButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_okButtonActionPerformed
        c.setStringOpt(AppSettings.OSMLOGIN, txtLogin.getText());
        c.setStringOpt(AppSettings.OSMPASS, String.valueOf(txtPassword.getPassword()));

        doClose(RET_OK);
    }//GEN-LAST:event_okButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cancelButtonActionPerformed
        doClose(RET_CANCEL);
    }//GEN-LAST:event_cancelButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        doClose(RET_CANCEL);
    }//GEN-LAST:event_closeDialog

    private void txtLoginFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_txtLoginFocusLost
        c.setStringOpt(AppSettings.OSMLOGIN, txtLogin.getText());
}//GEN-LAST:event_txtLoginFocusLost

    private void txtPasswordFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_txtPasswordFocusLost
        c.setStringOpt(AppSettings.OSMPASS, String.copyValueOf(txtPassword.getPassword()));
}//GEN-LAST:event_txtPasswordFocusLost

    private void doClose(int retStatus) {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
    }

//    /**
//    * @param args the command line arguments
//    */
//    public static void main(String args[]) {
//        java.awt.EventQueue.invokeLater(new Runnable() {
//            public void run() {
//                OsmUploadDialog dialog = new OsmUploadDialog(new javax.swing.JFrame(), true);
//                dialog.addWindowListener(new java.awt.event.WindowAdapter() {
//                    public void windowClosing(java.awt.event.WindowEvent e) {
//                        System.exit(0);
//                    }
//                });
//                dialog.setVisible(true);
//            }
//        });
//    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton cancelButton;
    private javax.swing.JComboBox cbVisibility;
    private javax.swing.JLabel lbCommaSeparated;
    private javax.swing.JLabel lbDescription;
    private javax.swing.JLabel lbInstructions;
    private javax.swing.JLabel lbLogin;
    private javax.swing.JLabel lbPassword;
    private javax.swing.JLabel lbTags;
    private javax.swing.JLabel lbVisibility;
    private javax.swing.JButton okButton;
    private javax.swing.JPanel osmAccountPanel;
    private javax.swing.JPanel pnInstructions;
    private javax.swing.JPanel pnOsmTrackProps;
    private javax.swing.JTextField tfDescription;
    private javax.swing.JTextField tfTags;
    private javax.swing.JTextField txtLogin;
    private javax.swing.JPasswordField txtPassword;
    // End of variables declaration//GEN-END:variables

    private int returnStatus = RET_CANCEL;
}
