/*
 * QtTapioca, the Tapioca Qt4 Client Library
 * Copyright (C) 2007 by INdT
 *  @author Abner Jose de Faria Silva <abner.silva@indt.org.br>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA
 */

#include "config.h"

#include <QDebug>
#include "QtTapioca/VideoStream"
#include "QtTapioca/StreamChannel"

namespace QtTapioca {

class VideoStreamPrivate {
public:
    VideoStreamPrivate(org::freedesktop::Telepathy::StreamEngine *se)
        : windowId(0),
          telepathyStreamEngine(se)
    {
    }
    ~VideoStreamPrivate()
    {
    }

    uint windowId;
    org::freedesktop::Telepathy::StreamEngine *telepathyStreamEngine;
};

}

using namespace QtTapioca;

VideoStream::VideoStream(org::freedesktop::Telepathy::ChannelStreamedMedia *sm,
                         org::freedesktop::Telepathy::StreamEngine *se,
                         uint id, uint contact, uint type, QObject *parent)
    : Stream(sm, id, contact, type, parent),
      d(new VideoStreamPrivate(se))
{
}

VideoStream::VideoStream(org::freedesktop::Telepathy::ChannelStreamedMedia *sm,
                         org::freedesktop::Telepathy::StreamEngine *se,
                         uint id,
                         uint contact,
                         uint type,
                         uint state,
                         uint direction,
                         uint flags,
                         QObject *parent)
    : Stream(sm, id, contact, type, state, direction, flags, parent),
      d(new VideoStreamPrivate(se))
{
}

VideoStream::~VideoStream()
{
    delete d;
}

void VideoStream::setWindowId(uint id)
{
    Q_ASSERT(d->telepathyStreamEngine);

    if (id == d->windowId) {
        qDebug() << "Current id is equal to the new id.";
        return;
    }

    StreamChannel *sch = dynamic_cast<StreamChannel *>(parent());
    QDBusReply<void> reply = d->telepathyStreamEngine->SetOutputWindow(QDBusObjectPath(sch->objectPath()), m_id, id);

    if (!reply.isValid())
        qDebug() << "Unable to set the window id:" << reply.error().message();
    else
        d->windowId = id;
}

uint VideoStream::windowId() const
{
    return d->windowId;
}

void VideoStream::addPreviewWindowId(uint id)
{
    Q_ASSERT(d->telepathyStreamEngine);

    QDBusReply<void> reply = d->telepathyStreamEngine->AddPreviewWindow(id);

    if (!reply.isValid())
        qDebug() << "Unable to add the preview window id:" << reply.error().message();
}

void VideoStream::removePreviewWindowId(uint id)
{
    Q_ASSERT(d->telepathyStreamEngine);

    QDBusReply<void> reply = d->telepathyStreamEngine->RemovePreviewWindow(id);

    if (!reply.isValid())
        qDebug() << "Unable to remove the preview window id:" << reply.error().message();
}
