// -*- Mode: c++ -*-

#ifndef HDHRSIGNALMONITOR_H
#define HDHRSIGNALMONITOR_H

#include "dtvsignalmonitor.h"
#include "qstringlist.h"

class HDHRChannel;
class HDHRStreamHandler;

typedef QMap<uint,int> FilterMap;

class HDHRSignalMonitor: public DTVSignalMonitor
{
  public:
    HDHRSignalMonitor(int db_cardnum, HDHRChannel* _channel,
                      uint64_t _flags = 0);
    virtual ~HDHRSignalMonitor();

    void Stop(void);

  protected:
    HDHRSignalMonitor(void);
    HDHRSignalMonitor(const HDHRSignalMonitor&);

    virtual void UpdateValues(void);
    HDHRChannel *GetHDHRChannel(void); 

  protected:
    bool               streamHandlerStarted;
    HDHRStreamHandler *streamHandler;
};

#endif // HDHRSIGNALMONITOR_H
