/*
 * Copyright 2010 Jerome Glisse <glisse@freedesktop.org>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors:
 *      Jerome Glisse
 */
#include <errno.h>
#include <stdint.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "xf86drm.h"
#include "r600.h"
#include "evergreend.h"
#include "radeon_drm.h"
#include "bof.h"
#include "pipe/p_compiler.h"
#include "util/u_inlines.h"
#include "util/u_memory.h"
#include "r600_priv.h"

#define GROUP_FORCE_NEW_BLOCK	0

static const struct r600_reg evergreen_config_reg_list[] = {
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_008958_VGT_PRIMITIVE_TYPE, 0, 0, 0},
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_008A14_PA_CL_ENHANCE, 0, 0, 0},
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_008C00_SQ_CONFIG, 0, 0, 0},
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_008C04_SQ_GPR_RESOURCE_MGMT_1, 0, 0, 0},
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_008C08_SQ_GPR_RESOURCE_MGMT_2, 0, 0, 0},
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_008C0C_SQ_THREAD_RESOURCE_MGMT, 0, 0, 0},
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_008C18_SQ_THREAD_RESOURCE_MGMT_1, 0, 0, 0},
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_008C1C_SQ_THREAD_RESOURCE_MGMT_2, 0, 0, 0},
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_008C20_SQ_STACK_RESOURCE_MGMT_1, 0, 0, 0},
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_008C24_SQ_STACK_RESOURCE_MGMT_2, 0, 0, 0},
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_008C28_SQ_STACK_RESOURCE_MGMT_3, 0, 0, 0},
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_008D8C_SQ_DYN_GPR_CNTL_PS_FLUSH_REQ, 0, 0, 0},
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_009100_SPI_CONFIG_CNTL, 0, 0, 0},
	{PKT3_SET_CONFIG_REG, EVERGREEN_CONFIG_REG_OFFSET, R_00913C_SPI_CONFIG_CNTL_1, 0, 0, 0},
};

static const struct r600_reg evergreen_ctl_const_list[] = {
	{PKT3_SET_CTL_CONST, EVERGREEN_CTL_CONST_OFFSET, R_03CFF0_SQ_VTX_BASE_VTX_LOC, 0, 0, 0},
	{PKT3_SET_CTL_CONST, EVERGREEN_CTL_CONST_OFFSET, R_03CFF4_SQ_VTX_START_INST_LOC, 0, 0, 0},
};

static const struct r600_reg evergreen_context_reg_list[] = {
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028000_DB_RENDER_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028004_DB_COUNT_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028008_DB_DEPTH_VIEW, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02800C_DB_RENDER_OVERRIDE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028010_DB_RENDER_OVERRIDE2, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028014_DB_HTILE_DATA_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028028_DB_STENCIL_CLEAR, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02802C_DB_DEPTH_CLEAR, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028030_PA_SC_SCREEN_SCISSOR_TL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028034_PA_SC_SCREEN_SCISSOR_BR, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028040_DB_Z_INFO, REG_FLAG_NEED_BO, 0, 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028044_DB_STENCIL_INFO, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028048_DB_Z_READ_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02804C_DB_STENCIL_READ_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028050_DB_Z_WRITE_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028054_DB_STENCIL_WRITE_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028058_DB_DEPTH_SIZE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02805C_DB_DEPTH_SLICE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028140_ALU_CONST_BUFFER_SIZE_PS_0, REG_FLAG_DIRTY_ALWAYS, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028180_ALU_CONST_BUFFER_SIZE_VS_0, REG_FLAG_DIRTY_ALWAYS, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028200_PA_SC_WINDOW_OFFSET, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028204_PA_SC_WINDOW_SCISSOR_TL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028208_PA_SC_WINDOW_SCISSOR_BR, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02820C_PA_SC_CLIPRECT_RULE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028210_PA_SC_CLIPRECT_0_TL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028214_PA_SC_CLIPRECT_0_BR, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028218_PA_SC_CLIPRECT_1_TL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02821C_PA_SC_CLIPRECT_1_BR, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028220_PA_SC_CLIPRECT_2_TL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028224_PA_SC_CLIPRECT_2_BR, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028228_PA_SC_CLIPRECT_3_TL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02822C_PA_SC_CLIPRECT_3_BR, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028230_PA_SC_EDGERULE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028234_PA_SU_HARDWARE_SCREEN_OFFSET, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028238_CB_TARGET_MASK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02823C_CB_SHADER_MASK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028240_PA_SC_GENERIC_SCISSOR_TL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028244_PA_SC_GENERIC_SCISSOR_BR, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028250_PA_SC_VPORT_SCISSOR_0_TL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028254_PA_SC_VPORT_SCISSOR_0_BR, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028350_SX_MISC, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028380_SQ_VTX_SEMANTIC_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028384_SQ_VTX_SEMANTIC_1, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028388_SQ_VTX_SEMANTIC_2, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02838C_SQ_VTX_SEMANTIC_3, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028390_SQ_VTX_SEMANTIC_4, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028394_SQ_VTX_SEMANTIC_5, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028398_SQ_VTX_SEMANTIC_6, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02839C_SQ_VTX_SEMANTIC_7, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283A0_SQ_VTX_SEMANTIC_8, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283A4_SQ_VTX_SEMANTIC_9, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283A8_SQ_VTX_SEMANTIC_10, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283AC_SQ_VTX_SEMANTIC_11, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283B0_SQ_VTX_SEMANTIC_12, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283B4_SQ_VTX_SEMANTIC_13, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283B8_SQ_VTX_SEMANTIC_14, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283BC_SQ_VTX_SEMANTIC_15, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283C0_SQ_VTX_SEMANTIC_16, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283C4_SQ_VTX_SEMANTIC_17, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283C8_SQ_VTX_SEMANTIC_18, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283CC_SQ_VTX_SEMANTIC_19, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283D0_SQ_VTX_SEMANTIC_20, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283D4_SQ_VTX_SEMANTIC_21, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283D8_SQ_VTX_SEMANTIC_22, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283DC_SQ_VTX_SEMANTIC_23, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283E0_SQ_VTX_SEMANTIC_24, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283E4_SQ_VTX_SEMANTIC_25, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283E8_SQ_VTX_SEMANTIC_26, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283EC_SQ_VTX_SEMANTIC_27, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283F0_SQ_VTX_SEMANTIC_28, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283F4_SQ_VTX_SEMANTIC_29, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283F8_SQ_VTX_SEMANTIC_30, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0283FC_SQ_VTX_SEMANTIC_31, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0282D0_PA_SC_VPORT_ZMIN_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0282D4_PA_SC_VPORT_ZMAX_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028400_VGT_MAX_VTX_INDX, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028404_VGT_MIN_VTX_INDX, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028408_VGT_INDX_OFFSET, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02840C_VGT_MULTI_PRIM_IB_RESET_INDX, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028410_SX_ALPHA_TEST_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028414_CB_BLEND_RED, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028418_CB_BLEND_GREEN, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02841C_CB_BLEND_BLUE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028420_CB_BLEND_ALPHA, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028430_DB_STENCILREFMASK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028434_DB_STENCILREFMASK_BF, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028438_SX_ALPHA_REF, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02843C_PA_CL_VPORT_XSCALE_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028440_PA_CL_VPORT_XOFFSET_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028444_PA_CL_VPORT_YSCALE_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028448_PA_CL_VPORT_YOFFSET_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02844C_PA_CL_VPORT_ZSCALE_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028450_PA_CL_VPORT_ZOFFSET_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285BC_PA_CL_UCP0_X, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285C0_PA_CL_UCP0_Y, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285C4_PA_CL_UCP0_Z, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285C8_PA_CL_UCP0_W, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285CC_PA_CL_UCP1_X, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285D0_PA_CL_UCP1_Y, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285D4_PA_CL_UCP1_Z, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285D8_PA_CL_UCP1_W, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285DC_PA_CL_UCP2_X, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285E0_PA_CL_UCP2_Y, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285E4_PA_CL_UCP2_Z, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285E8_PA_CL_UCP2_W, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285EC_PA_CL_UCP3_X, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285F0_PA_CL_UCP3_Y, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285F4_PA_CL_UCP3_Z, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285F8_PA_CL_UCP3_W, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0285FC_PA_CL_UCP4_X, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028600_PA_CL_UCP4_Y, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028604_PA_CL_UCP4_Z, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028608_PA_CL_UCP4_W, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02860C_PA_CL_UCP5_X, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028610_PA_CL_UCP5_Y, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028614_PA_CL_UCP5_Z, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028618_PA_CL_UCP5_W, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02861C_SPI_VS_OUT_ID_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028620_SPI_VS_OUT_ID_1, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028624_SPI_VS_OUT_ID_2, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028628_SPI_VS_OUT_ID_3, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02862C_SPI_VS_OUT_ID_4, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028630_SPI_VS_OUT_ID_5, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028634_SPI_VS_OUT_ID_6, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028638_SPI_VS_OUT_ID_7, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02863C_SPI_VS_OUT_ID_8, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028640_SPI_VS_OUT_ID_9, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028644_SPI_PS_INPUT_CNTL_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028648_SPI_PS_INPUT_CNTL_1, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02864C_SPI_PS_INPUT_CNTL_2, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028650_SPI_PS_INPUT_CNTL_3, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028654_SPI_PS_INPUT_CNTL_4, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028658_SPI_PS_INPUT_CNTL_5, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02865C_SPI_PS_INPUT_CNTL_6, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028660_SPI_PS_INPUT_CNTL_7, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028664_SPI_PS_INPUT_CNTL_8, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028668_SPI_PS_INPUT_CNTL_9, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02866C_SPI_PS_INPUT_CNTL_10, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028670_SPI_PS_INPUT_CNTL_11, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028674_SPI_PS_INPUT_CNTL_12, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028678_SPI_PS_INPUT_CNTL_13, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02867C_SPI_PS_INPUT_CNTL_14, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028680_SPI_PS_INPUT_CNTL_15, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028684_SPI_PS_INPUT_CNTL_16, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028688_SPI_PS_INPUT_CNTL_17, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02868C_SPI_PS_INPUT_CNTL_18, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028690_SPI_PS_INPUT_CNTL_19, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028694_SPI_PS_INPUT_CNTL_20, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028698_SPI_PS_INPUT_CNTL_21, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02869C_SPI_PS_INPUT_CNTL_22, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286A0_SPI_PS_INPUT_CNTL_23, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286A4_SPI_PS_INPUT_CNTL_24, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286A8_SPI_PS_INPUT_CNTL_25, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286AC_SPI_PS_INPUT_CNTL_26, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286B0_SPI_PS_INPUT_CNTL_27, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286B4_SPI_PS_INPUT_CNTL_28, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286B8_SPI_PS_INPUT_CNTL_29, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286BC_SPI_PS_INPUT_CNTL_30, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286C0_SPI_PS_INPUT_CNTL_31, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286C4_SPI_VS_OUT_CONFIG, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286C8_SPI_THREAD_GROUPING, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286CC_SPI_PS_IN_CONTROL_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286D0_SPI_PS_IN_CONTROL_1, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286D4_SPI_INTERP_CONTROL_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286D8_SPI_INPUT_Z, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286DC_SPI_FOG_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286E0_SPI_BARYC_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286E4_SPI_PS_IN_CONTROL_2, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0286E8_SPI_COMPUTE_INPUT_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028780_CB_BLEND0_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028784_CB_BLEND1_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028788_CB_BLEND2_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02878C_CB_BLEND3_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028790_CB_BLEND4_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028794_CB_BLEND5_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028798_CB_BLEND6_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02879C_CB_BLEND7_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028800_DB_DEPTH_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02880C_DB_SHADER_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028808_CB_COLOR_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028810_PA_CL_CLIP_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028814_PA_SU_SC_MODE_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028818_PA_CL_VTE_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02881C_PA_CL_VS_OUT_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028820_PA_CL_NANINF_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028838_SQ_DYN_GPR_RESOURCE_LIMIT_1, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028840_SQ_PGM_START_PS, REG_FLAG_NEED_BO, S_0085F0_SH_ACTION_ENA(1), 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028844_SQ_PGM_RESOURCES_PS, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028848_SQ_PGM_RESOURCES_2_PS, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02884C_SQ_PGM_EXPORTS_PS, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02885C_SQ_PGM_START_VS, REG_FLAG_NEED_BO, S_0085F0_SH_ACTION_ENA(1), 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028860_SQ_PGM_RESOURCES_VS, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028864_SQ_PGM_RESOURCES_2_VS, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0288A4_SQ_PGM_START_FS, REG_FLAG_NEED_BO, S_0085F0_SH_ACTION_ENA(1), 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0288A8_SQ_PGM_RESOURCES_FS, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_0288EC_SQ_LDS_ALLOC_PS, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028900_SQ_ESGS_RING_ITEMSIZE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028904_SQ_GSVS_RING_ITEMSIZE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028908_SQ_ESTMP_RING_ITEMSIZE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02890C_SQ_GSTMP_RING_ITEMSIZE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028910_SQ_VSTMP_RING_ITEMSIZE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028914_SQ_PSTMP_RING_ITEMSIZE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_02891C_SQ_GS_VERT_ITEMSIZE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028920_SQ_GS_VERT_ITEMSIZE_1, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028924_SQ_GS_VERT_ITEMSIZE_2, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028928_SQ_GS_VERT_ITEMSIZE_3, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028940_ALU_CONST_CACHE_PS_0, REG_FLAG_NEED_BO, S_0085F0_SH_ACTION_ENA(1), 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028980_ALU_CONST_CACHE_VS_0, REG_FLAG_NEED_BO, S_0085F0_SH_ACTION_ENA(1), 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A00_PA_SU_POINT_SIZE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A04_PA_SU_POINT_MINMAX, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A08_PA_SU_LINE_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A10_VGT_OUTPUT_PATH_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A14_VGT_HOS_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A18_VGT_HOS_MAX_TESS_LEVEL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A1C_VGT_HOS_MIN_TESS_LEVEL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A20_VGT_HOS_REUSE_DEPTH, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A24_VGT_GROUP_PRIM_TYPE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A28_VGT_GROUP_FIRST_DECR, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A2C_VGT_GROUP_DECR, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A30_VGT_GROUP_VECT_0_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A34_VGT_GROUP_VECT_1_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A38_VGT_GROUP_VECT_0_FMT_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A3C_VGT_GROUP_VECT_1_FMT_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A40_VGT_GS_MODE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A48_PA_SC_MODE_CNTL_0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028A4C_PA_SC_MODE_CNTL_1, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028AB4_VGT_REUSE_OFF, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028AB8_VGT_VTX_CNT_EN, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028ABC_DB_HTILE_SURFACE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028AC0_DB_SRESULTS_COMPARE_STATE0, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028AC4_DB_SRESULTS_COMPARE_STATE1, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028AC8_DB_PRELOAD_CONTROL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028B54_VGT_SHADER_STAGES_EN, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028B70_DB_ALPHA_TO_MASK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028B78_PA_SU_POLY_OFFSET_DB_FMT_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028B7C_PA_SU_POLY_OFFSET_CLAMP, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028B80_PA_SU_POLY_OFFSET_FRONT_SCALE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028B84_PA_SU_POLY_OFFSET_FRONT_OFFSET, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028B88_PA_SU_POLY_OFFSET_BACK_SCALE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028B8C_PA_SU_POLY_OFFSET_BACK_OFFSET, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028B94_VGT_STRMOUT_CONFIG, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028B98_VGT_STRMOUT_BUFFER_CONFIG, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C00_PA_SC_LINE_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C04_PA_SC_AA_CONFIG, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C08_PA_SU_VTX_CNTL, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C0C_PA_CL_GB_VERT_CLIP_ADJ, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C10_PA_CL_GB_VERT_DISC_ADJ, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C14_PA_CL_GB_HORZ_CLIP_ADJ, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C18_PA_CL_GB_HORZ_DISC_ADJ, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C1C_PA_SC_AA_SAMPLE_LOCS_MCTX, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C3C_PA_SC_AA_MASK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C60_CB_COLOR0_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C64_CB_COLOR0_PITCH, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C68_CB_COLOR0_SLICE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C6C_CB_COLOR0_VIEW, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C70_CB_COLOR0_INFO, REG_FLAG_NEED_BO, 0, 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C74_CB_COLOR0_ATTRIB, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C78_CB_COLOR0_DIM, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028C9C_CB_COLOR1_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028CA0_CB_COLOR1_PITCH, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028CA4_CB_COLOR1_SLICE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028CA8_CB_COLOR1_VIEW, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028CAC_CB_COLOR1_INFO, REG_FLAG_NEED_BO, 0, 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028CB0_CB_COLOR1_ATTRIB, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028CB4_CB_COLOR1_DIM, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028CD8_CB_COLOR2_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028CDC_CB_COLOR2_PITCH, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028CE0_CB_COLOR2_SLICE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028CE4_CB_COLOR2_VIEW, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028CE8_CB_COLOR2_INFO, REG_FLAG_NEED_BO, 0, 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028CEC_CB_COLOR2_ATTRIB, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028CF0_CB_COLOR2_DIM, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D14_CB_COLOR3_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D18_CB_COLOR3_PITCH, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D1C_CB_COLOR3_SLICE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D20_CB_COLOR3_VIEW, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D24_CB_COLOR3_INFO, REG_FLAG_NEED_BO, 0, 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D28_CB_COLOR3_ATTRIB, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D2C_CB_COLOR3_DIM, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D50_CB_COLOR4_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D54_CB_COLOR4_PITCH, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D58_CB_COLOR4_SLICE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D5C_CB_COLOR4_VIEW, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D60_CB_COLOR4_INFO, REG_FLAG_NEED_BO, 0, 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D64_CB_COLOR4_ATTRIB, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D68_CB_COLOR4_DIM, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D8C_CB_COLOR5_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D90_CB_COLOR5_PITCH, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D94_CB_COLOR5_SLICE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D98_CB_COLOR5_VIEW, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028D9C_CB_COLOR5_INFO, REG_FLAG_NEED_BO, 0, 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028DA0_CB_COLOR5_ATTRIB, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028DA4_CB_COLOR5_DIM, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028DC8_CB_COLOR6_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028DCC_CB_COLOR6_PITCH, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028DD0_CB_COLOR6_SLICE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028DD4_CB_COLOR6_VIEW, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028DD8_CB_COLOR6_INFO, REG_FLAG_NEED_BO, 0, 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028DDC_CB_COLOR6_ATTRIB, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028DE0_CB_COLOR6_DIM, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E04_CB_COLOR7_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E08_CB_COLOR7_PITCH, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E0C_CB_COLOR7_SLICE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E10_CB_COLOR7_VIEW, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E14_CB_COLOR7_INFO, REG_FLAG_NEED_BO, 0, 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E18_CB_COLOR7_ATTRIB, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E1C_CB_COLOR7_DIM, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E40_CB_COLOR8_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E44_CB_COLOR8_PITCH, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E48_CB_COLOR8_SLICE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E4C_CB_COLOR8_VIEW, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E50_CB_COLOR8_INFO, REG_FLAG_NEED_BO, 0, 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E54_CB_COLOR8_ATTRIB, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E58_CB_COLOR8_DIM, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E5C_CB_COLOR9_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E60_CB_COLOR9_PITCH, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E64_CB_COLOR9_SLICE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E68_CB_COLOR9_VIEW, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E6C_CB_COLOR9_INFO, REG_FLAG_NEED_BO, 0, 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E70_CB_COLOR9_ATTRIB, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E74_CB_COLOR9_DIM, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E78_CB_COLOR10_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E7C_CB_COLOR10_PITCH, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E80_CB_COLOR10_SLICE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E84_CB_COLOR10_VIEW, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E88_CB_COLOR10_INFO, REG_FLAG_NEED_BO, 0, 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E8C_CB_COLOR10_ATTRIB, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E90_CB_COLOR10_DIM, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, GROUP_FORCE_NEW_BLOCK, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E94_CB_COLOR11_BASE, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E98_CB_COLOR11_PITCH, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028E9C_CB_COLOR11_SLICE, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028EA0_CB_COLOR11_VIEW, 0, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028EA4_CB_COLOR11_INFO, REG_FLAG_NEED_BO, 0, 0xFFFFFFFF},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028EA8_CB_COLOR11_ATTRIB, REG_FLAG_NEED_BO, 0, 0},
	{PKT3_SET_CONTEXT_REG, EVERGREEN_CONTEXT_REG_OFFSET, R_028EAC_CB_COLOR11_DIM, 0, 0, 0},
};

/* SHADER RESOURCE R600/R700 */
static int evergreen_state_resource_init(struct r600_context *ctx, u32 offset)
{
	struct r600_reg r600_shader_resource[] = {
		{PKT3_SET_RESOURCE, EVERGREEN_RESOURCE_OFFSET, R_030000_RESOURCE0_WORD0, 0, 0, 0},
		{PKT3_SET_RESOURCE, EVERGREEN_RESOURCE_OFFSET, R_030004_RESOURCE0_WORD1, 0, 0, 0},
		{PKT3_SET_RESOURCE, EVERGREEN_RESOURCE_OFFSET, R_030008_RESOURCE0_WORD2, REG_FLAG_NEED_BO, S_0085F0_TC_ACTION_ENA(1) | S_0085F0_VC_ACTION_ENA(1), 0xFFFFFFFF},
		{PKT3_SET_RESOURCE, EVERGREEN_RESOURCE_OFFSET, R_03000C_RESOURCE0_WORD3, REG_FLAG_NEED_BO, S_0085F0_TC_ACTION_ENA(1) | S_0085F0_VC_ACTION_ENA(1), 0xFFFFFFFF},
		{PKT3_SET_RESOURCE, EVERGREEN_RESOURCE_OFFSET, R_030010_RESOURCE0_WORD4, 0, 0, 0},
		{PKT3_SET_RESOURCE, EVERGREEN_RESOURCE_OFFSET, R_030014_RESOURCE0_WORD5, 0, 0, 0},
		{PKT3_SET_RESOURCE, EVERGREEN_RESOURCE_OFFSET, R_030018_RESOURCE0_WORD6, 0, 0, 0},
		{PKT3_SET_RESOURCE, EVERGREEN_RESOURCE_OFFSET, R_03001C_RESOURCE0_WORD7, 0, 0, 0},
	};
	unsigned nreg = Elements(r600_shader_resource);

	for (int i = 0; i < nreg; i++) {
		r600_shader_resource[i].offset += offset;
	}
	return r600_context_add_block(ctx, r600_shader_resource, nreg);
}

/* SHADER SAMPLER R600/R700 */
static int r600_state_sampler_init(struct r600_context *ctx, u32 offset)
{
	struct r600_reg r600_shader_sampler[] = {
		{PKT3_SET_SAMPLER, EVERGREEN_SAMPLER_OFFSET, R_03C000_SQ_TEX_SAMPLER_WORD0_0, 0, 0, 0},
		{PKT3_SET_SAMPLER, EVERGREEN_SAMPLER_OFFSET, R_03C004_SQ_TEX_SAMPLER_WORD1_0, 0, 0, 0},
		{PKT3_SET_SAMPLER, EVERGREEN_SAMPLER_OFFSET, R_03C008_SQ_TEX_SAMPLER_WORD2_0, 0, 0, 0},
	};
	unsigned nreg = Elements(r600_shader_sampler);

	for (int i = 0; i < nreg; i++) {
		r600_shader_sampler[i].offset += offset;
	}
	return r600_context_add_block(ctx, r600_shader_sampler, nreg);
}

/* SHADER SAMPLER BORDER R600/R700 */
static int evergreen_state_sampler_border_init(struct r600_context *ctx, u32 offset, unsigned id)
{
	struct r600_reg r600_shader_sampler_border[] = {
		{PKT3_SET_CONFIG_REG, 0, R_00A400_TD_PS_SAMPLER0_BORDER_INDEX, 0, 0, 0},
		{PKT3_SET_CONFIG_REG, 0, R_00A404_TD_PS_SAMPLER0_BORDER_RED, 0, 0, 0},
		{PKT3_SET_CONFIG_REG, 0, R_00A408_TD_PS_SAMPLER0_BORDER_GREEN, 0, 0, 0},
		{PKT3_SET_CONFIG_REG, 0, R_00A40C_TD_PS_SAMPLER0_BORDER_BLUE, 0, 0, 0},
		{PKT3_SET_CONFIG_REG, 0, R_00A410_TD_PS_SAMPLER0_BORDER_ALPHA, 0, 0, 0},
	};
	unsigned nreg = Elements(r600_shader_sampler_border);
	unsigned fake_offset = (offset - R_00A400_TD_PS_SAMPLER0_BORDER_INDEX) * 0x100 + 0x40000 + id * 0x1C;
	struct r600_range *range;
	struct r600_block *block;
	int r;

	for (int i = 0; i < nreg; i++) {
		r600_shader_sampler_border[i].offset -= R_00A400_TD_PS_SAMPLER0_BORDER_INDEX;
		r600_shader_sampler_border[i].offset += fake_offset;
	}
	r = r600_context_add_block(ctx, r600_shader_sampler_border, nreg);
	if (r) {
		return r;
	}
	/* set proper offset */
	range = &ctx->range[CTX_RANGE_ID(ctx, r600_shader_sampler_border[0].offset)];
	block = range->blocks[CTX_BLOCK_ID(ctx, r600_shader_sampler_border[0].offset)];
	block->pm4[1] = (offset - EVERGREEN_CONFIG_REG_OFFSET) >> 2;
	return 0;
}

static int evergreen_loop_const_init(struct r600_context *ctx, u32 offset)
{
	unsigned nreg = 32;
	struct r600_reg r600_loop_consts[32];
	int i;

	for (i = 0; i < nreg; i++) {
		r600_loop_consts[i].opcode = PKT3_SET_LOOP_CONST;
		r600_loop_consts[i].offset_base = EVERGREEN_LOOP_CONST_OFFSET;
		r600_loop_consts[i].offset = EVERGREEN_LOOP_CONST_OFFSET + ((offset + i) * 4);
		r600_loop_consts[i].flags = REG_FLAG_DIRTY_ALWAYS;
		r600_loop_consts[i].flush_flags = 0;
	}
	return r600_context_add_block(ctx, r600_loop_consts, nreg);
}

int evergreen_context_init(struct r600_context *ctx, struct radeon *radeon)
{
	int r;

	memset(ctx, 0, sizeof(struct r600_context));
	ctx->radeon = radeon;
	LIST_INITHEAD(&ctx->query_list);

	/* initialize hash */
	ctx->hash_size = 19;
	ctx->hash_shift = 11;
	for (int i = 0; i < 256; i++) {
		ctx->range[i].start_offset = i << ctx->hash_shift;
		ctx->range[i].end_offset = ((i + 1) << ctx->hash_shift) - 1;
		ctx->range[i].blocks = calloc(1 << ctx->hash_shift, sizeof(void*));
		if (ctx->range[i].blocks == NULL) {
			return -ENOMEM;
		}
	}

	/* add blocks */
	r = r600_context_add_block(ctx, evergreen_config_reg_list,
				   Elements(evergreen_config_reg_list));
	if (r)
		goto out_err;
	r = r600_context_add_block(ctx, evergreen_context_reg_list,
				   Elements(evergreen_context_reg_list));
	if (r)
		goto out_err;
	r = r600_context_add_block(ctx, evergreen_ctl_const_list,
				   Elements(evergreen_ctl_const_list));
	if (r)
		goto out_err;


	/* PS SAMPLER */
	for (int j = 0, offset = 0; j < 18; j++, offset += 0xC) {
		r = r600_state_sampler_init(ctx, offset);
		if (r)
			goto out_err;
	}
	/* VS SAMPLER */
	for (int j = 0, offset = 0xD8; j < 18; j++, offset += 0xC) {
		r = r600_state_sampler_init(ctx, offset);
		if (r)
			goto out_err;
	}
	/* PS SAMPLER BORDER */
	for (int j = 0; j < 18; j++) {
		r = evergreen_state_sampler_border_init(ctx, R_00A400_TD_PS_SAMPLER0_BORDER_INDEX, j);
		if (r)
			goto out_err;
	}
	/* VS SAMPLER BORDER */
	for (int j = 0; j < 18; j++) {
		r = evergreen_state_sampler_border_init(ctx, R_00A414_TD_VS_SAMPLER0_BORDER_INDEX, j);
		if (r)
			goto out_err;
	}
	/* PS RESOURCE */
	for (int j = 0, offset = 0; j < 176; j++, offset += 0x20) {
		r = evergreen_state_resource_init(ctx, offset);
		if (r)
			goto out_err;
	}
	/* VS RESOURCE */
	for (int j = 0, offset = 0x1600; j < 160; j++, offset += 0x20) {
		r = evergreen_state_resource_init(ctx, offset);
		if (r)
			goto out_err;
	}
	/* FS RESOURCE */
	for (int j = 0, offset = 0x7C00; j < 16; j++, offset += 0x20) {
		r = evergreen_state_resource_init(ctx, offset);
		if (r)
			goto out_err;
	}

	/* PS loop const */
	evergreen_loop_const_init(ctx, 0);
	/* VS loop const */
	evergreen_loop_const_init(ctx, 32);

	/* setup block table */
	ctx->blocks = calloc(ctx->nblocks, sizeof(void*));
	for (int i = 0, c = 0; i < 256; i++) {
		for (int j = 0; j < (1 << ctx->hash_shift); j++) {
			if (ctx->range[i].blocks[j]) {
				assert(c < ctx->nblocks);
				ctx->blocks[c++] = ctx->range[i].blocks[j];
				j += (ctx->range[i].blocks[j]->nreg << 2) - 1;
			}
		}
	}

	/* allocate cs variables */
	ctx->nreloc = RADEON_CTX_MAX_PM4;
	ctx->reloc = calloc(ctx->nreloc, sizeof(struct r600_reloc));
	if (ctx->reloc == NULL) {
		r = -ENOMEM;
		goto out_err;
	}
	ctx->bo = calloc(ctx->nreloc, sizeof(void *));
	if (ctx->bo == NULL) {
		r = -ENOMEM;
		goto out_err;
	}
	ctx->pm4_ndwords = RADEON_CTX_MAX_PM4;
	ctx->pm4 = calloc(ctx->pm4_ndwords, 4);
	if (ctx->pm4 == NULL) {
		r = -ENOMEM;
		goto out_err;
	}
	/* save 16dwords space for fence mecanism */
	ctx->pm4_ndwords -= 16;

	ctx->max_db = 8;

	LIST_INITHEAD(&ctx->fenced_bo);

	/* init dirty list */
	LIST_INITHEAD(&ctx->dirty);
	return 0;
out_err:
	r600_context_fini(ctx);
	return r;
}

void evergreen_context_pipe_state_set_ps_resource(struct r600_context *ctx, struct r600_pipe_state *state, unsigned rid)
{
	unsigned offset = R_030000_SQ_TEX_RESOURCE_WORD0_0 + 0x20 * rid;

	r600_context_pipe_state_set_resource(ctx, state, offset);
}

void evergreen_context_pipe_state_set_vs_resource(struct r600_context *ctx, struct r600_pipe_state *state, unsigned rid)
{
	unsigned offset = R_030000_SQ_TEX_RESOURCE_WORD0_0 + 0x1600 + 0x20 * rid;

	r600_context_pipe_state_set_resource(ctx, state, offset);
}

void evergreen_context_pipe_state_set_fs_resource(struct r600_context *ctx, struct r600_pipe_state *state, unsigned rid)
{
	unsigned offset = R_030000_SQ_TEX_RESOURCE_WORD0_0 + 0x7C00 + 0x20 * rid;

	r600_context_pipe_state_set_resource(ctx, state, offset);
}

static inline void evergreen_context_pipe_state_set_sampler(struct r600_context *ctx, struct r600_pipe_state *state, unsigned offset)
{
	struct r600_range *range;
	struct r600_block *block;
	int i;
	int dirty;

	range = &ctx->range[CTX_RANGE_ID(ctx, offset)];
	block = range->blocks[CTX_BLOCK_ID(ctx, offset)];
	if (state == NULL) {
		block->status &= ~(R600_BLOCK_STATUS_ENABLED | R600_BLOCK_STATUS_DIRTY);
		LIST_DELINIT(&block->list);
		return;
	}
	dirty = block->status & R600_BLOCK_STATUS_DIRTY;

	for (i = 0; i < 3; i++) {
		if (block->reg[i] != state->regs[i].value) {
			dirty |= R600_BLOCK_STATUS_DIRTY;
			block->reg[i] = state->regs[i].value;
		}
	}

	r600_context_dirty_block(ctx, block, dirty, 2);
}

static inline void evergreen_context_ps_partial_flush(struct r600_context *ctx)
{
	if (!(ctx->flags & R600_CONTEXT_DRAW_PENDING))
		return;

	ctx->pm4[ctx->pm4_cdwords++] = PKT3(PKT3_EVENT_WRITE, 0, 0);
	ctx->pm4[ctx->pm4_cdwords++] = EVENT_TYPE(EVENT_TYPE_PS_PARTIAL_FLUSH) | EVENT_INDEX(4);

	ctx->flags &= ~R600_CONTEXT_DRAW_PENDING;
}

static inline void evergreen_context_pipe_state_set_sampler_border(struct r600_context *ctx, struct r600_pipe_state *state, unsigned offset, unsigned id)
{
	unsigned fake_offset = (offset - R_00A400_TD_PS_SAMPLER0_BORDER_INDEX) * 0x100 + 0x40000 + id * 0x1C;
	struct r600_range *range;
	struct r600_block *block;
	int i;
	int dirty;

	range = &ctx->range[CTX_RANGE_ID(ctx, fake_offset)];
	block = range->blocks[CTX_BLOCK_ID(ctx, fake_offset)];
	if (state == NULL) {
		block->status &= ~(R600_BLOCK_STATUS_ENABLED | R600_BLOCK_STATUS_DIRTY);
		LIST_DELINIT(&block->list);
		return;
	}
	if (state->nregs <= 3) {
		return;
	}

	dirty = block->status & R600_BLOCK_STATUS_DIRTY;
	if (block->reg[0] != id) {
		block->reg[0] = id;
		dirty |= R600_BLOCK_STATUS_DIRTY;
	}

	for (i = 1; i < 5; i++) {
		if (block->reg[i] != state->regs[i + 2].value) {
			block->reg[i] = state->regs[i + 2].value;
			dirty |= R600_BLOCK_STATUS_DIRTY;
		}
	}

	/* We have to flush the shaders before we change the border color
	 * registers, or previous draw commands that haven't completed yet
	 * will end up using the new border color. */
	if (dirty & R600_BLOCK_STATUS_DIRTY)
		evergreen_context_ps_partial_flush(ctx);

	r600_context_dirty_block(ctx, block, dirty, 4);
}

void evergreen_context_pipe_state_set_ps_sampler(struct r600_context *ctx, struct r600_pipe_state *state, unsigned id)
{
	unsigned offset;

	offset = 0x0003C000 + id * 0xc;
	evergreen_context_pipe_state_set_sampler(ctx, state, offset);
	evergreen_context_pipe_state_set_sampler_border(ctx, state, R_00A400_TD_PS_SAMPLER0_BORDER_INDEX, id);
}

void evergreen_context_pipe_state_set_vs_sampler(struct r600_context *ctx, struct r600_pipe_state *state, unsigned id)
{
	unsigned offset;

	offset = 0x0003C0D8 + id * 0xc;
	evergreen_context_pipe_state_set_sampler(ctx, state, offset);
	evergreen_context_pipe_state_set_sampler_border(ctx, state, R_00A414_TD_VS_SAMPLER0_BORDER_INDEX, id);
}


void evergreen_context_draw(struct r600_context *ctx, const struct r600_draw *draw)
{
	unsigned ndwords = 7;
	struct r600_block *dirty_block = NULL;
	struct r600_block *next_block;

	if (draw->indices) {
		ndwords = 11;
		/* make sure there is enough relocation space before scheduling draw */
		if (ctx->creloc >= (ctx->nreloc - 1)) {
			r600_context_flush(ctx);
		}
	}

	/* queries need some special values */
	if (ctx->num_query_running) {
		r600_context_reg(ctx,
				R_028004_DB_COUNT_CONTROL,
				S_028004_PERFECT_ZPASS_COUNTS(1),
				S_028004_PERFECT_ZPASS_COUNTS(1));
		r600_context_reg(ctx,
				R_02800C_DB_RENDER_OVERRIDE,
				S_02800C_NOOP_CULL_DISABLE(1),
				S_02800C_NOOP_CULL_DISABLE(1));
	}

	/* update the max dword count to make sure we have enough space
	 * reserved for flushing the destination caches */
	ctx->pm4_ndwords = RADEON_CTX_MAX_PM4 - ctx->num_dest_buffers * 7 - 16;

	if ((ctx->pm4_dirty_cdwords + ndwords + ctx->pm4_cdwords) > ctx->pm4_ndwords) {
		/* need to flush */
		r600_context_flush(ctx);
	}
	/* at that point everythings is flushed and ctx->pm4_cdwords = 0 */
	if ((ctx->pm4_dirty_cdwords + ndwords) > ctx->pm4_ndwords) {
		R600_ERR("context is too big to be scheduled\n");
		return;
	}

	/* enough room to copy packet */
	LIST_FOR_EACH_ENTRY_SAFE(dirty_block, next_block, &ctx->dirty,list) {
		r600_context_block_emit_dirty(ctx, dirty_block);
	}

	/* draw packet */
	ctx->pm4[ctx->pm4_cdwords++] = PKT3(PKT3_INDEX_TYPE, 0, ctx->predicate_drawing);
	ctx->pm4[ctx->pm4_cdwords++] = draw->vgt_index_type;
	ctx->pm4[ctx->pm4_cdwords++] = PKT3(PKT3_NUM_INSTANCES, 0, ctx->predicate_drawing);
	ctx->pm4[ctx->pm4_cdwords++] = draw->vgt_num_instances;
	if (draw->indices) {
	        ctx->pm4[ctx->pm4_cdwords++] = PKT3(PKT3_DRAW_INDEX, 3, ctx->predicate_drawing);
		ctx->pm4[ctx->pm4_cdwords++] = draw->indices_bo_offset + r600_bo_offset(draw->indices);
		ctx->pm4[ctx->pm4_cdwords++] = 0;
		ctx->pm4[ctx->pm4_cdwords++] = draw->vgt_num_indices;
		ctx->pm4[ctx->pm4_cdwords++] = draw->vgt_draw_initiator;
		ctx->pm4[ctx->pm4_cdwords++] = PKT3(PKT3_NOP, 0, ctx->predicate_drawing);
		ctx->pm4[ctx->pm4_cdwords++] = 0;
		r600_context_bo_reloc(ctx, &ctx->pm4[ctx->pm4_cdwords - 1], draw->indices);
	} else {
		ctx->pm4[ctx->pm4_cdwords++] = PKT3(PKT3_DRAW_INDEX_AUTO, 1, ctx->predicate_drawing);
		ctx->pm4[ctx->pm4_cdwords++] = draw->vgt_num_indices;
		ctx->pm4[ctx->pm4_cdwords++] = draw->vgt_draw_initiator;
	}

	ctx->flags |= (R600_CONTEXT_DRAW_PENDING | R600_CONTEXT_DST_CACHES_DIRTY);

	/* all dirty state have been scheduled in current cs */
	ctx->pm4_dirty_cdwords = 0;
}

void evergreen_context_flush_dest_caches(struct r600_context *ctx)
{
	struct r600_bo *cb[12];
	struct r600_bo *db;

	if (!(ctx->flags & R600_CONTEXT_DST_CACHES_DIRTY))
		return;

	/* find number of color buffer */
	db = r600_context_reg_bo(ctx, R_028048_DB_Z_READ_BASE);
	cb[0] = r600_context_reg_bo(ctx, R_028C60_CB_COLOR0_BASE);
	cb[1] = r600_context_reg_bo(ctx, R_028C9C_CB_COLOR1_BASE);
	cb[2] = r600_context_reg_bo(ctx, R_028CD8_CB_COLOR2_BASE);
	cb[3] = r600_context_reg_bo(ctx, R_028D14_CB_COLOR3_BASE);
	cb[4] = r600_context_reg_bo(ctx, R_028D50_CB_COLOR4_BASE);
	cb[5] = r600_context_reg_bo(ctx, R_028D8C_CB_COLOR5_BASE);
	cb[6] = r600_context_reg_bo(ctx, R_028DC8_CB_COLOR6_BASE);
	cb[7] = r600_context_reg_bo(ctx, R_028E04_CB_COLOR7_BASE);
	cb[8] = r600_context_reg_bo(ctx, R_028E40_CB_COLOR8_BASE);
	cb[9] = r600_context_reg_bo(ctx, R_028E5C_CB_COLOR9_BASE);
	cb[10] = r600_context_reg_bo(ctx, R_028E78_CB_COLOR10_BASE);
	cb[11] = r600_context_reg_bo(ctx, R_028E94_CB_COLOR11_BASE);

	/* flush color buffer */
	for (int i = 0; i < 12; i++) {
		if (cb[i]) {
			unsigned flush;

			if (i > 7) {
				flush = (S_0085F0_CB8_DEST_BASE_ENA(1) << (i - 8)) |
					S_0085F0_CB_ACTION_ENA(1);
			} else {
				flush = (S_0085F0_CB0_DEST_BASE_ENA(1) << i) |
					S_0085F0_CB_ACTION_ENA(1);
			}
			r600_context_bo_flush(ctx, flush, 0, cb[i]);
		}
	}
	if (db) {
		r600_context_bo_flush(ctx,
					S_0085F0_DB_ACTION_ENA(1) |
					S_0085F0_DB_DEST_BASE_ENA(1),
					0, db);
	}

	ctx->flags &= ~R600_CONTEXT_DST_CACHES_DIRTY;
}

